import React, { HTMLAttributes } from "react";
export declare type DirectoryListItem = {
    name: string;
    subItems?: DirectoryListItem[];
};
declare type Base = HTMLAttributes<HTMLLIElement> & DirectoryListItem;
export interface SidebarItemProps extends Base {
    onSelect?: () => void;
    defaultIsExpanded?: boolean;
    props?: HTMLAttributes<HTMLUListElement>;
    isOpen?: boolean;
    level: number;
}
export declare function getSidebarItemsFromData(data: DirectoryListItem[], isOpen?: boolean, level?: number): JSX.Element[];
interface SidebarItemState {
    isExpanded?: boolean;
}
export declare class SidebarItem extends React.PureComponent<SidebarItemProps, SidebarItemState> {
    state: SidebarItemState;
    handleToggleExpanded: (e: React.MouseEvent) => void;
    render(): JSX.Element;
}
export {};
