"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WINDOW = exports.REQUESTS = exports.MILLIS_MULTIPLIER = exports.INTERVAL = exports.GLOBAL_BASIC_COUNTER = exports.DEFAULT_ROLLING_COUNTER = exports.COMPONENTS = exports.CAPACITY = void 0;
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

const WINDOW = exports.WINDOW = 3600;
const INTERVAL = exports.INTERVAL = 60;
const CAPACITY = exports.CAPACITY = WINDOW / INTERVAL * 2;
const MILLIS_MULTIPLIER = exports.MILLIS_MULTIPLIER = 1000;
const COMPONENTS = exports.COMPONENTS = ['application_analytics', 'operational_panels', 'event_analytics', 'notebooks', 'trace_analytics', 'metrics_analytics', 'integrations'];
const REQUESTS = exports.REQUESTS = ['create', 'get', 'update', 'delete'];
const GLOBAL_BASIC_COUNTER = exports.GLOBAL_BASIC_COUNTER = (() => {
  const counter = {};
  COMPONENTS.forEach(component => {
    counter[component] = {};
    REQUESTS.forEach(request => {
      counter[component][request] = {
        total: 0
      };
    });
  });
  return counter;
})();
const DEFAULT_ROLLING_COUNTER = exports.DEFAULT_ROLLING_COUNTER = (() => {
  const counter = {};
  COMPONENTS.forEach(component => {
    counter[component] = {};
    REQUESTS.forEach(request => {
      counter[component][request] = {
        count: 0,
        system_error: 0,
        user_error: 0
      };
    });
  });
  return counter;
})();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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