"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NotificationsPlugin = NotificationsPlugin;
var _common = require("../../common");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

function NotificationsPlugin(Client, config, components) {
  const clientAction = components.clientAction.factory;
  Client.prototype.notifications = components.clientAction.namespaceFactory();
  const notifications = Client.prototype.notifications.prototype;
  notifications.getConfigs = clientAction({
    url: {
      fmt: _common.NOTIFICATIONS_API.CONFIGS
    },
    method: 'GET'
  });
  notifications.getEventById = clientAction({
    url: {
      fmt: `${_common.NOTIFICATIONS_API.EVENTS}/<%=eventId%>`,
      req: {
        eventId: {
          type: 'string',
          required: true
        }
      }
    },
    method: 'GET'
  });
  notifications.sendTestMessage = clientAction({
    url: {
      fmt: `${_common.NOTIFICATIONS_API.TEST_MESSAGE}/<%=configId%>`,
      req: {
        configId: {
          type: 'string',
          required: true
        }
      }
    },
    method: 'GET'
  });
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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