"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.updateReportDefinition = void 0;
var _uiToBackend = require("../utils/converters/uiToBackend");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

const updateReportDefinition = async (request, context, reportDefinition) => {
  // @ts-ignore
  const opensearchReportsClient = context.reporting_plugin.opensearchReportsClient.asScoped(request);
  // @ts-ignore
  const reportDefinitionId = request.params.reportDefinitionId;
  // create report definition
  const reqBody = {
    reportDefinitionId: reportDefinitionId,
    reportDefinition: (0, _uiToBackend.uiToBackendReportDefinition)(reportDefinition)
  };
  const opensearchResp = await opensearchReportsClient.callAsCurrentUser('opensearch_reports.updateReportDefinitionById', {
    reportDefinitionId: reportDefinitionId,
    body: reqBody
  });
  return opensearchResp;
};
exports.updateReportDefinition = updateReportDefinition;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJuYW1lcyI6WyJfdWlUb0JhY2tlbmQiLCJyZXF1aXJlIiwidXBkYXRlUmVwb3J0RGVmaW5pdGlvbiIsInJlcXVlc3QiLCJjb250ZXh0IiwicmVwb3J0RGVmaW5pdGlvbiIsIm9wZW5zZWFyY2hSZXBvcnRzQ2xpZW50IiwicmVwb3J0aW5nX3BsdWdpbiIsImFzU2NvcGVkIiwicmVwb3J0RGVmaW5pdGlvbklkIiwicGFyYW1zIiwicmVxQm9keSIsInVpVG9CYWNrZW5kUmVwb3J0RGVmaW5pdGlvbiIsIm9wZW5zZWFyY2hSZXNwIiwiY2FsbEFzQ3VycmVudFVzZXIiLCJib2R5IiwiZXhwb3J0cyJdLCJzb3VyY2VzIjpbInVwZGF0ZVJlcG9ydERlZmluaXRpb24udHMiXSwic291cmNlc0NvbnRlbnQiOlsiLypcbiAqIENvcHlyaWdodCBPcGVuU2VhcmNoIENvbnRyaWJ1dG9yc1xuICogU1BEWC1MaWNlbnNlLUlkZW50aWZpZXI6IEFwYWNoZS0yLjBcbiAqL1xuXG5pbXBvcnQgeyBSZXBvcnREZWZpbml0aW9uU2NoZW1hVHlwZSB9IGZyb20gJy4uLy4uL21vZGVsJztcbmltcG9ydCB7XG4gIElMZWdhY3lTY29wZWRDbHVzdGVyQ2xpZW50LFxuICBPcGVuU2VhcmNoRGFzaGJvYXJkc1JlcXVlc3QsXG4gIFJlcXVlc3RIYW5kbGVyQ29udGV4dCxcbn0gZnJvbSAnLi4vLi4vLi4vLi4vLi4vc3JjL2NvcmUvc2VydmVyJztcbmltcG9ydCB7IHVpVG9CYWNrZW5kUmVwb3J0RGVmaW5pdGlvbiB9IGZyb20gJy4uL3V0aWxzL2NvbnZlcnRlcnMvdWlUb0JhY2tlbmQnO1xuXG5leHBvcnQgY29uc3QgdXBkYXRlUmVwb3J0RGVmaW5pdGlvbiA9IGFzeW5jIChcbiAgcmVxdWVzdDogT3BlblNlYXJjaERhc2hib2FyZHNSZXF1ZXN0LFxuICBjb250ZXh0OiBSZXF1ZXN0SGFuZGxlckNvbnRleHQsXG4gIHJlcG9ydERlZmluaXRpb246IFJlcG9ydERlZmluaXRpb25TY2hlbWFUeXBlXG4pID0+IHtcbiAgLy8gQHRzLWlnbm9yZVxuICBjb25zdCBvcGVuc2VhcmNoUmVwb3J0c0NsaWVudDogSUxlZ2FjeVNjb3BlZENsdXN0ZXJDbGllbnQgPSBjb250ZXh0LnJlcG9ydGluZ19wbHVnaW4ub3BlbnNlYXJjaFJlcG9ydHNDbGllbnQuYXNTY29wZWQoXG4gICAgcmVxdWVzdFxuICApO1xuICAvLyBAdHMtaWdub3JlXG4gIGNvbnN0IHJlcG9ydERlZmluaXRpb25JZCA9IHJlcXVlc3QucGFyYW1zLnJlcG9ydERlZmluaXRpb25JZDtcbiAgLy8gY3JlYXRlIHJlcG9ydCBkZWZpbml0aW9uXG4gIGNvbnN0IHJlcUJvZHkgPSB7XG4gICAgcmVwb3J0RGVmaW5pdGlvbklkOiByZXBvcnREZWZpbml0aW9uSWQsXG4gICAgcmVwb3J0RGVmaW5pdGlvbjogdWlUb0JhY2tlbmRSZXBvcnREZWZpbml0aW9uKHJlcG9ydERlZmluaXRpb24pLFxuICB9O1xuXG4gIGNvbnN0IG9wZW5zZWFyY2hSZXNwID0gYXdhaXQgb3BlbnNlYXJjaFJlcG9ydHNDbGllbnQuY2FsbEFzQ3VycmVudFVzZXIoXG4gICAgJ29wZW5zZWFyY2hfcmVwb3J0cy51cGRhdGVSZXBvcnREZWZpbml0aW9uQnlJZCcsXG4gICAge1xuICAgICAgcmVwb3J0RGVmaW5pdGlvbklkOiByZXBvcnREZWZpbml0aW9uSWQsXG4gICAgICBib2R5OiByZXFCb2R5LFxuICAgIH1cbiAgKTtcblxuICByZXR1cm4gb3BlbnNlYXJjaFJlc3A7XG59O1xuIl0sIm1hcHBpbmdzIjoiOzs7Ozs7QUFXQSxJQUFBQSxZQUFBLEdBQUFDLE9BQUE7QUFYQTtBQUNBO0FBQ0E7QUFDQTs7QUFVTyxNQUFNQyxzQkFBc0IsR0FBRyxNQUFBQSxDQUNwQ0MsT0FBb0MsRUFDcENDLE9BQThCLEVBQzlCQyxnQkFBNEMsS0FDekM7RUFDSDtFQUNBLE1BQU1DLHVCQUFtRCxHQUFHRixPQUFPLENBQUNHLGdCQUFnQixDQUFDRCx1QkFBdUIsQ0FBQ0UsUUFBUSxDQUNuSEwsT0FDRixDQUFDO0VBQ0Q7RUFDQSxNQUFNTSxrQkFBa0IsR0FBR04sT0FBTyxDQUFDTyxNQUFNLENBQUNELGtCQUFrQjtFQUM1RDtFQUNBLE1BQU1FLE9BQU8sR0FBRztJQUNkRixrQkFBa0IsRUFBRUEsa0JBQWtCO0lBQ3RDSixnQkFBZ0IsRUFBRSxJQUFBTyx3Q0FBMkIsRUFBQ1AsZ0JBQWdCO0VBQ2hFLENBQUM7RUFFRCxNQUFNUSxjQUFjLEdBQUcsTUFBTVAsdUJBQXVCLENBQUNRLGlCQUFpQixDQUNwRSwrQ0FBK0MsRUFDL0M7SUFDRUwsa0JBQWtCLEVBQUVBLGtCQUFrQjtJQUN0Q00sSUFBSSxFQUFFSjtFQUNSLENBQ0YsQ0FBQztFQUVELE9BQU9FLGNBQWM7QUFDdkIsQ0FBQztBQUFDRyxPQUFBLENBQUFkLHNCQUFBLEdBQUFBLHNCQUFBIn0=