/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.management.compute;

import com.microsoft.windowsazure.core.LazyCollection;
import com.microsoft.windowsazure.core.OperationResponse;
import com.microsoft.windowsazure.core.OperationStatus;
import com.microsoft.windowsazure.core.OperationStatusResponse;
import com.microsoft.windowsazure.core.ServiceOperations;
import com.microsoft.windowsazure.core.pipeline.apache.CustomHttpDelete;
import com.microsoft.windowsazure.core.pipeline.filter.ServiceRequestFilter;
import com.microsoft.windowsazure.core.pipeline.filter.ServiceResponseFilter;
import com.microsoft.windowsazure.core.utils.BOMInputStream;
import com.microsoft.windowsazure.core.utils.Base64;
import com.microsoft.windowsazure.core.utils.CollectionStringBuilder;
import com.microsoft.windowsazure.core.utils.XmlUtility;
import com.microsoft.windowsazure.exception.CloudError;
import com.microsoft.windowsazure.exception.ServiceException;
import com.microsoft.windowsazure.management.compute.ComputeManagementClient;
import com.microsoft.windowsazure.management.compute.ComputeManagementClientImpl;
import com.microsoft.windowsazure.management.compute.DeploymentOperations;
import com.microsoft.windowsazure.management.compute.models.AccessControlListRule;
import com.microsoft.windowsazure.management.compute.models.AdditionalUnattendContentSettings;
import com.microsoft.windowsazure.management.compute.models.ComponentSetting;
import com.microsoft.windowsazure.management.compute.models.ConfigurationSet;
import com.microsoft.windowsazure.management.compute.models.DataDiskConfiguration;
import com.microsoft.windowsazure.management.compute.models.DataVirtualHardDisk;
import com.microsoft.windowsazure.management.compute.models.DeploymentChangeConfigurationParameters;
import com.microsoft.windowsazure.management.compute.models.DeploymentCreateParameters;
import com.microsoft.windowsazure.management.compute.models.DeploymentDeleteRoleInstanceParameters;
import com.microsoft.windowsazure.management.compute.models.DeploymentEventListResponse;
import com.microsoft.windowsazure.management.compute.models.DeploymentGetPackageParameters;
import com.microsoft.windowsazure.management.compute.models.DeploymentGetResponse;
import com.microsoft.windowsazure.management.compute.models.DeploymentRollbackUpdateOrUpgradeParameters;
import com.microsoft.windowsazure.management.compute.models.DeploymentSlot;
import com.microsoft.windowsazure.management.compute.models.DeploymentStatus;
import com.microsoft.windowsazure.management.compute.models.DeploymentSwapParameters;
import com.microsoft.windowsazure.management.compute.models.DeploymentUpdateStatusParameters;
import com.microsoft.windowsazure.management.compute.models.DeploymentUpgradeParameters;
import com.microsoft.windowsazure.management.compute.models.DeploymentUpgradeType;
import com.microsoft.windowsazure.management.compute.models.DeploymentWalkUpgradeDomainParameters;
import com.microsoft.windowsazure.management.compute.models.DnsServer;
import com.microsoft.windowsazure.management.compute.models.DnsSettings;
import com.microsoft.windowsazure.management.compute.models.DomainJoinCredentials;
import com.microsoft.windowsazure.management.compute.models.DomainJoinProvisioning;
import com.microsoft.windowsazure.management.compute.models.DomainJoinSettings;
import com.microsoft.windowsazure.management.compute.models.EndpointAcl;
import com.microsoft.windowsazure.management.compute.models.ExtensionConfiguration;
import com.microsoft.windowsazure.management.compute.models.FrontendIPConfiguration;
import com.microsoft.windowsazure.management.compute.models.GuestAgentFormattedMessage;
import com.microsoft.windowsazure.management.compute.models.GuestAgentMessage;
import com.microsoft.windowsazure.management.compute.models.GuestAgentStatus;
import com.microsoft.windowsazure.management.compute.models.IPConfiguration;
import com.microsoft.windowsazure.management.compute.models.IPConfigurationInstance;
import com.microsoft.windowsazure.management.compute.models.InputEndpoint;
import com.microsoft.windowsazure.management.compute.models.InstanceEndpoint;
import com.microsoft.windowsazure.management.compute.models.LoadBalancer;
import com.microsoft.windowsazure.management.compute.models.LoadBalancerProbe;
import com.microsoft.windowsazure.management.compute.models.LoadBalancerProbeTransportProtocol;
import com.microsoft.windowsazure.management.compute.models.NetworkInterface;
import com.microsoft.windowsazure.management.compute.models.NetworkInterfaceInstance;
import com.microsoft.windowsazure.management.compute.models.OSDiskConfiguration;
import com.microsoft.windowsazure.management.compute.models.OSVirtualHardDisk;
import com.microsoft.windowsazure.management.compute.models.PersistentVMDowntime;
import com.microsoft.windowsazure.management.compute.models.RebootEvent;
import com.microsoft.windowsazure.management.compute.models.ResourceExtensionConfigurationStatus;
import com.microsoft.windowsazure.management.compute.models.ResourceExtensionParameterValue;
import com.microsoft.windowsazure.management.compute.models.ResourceExtensionReference;
import com.microsoft.windowsazure.management.compute.models.ResourceExtensionStatus;
import com.microsoft.windowsazure.management.compute.models.ResourceExtensionSubStatus;
import com.microsoft.windowsazure.management.compute.models.Role;
import com.microsoft.windowsazure.management.compute.models.RoleInstance;
import com.microsoft.windowsazure.management.compute.models.RoleInstancePowerState;
import com.microsoft.windowsazure.management.compute.models.SshSettingKeyPair;
import com.microsoft.windowsazure.management.compute.models.SshSettingPublicKey;
import com.microsoft.windowsazure.management.compute.models.SshSettings;
import com.microsoft.windowsazure.management.compute.models.StoredCertificateSettings;
import com.microsoft.windowsazure.management.compute.models.UnattendComponent;
import com.microsoft.windowsazure.management.compute.models.UnattendPassSettings;
import com.microsoft.windowsazure.management.compute.models.UpgradeDomainState;
import com.microsoft.windowsazure.management.compute.models.UpgradeStatus;
import com.microsoft.windowsazure.management.compute.models.VMImageInput;
import com.microsoft.windowsazure.management.compute.models.VirtualIPAddress;
import com.microsoft.windowsazure.management.compute.models.VirtualMachineWindowsRemoteManagementListenerType;
import com.microsoft.windowsazure.management.compute.models.WindowsRemoteManagementListener;
import com.microsoft.windowsazure.management.compute.models.WindowsRemoteManagementSettings;
import com.microsoft.windowsazure.tracing.ClientRequestTrackingHandler;
import com.microsoft.windowsazure.tracing.CloudTracing;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.xml.bind.DatatypeConverter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class DeploymentOperationsImpl
implements ServiceOperations<ComputeManagementClientImpl>,
DeploymentOperations {
    private ComputeManagementClientImpl client;

    DeploymentOperationsImpl(ComputeManagementClientImpl client) {
        this.client = client;
    }

    public ComputeManagementClientImpl getClient() {
        return this.client;
    }

    @Override
    public Future<OperationResponse> beginChangingConfigurationByNameAsync(final String serviceName, final String deploymentName, final DeploymentChangeConfigurationParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<OperationResponse>(){

            @Override
            public OperationResponse call() throws Exception {
                return DeploymentOperationsImpl.this.beginChangingConfigurationByName(serviceName, deploymentName, parameters);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResponse beginChangingConfigurationByName(String serviceName, String deploymentName, DeploymentChangeConfigurationParameters parameters) throws ParserConfigurationException, SAXException, TransformerException, IOException, ServiceException {
        String baseUrl;
        if (serviceName == null) {
            throw new NullPointerException("serviceName");
        }
        if (deploymentName == null) {
            throw new NullPointerException("deploymentName");
        }
        if (parameters == null) {
            throw new NullPointerException("parameters");
        }
        if (parameters.getConfiguration() == null) {
            throw new NullPointerException("parameters.Configuration");
        }
        if (parameters.getExtensionConfiguration() != null) {
            if (parameters.getExtensionConfiguration().getAllRoles() != null) {
                for (ExtensionConfiguration.Extension allRolesParameterItem : parameters.getExtensionConfiguration().getAllRoles()) {
                    if (allRolesParameterItem.getId() != null) continue;
                    throw new NullPointerException("parameters.ExtensionConfiguration.AllRoles.Id");
                }
            }
            if (parameters.getExtensionConfiguration().getNamedRoles() != null) {
                for (ExtensionConfiguration.NamedRole namedRolesParameterItem : parameters.getExtensionConfiguration().getNamedRoles()) {
                    if (namedRolesParameterItem.getExtensions() == null) {
                        throw new NullPointerException("parameters.ExtensionConfiguration.NamedRoles.Extensions");
                    }
                    if (namedRolesParameterItem.getExtensions() != null) {
                        for (ExtensionConfiguration.Extension extensionsParameterItem : namedRolesParameterItem.getExtensions()) {
                            if (extensionsParameterItem.getId() != null) continue;
                            throw new NullPointerException("parameters.ExtensionConfiguration.NamedRoles.Extensions.Id");
                        }
                    }
                    if (namedRolesParameterItem.getRoleName() != null) continue;
                    throw new NullPointerException("parameters.ExtensionConfiguration.NamedRoles.RoleName");
                }
            }
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("serviceName", serviceName);
            tracingParameters.put("deploymentName", deploymentName);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"beginChangingConfigurationByNameAsync", tracingParameters);
        }
        String url = "";
        url = url + "/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/services/hostedservices/";
        url = url + URLEncoder.encode(serviceName, "UTF-8");
        url = url + "/deployments/";
        url = url + URLEncoder.encode(deploymentName, "UTF-8");
        url = url + "/";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("comp=config");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, (String)"&");
        }
        if ((baseUrl = this.getClient().getBaseUri().toString()).charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpPost httpRequest = new HttpPost(url);
        httpRequest.setHeader("Content-Type", "application/xml");
        httpRequest.setHeader("x-ms-version", "2015-04-01");
        String requestContent = null;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document requestDoc = documentBuilder.newDocument();
        Element changeConfigurationElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "ChangeConfiguration");
        requestDoc.appendChild(changeConfigurationElement);
        Element configurationElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Configuration");
        configurationElement.appendChild(requestDoc.createTextNode(Base64.encode((byte[])parameters.getConfiguration().getBytes())));
        changeConfigurationElement.appendChild(configurationElement);
        if (parameters.isTreatWarningsAsError() != null) {
            Element treatWarningsAsErrorElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "TreatWarningsAsError");
            treatWarningsAsErrorElement.appendChild(requestDoc.createTextNode(Boolean.toString(parameters.isTreatWarningsAsError()).toLowerCase()));
            changeConfigurationElement.appendChild(treatWarningsAsErrorElement);
        }
        if (parameters.getMode() != null) {
            Element modeElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Mode");
            modeElement.appendChild(requestDoc.createTextNode(parameters.getMode().toString()));
            changeConfigurationElement.appendChild(modeElement);
        }
        if (parameters.getExtendedProperties() != null && (!(parameters.getExtendedProperties() instanceof LazyCollection) || ((LazyCollection)parameters.getExtendedProperties()).isInitialized())) {
            Element extendedPropertiesDictionaryElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "ExtendedProperties");
            for (Map.Entry<String, String> entry : parameters.getExtendedProperties().entrySet()) {
                String extendedPropertiesKey = entry.getKey();
                String extendedPropertiesValue = entry.getValue();
                Element extendedPropertiesElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "ExtendedProperty");
                extendedPropertiesDictionaryElement.appendChild(extendedPropertiesElement);
                Element extendedPropertiesKeyElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Name");
                extendedPropertiesKeyElement.appendChild(requestDoc.createTextNode(extendedPropertiesKey));
                extendedPropertiesElement.appendChild(extendedPropertiesKeyElement);
                Element extendedPropertiesValueElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Value");
                extendedPropertiesValueElement.appendChild(requestDoc.createTextNode(extendedPropertiesValue));
                extendedPropertiesElement.appendChild(extendedPropertiesValueElement);
            }
            changeConfigurationElement.appendChild(extendedPropertiesDictionaryElement);
        }
        if (parameters.getExtensionConfiguration() != null) {
            Element extensionConfigurationElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "ExtensionConfiguration");
            changeConfigurationElement.appendChild(extensionConfigurationElement);
            if (parameters.getExtensionConfiguration().getAllRoles() != null && (!(parameters.getExtensionConfiguration().getAllRoles() instanceof LazyCollection) || ((LazyCollection)parameters.getExtensionConfiguration().getAllRoles()).isInitialized())) {
                Element allRolesSequenceElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "AllRoles");
                for (ExtensionConfiguration.Extension allRolesItem : parameters.getExtensionConfiguration().getAllRoles()) {
                    Element extensionElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Extension");
                    allRolesSequenceElement.appendChild(extensionElement);
                    Element idElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Id");
                    idElement.appendChild(requestDoc.createTextNode(allRolesItem.getId()));
                    extensionElement.appendChild(idElement);
                }
                extensionConfigurationElement.appendChild(allRolesSequenceElement);
            }
            if (parameters.getExtensionConfiguration().getNamedRoles() != null && (!(parameters.getExtensionConfiguration().getNamedRoles() instanceof LazyCollection) || ((LazyCollection)parameters.getExtensionConfiguration().getNamedRoles()).isInitialized())) {
                Element namedRolesSequenceElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "NamedRoles");
                for (ExtensionConfiguration.NamedRole namedRolesItem : parameters.getExtensionConfiguration().getNamedRoles()) {
                    Element roleElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Role");
                    namedRolesSequenceElement.appendChild(roleElement);
                    Element roleNameElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "RoleName");
                    roleNameElement.appendChild(requestDoc.createTextNode(namedRolesItem.getRoleName()));
                    roleElement.appendChild(roleNameElement);
                    if (namedRolesItem.getExtensions() instanceof LazyCollection && !((LazyCollection)namedRolesItem.getExtensions()).isInitialized()) continue;
                    Element extensionsSequenceElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Extensions");
                    for (ExtensionConfiguration.Extension extensionsItem : namedRolesItem.getExtensions()) {
                        Element extensionElement2 = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Extension");
                        extensionsSequenceElement.appendChild(extensionElement2);
                        Element idElement2 = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Id");
                        idElement2.appendChild(requestDoc.createTextNode(extensionsItem.getId()));
                        extensionElement2.appendChild(idElement2);
                    }
                    roleElement.appendChild(extensionsSequenceElement);
                }
                extensionConfigurationElement.appendChild(namedRolesSequenceElement);
            }
        }
        DOMSource domSource = new DOMSource(requestDoc);
        StringWriter stringWriter = new StringWriter();
        StreamResult streamResult = new StreamResult(stringWriter);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.transform(domSource, streamResult);
        requestContent = stringWriter.toString();
        StringEntity entity = new StringEntity(requestContent);
        httpRequest.setEntity((HttpEntity)entity);
        httpRequest.setHeader("Content-Type", "application/xml");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 202) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, (String)requestContent, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            OperationResponse result = null;
            result = new OperationResponse();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)result);
            }
            OperationResponse operationResponse = result;
            return operationResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<OperationResponse> beginChangingConfigurationBySlotAsync(final String serviceName, final DeploymentSlot deploymentSlot, final DeploymentChangeConfigurationParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<OperationResponse>(){

            @Override
            public OperationResponse call() throws Exception {
                return DeploymentOperationsImpl.this.beginChangingConfigurationBySlot(serviceName, deploymentSlot, parameters);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResponse beginChangingConfigurationBySlot(String serviceName, DeploymentSlot deploymentSlot, DeploymentChangeConfigurationParameters parameters) throws ParserConfigurationException, SAXException, TransformerException, IOException, ServiceException {
        String baseUrl;
        if (serviceName == null) {
            throw new NullPointerException("serviceName");
        }
        if (deploymentSlot == null) {
            throw new NullPointerException("deploymentSlot");
        }
        if (parameters == null) {
            throw new NullPointerException("parameters");
        }
        if (parameters.getConfiguration() == null) {
            throw new NullPointerException("parameters.Configuration");
        }
        if (parameters.getExtensionConfiguration() != null) {
            if (parameters.getExtensionConfiguration().getAllRoles() != null) {
                for (ExtensionConfiguration.Extension allRolesParameterItem : parameters.getExtensionConfiguration().getAllRoles()) {
                    if (allRolesParameterItem.getId() != null) continue;
                    throw new NullPointerException("parameters.ExtensionConfiguration.AllRoles.Id");
                }
            }
            if (parameters.getExtensionConfiguration().getNamedRoles() != null) {
                for (ExtensionConfiguration.NamedRole namedRolesParameterItem : parameters.getExtensionConfiguration().getNamedRoles()) {
                    if (namedRolesParameterItem.getExtensions() == null) {
                        throw new NullPointerException("parameters.ExtensionConfiguration.NamedRoles.Extensions");
                    }
                    if (namedRolesParameterItem.getExtensions() != null) {
                        for (ExtensionConfiguration.Extension extensionsParameterItem : namedRolesParameterItem.getExtensions()) {
                            if (extensionsParameterItem.getId() != null) continue;
                            throw new NullPointerException("parameters.ExtensionConfiguration.NamedRoles.Extensions.Id");
                        }
                    }
                    if (namedRolesParameterItem.getRoleName() != null) continue;
                    throw new NullPointerException("parameters.ExtensionConfiguration.NamedRoles.RoleName");
                }
            }
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("serviceName", serviceName);
            tracingParameters.put("deploymentSlot", (Object)deploymentSlot);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"beginChangingConfigurationBySlotAsync", tracingParameters);
        }
        String url = "";
        url = url + "/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/services/hostedservices/";
        url = url + URLEncoder.encode(serviceName, "UTF-8");
        url = url + "/deploymentslots/";
        url = url + URLEncoder.encode(deploymentSlot.toString(), "UTF-8");
        url = url + "/";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("comp=config");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, (String)"&");
        }
        if ((baseUrl = this.getClient().getBaseUri().toString()).charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpPost httpRequest = new HttpPost(url);
        httpRequest.setHeader("Content-Type", "application/xml");
        httpRequest.setHeader("x-ms-version", "2015-04-01");
        String requestContent = null;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document requestDoc = documentBuilder.newDocument();
        Element changeConfigurationElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "ChangeConfiguration");
        requestDoc.appendChild(changeConfigurationElement);
        Element configurationElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Configuration");
        configurationElement.appendChild(requestDoc.createTextNode(Base64.encode((byte[])parameters.getConfiguration().getBytes())));
        changeConfigurationElement.appendChild(configurationElement);
        if (parameters.isTreatWarningsAsError() != null) {
            Element treatWarningsAsErrorElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "TreatWarningsAsError");
            treatWarningsAsErrorElement.appendChild(requestDoc.createTextNode(Boolean.toString(parameters.isTreatWarningsAsError()).toLowerCase()));
            changeConfigurationElement.appendChild(treatWarningsAsErrorElement);
        }
        if (parameters.getMode() != null) {
            Element modeElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Mode");
            modeElement.appendChild(requestDoc.createTextNode(parameters.getMode().toString()));
            changeConfigurationElement.appendChild(modeElement);
        }
        if (parameters.getExtendedProperties() != null && (!(parameters.getExtendedProperties() instanceof LazyCollection) || ((LazyCollection)parameters.getExtendedProperties()).isInitialized())) {
            Element extendedPropertiesDictionaryElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "ExtendedProperties");
            for (Map.Entry<String, String> entry : parameters.getExtendedProperties().entrySet()) {
                String extendedPropertiesKey = entry.getKey();
                String extendedPropertiesValue = entry.getValue();
                Element extendedPropertiesElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "ExtendedProperty");
                extendedPropertiesDictionaryElement.appendChild(extendedPropertiesElement);
                Element extendedPropertiesKeyElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Name");
                extendedPropertiesKeyElement.appendChild(requestDoc.createTextNode(extendedPropertiesKey));
                extendedPropertiesElement.appendChild(extendedPropertiesKeyElement);
                Element extendedPropertiesValueElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Value");
                extendedPropertiesValueElement.appendChild(requestDoc.createTextNode(extendedPropertiesValue));
                extendedPropertiesElement.appendChild(extendedPropertiesValueElement);
            }
            changeConfigurationElement.appendChild(extendedPropertiesDictionaryElement);
        }
        if (parameters.getExtensionConfiguration() != null) {
            Element extensionConfigurationElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "ExtensionConfiguration");
            changeConfigurationElement.appendChild(extensionConfigurationElement);
            if (parameters.getExtensionConfiguration().getAllRoles() != null && (!(parameters.getExtensionConfiguration().getAllRoles() instanceof LazyCollection) || ((LazyCollection)parameters.getExtensionConfiguration().getAllRoles()).isInitialized())) {
                Element allRolesSequenceElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "AllRoles");
                for (ExtensionConfiguration.Extension allRolesItem : parameters.getExtensionConfiguration().getAllRoles()) {
                    Element extensionElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Extension");
                    allRolesSequenceElement.appendChild(extensionElement);
                    Element idElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Id");
                    idElement.appendChild(requestDoc.createTextNode(allRolesItem.getId()));
                    extensionElement.appendChild(idElement);
                }
                extensionConfigurationElement.appendChild(allRolesSequenceElement);
            }
            if (parameters.getExtensionConfiguration().getNamedRoles() != null && (!(parameters.getExtensionConfiguration().getNamedRoles() instanceof LazyCollection) || ((LazyCollection)parameters.getExtensionConfiguration().getNamedRoles()).isInitialized())) {
                Element namedRolesSequenceElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "NamedRoles");
                for (ExtensionConfiguration.NamedRole namedRolesItem : parameters.getExtensionConfiguration().getNamedRoles()) {
                    Element roleElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Role");
                    namedRolesSequenceElement.appendChild(roleElement);
                    Element roleNameElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "RoleName");
                    roleNameElement.appendChild(requestDoc.createTextNode(namedRolesItem.getRoleName()));
                    roleElement.appendChild(roleNameElement);
                    if (namedRolesItem.getExtensions() instanceof LazyCollection && !((LazyCollection)namedRolesItem.getExtensions()).isInitialized()) continue;
                    Element extensionsSequenceElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Extensions");
                    for (ExtensionConfiguration.Extension extensionsItem : namedRolesItem.getExtensions()) {
                        Element extensionElement2 = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Extension");
                        extensionsSequenceElement.appendChild(extensionElement2);
                        Element idElement2 = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Id");
                        idElement2.appendChild(requestDoc.createTextNode(extensionsItem.getId()));
                        extensionElement2.appendChild(idElement2);
                    }
                    roleElement.appendChild(extensionsSequenceElement);
                }
                extensionConfigurationElement.appendChild(namedRolesSequenceElement);
            }
        }
        DOMSource domSource = new DOMSource(requestDoc);
        StringWriter stringWriter = new StringWriter();
        StreamResult streamResult = new StreamResult(stringWriter);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.transform(domSource, streamResult);
        requestContent = stringWriter.toString();
        StringEntity entity = new StringEntity(requestContent);
        httpRequest.setEntity((HttpEntity)entity);
        httpRequest.setHeader("Content-Type", "application/xml");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 202) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, (String)requestContent, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            OperationResponse result = null;
            result = new OperationResponse();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)result);
            }
            OperationResponse operationResponse = result;
            return operationResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<OperationResponse> beginCreatingAsync(final String serviceName, final DeploymentSlot deploymentSlot, final DeploymentCreateParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<OperationResponse>(){

            @Override
            public OperationResponse call() throws Exception {
                return DeploymentOperationsImpl.this.beginCreating(serviceName, deploymentSlot, parameters);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResponse beginCreating(String serviceName, DeploymentSlot deploymentSlot, DeploymentCreateParameters parameters) throws ParserConfigurationException, SAXException, TransformerException, IOException, ServiceException {
        if (serviceName == null) {
            throw new NullPointerException("serviceName");
        }
        if (deploymentSlot == null) {
            throw new NullPointerException("deploymentSlot");
        }
        if (parameters == null) {
            throw new NullPointerException("parameters");
        }
        if (parameters.getConfiguration() == null) {
            throw new NullPointerException("parameters.Configuration");
        }
        if (parameters.getExtensionConfiguration() != null) {
            if (parameters.getExtensionConfiguration().getAllRoles() != null) {
                for (ExtensionConfiguration.Extension allRolesParameterItem : parameters.getExtensionConfiguration().getAllRoles()) {
                    if (allRolesParameterItem.getId() != null) continue;
                    throw new NullPointerException("parameters.ExtensionConfiguration.AllRoles.Id");
                }
            }
            if (parameters.getExtensionConfiguration().getNamedRoles() != null) {
                for (ExtensionConfiguration.NamedRole namedRolesParameterItem : parameters.getExtensionConfiguration().getNamedRoles()) {
                    if (namedRolesParameterItem.getExtensions() == null) {
                        throw new NullPointerException("parameters.ExtensionConfiguration.NamedRoles.Extensions");
                    }
                    if (namedRolesParameterItem.getExtensions() != null) {
                        for (ExtensionConfiguration.Extension extensionsParameterItem : namedRolesParameterItem.getExtensions()) {
                            if (extensionsParameterItem.getId() != null) continue;
                            throw new NullPointerException("parameters.ExtensionConfiguration.NamedRoles.Extensions.Id");
                        }
                    }
                    if (namedRolesParameterItem.getRoleName() != null) continue;
                    throw new NullPointerException("parameters.ExtensionConfiguration.NamedRoles.RoleName");
                }
            }
        }
        if (parameters.getLabel() == null) {
            throw new NullPointerException("parameters.Label");
        }
        if (parameters.getLabel().length() > 100) {
            throw new IllegalArgumentException("parameters.Label");
        }
        if (parameters.getName() == null) {
            throw new NullPointerException("parameters.Name");
        }
        if (parameters.getPackageUri() == null) {
            throw new NullPointerException("parameters.PackageUri");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("serviceName", serviceName);
            tracingParameters.put("deploymentSlot", (Object)deploymentSlot);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"beginCreatingAsync", tracingParameters);
        }
        String url = "";
        url = url + "/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/services/hostedservices/";
        url = url + URLEncoder.encode(serviceName, "UTF-8");
        url = url + "/deploymentslots/";
        url = url + URLEncoder.encode(deploymentSlot.toString(), "UTF-8");
        String baseUrl = this.getClient().getBaseUri().toString();
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpPost httpRequest = new HttpPost(url);
        httpRequest.setHeader("Content-Type", "application/xml");
        httpRequest.setHeader("x-ms-version", "2015-04-01");
        String requestContent = null;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document requestDoc = documentBuilder.newDocument();
        Element createDeploymentElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "CreateDeployment");
        requestDoc.appendChild(createDeploymentElement);
        Element nameElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Name");
        nameElement.appendChild(requestDoc.createTextNode(parameters.getName()));
        createDeploymentElement.appendChild(nameElement);
        Element packageUrlElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "PackageUrl");
        packageUrlElement.appendChild(requestDoc.createTextNode(parameters.getPackageUri().toString()));
        createDeploymentElement.appendChild(packageUrlElement);
        Element labelElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Label");
        labelElement.appendChild(requestDoc.createTextNode(Base64.encode((byte[])parameters.getLabel().getBytes())));
        createDeploymentElement.appendChild(labelElement);
        Element configurationElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Configuration");
        configurationElement.appendChild(requestDoc.createTextNode(Base64.encode((byte[])parameters.getConfiguration().getBytes())));
        createDeploymentElement.appendChild(configurationElement);
        if (parameters.isStartDeployment() != null) {
            Element startDeploymentElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "StartDeployment");
            startDeploymentElement.appendChild(requestDoc.createTextNode(Boolean.toString(parameters.isStartDeployment()).toLowerCase()));
            createDeploymentElement.appendChild(startDeploymentElement);
        }
        if (parameters.isTreatWarningsAsError() != null) {
            Element treatWarningsAsErrorElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "TreatWarningsAsError");
            treatWarningsAsErrorElement.appendChild(requestDoc.createTextNode(Boolean.toString(parameters.isTreatWarningsAsError()).toLowerCase()));
            createDeploymentElement.appendChild(treatWarningsAsErrorElement);
        }
        if (parameters.getExtendedProperties() != null && (!(parameters.getExtendedProperties() instanceof LazyCollection) || ((LazyCollection)parameters.getExtendedProperties()).isInitialized())) {
            Element extendedPropertiesDictionaryElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "ExtendedProperties");
            for (Map.Entry<String, String> entry : parameters.getExtendedProperties().entrySet()) {
                String extendedPropertiesKey = entry.getKey();
                String extendedPropertiesValue = entry.getValue();
                Element extendedPropertiesElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "ExtendedProperty");
                extendedPropertiesDictionaryElement.appendChild(extendedPropertiesElement);
                Element extendedPropertiesKeyElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Name");
                extendedPropertiesKeyElement.appendChild(requestDoc.createTextNode(extendedPropertiesKey));
                extendedPropertiesElement.appendChild(extendedPropertiesKeyElement);
                Element extendedPropertiesValueElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Value");
                extendedPropertiesValueElement.appendChild(requestDoc.createTextNode(extendedPropertiesValue));
                extendedPropertiesElement.appendChild(extendedPropertiesValueElement);
            }
            createDeploymentElement.appendChild(extendedPropertiesDictionaryElement);
        }
        if (parameters.getExtensionConfiguration() != null) {
            Element extensionConfigurationElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "ExtensionConfiguration");
            createDeploymentElement.appendChild(extensionConfigurationElement);
            if (parameters.getExtensionConfiguration().getAllRoles() != null && (!(parameters.getExtensionConfiguration().getAllRoles() instanceof LazyCollection) || ((LazyCollection)parameters.getExtensionConfiguration().getAllRoles()).isInitialized())) {
                Element allRolesSequenceElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "AllRoles");
                for (ExtensionConfiguration.Extension allRolesItem : parameters.getExtensionConfiguration().getAllRoles()) {
                    Element extensionElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Extension");
                    allRolesSequenceElement.appendChild(extensionElement);
                    Element idElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Id");
                    idElement.appendChild(requestDoc.createTextNode(allRolesItem.getId()));
                    extensionElement.appendChild(idElement);
                }
                extensionConfigurationElement.appendChild(allRolesSequenceElement);
            }
            if (parameters.getExtensionConfiguration().getNamedRoles() != null && (!(parameters.getExtensionConfiguration().getNamedRoles() instanceof LazyCollection) || ((LazyCollection)parameters.getExtensionConfiguration().getNamedRoles()).isInitialized())) {
                Element namedRolesSequenceElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "NamedRoles");
                for (ExtensionConfiguration.NamedRole namedRolesItem : parameters.getExtensionConfiguration().getNamedRoles()) {
                    Element roleElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Role");
                    namedRolesSequenceElement.appendChild(roleElement);
                    Element roleNameElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "RoleName");
                    roleNameElement.appendChild(requestDoc.createTextNode(namedRolesItem.getRoleName()));
                    roleElement.appendChild(roleNameElement);
                    if (namedRolesItem.getExtensions() instanceof LazyCollection && !((LazyCollection)namedRolesItem.getExtensions()).isInitialized()) continue;
                    Element extensionsSequenceElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Extensions");
                    for (ExtensionConfiguration.Extension extensionsItem : namedRolesItem.getExtensions()) {
                        Element extensionElement2 = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Extension");
                        extensionsSequenceElement.appendChild(extensionElement2);
                        Element idElement2 = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Id");
                        idElement2.appendChild(requestDoc.createTextNode(extensionsItem.getId()));
                        extensionElement2.appendChild(idElement2);
                    }
                    roleElement.appendChild(extensionsSequenceElement);
                }
                extensionConfigurationElement.appendChild(namedRolesSequenceElement);
            }
        }
        DOMSource domSource = new DOMSource(requestDoc);
        StringWriter stringWriter = new StringWriter();
        StreamResult streamResult = new StreamResult(stringWriter);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.transform(domSource, streamResult);
        requestContent = stringWriter.toString();
        StringEntity entity = new StringEntity(requestContent);
        httpRequest.setEntity((HttpEntity)entity);
        httpRequest.setHeader("Content-Type", "application/xml");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 202) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, (String)requestContent, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            OperationResponse result = null;
            result = new OperationResponse();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)result);
            }
            OperationResponse operationResponse = result;
            return operationResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<OperationResponse> beginDeletingByNameAsync(final String serviceName, final String deploymentName, final boolean deleteFromStorage) {
        return this.getClient().getExecutorService().submit(new Callable<OperationResponse>(){

            @Override
            public OperationResponse call() throws Exception {
                return DeploymentOperationsImpl.this.beginDeletingByName(serviceName, deploymentName, deleteFromStorage);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResponse beginDeletingByName(String serviceName, String deploymentName, boolean deleteFromStorage) throws IOException, ServiceException {
        String baseUrl;
        if (serviceName == null) {
            throw new NullPointerException("serviceName");
        }
        if (deploymentName == null) {
            throw new NullPointerException("deploymentName");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("serviceName", serviceName);
            tracingParameters.put("deploymentName", deploymentName);
            tracingParameters.put("deleteFromStorage", deleteFromStorage);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"beginDeletingByNameAsync", tracingParameters);
        }
        String url = "";
        url = url + "/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/services/hostedservices/";
        url = url + URLEncoder.encode(serviceName, "UTF-8");
        url = url + "/deployments/";
        url = url + URLEncoder.encode(deploymentName, "UTF-8");
        ArrayList<String> queryParameters = new ArrayList<String>();
        if (deleteFromStorage) {
            queryParameters.add("comp=media");
        }
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, (String)"&");
        }
        if ((baseUrl = this.getClient().getBaseUri().toString()).charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        CustomHttpDelete httpRequest = new CustomHttpDelete(url);
        httpRequest.setHeader("x-ms-version", "2015-04-01");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 202) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            OperationResponse result = null;
            result = new OperationResponse();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)result);
            }
            OperationResponse operationResponse = result;
            return operationResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<OperationResponse> beginDeletingBySlotAsync(final String serviceName, final DeploymentSlot deploymentSlot) {
        return this.getClient().getExecutorService().submit(new Callable<OperationResponse>(){

            @Override
            public OperationResponse call() throws Exception {
                return DeploymentOperationsImpl.this.beginDeletingBySlot(serviceName, deploymentSlot);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResponse beginDeletingBySlot(String serviceName, DeploymentSlot deploymentSlot) throws IOException, ServiceException {
        if (serviceName == null) {
            throw new NullPointerException("serviceName");
        }
        if (deploymentSlot == null) {
            throw new NullPointerException("deploymentSlot");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("serviceName", serviceName);
            tracingParameters.put("deploymentSlot", (Object)deploymentSlot);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"beginDeletingBySlotAsync", tracingParameters);
        }
        String url = "";
        url = url + "/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/services/hostedservices/";
        url = url + URLEncoder.encode(serviceName, "UTF-8");
        url = url + "/deploymentslots/";
        url = url + URLEncoder.encode(deploymentSlot.toString(), "UTF-8");
        String baseUrl = this.getClient().getBaseUri().toString();
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        CustomHttpDelete httpRequest = new CustomHttpDelete(url);
        httpRequest.setHeader("x-ms-version", "2015-04-01");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 202) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            OperationResponse result = null;
            result = new OperationResponse();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)result);
            }
            OperationResponse operationResponse = result;
            return operationResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<OperationResponse> beginDeletingRoleInstanceByBeploymentSlotAsync(final String serviceName, final String deploymentSlot, final DeploymentDeleteRoleInstanceParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<OperationResponse>(){

            @Override
            public OperationResponse call() throws Exception {
                return DeploymentOperationsImpl.this.beginDeletingRoleInstanceByBeploymentSlot(serviceName, deploymentSlot, parameters);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResponse beginDeletingRoleInstanceByBeploymentSlot(String serviceName, String deploymentSlot, DeploymentDeleteRoleInstanceParameters parameters) throws ParserConfigurationException, SAXException, TransformerException, IOException, ServiceException {
        String baseUrl;
        if (serviceName == null) {
            throw new NullPointerException("serviceName");
        }
        if (deploymentSlot == null) {
            throw new NullPointerException("deploymentSlot");
        }
        if (parameters == null) {
            throw new NullPointerException("parameters");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("serviceName", serviceName);
            tracingParameters.put("deploymentSlot", deploymentSlot);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"beginDeletingRoleInstanceByBeploymentSlotAsync", tracingParameters);
        }
        String url = "";
        url = url + "/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/services/hostedservices/";
        url = url + URLEncoder.encode(serviceName, "UTF-8");
        url = url + "/deploymentslots/";
        url = url + URLEncoder.encode(deploymentSlot, "UTF-8");
        url = url + "/roleinstances/";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("comp=delete");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, (String)"&");
        }
        if ((baseUrl = this.getClient().getBaseUri().toString()).charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpPost httpRequest = new HttpPost(url);
        httpRequest.setHeader("Content-Type", "application/xml");
        httpRequest.setHeader("x-ms-version", "2015-04-01");
        String requestContent = null;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document requestDoc = documentBuilder.newDocument();
        if (parameters.getName() != null && (!(parameters.getName() instanceof LazyCollection) || ((LazyCollection)parameters.getName()).isInitialized())) {
            Element roleInstancesSequenceElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "RoleInstances");
            for (String roleInstancesItem : parameters.getName()) {
                Element roleInstancesItemElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Name");
                roleInstancesItemElement.appendChild(requestDoc.createTextNode(roleInstancesItem));
                roleInstancesSequenceElement.appendChild(roleInstancesItemElement);
            }
            requestDoc.appendChild(roleInstancesSequenceElement);
        }
        DOMSource domSource = new DOMSource(requestDoc);
        StringWriter stringWriter = new StringWriter();
        StreamResult streamResult = new StreamResult(stringWriter);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.transform(domSource, streamResult);
        requestContent = stringWriter.toString();
        StringEntity entity = new StringEntity(requestContent);
        httpRequest.setEntity((HttpEntity)entity);
        httpRequest.setHeader("Content-Type", "application/xml");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 202) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, (String)requestContent, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            OperationResponse result = null;
            result = new OperationResponse();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)result);
            }
            OperationResponse operationResponse = result;
            return operationResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<OperationResponse> beginDeletingRoleInstanceByDeploymentNameAsync(final String serviceName, final String deploymentName, final DeploymentDeleteRoleInstanceParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<OperationResponse>(){

            @Override
            public OperationResponse call() throws Exception {
                return DeploymentOperationsImpl.this.beginDeletingRoleInstanceByDeploymentName(serviceName, deploymentName, parameters);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResponse beginDeletingRoleInstanceByDeploymentName(String serviceName, String deploymentName, DeploymentDeleteRoleInstanceParameters parameters) throws ParserConfigurationException, SAXException, TransformerException, IOException, ServiceException {
        String baseUrl;
        if (serviceName == null) {
            throw new NullPointerException("serviceName");
        }
        if (deploymentName == null) {
            throw new NullPointerException("deploymentName");
        }
        if (parameters == null) {
            throw new NullPointerException("parameters");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("serviceName", serviceName);
            tracingParameters.put("deploymentName", deploymentName);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"beginDeletingRoleInstanceByDeploymentNameAsync", tracingParameters);
        }
        String url = "";
        url = url + "/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/services/hostedservices/";
        url = url + URLEncoder.encode(serviceName, "UTF-8");
        url = url + "/deployments/";
        url = url + URLEncoder.encode(deploymentName, "UTF-8");
        url = url + "/roleinstances/";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("comp=delete");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, (String)"&");
        }
        if ((baseUrl = this.getClient().getBaseUri().toString()).charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpPost httpRequest = new HttpPost(url);
        httpRequest.setHeader("Content-Type", "application/xml");
        httpRequest.setHeader("x-ms-version", "2015-04-01");
        String requestContent = null;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document requestDoc = documentBuilder.newDocument();
        if (parameters.getName() != null && (!(parameters.getName() instanceof LazyCollection) || ((LazyCollection)parameters.getName()).isInitialized())) {
            Element roleInstancesSequenceElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "RoleInstances");
            for (String roleInstancesItem : parameters.getName()) {
                Element roleInstancesItemElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Name");
                roleInstancesItemElement.appendChild(requestDoc.createTextNode(roleInstancesItem));
                roleInstancesSequenceElement.appendChild(roleInstancesItemElement);
            }
            requestDoc.appendChild(roleInstancesSequenceElement);
        }
        DOMSource domSource = new DOMSource(requestDoc);
        StringWriter stringWriter = new StringWriter();
        StreamResult streamResult = new StreamResult(stringWriter);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.transform(domSource, streamResult);
        requestContent = stringWriter.toString();
        StringEntity entity = new StringEntity(requestContent);
        httpRequest.setEntity((HttpEntity)entity);
        httpRequest.setHeader("Content-Type", "application/xml");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 202) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, (String)requestContent, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            OperationResponse result = null;
            result = new OperationResponse();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)result);
            }
            OperationResponse operationResponse = result;
            return operationResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<OperationResponse> beginGettingPackageByNameAsync(final String serviceName, final String deploymentName, final DeploymentGetPackageParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<OperationResponse>(){

            @Override
            public OperationResponse call() throws Exception {
                return DeploymentOperationsImpl.this.beginGettingPackageByName(serviceName, deploymentName, parameters);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResponse beginGettingPackageByName(String serviceName, String deploymentName, DeploymentGetPackageParameters parameters) throws IOException, ServiceException {
        String baseUrl;
        if (serviceName == null) {
            throw new NullPointerException("serviceName");
        }
        if (deploymentName == null) {
            throw new NullPointerException("deploymentName");
        }
        if (parameters == null) {
            throw new NullPointerException("parameters");
        }
        if (parameters.getContainerUri() == null) {
            throw new NullPointerException("parameters.ContainerUri");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("serviceName", serviceName);
            tracingParameters.put("deploymentName", deploymentName);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"beginGettingPackageByNameAsync", tracingParameters);
        }
        String url = "";
        url = url + "/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/services/hostedservices/";
        url = url + URLEncoder.encode(serviceName, "UTF-8");
        url = url + "/deployments/";
        url = url + URLEncoder.encode(deploymentName, "UTF-8");
        url = url + "/package";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("containerUri=" + URLEncoder.encode(parameters.getContainerUri().toString(), "UTF-8") + " +");
        if (parameters.isOverwriteExisting() != null) {
            queryParameters.add("overwriteExisting=" + URLEncoder.encode(Boolean.toString(parameters.isOverwriteExisting()).toLowerCase(), "UTF-8"));
        }
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, (String)"&");
        }
        if ((baseUrl = this.getClient().getBaseUri().toString()).charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpPost httpRequest = new HttpPost(url);
        httpRequest.setHeader("Content-Type", "application/xml");
        httpRequest.setHeader("x-ms-version", "2015-04-01");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 202) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            OperationResponse result = null;
            result = new OperationResponse();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)result);
            }
            OperationResponse operationResponse = result;
            return operationResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<OperationResponse> beginGettingPackageBySlotAsync(final String serviceName, final DeploymentSlot deploymentSlot, final DeploymentGetPackageParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<OperationResponse>(){

            @Override
            public OperationResponse call() throws Exception {
                return DeploymentOperationsImpl.this.beginGettingPackageBySlot(serviceName, deploymentSlot, parameters);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResponse beginGettingPackageBySlot(String serviceName, DeploymentSlot deploymentSlot, DeploymentGetPackageParameters parameters) throws IOException, ServiceException {
        String baseUrl;
        if (serviceName == null) {
            throw new NullPointerException("serviceName");
        }
        if (deploymentSlot == null) {
            throw new NullPointerException("deploymentSlot");
        }
        if (parameters == null) {
            throw new NullPointerException("parameters");
        }
        if (parameters.getContainerUri() == null) {
            throw new NullPointerException("parameters.ContainerUri");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("serviceName", serviceName);
            tracingParameters.put("deploymentSlot", (Object)deploymentSlot);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"beginGettingPackageBySlotAsync", tracingParameters);
        }
        String url = "";
        url = url + "/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/services/hostedservices/";
        url = url + URLEncoder.encode(serviceName, "UTF-8");
        url = url + "/deploymentslots/";
        url = url + URLEncoder.encode(deploymentSlot.toString(), "UTF-8");
        url = url + "/package";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("containerUri=" + URLEncoder.encode(parameters.getContainerUri().toString(), "UTF-8") + " +");
        if (parameters.isOverwriteExisting() != null) {
            queryParameters.add("overwriteExisting=" + URLEncoder.encode(Boolean.toString(parameters.isOverwriteExisting()).toLowerCase(), "UTF-8"));
        }
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, (String)"&");
        }
        if ((baseUrl = this.getClient().getBaseUri().toString()).charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpPost httpRequest = new HttpPost(url);
        httpRequest.setHeader("Content-Type", "application/xml");
        httpRequest.setHeader("x-ms-version", "2015-04-01");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 202) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            OperationResponse result = null;
            result = new OperationResponse();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)result);
            }
            OperationResponse operationResponse = result;
            return operationResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<OperationResponse> beginRebootingRoleInstanceByDeploymentNameAsync(final String serviceName, final String deploymentName, final String roleInstanceName) {
        return this.getClient().getExecutorService().submit(new Callable<OperationResponse>(){

            @Override
            public OperationResponse call() throws Exception {
                return DeploymentOperationsImpl.this.beginRebootingRoleInstanceByDeploymentName(serviceName, deploymentName, roleInstanceName);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResponse beginRebootingRoleInstanceByDeploymentName(String serviceName, String deploymentName, String roleInstanceName) throws IOException, ServiceException {
        String baseUrl;
        if (serviceName == null) {
            throw new NullPointerException("serviceName");
        }
        if (deploymentName == null) {
            throw new NullPointerException("deploymentName");
        }
        if (roleInstanceName == null) {
            throw new NullPointerException("roleInstanceName");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("serviceName", serviceName);
            tracingParameters.put("deploymentName", deploymentName);
            tracingParameters.put("roleInstanceName", roleInstanceName);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"beginRebootingRoleInstanceByDeploymentNameAsync", tracingParameters);
        }
        String url = "";
        url = url + "/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/services/hostedservices/";
        url = url + URLEncoder.encode(serviceName, "UTF-8");
        url = url + "/deployments/";
        url = url + URLEncoder.encode(deploymentName, "UTF-8");
        url = url + "/roleinstances/";
        url = url + URLEncoder.encode(roleInstanceName, "UTF-8");
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("comp=reboot");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, (String)"&");
        }
        if ((baseUrl = this.getClient().getBaseUri().toString()).charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpPost httpRequest = new HttpPost(url);
        httpRequest.setHeader("Content-Type", "application/xml");
        httpRequest.setHeader("x-ms-version", "2015-04-01");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 202) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            OperationResponse result = null;
            result = new OperationResponse();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)result);
            }
            OperationResponse operationResponse = result;
            return operationResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<OperationResponse> beginRebootingRoleInstanceByDeploymentSlotAsync(final String serviceName, final DeploymentSlot deploymentSlot, final String roleInstanceName) {
        return this.getClient().getExecutorService().submit(new Callable<OperationResponse>(){

            @Override
            public OperationResponse call() throws Exception {
                return DeploymentOperationsImpl.this.beginRebootingRoleInstanceByDeploymentSlot(serviceName, deploymentSlot, roleInstanceName);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResponse beginRebootingRoleInstanceByDeploymentSlot(String serviceName, DeploymentSlot deploymentSlot, String roleInstanceName) throws IOException, ServiceException {
        String baseUrl;
        if (serviceName == null) {
            throw new NullPointerException("serviceName");
        }
        if (deploymentSlot == null) {
            throw new NullPointerException("deploymentSlot");
        }
        if (roleInstanceName == null) {
            throw new NullPointerException("roleInstanceName");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("serviceName", serviceName);
            tracingParameters.put("deploymentSlot", (Object)deploymentSlot);
            tracingParameters.put("roleInstanceName", roleInstanceName);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"beginRebootingRoleInstanceByDeploymentSlotAsync", tracingParameters);
        }
        String url = "";
        url = url + "/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/services/hostedservices/";
        url = url + URLEncoder.encode(serviceName, "UTF-8");
        url = url + "/deploymentslots/";
        url = url + URLEncoder.encode(deploymentSlot.toString(), "UTF-8");
        url = url + "/roleinstances/";
        url = url + URLEncoder.encode(roleInstanceName, "UTF-8");
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("comp=reboot");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, (String)"&");
        }
        if ((baseUrl = this.getClient().getBaseUri().toString()).charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpPost httpRequest = new HttpPost(url);
        httpRequest.setHeader("Content-Type", "application/xml");
        httpRequest.setHeader("x-ms-version", "2015-04-01");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 202) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            OperationResponse result = null;
            result = new OperationResponse();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)result);
            }
            OperationResponse operationResponse = result;
            return operationResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<OperationResponse> beginRebuildingRoleInstanceByDeploymentNameAsync(final String serviceName, final String deploymentName, final String roleInstanceName, final String resources) {
        return this.getClient().getExecutorService().submit(new Callable<OperationResponse>(){

            @Override
            public OperationResponse call() throws Exception {
                return DeploymentOperationsImpl.this.beginRebuildingRoleInstanceByDeploymentName(serviceName, deploymentName, roleInstanceName, resources);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResponse beginRebuildingRoleInstanceByDeploymentName(String serviceName, String deploymentName, String roleInstanceName, String resources) throws IOException, ServiceException {
        String baseUrl;
        if (serviceName == null) {
            throw new NullPointerException("serviceName");
        }
        if (deploymentName == null) {
            throw new NullPointerException("deploymentName");
        }
        if (roleInstanceName == null) {
            throw new NullPointerException("roleInstanceName");
        }
        if (resources == null) {
            throw new NullPointerException("resources");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("serviceName", serviceName);
            tracingParameters.put("deploymentName", deploymentName);
            tracingParameters.put("roleInstanceName", roleInstanceName);
            tracingParameters.put("resources", resources);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"beginRebuildingRoleInstanceByDeploymentNameAsync", tracingParameters);
        }
        String url = "";
        url = url + "/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/services/hostedservices/";
        url = url + URLEncoder.encode(serviceName, "UTF-8");
        url = url + "/deployments/";
        url = url + URLEncoder.encode(deploymentName, "UTF-8");
        url = url + "/roleinstances/";
        url = url + URLEncoder.encode(roleInstanceName, "UTF-8");
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("comp=rebuild");
        queryParameters.add("resources=" + URLEncoder.encode(resources, "UTF-8"));
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, (String)"&");
        }
        if ((baseUrl = this.getClient().getBaseUri().toString()).charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpPost httpRequest = new HttpPost(url);
        httpRequest.setHeader("Content-Type", "application/xml");
        httpRequest.setHeader("x-ms-version", "2015-04-01");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 202) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            OperationResponse result = null;
            result = new OperationResponse();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)result);
            }
            OperationResponse operationResponse = result;
            return operationResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<OperationResponse> beginRebuildingRoleInstanceByDeploymentSlotAsync(final String serviceName, final String deploymentSlot, final String roleInstanceName, final String resources) {
        return this.getClient().getExecutorService().submit(new Callable<OperationResponse>(){

            @Override
            public OperationResponse call() throws Exception {
                return DeploymentOperationsImpl.this.beginRebuildingRoleInstanceByDeploymentSlot(serviceName, deploymentSlot, roleInstanceName, resources);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResponse beginRebuildingRoleInstanceByDeploymentSlot(String serviceName, String deploymentSlot, String roleInstanceName, String resources) throws IOException, ServiceException {
        String baseUrl;
        if (serviceName == null) {
            throw new NullPointerException("serviceName");
        }
        if (deploymentSlot == null) {
            throw new NullPointerException("deploymentSlot");
        }
        if (roleInstanceName == null) {
            throw new NullPointerException("roleInstanceName");
        }
        if (resources == null) {
            throw new NullPointerException("resources");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("serviceName", serviceName);
            tracingParameters.put("deploymentSlot", deploymentSlot);
            tracingParameters.put("roleInstanceName", roleInstanceName);
            tracingParameters.put("resources", resources);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"beginRebuildingRoleInstanceByDeploymentSlotAsync", tracingParameters);
        }
        String url = "";
        url = url + "/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/services/hostedservices/";
        url = url + URLEncoder.encode(serviceName, "UTF-8");
        url = url + "/deploymentslots/";
        url = url + URLEncoder.encode(deploymentSlot, "UTF-8");
        url = url + "/roleinstances/";
        url = url + URLEncoder.encode(roleInstanceName, "UTF-8");
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("comp=rebuild");
        queryParameters.add("resources=" + URLEncoder.encode(resources, "UTF-8"));
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, (String)"&");
        }
        if ((baseUrl = this.getClient().getBaseUri().toString()).charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpPost httpRequest = new HttpPost(url);
        httpRequest.setHeader("Content-Type", "application/xml");
        httpRequest.setHeader("x-ms-version", "2015-04-01");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 202) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            OperationResponse result = null;
            result = new OperationResponse();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)result);
            }
            OperationResponse operationResponse = result;
            return operationResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<OperationResponse> beginReimagingRoleInstanceByDeploymentNameAsync(final String serviceName, final String deploymentName, final String roleInstanceName) {
        return this.getClient().getExecutorService().submit(new Callable<OperationResponse>(){

            @Override
            public OperationResponse call() throws Exception {
                return DeploymentOperationsImpl.this.beginReimagingRoleInstanceByDeploymentName(serviceName, deploymentName, roleInstanceName);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResponse beginReimagingRoleInstanceByDeploymentName(String serviceName, String deploymentName, String roleInstanceName) throws IOException, ServiceException {
        String baseUrl;
        if (serviceName == null) {
            throw new NullPointerException("serviceName");
        }
        if (deploymentName == null) {
            throw new NullPointerException("deploymentName");
        }
        if (roleInstanceName == null) {
            throw new NullPointerException("roleInstanceName");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("serviceName", serviceName);
            tracingParameters.put("deploymentName", deploymentName);
            tracingParameters.put("roleInstanceName", roleInstanceName);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"beginReimagingRoleInstanceByDeploymentNameAsync", tracingParameters);
        }
        String url = "";
        url = url + "/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/services/hostedservices/";
        url = url + URLEncoder.encode(serviceName, "UTF-8");
        url = url + "/deployments/";
        url = url + URLEncoder.encode(deploymentName, "UTF-8");
        url = url + "/roleinstances/";
        url = url + URLEncoder.encode(roleInstanceName, "UTF-8");
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("comp=reimage");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, (String)"&");
        }
        if ((baseUrl = this.getClient().getBaseUri().toString()).charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpPost httpRequest = new HttpPost(url);
        httpRequest.setHeader("Content-Type", "application/xml");
        httpRequest.setHeader("x-ms-version", "2015-04-01");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 202) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            OperationResponse result = null;
            result = new OperationResponse();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)result);
            }
            OperationResponse operationResponse = result;
            return operationResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<OperationResponse> beginReimagingRoleInstanceByDeploymentSlotAsync(final String serviceName, final DeploymentSlot deploymentSlot, final String roleInstanceName) {
        return this.getClient().getExecutorService().submit(new Callable<OperationResponse>(){

            @Override
            public OperationResponse call() throws Exception {
                return DeploymentOperationsImpl.this.beginReimagingRoleInstanceByDeploymentSlot(serviceName, deploymentSlot, roleInstanceName);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResponse beginReimagingRoleInstanceByDeploymentSlot(String serviceName, DeploymentSlot deploymentSlot, String roleInstanceName) throws IOException, ServiceException {
        String baseUrl;
        if (serviceName == null) {
            throw new NullPointerException("serviceName");
        }
        if (deploymentSlot == null) {
            throw new NullPointerException("deploymentSlot");
        }
        if (roleInstanceName == null) {
            throw new NullPointerException("roleInstanceName");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("serviceName", serviceName);
            tracingParameters.put("deploymentSlot", (Object)deploymentSlot);
            tracingParameters.put("roleInstanceName", roleInstanceName);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"beginReimagingRoleInstanceByDeploymentSlotAsync", tracingParameters);
        }
        String url = "";
        url = url + "/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/services/hostedservices/";
        url = url + URLEncoder.encode(serviceName, "UTF-8");
        url = url + "/deploymentslots/";
        url = url + URLEncoder.encode(deploymentSlot.toString(), "UTF-8");
        url = url + "/roleinstances/";
        url = url + URLEncoder.encode(roleInstanceName, "UTF-8");
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("comp=reimage");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, (String)"&");
        }
        if ((baseUrl = this.getClient().getBaseUri().toString()).charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpPost httpRequest = new HttpPost(url);
        httpRequest.setHeader("Content-Type", "application/xml");
        httpRequest.setHeader("x-ms-version", "2015-04-01");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 202) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            OperationResponse result = null;
            result = new OperationResponse();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)result);
            }
            OperationResponse operationResponse = result;
            return operationResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<OperationResponse> beginSwappingAsync(final String serviceName, final DeploymentSwapParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<OperationResponse>(){

            @Override
            public OperationResponse call() throws Exception {
                return DeploymentOperationsImpl.this.beginSwapping(serviceName, parameters);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResponse beginSwapping(String serviceName, DeploymentSwapParameters parameters) throws ParserConfigurationException, SAXException, TransformerException, IOException, ServiceException {
        if (serviceName == null) {
            throw new NullPointerException("serviceName");
        }
        if (parameters == null) {
            throw new NullPointerException("parameters");
        }
        if (parameters.getSourceDeployment() == null) {
            throw new NullPointerException("parameters.SourceDeployment");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("serviceName", serviceName);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"beginSwappingAsync", tracingParameters);
        }
        String url = "";
        url = url + "/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/services/hostedservices/";
        url = url + URLEncoder.encode(serviceName, "UTF-8");
        String baseUrl = this.getClient().getBaseUri().toString();
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpPost httpRequest = new HttpPost(url);
        httpRequest.setHeader("Content-Type", "application/xml");
        httpRequest.setHeader("x-ms-version", "2015-04-01");
        String requestContent = null;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document requestDoc = documentBuilder.newDocument();
        Element swapElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Swap");
        requestDoc.appendChild(swapElement);
        if (parameters.getProductionDeployment() != null) {
            Element productionElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Production");
            productionElement.appendChild(requestDoc.createTextNode(parameters.getProductionDeployment()));
            swapElement.appendChild(productionElement);
        }
        Element sourceDeploymentElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "SourceDeployment");
        sourceDeploymentElement.appendChild(requestDoc.createTextNode(parameters.getSourceDeployment()));
        swapElement.appendChild(sourceDeploymentElement);
        DOMSource domSource = new DOMSource(requestDoc);
        StringWriter stringWriter = new StringWriter();
        StreamResult streamResult = new StreamResult(stringWriter);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.transform(domSource, streamResult);
        requestContent = stringWriter.toString();
        StringEntity entity = new StringEntity(requestContent);
        httpRequest.setEntity((HttpEntity)entity);
        httpRequest.setHeader("Content-Type", "application/xml");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 202) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, (String)requestContent, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            OperationResponse result = null;
            result = new OperationResponse();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)result);
            }
            OperationResponse operationResponse = result;
            return operationResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<OperationResponse> beginUpdatingStatusByDeploymentNameAsync(final String serviceName, final String deploymentName, final DeploymentUpdateStatusParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<OperationResponse>(){

            @Override
            public OperationResponse call() throws Exception {
                return DeploymentOperationsImpl.this.beginUpdatingStatusByDeploymentName(serviceName, deploymentName, parameters);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResponse beginUpdatingStatusByDeploymentName(String serviceName, String deploymentName, DeploymentUpdateStatusParameters parameters) throws ParserConfigurationException, SAXException, TransformerException, IOException, ServiceException {
        String baseUrl;
        if (serviceName == null) {
            throw new NullPointerException("serviceName");
        }
        if (deploymentName == null) {
            throw new NullPointerException("deploymentName");
        }
        if (parameters == null) {
            throw new NullPointerException("parameters");
        }
        if (parameters.getStatus() == null) {
            throw new NullPointerException("parameters.Status");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("serviceName", serviceName);
            tracingParameters.put("deploymentName", deploymentName);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"beginUpdatingStatusByDeploymentNameAsync", tracingParameters);
        }
        String url = "";
        url = url + "/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/services/hostedservices/";
        url = url + URLEncoder.encode(serviceName, "UTF-8");
        url = url + "/deployments/";
        url = url + URLEncoder.encode(deploymentName, "UTF-8");
        url = url + "/";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("comp=status");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, (String)"&");
        }
        if ((baseUrl = this.getClient().getBaseUri().toString()).charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpPost httpRequest = new HttpPost(url);
        httpRequest.setHeader("Content-Type", "application/xml");
        httpRequest.setHeader("x-ms-version", "2015-04-01");
        String requestContent = null;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document requestDoc = documentBuilder.newDocument();
        Element updateDeploymentStatusElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "UpdateDeploymentStatus");
        requestDoc.appendChild(updateDeploymentStatusElement);
        Element statusElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Status");
        statusElement.appendChild(requestDoc.createTextNode(parameters.getStatus().toString()));
        updateDeploymentStatusElement.appendChild(statusElement);
        DOMSource domSource = new DOMSource(requestDoc);
        StringWriter stringWriter = new StringWriter();
        StreamResult streamResult = new StreamResult(stringWriter);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.transform(domSource, streamResult);
        requestContent = stringWriter.toString();
        StringEntity entity = new StringEntity(requestContent);
        httpRequest.setEntity((HttpEntity)entity);
        httpRequest.setHeader("Content-Type", "application/xml");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 202) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, (String)requestContent, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            OperationResponse result = null;
            result = new OperationResponse();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)result);
            }
            OperationResponse operationResponse = result;
            return operationResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<OperationResponse> beginUpdatingStatusByDeploymentSlotAsync(final String serviceName, final DeploymentSlot deploymentSlot, final DeploymentUpdateStatusParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<OperationResponse>(){

            @Override
            public OperationResponse call() throws Exception {
                return DeploymentOperationsImpl.this.beginUpdatingStatusByDeploymentSlot(serviceName, deploymentSlot, parameters);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResponse beginUpdatingStatusByDeploymentSlot(String serviceName, DeploymentSlot deploymentSlot, DeploymentUpdateStatusParameters parameters) throws ParserConfigurationException, SAXException, TransformerException, IOException, ServiceException {
        String baseUrl;
        if (serviceName == null) {
            throw new NullPointerException("serviceName");
        }
        if (deploymentSlot == null) {
            throw new NullPointerException("deploymentSlot");
        }
        if (parameters == null) {
            throw new NullPointerException("parameters");
        }
        if (parameters.getStatus() == null) {
            throw new NullPointerException("parameters.Status");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("serviceName", serviceName);
            tracingParameters.put("deploymentSlot", (Object)deploymentSlot);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"beginUpdatingStatusByDeploymentSlotAsync", tracingParameters);
        }
        String url = "";
        url = url + "/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/services/hostedservices/";
        url = url + URLEncoder.encode(serviceName, "UTF-8");
        url = url + "/deploymentslots/";
        url = url + URLEncoder.encode(deploymentSlot.toString(), "UTF-8");
        url = url + "/";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("comp=status");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, (String)"&");
        }
        if ((baseUrl = this.getClient().getBaseUri().toString()).charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpPost httpRequest = new HttpPost(url);
        httpRequest.setHeader("Content-Type", "application/xml");
        httpRequest.setHeader("x-ms-version", "2015-04-01");
        String requestContent = null;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document requestDoc = documentBuilder.newDocument();
        Element updateDeploymentStatusElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "UpdateDeploymentStatus");
        requestDoc.appendChild(updateDeploymentStatusElement);
        Element statusElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Status");
        statusElement.appendChild(requestDoc.createTextNode(parameters.getStatus().toString()));
        updateDeploymentStatusElement.appendChild(statusElement);
        DOMSource domSource = new DOMSource(requestDoc);
        StringWriter stringWriter = new StringWriter();
        StreamResult streamResult = new StreamResult(stringWriter);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.transform(domSource, streamResult);
        requestContent = stringWriter.toString();
        StringEntity entity = new StringEntity(requestContent);
        httpRequest.setEntity((HttpEntity)entity);
        httpRequest.setHeader("Content-Type", "application/xml");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 202) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, (String)requestContent, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            OperationResponse result = null;
            result = new OperationResponse();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)result);
            }
            OperationResponse operationResponse = result;
            return operationResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<OperationResponse> beginUpgradingByNameAsync(final String serviceName, final String deploymentName, final DeploymentUpgradeParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<OperationResponse>(){

            @Override
            public OperationResponse call() throws Exception {
                return DeploymentOperationsImpl.this.beginUpgradingByName(serviceName, deploymentName, parameters);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResponse beginUpgradingByName(String serviceName, String deploymentName, DeploymentUpgradeParameters parameters) throws ParserConfigurationException, SAXException, TransformerException, IOException, ServiceException {
        String baseUrl;
        if (serviceName == null) {
            throw new NullPointerException("serviceName");
        }
        if (deploymentName == null) {
            throw new NullPointerException("deploymentName");
        }
        if (parameters == null) {
            throw new NullPointerException("parameters");
        }
        if (parameters.getConfiguration() == null) {
            throw new NullPointerException("parameters.Configuration");
        }
        if (parameters.getExtensionConfiguration() != null) {
            if (parameters.getExtensionConfiguration().getAllRoles() != null) {
                for (ExtensionConfiguration.Extension allRolesParameterItem : parameters.getExtensionConfiguration().getAllRoles()) {
                    if (allRolesParameterItem.getId() != null) continue;
                    throw new NullPointerException("parameters.ExtensionConfiguration.AllRoles.Id");
                }
            }
            if (parameters.getExtensionConfiguration().getNamedRoles() != null) {
                for (ExtensionConfiguration.NamedRole namedRolesParameterItem : parameters.getExtensionConfiguration().getNamedRoles()) {
                    if (namedRolesParameterItem.getExtensions() == null) {
                        throw new NullPointerException("parameters.ExtensionConfiguration.NamedRoles.Extensions");
                    }
                    if (namedRolesParameterItem.getExtensions() != null) {
                        for (ExtensionConfiguration.Extension extensionsParameterItem : namedRolesParameterItem.getExtensions()) {
                            if (extensionsParameterItem.getId() != null) continue;
                            throw new NullPointerException("parameters.ExtensionConfiguration.NamedRoles.Extensions.Id");
                        }
                    }
                    if (namedRolesParameterItem.getRoleName() != null) continue;
                    throw new NullPointerException("parameters.ExtensionConfiguration.NamedRoles.RoleName");
                }
            }
        }
        if (parameters.getLabel() == null) {
            throw new NullPointerException("parameters.Label");
        }
        if (parameters.getLabel().length() > 100) {
            throw new IllegalArgumentException("parameters.Label");
        }
        if (parameters.getMode() == null) {
            throw new NullPointerException("parameters.Mode");
        }
        if (parameters.getPackageUri() == null) {
            throw new NullPointerException("parameters.PackageUri");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("serviceName", serviceName);
            tracingParameters.put("deploymentName", deploymentName);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"beginUpgradingByNameAsync", tracingParameters);
        }
        String url = "";
        url = url + "/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/services/hostedservices/";
        url = url + URLEncoder.encode(serviceName, "UTF-8");
        url = url + "/deployments/";
        url = url + URLEncoder.encode(deploymentName, "UTF-8");
        url = url + "/";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("comp=upgrade");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, (String)"&");
        }
        if ((baseUrl = this.getClient().getBaseUri().toString()).charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpPost httpRequest = new HttpPost(url);
        httpRequest.setHeader("Content-Type", "application/xml");
        httpRequest.setHeader("x-ms-version", "2015-04-01");
        String requestContent = null;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document requestDoc = documentBuilder.newDocument();
        Element upgradeDeploymentElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "UpgradeDeployment");
        requestDoc.appendChild(upgradeDeploymentElement);
        Element modeElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Mode");
        modeElement.appendChild(requestDoc.createTextNode(parameters.getMode().toString()));
        upgradeDeploymentElement.appendChild(modeElement);
        Element packageUrlElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "PackageUrl");
        packageUrlElement.appendChild(requestDoc.createTextNode(parameters.getPackageUri().toString()));
        upgradeDeploymentElement.appendChild(packageUrlElement);
        Element configurationElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Configuration");
        configurationElement.appendChild(requestDoc.createTextNode(Base64.encode((byte[])parameters.getConfiguration().getBytes())));
        upgradeDeploymentElement.appendChild(configurationElement);
        Element labelElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Label");
        labelElement.appendChild(requestDoc.createTextNode(Base64.encode((byte[])parameters.getLabel().getBytes())));
        upgradeDeploymentElement.appendChild(labelElement);
        if (parameters.getRoleToUpgrade() != null) {
            Element roleToUpgradeElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "RoleToUpgrade");
            roleToUpgradeElement.appendChild(requestDoc.createTextNode(parameters.getRoleToUpgrade()));
            upgradeDeploymentElement.appendChild(roleToUpgradeElement);
        }
        Element forceElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Force");
        forceElement.appendChild(requestDoc.createTextNode(Boolean.toString(parameters.isForce()).toLowerCase()));
        upgradeDeploymentElement.appendChild(forceElement);
        if (parameters.getExtendedProperties() != null && (!(parameters.getExtendedProperties() instanceof LazyCollection) || ((LazyCollection)parameters.getExtendedProperties()).isInitialized())) {
            Element extendedPropertiesDictionaryElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "ExtendedProperties");
            for (Map.Entry<String, String> entry : parameters.getExtendedProperties().entrySet()) {
                String extendedPropertiesKey = entry.getKey();
                String extendedPropertiesValue = entry.getValue();
                Element extendedPropertiesElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "ExtendedProperty");
                extendedPropertiesDictionaryElement.appendChild(extendedPropertiesElement);
                Element extendedPropertiesKeyElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Name");
                extendedPropertiesKeyElement.appendChild(requestDoc.createTextNode(extendedPropertiesKey));
                extendedPropertiesElement.appendChild(extendedPropertiesKeyElement);
                Element extendedPropertiesValueElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Value");
                extendedPropertiesValueElement.appendChild(requestDoc.createTextNode(extendedPropertiesValue));
                extendedPropertiesElement.appendChild(extendedPropertiesValueElement);
            }
            upgradeDeploymentElement.appendChild(extendedPropertiesDictionaryElement);
        }
        if (parameters.getExtensionConfiguration() != null) {
            Element extensionConfigurationElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "ExtensionConfiguration");
            upgradeDeploymentElement.appendChild(extensionConfigurationElement);
            if (parameters.getExtensionConfiguration().getAllRoles() != null && (!(parameters.getExtensionConfiguration().getAllRoles() instanceof LazyCollection) || ((LazyCollection)parameters.getExtensionConfiguration().getAllRoles()).isInitialized())) {
                Element allRolesSequenceElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "AllRoles");
                for (ExtensionConfiguration.Extension allRolesItem : parameters.getExtensionConfiguration().getAllRoles()) {
                    Element extensionElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Extension");
                    allRolesSequenceElement.appendChild(extensionElement);
                    Element idElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Id");
                    idElement.appendChild(requestDoc.createTextNode(allRolesItem.getId()));
                    extensionElement.appendChild(idElement);
                }
                extensionConfigurationElement.appendChild(allRolesSequenceElement);
            }
            if (parameters.getExtensionConfiguration().getNamedRoles() != null && (!(parameters.getExtensionConfiguration().getNamedRoles() instanceof LazyCollection) || ((LazyCollection)parameters.getExtensionConfiguration().getNamedRoles()).isInitialized())) {
                Element namedRolesSequenceElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "NamedRoles");
                for (ExtensionConfiguration.NamedRole namedRolesItem : parameters.getExtensionConfiguration().getNamedRoles()) {
                    Element roleElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Role");
                    namedRolesSequenceElement.appendChild(roleElement);
                    Element roleNameElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "RoleName");
                    roleNameElement.appendChild(requestDoc.createTextNode(namedRolesItem.getRoleName()));
                    roleElement.appendChild(roleNameElement);
                    if (namedRolesItem.getExtensions() instanceof LazyCollection && !((LazyCollection)namedRolesItem.getExtensions()).isInitialized()) continue;
                    Element extensionsSequenceElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Extensions");
                    for (ExtensionConfiguration.Extension extensionsItem : namedRolesItem.getExtensions()) {
                        Element extensionElement2 = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Extension");
                        extensionsSequenceElement.appendChild(extensionElement2);
                        Element idElement2 = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Id");
                        idElement2.appendChild(requestDoc.createTextNode(extensionsItem.getId()));
                        extensionElement2.appendChild(idElement2);
                    }
                    roleElement.appendChild(extensionsSequenceElement);
                }
                extensionConfigurationElement.appendChild(namedRolesSequenceElement);
            }
        }
        DOMSource domSource = new DOMSource(requestDoc);
        StringWriter stringWriter = new StringWriter();
        StreamResult streamResult = new StreamResult(stringWriter);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.transform(domSource, streamResult);
        requestContent = stringWriter.toString();
        StringEntity entity = new StringEntity(requestContent);
        httpRequest.setEntity((HttpEntity)entity);
        httpRequest.setHeader("Content-Type", "application/xml");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 202) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, (String)requestContent, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            OperationResponse result = null;
            result = new OperationResponse();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)result);
            }
            OperationResponse operationResponse = result;
            return operationResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<OperationResponse> beginUpgradingBySlotAsync(final String serviceName, final DeploymentSlot deploymentSlot, final DeploymentUpgradeParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<OperationResponse>(){

            @Override
            public OperationResponse call() throws Exception {
                return DeploymentOperationsImpl.this.beginUpgradingBySlot(serviceName, deploymentSlot, parameters);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResponse beginUpgradingBySlot(String serviceName, DeploymentSlot deploymentSlot, DeploymentUpgradeParameters parameters) throws ParserConfigurationException, SAXException, TransformerException, IOException, ServiceException {
        String baseUrl;
        if (serviceName == null) {
            throw new NullPointerException("serviceName");
        }
        if (deploymentSlot == null) {
            throw new NullPointerException("deploymentSlot");
        }
        if (parameters == null) {
            throw new NullPointerException("parameters");
        }
        if (parameters.getConfiguration() == null) {
            throw new NullPointerException("parameters.Configuration");
        }
        if (parameters.getExtensionConfiguration() != null) {
            if (parameters.getExtensionConfiguration().getAllRoles() != null) {
                for (ExtensionConfiguration.Extension allRolesParameterItem : parameters.getExtensionConfiguration().getAllRoles()) {
                    if (allRolesParameterItem.getId() != null) continue;
                    throw new NullPointerException("parameters.ExtensionConfiguration.AllRoles.Id");
                }
            }
            if (parameters.getExtensionConfiguration().getNamedRoles() != null) {
                for (ExtensionConfiguration.NamedRole namedRolesParameterItem : parameters.getExtensionConfiguration().getNamedRoles()) {
                    if (namedRolesParameterItem.getExtensions() == null) {
                        throw new NullPointerException("parameters.ExtensionConfiguration.NamedRoles.Extensions");
                    }
                    if (namedRolesParameterItem.getExtensions() != null) {
                        for (ExtensionConfiguration.Extension extensionsParameterItem : namedRolesParameterItem.getExtensions()) {
                            if (extensionsParameterItem.getId() != null) continue;
                            throw new NullPointerException("parameters.ExtensionConfiguration.NamedRoles.Extensions.Id");
                        }
                    }
                    if (namedRolesParameterItem.getRoleName() != null) continue;
                    throw new NullPointerException("parameters.ExtensionConfiguration.NamedRoles.RoleName");
                }
            }
        }
        if (parameters.getLabel() == null) {
            throw new NullPointerException("parameters.Label");
        }
        if (parameters.getLabel().length() > 100) {
            throw new IllegalArgumentException("parameters.Label");
        }
        if (parameters.getMode() == null) {
            throw new NullPointerException("parameters.Mode");
        }
        if (parameters.getPackageUri() == null) {
            throw new NullPointerException("parameters.PackageUri");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("serviceName", serviceName);
            tracingParameters.put("deploymentSlot", (Object)deploymentSlot);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"beginUpgradingBySlotAsync", tracingParameters);
        }
        String url = "";
        url = url + "/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/services/hostedservices/";
        url = url + URLEncoder.encode(serviceName, "UTF-8");
        url = url + "/deploymentslots/";
        url = url + URLEncoder.encode(deploymentSlot.toString(), "UTF-8");
        url = url + "/";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("comp=upgrade");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, (String)"&");
        }
        if ((baseUrl = this.getClient().getBaseUri().toString()).charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpPost httpRequest = new HttpPost(url);
        httpRequest.setHeader("Content-Type", "application/xml");
        httpRequest.setHeader("x-ms-version", "2015-04-01");
        String requestContent = null;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document requestDoc = documentBuilder.newDocument();
        Element upgradeDeploymentElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "UpgradeDeployment");
        requestDoc.appendChild(upgradeDeploymentElement);
        Element modeElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Mode");
        modeElement.appendChild(requestDoc.createTextNode(parameters.getMode().toString()));
        upgradeDeploymentElement.appendChild(modeElement);
        Element packageUrlElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "PackageUrl");
        packageUrlElement.appendChild(requestDoc.createTextNode(parameters.getPackageUri().toString()));
        upgradeDeploymentElement.appendChild(packageUrlElement);
        Element configurationElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Configuration");
        configurationElement.appendChild(requestDoc.createTextNode(Base64.encode((byte[])parameters.getConfiguration().getBytes())));
        upgradeDeploymentElement.appendChild(configurationElement);
        Element labelElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Label");
        labelElement.appendChild(requestDoc.createTextNode(Base64.encode((byte[])parameters.getLabel().getBytes())));
        upgradeDeploymentElement.appendChild(labelElement);
        if (parameters.getRoleToUpgrade() != null) {
            Element roleToUpgradeElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "RoleToUpgrade");
            roleToUpgradeElement.appendChild(requestDoc.createTextNode(parameters.getRoleToUpgrade()));
            upgradeDeploymentElement.appendChild(roleToUpgradeElement);
        }
        Element forceElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Force");
        forceElement.appendChild(requestDoc.createTextNode(Boolean.toString(parameters.isForce()).toLowerCase()));
        upgradeDeploymentElement.appendChild(forceElement);
        if (parameters.getExtendedProperties() != null && (!(parameters.getExtendedProperties() instanceof LazyCollection) || ((LazyCollection)parameters.getExtendedProperties()).isInitialized())) {
            Element extendedPropertiesDictionaryElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "ExtendedProperties");
            for (Map.Entry<String, String> entry : parameters.getExtendedProperties().entrySet()) {
                String extendedPropertiesKey = entry.getKey();
                String extendedPropertiesValue = entry.getValue();
                Element extendedPropertiesElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "ExtendedProperty");
                extendedPropertiesDictionaryElement.appendChild(extendedPropertiesElement);
                Element extendedPropertiesKeyElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Name");
                extendedPropertiesKeyElement.appendChild(requestDoc.createTextNode(extendedPropertiesKey));
                extendedPropertiesElement.appendChild(extendedPropertiesKeyElement);
                Element extendedPropertiesValueElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Value");
                extendedPropertiesValueElement.appendChild(requestDoc.createTextNode(extendedPropertiesValue));
                extendedPropertiesElement.appendChild(extendedPropertiesValueElement);
            }
            upgradeDeploymentElement.appendChild(extendedPropertiesDictionaryElement);
        }
        if (parameters.getExtensionConfiguration() != null) {
            Element extensionConfigurationElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "ExtensionConfiguration");
            upgradeDeploymentElement.appendChild(extensionConfigurationElement);
            if (parameters.getExtensionConfiguration().getAllRoles() != null && (!(parameters.getExtensionConfiguration().getAllRoles() instanceof LazyCollection) || ((LazyCollection)parameters.getExtensionConfiguration().getAllRoles()).isInitialized())) {
                Element allRolesSequenceElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "AllRoles");
                for (ExtensionConfiguration.Extension allRolesItem : parameters.getExtensionConfiguration().getAllRoles()) {
                    Element extensionElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Extension");
                    allRolesSequenceElement.appendChild(extensionElement);
                    Element idElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Id");
                    idElement.appendChild(requestDoc.createTextNode(allRolesItem.getId()));
                    extensionElement.appendChild(idElement);
                }
                extensionConfigurationElement.appendChild(allRolesSequenceElement);
            }
            if (parameters.getExtensionConfiguration().getNamedRoles() != null && (!(parameters.getExtensionConfiguration().getNamedRoles() instanceof LazyCollection) || ((LazyCollection)parameters.getExtensionConfiguration().getNamedRoles()).isInitialized())) {
                Element namedRolesSequenceElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "NamedRoles");
                for (ExtensionConfiguration.NamedRole namedRolesItem : parameters.getExtensionConfiguration().getNamedRoles()) {
                    Element roleElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Role");
                    namedRolesSequenceElement.appendChild(roleElement);
                    Element roleNameElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "RoleName");
                    roleNameElement.appendChild(requestDoc.createTextNode(namedRolesItem.getRoleName()));
                    roleElement.appendChild(roleNameElement);
                    if (namedRolesItem.getExtensions() instanceof LazyCollection && !((LazyCollection)namedRolesItem.getExtensions()).isInitialized()) continue;
                    Element extensionsSequenceElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Extensions");
                    for (ExtensionConfiguration.Extension extensionsItem : namedRolesItem.getExtensions()) {
                        Element extensionElement2 = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Extension");
                        extensionsSequenceElement.appendChild(extensionElement2);
                        Element idElement2 = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Id");
                        idElement2.appendChild(requestDoc.createTextNode(extensionsItem.getId()));
                        extensionElement2.appendChild(idElement2);
                    }
                    roleElement.appendChild(extensionsSequenceElement);
                }
                extensionConfigurationElement.appendChild(namedRolesSequenceElement);
            }
        }
        DOMSource domSource = new DOMSource(requestDoc);
        StringWriter stringWriter = new StringWriter();
        StreamResult streamResult = new StreamResult(stringWriter);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.transform(domSource, streamResult);
        requestContent = stringWriter.toString();
        StringEntity entity = new StringEntity(requestContent);
        httpRequest.setEntity((HttpEntity)entity);
        httpRequest.setHeader("Content-Type", "application/xml");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 202) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, (String)requestContent, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            OperationResponse result = null;
            result = new OperationResponse();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)result);
            }
            OperationResponse operationResponse = result;
            return operationResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<OperationResponse> beginWalkingUpgradeDomainByDeploymentNameAsync(final String serviceName, final String deploymentName, final DeploymentWalkUpgradeDomainParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<OperationResponse>(){

            @Override
            public OperationResponse call() throws Exception {
                return DeploymentOperationsImpl.this.beginWalkingUpgradeDomainByDeploymentName(serviceName, deploymentName, parameters);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResponse beginWalkingUpgradeDomainByDeploymentName(String serviceName, String deploymentName, DeploymentWalkUpgradeDomainParameters parameters) throws ParserConfigurationException, SAXException, TransformerException, IOException, ServiceException {
        String baseUrl;
        if (serviceName == null) {
            throw new NullPointerException("serviceName");
        }
        if (deploymentName == null) {
            throw new NullPointerException("deploymentName");
        }
        if (parameters == null) {
            throw new NullPointerException("parameters");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("serviceName", serviceName);
            tracingParameters.put("deploymentName", deploymentName);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"beginWalkingUpgradeDomainByDeploymentNameAsync", tracingParameters);
        }
        String url = "";
        url = url + "/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/services/hostedservices/";
        url = url + URLEncoder.encode(serviceName, "UTF-8");
        url = url + "/deployments/";
        url = url + URLEncoder.encode(deploymentName, "UTF-8");
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("comp=walkupgradedomain");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, (String)"&");
        }
        if ((baseUrl = this.getClient().getBaseUri().toString()).charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpPost httpRequest = new HttpPost(url);
        httpRequest.setHeader("Content-Type", "application/xml");
        httpRequest.setHeader("x-ms-version", "2015-04-01");
        String requestContent = null;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document requestDoc = documentBuilder.newDocument();
        Element walkUpgradeDomainElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "WalkUpgradeDomain");
        requestDoc.appendChild(walkUpgradeDomainElement);
        Element upgradeDomainElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "UpgradeDomain");
        upgradeDomainElement.appendChild(requestDoc.createTextNode(Integer.toString(parameters.getUpgradeDomain())));
        walkUpgradeDomainElement.appendChild(upgradeDomainElement);
        DOMSource domSource = new DOMSource(requestDoc);
        StringWriter stringWriter = new StringWriter();
        StreamResult streamResult = new StreamResult(stringWriter);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.transform(domSource, streamResult);
        requestContent = stringWriter.toString();
        StringEntity entity = new StringEntity(requestContent);
        httpRequest.setEntity((HttpEntity)entity);
        httpRequest.setHeader("Content-Type", "application/xml");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 202) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, (String)requestContent, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            OperationResponse result = null;
            result = new OperationResponse();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)result);
            }
            OperationResponse operationResponse = result;
            return operationResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<OperationResponse> beginWalkingUpgradeDomainByDeploymentSlotAsync(final String serviceName, final DeploymentSlot deploymentSlot, final DeploymentWalkUpgradeDomainParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<OperationResponse>(){

            @Override
            public OperationResponse call() throws Exception {
                return DeploymentOperationsImpl.this.beginWalkingUpgradeDomainByDeploymentSlot(serviceName, deploymentSlot, parameters);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResponse beginWalkingUpgradeDomainByDeploymentSlot(String serviceName, DeploymentSlot deploymentSlot, DeploymentWalkUpgradeDomainParameters parameters) throws ParserConfigurationException, SAXException, TransformerException, IOException, ServiceException {
        String baseUrl;
        if (serviceName == null) {
            throw new NullPointerException("serviceName");
        }
        if (deploymentSlot == null) {
            throw new NullPointerException("deploymentSlot");
        }
        if (parameters == null) {
            throw new NullPointerException("parameters");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("serviceName", serviceName);
            tracingParameters.put("deploymentSlot", (Object)deploymentSlot);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"beginWalkingUpgradeDomainByDeploymentSlotAsync", tracingParameters);
        }
        String url = "";
        url = url + "/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/services/hostedservices/";
        url = url + URLEncoder.encode(serviceName, "UTF-8");
        url = url + "/deploymentslots/";
        url = url + URLEncoder.encode(deploymentSlot.toString(), "UTF-8");
        url = url + "/";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("comp=walkupgradedomain");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, (String)"&");
        }
        if ((baseUrl = this.getClient().getBaseUri().toString()).charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpPost httpRequest = new HttpPost(url);
        httpRequest.setHeader("Content-Type", "application/xml");
        httpRequest.setHeader("x-ms-version", "2015-04-01");
        String requestContent = null;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document requestDoc = documentBuilder.newDocument();
        Element walkUpgradeDomainElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "WalkUpgradeDomain");
        requestDoc.appendChild(walkUpgradeDomainElement);
        Element upgradeDomainElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "UpgradeDomain");
        upgradeDomainElement.appendChild(requestDoc.createTextNode(Integer.toString(parameters.getUpgradeDomain())));
        walkUpgradeDomainElement.appendChild(upgradeDomainElement);
        DOMSource domSource = new DOMSource(requestDoc);
        StringWriter stringWriter = new StringWriter();
        StreamResult streamResult = new StreamResult(stringWriter);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.transform(domSource, streamResult);
        requestContent = stringWriter.toString();
        StringEntity entity = new StringEntity(requestContent);
        httpRequest.setEntity((HttpEntity)entity);
        httpRequest.setHeader("Content-Type", "application/xml");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 202) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, (String)requestContent, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            OperationResponse result = null;
            result = new OperationResponse();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)result);
            }
            OperationResponse operationResponse = result;
            return operationResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<OperationStatusResponse> changeConfigurationByNameAsync(final String serviceName, final String deploymentName, final DeploymentChangeConfigurationParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<OperationStatusResponse>(){

            @Override
            public OperationStatusResponse call() throws Exception {
                return DeploymentOperationsImpl.this.changeConfigurationByName(serviceName, deploymentName, parameters);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationStatusResponse changeConfigurationByName(String serviceName, String deploymentName, DeploymentChangeConfigurationParameters parameters) throws InterruptedException, ExecutionException, ServiceException, IOException {
        ComputeManagementClient client2 = this.getClient();
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("serviceName", serviceName);
            tracingParameters.put("deploymentName", deploymentName);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"changeConfigurationByNameAsync", tracingParameters);
        }
        try {
            if (shouldTrace) {
                client2 = (ComputeManagementClient)((ComputeManagementClient)this.getClient().withRequestFilterLast((ServiceRequestFilter)new ClientRequestTrackingHandler(invocationId))).withResponseFilterLast((ServiceResponseFilter)new ClientRequestTrackingHandler(invocationId));
            }
            OperationResponse response = client2.getDeploymentsOperations().beginChangingConfigurationByNameAsync(serviceName, deploymentName, parameters).get();
            OperationStatusResponse result = client2.getOperationStatusAsync(response.getRequestId()).get();
            int delayInSeconds = 30;
            if (client2.getLongRunningOperationInitialTimeout() >= 0) {
                delayInSeconds = client2.getLongRunningOperationInitialTimeout();
            }
            while (result.getStatus() != null && result.getStatus().equals((Object)OperationStatus.InProgress)) {
                Thread.sleep(delayInSeconds * 1000);
                result = client2.getOperationStatusAsync(response.getRequestId()).get();
                delayInSeconds = 30;
                if (client2.getLongRunningOperationRetryTimeout() < 0) continue;
                delayInSeconds = client2.getLongRunningOperationRetryTimeout();
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)result);
            }
            if (result.getStatus() != OperationStatus.Succeeded) {
                if (result.getError() != null) {
                    ServiceException ex = new ServiceException(result.getError().getCode() + " : " + result.getError().getMessage());
                    ex.setError(new CloudError());
                    ex.getError().setCode(result.getError().getCode());
                    ex.getError().setMessage(result.getError().getMessage());
                    if (shouldTrace) {
                        CloudTracing.error((String)invocationId, (Exception)ex);
                    }
                    throw ex;
                }
                ServiceException ex = new ServiceException("");
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            OperationStatusResponse operationStatusResponse = result;
            return operationStatusResponse;
        }
        finally {
            if (client2 != null && shouldTrace) {
                client2.close();
            }
        }
    }

    @Override
    public Future<OperationStatusResponse> changeConfigurationBySlotAsync(final String serviceName, final DeploymentSlot deploymentSlot, final DeploymentChangeConfigurationParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<OperationStatusResponse>(){

            @Override
            public OperationStatusResponse call() throws Exception {
                return DeploymentOperationsImpl.this.changeConfigurationBySlot(serviceName, deploymentSlot, parameters);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationStatusResponse changeConfigurationBySlot(String serviceName, DeploymentSlot deploymentSlot, DeploymentChangeConfigurationParameters parameters) throws InterruptedException, ExecutionException, ServiceException, IOException {
        ComputeManagementClient client2 = this.getClient();
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("serviceName", serviceName);
            tracingParameters.put("deploymentSlot", (Object)deploymentSlot);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"changeConfigurationBySlotAsync", tracingParameters);
        }
        try {
            if (shouldTrace) {
                client2 = (ComputeManagementClient)((ComputeManagementClient)this.getClient().withRequestFilterLast((ServiceRequestFilter)new ClientRequestTrackingHandler(invocationId))).withResponseFilterLast((ServiceResponseFilter)new ClientRequestTrackingHandler(invocationId));
            }
            OperationResponse response = client2.getDeploymentsOperations().beginChangingConfigurationBySlotAsync(serviceName, deploymentSlot, parameters).get();
            OperationStatusResponse result = client2.getOperationStatusAsync(response.getRequestId()).get();
            int delayInSeconds = 30;
            if (client2.getLongRunningOperationInitialTimeout() >= 0) {
                delayInSeconds = client2.getLongRunningOperationInitialTimeout();
            }
            while (result.getStatus() != null && result.getStatus().equals((Object)OperationStatus.InProgress)) {
                Thread.sleep(delayInSeconds * 1000);
                result = client2.getOperationStatusAsync(response.getRequestId()).get();
                delayInSeconds = 30;
                if (client2.getLongRunningOperationRetryTimeout() < 0) continue;
                delayInSeconds = client2.getLongRunningOperationRetryTimeout();
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)result);
            }
            if (result.getStatus() != OperationStatus.Succeeded) {
                if (result.getError() != null) {
                    ServiceException ex = new ServiceException(result.getError().getCode() + " : " + result.getError().getMessage());
                    ex.setError(new CloudError());
                    ex.getError().setCode(result.getError().getCode());
                    ex.getError().setMessage(result.getError().getMessage());
                    if (shouldTrace) {
                        CloudTracing.error((String)invocationId, (Exception)ex);
                    }
                    throw ex;
                }
                ServiceException ex = new ServiceException("");
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            OperationStatusResponse operationStatusResponse = result;
            return operationStatusResponse;
        }
        finally {
            if (client2 != null && shouldTrace) {
                client2.close();
            }
        }
    }

    @Override
    public Future<OperationStatusResponse> createAsync(final String serviceName, final DeploymentSlot deploymentSlot, final DeploymentCreateParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<OperationStatusResponse>(){

            @Override
            public OperationStatusResponse call() throws Exception {
                return DeploymentOperationsImpl.this.create(serviceName, deploymentSlot, parameters);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationStatusResponse create(String serviceName, DeploymentSlot deploymentSlot, DeploymentCreateParameters parameters) throws InterruptedException, ExecutionException, ServiceException, IOException, ParserConfigurationException, SAXException, TransformerException, URISyntaxException {
        ComputeManagementClient client2 = this.getClient();
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("serviceName", serviceName);
            tracingParameters.put("deploymentSlot", (Object)deploymentSlot);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"createAsync", tracingParameters);
        }
        try {
            if (shouldTrace) {
                client2 = (ComputeManagementClient)((ComputeManagementClient)this.getClient().withRequestFilterLast((ServiceRequestFilter)new ClientRequestTrackingHandler(invocationId))).withResponseFilterLast((ServiceResponseFilter)new ClientRequestTrackingHandler(invocationId));
            }
            OperationResponse response = client2.getDeploymentsOperations().beginCreatingAsync(serviceName, deploymentSlot, parameters).get();
            OperationStatusResponse result = client2.getOperationStatusAsync(response.getRequestId()).get();
            int delayInSeconds = 30;
            if (client2.getLongRunningOperationInitialTimeout() >= 0) {
                delayInSeconds = client2.getLongRunningOperationInitialTimeout();
            }
            while (result.getStatus() != null && result.getStatus().equals((Object)OperationStatus.InProgress)) {
                Thread.sleep(delayInSeconds * 1000);
                result = client2.getOperationStatusAsync(response.getRequestId()).get();
                delayInSeconds = 30;
                if (client2.getLongRunningOperationRetryTimeout() < 0) continue;
                delayInSeconds = client2.getLongRunningOperationRetryTimeout();
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)result);
            }
            if (result.getStatus() != OperationStatus.Succeeded) {
                if (result.getError() != null) {
                    ServiceException ex = new ServiceException(result.getError().getCode() + " : " + result.getError().getMessage());
                    ex.setError(new CloudError());
                    ex.getError().setCode(result.getError().getCode());
                    ex.getError().setMessage(result.getError().getMessage());
                    if (shouldTrace) {
                        CloudTracing.error((String)invocationId, (Exception)ex);
                    }
                    throw ex;
                }
                ServiceException ex = new ServiceException("");
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            OperationStatusResponse operationStatusResponse = result;
            return operationStatusResponse;
        }
        finally {
            if (client2 != null && shouldTrace) {
                client2.close();
            }
        }
    }

    @Override
    public Future<OperationStatusResponse> deleteByNameAsync(final String serviceName, final String deploymentName, final boolean deleteFromStorage) {
        return this.getClient().getExecutorService().submit(new Callable<OperationStatusResponse>(){

            @Override
            public OperationStatusResponse call() throws Exception {
                return DeploymentOperationsImpl.this.deleteByName(serviceName, deploymentName, deleteFromStorage);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationStatusResponse deleteByName(String serviceName, String deploymentName, boolean deleteFromStorage) throws InterruptedException, ExecutionException, ServiceException, IOException {
        ComputeManagementClient client2 = this.getClient();
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("serviceName", serviceName);
            tracingParameters.put("deploymentName", deploymentName);
            tracingParameters.put("deleteFromStorage", deleteFromStorage);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"deleteByNameAsync", tracingParameters);
        }
        try {
            if (shouldTrace) {
                client2 = (ComputeManagementClient)((ComputeManagementClient)this.getClient().withRequestFilterLast((ServiceRequestFilter)new ClientRequestTrackingHandler(invocationId))).withResponseFilterLast((ServiceResponseFilter)new ClientRequestTrackingHandler(invocationId));
            }
            OperationResponse response = client2.getDeploymentsOperations().beginDeletingByNameAsync(serviceName, deploymentName, deleteFromStorage).get();
            OperationStatusResponse result = client2.getOperationStatusAsync(response.getRequestId()).get();
            int delayInSeconds = 30;
            if (client2.getLongRunningOperationInitialTimeout() >= 0) {
                delayInSeconds = client2.getLongRunningOperationInitialTimeout();
            }
            while (result.getStatus() != null && result.getStatus().equals((Object)OperationStatus.InProgress)) {
                Thread.sleep(delayInSeconds * 1000);
                result = client2.getOperationStatusAsync(response.getRequestId()).get();
                delayInSeconds = 30;
                if (client2.getLongRunningOperationRetryTimeout() < 0) continue;
                delayInSeconds = client2.getLongRunningOperationRetryTimeout();
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)result);
            }
            if (result.getStatus() != OperationStatus.Succeeded) {
                if (result.getError() != null) {
                    ServiceException ex = new ServiceException(result.getError().getCode() + " : " + result.getError().getMessage());
                    ex.setError(new CloudError());
                    ex.getError().setCode(result.getError().getCode());
                    ex.getError().setMessage(result.getError().getMessage());
                    if (shouldTrace) {
                        CloudTracing.error((String)invocationId, (Exception)ex);
                    }
                    throw ex;
                }
                ServiceException ex = new ServiceException("");
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            OperationStatusResponse operationStatusResponse = result;
            return operationStatusResponse;
        }
        finally {
            if (client2 != null && shouldTrace) {
                client2.close();
            }
        }
    }

    @Override
    public Future<OperationStatusResponse> deleteBySlotAsync(final String serviceName, final DeploymentSlot deploymentSlot) {
        return this.getClient().getExecutorService().submit(new Callable<OperationStatusResponse>(){

            @Override
            public OperationStatusResponse call() throws Exception {
                return DeploymentOperationsImpl.this.deleteBySlot(serviceName, deploymentSlot);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationStatusResponse deleteBySlot(String serviceName, DeploymentSlot deploymentSlot) throws InterruptedException, ExecutionException, ServiceException, IOException {
        ComputeManagementClient client2 = this.getClient();
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("serviceName", serviceName);
            tracingParameters.put("deploymentSlot", (Object)deploymentSlot);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"deleteBySlotAsync", tracingParameters);
        }
        try {
            if (shouldTrace) {
                client2 = (ComputeManagementClient)((ComputeManagementClient)this.getClient().withRequestFilterLast((ServiceRequestFilter)new ClientRequestTrackingHandler(invocationId))).withResponseFilterLast((ServiceResponseFilter)new ClientRequestTrackingHandler(invocationId));
            }
            OperationResponse response = client2.getDeploymentsOperations().beginDeletingBySlotAsync(serviceName, deploymentSlot).get();
            OperationStatusResponse result = client2.getOperationStatusAsync(response.getRequestId()).get();
            int delayInSeconds = 30;
            if (client2.getLongRunningOperationInitialTimeout() >= 0) {
                delayInSeconds = client2.getLongRunningOperationInitialTimeout();
            }
            while (result.getStatus() != null && result.getStatus().equals((Object)OperationStatus.InProgress)) {
                Thread.sleep(delayInSeconds * 1000);
                result = client2.getOperationStatusAsync(response.getRequestId()).get();
                delayInSeconds = 30;
                if (client2.getLongRunningOperationRetryTimeout() < 0) continue;
                delayInSeconds = client2.getLongRunningOperationRetryTimeout();
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)result);
            }
            if (result.getStatus() != OperationStatus.Succeeded) {
                if (result.getError() != null) {
                    ServiceException ex = new ServiceException(result.getError().getCode() + " : " + result.getError().getMessage());
                    ex.setError(new CloudError());
                    ex.getError().setCode(result.getError().getCode());
                    ex.getError().setMessage(result.getError().getMessage());
                    if (shouldTrace) {
                        CloudTracing.error((String)invocationId, (Exception)ex);
                    }
                    throw ex;
                }
                ServiceException ex = new ServiceException("");
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            OperationStatusResponse operationStatusResponse = result;
            return operationStatusResponse;
        }
        finally {
            if (client2 != null && shouldTrace) {
                client2.close();
            }
        }
    }

    @Override
    public Future<OperationStatusResponse> deleteRoleInstanceByDeploymentNameAsync(final String serviceName, final String deploymentName, final DeploymentDeleteRoleInstanceParameters roleInstanceName) {
        return this.getClient().getExecutorService().submit(new Callable<OperationStatusResponse>(){

            @Override
            public OperationStatusResponse call() throws Exception {
                return DeploymentOperationsImpl.this.deleteRoleInstanceByDeploymentName(serviceName, deploymentName, roleInstanceName);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationStatusResponse deleteRoleInstanceByDeploymentName(String serviceName, String deploymentName, DeploymentDeleteRoleInstanceParameters roleInstanceName) throws InterruptedException, ExecutionException, ServiceException, IOException {
        ComputeManagementClient client2 = this.getClient();
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("serviceName", serviceName);
            tracingParameters.put("deploymentName", deploymentName);
            tracingParameters.put("roleInstanceName", roleInstanceName);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"deleteRoleInstanceByDeploymentNameAsync", tracingParameters);
        }
        try {
            if (shouldTrace) {
                client2 = (ComputeManagementClient)((ComputeManagementClient)this.getClient().withRequestFilterLast((ServiceRequestFilter)new ClientRequestTrackingHandler(invocationId))).withResponseFilterLast((ServiceResponseFilter)new ClientRequestTrackingHandler(invocationId));
            }
            OperationResponse response = client2.getDeploymentsOperations().beginDeletingRoleInstanceByDeploymentNameAsync(serviceName, deploymentName, roleInstanceName).get();
            OperationStatusResponse result = client2.getOperationStatusAsync(response.getRequestId()).get();
            int delayInSeconds = 30;
            if (client2.getLongRunningOperationInitialTimeout() >= 0) {
                delayInSeconds = client2.getLongRunningOperationInitialTimeout();
            }
            while (result.getStatus() != null && result.getStatus().equals((Object)OperationStatus.InProgress)) {
                Thread.sleep(delayInSeconds * 1000);
                result = client2.getOperationStatusAsync(response.getRequestId()).get();
                delayInSeconds = 30;
                if (client2.getLongRunningOperationRetryTimeout() < 0) continue;
                delayInSeconds = client2.getLongRunningOperationRetryTimeout();
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)result);
            }
            if (result.getStatus() != OperationStatus.Succeeded) {
                if (result.getError() != null) {
                    ServiceException ex = new ServiceException(result.getError().getCode() + " : " + result.getError().getMessage());
                    ex.setError(new CloudError());
                    ex.getError().setCode(result.getError().getCode());
                    ex.getError().setMessage(result.getError().getMessage());
                    if (shouldTrace) {
                        CloudTracing.error((String)invocationId, (Exception)ex);
                    }
                    throw ex;
                }
                ServiceException ex = new ServiceException("");
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            OperationStatusResponse operationStatusResponse = result;
            return operationStatusResponse;
        }
        finally {
            if (client2 != null && shouldTrace) {
                client2.close();
            }
        }
    }

    @Override
    public Future<OperationStatusResponse> deleteRoleInstanceByDeploymentSlotAsync(final String serviceName, final String deploymentSlot, final DeploymentDeleteRoleInstanceParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<OperationStatusResponse>(){

            @Override
            public OperationStatusResponse call() throws Exception {
                return DeploymentOperationsImpl.this.deleteRoleInstanceByDeploymentSlot(serviceName, deploymentSlot, parameters);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationStatusResponse deleteRoleInstanceByDeploymentSlot(String serviceName, String deploymentSlot, DeploymentDeleteRoleInstanceParameters parameters) throws InterruptedException, ExecutionException, ServiceException, IOException {
        ComputeManagementClient client2 = this.getClient();
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("serviceName", serviceName);
            tracingParameters.put("deploymentSlot", deploymentSlot);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"deleteRoleInstanceByDeploymentSlotAsync", tracingParameters);
        }
        try {
            if (shouldTrace) {
                client2 = (ComputeManagementClient)((ComputeManagementClient)this.getClient().withRequestFilterLast((ServiceRequestFilter)new ClientRequestTrackingHandler(invocationId))).withResponseFilterLast((ServiceResponseFilter)new ClientRequestTrackingHandler(invocationId));
            }
            OperationResponse response = client2.getDeploymentsOperations().beginDeletingRoleInstanceByBeploymentSlotAsync(serviceName, deploymentSlot, parameters).get();
            OperationStatusResponse result = client2.getOperationStatusAsync(response.getRequestId()).get();
            int delayInSeconds = 30;
            if (client2.getLongRunningOperationInitialTimeout() >= 0) {
                delayInSeconds = client2.getLongRunningOperationInitialTimeout();
            }
            while (result.getStatus() != null && result.getStatus().equals((Object)OperationStatus.InProgress)) {
                Thread.sleep(delayInSeconds * 1000);
                result = client2.getOperationStatusAsync(response.getRequestId()).get();
                delayInSeconds = 30;
                if (client2.getLongRunningOperationRetryTimeout() < 0) continue;
                delayInSeconds = client2.getLongRunningOperationRetryTimeout();
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)result);
            }
            if (result.getStatus() != OperationStatus.Succeeded) {
                if (result.getError() != null) {
                    ServiceException ex = new ServiceException(result.getError().getCode() + " : " + result.getError().getMessage());
                    ex.setError(new CloudError());
                    ex.getError().setCode(result.getError().getCode());
                    ex.getError().setMessage(result.getError().getMessage());
                    if (shouldTrace) {
                        CloudTracing.error((String)invocationId, (Exception)ex);
                    }
                    throw ex;
                }
                ServiceException ex = new ServiceException("");
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            OperationStatusResponse operationStatusResponse = result;
            return operationStatusResponse;
        }
        finally {
            if (client2 != null && shouldTrace) {
                client2.close();
            }
        }
    }

    @Override
    public Future<DeploymentGetResponse> getByNameAsync(final String serviceName, final String deploymentName) {
        return this.getClient().getExecutorService().submit(new Callable<DeploymentGetResponse>(){

            @Override
            public DeploymentGetResponse call() throws Exception {
                return DeploymentOperationsImpl.this.getByName(serviceName, deploymentName);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeploymentGetResponse getByName(String serviceName, String deploymentName) throws IOException, ServiceException, ParserConfigurationException, SAXException, URISyntaxException {
        if (serviceName == null) {
            throw new NullPointerException("serviceName");
        }
        if (deploymentName == null) {
            throw new NullPointerException("deploymentName");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("serviceName", serviceName);
            tracingParameters.put("deploymentName", deploymentName);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"getByNameAsync", tracingParameters);
        }
        String url = "";
        url = url + "/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/services/hostedservices/";
        url = url + URLEncoder.encode(serviceName, "UTF-8");
        url = url + "/deployments/";
        url = url + URLEncoder.encode(deploymentName, "UTF-8");
        String baseUrl = this.getClient().getBaseUri().toString();
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpGet httpRequest = new HttpGet(url);
        httpRequest.setHeader("x-ms-version", "2015-04-01");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            DeploymentGetResponse result = null;
            if (statusCode == 200) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new DeploymentGetResponse();
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                documentBuilderFactory.setNamespaceAware(true);
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                Document responseDoc = documentBuilder.parse((InputStream)new BOMInputStream(responseContent));
                Element deploymentElement = XmlUtility.getElementByTagNameNS((Node)responseDoc, (String)"http://schemas.microsoft.com/windowsazure", (String)"Deployment");
                if (deploymentElement != null) {
                    Element loadBalancersSequenceElement;
                    Element reservedIPNameElement2;
                    Element extensionConfigurationElement;
                    Element virtualIPsSequenceElement;
                    Element persistentVMDowntimeElement;
                    Element dnsElement;
                    Element extendedPropertiesSequenceElement;
                    Element lastModifiedTimeElement;
                    Element createdTimeElement;
                    Element virtualNetworkNameElement;
                    Element rollbackAllowedElement;
                    Element lockedElement;
                    Element sdkVersionElement;
                    Element roleListSequenceElement;
                    Element upgradeDomainCountElement;
                    Element upgradeStatusElement;
                    Element roleInstanceListSequenceElement;
                    Element configurationElement;
                    Element urlElement;
                    Element labelElement;
                    Element statusElement;
                    Element privateIDElement;
                    Element deploymentSlotElement;
                    Element nameElement = XmlUtility.getElementByTagNameNS((Node)deploymentElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Name");
                    if (nameElement != null) {
                        String nameInstance = nameElement.getTextContent();
                        result.setName(nameInstance);
                    }
                    if ((deploymentSlotElement = XmlUtility.getElementByTagNameNS((Node)deploymentElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"DeploymentSlot")) != null && deploymentSlotElement.getTextContent() != null && !deploymentSlotElement.getTextContent().isEmpty()) {
                        DeploymentSlot deploymentSlotInstance = DeploymentSlot.valueOf(deploymentSlotElement.getTextContent());
                        result.setDeploymentSlot(deploymentSlotInstance);
                    }
                    if ((privateIDElement = XmlUtility.getElementByTagNameNS((Node)deploymentElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"PrivateID")) != null) {
                        String privateIDInstance = privateIDElement.getTextContent();
                        result.setPrivateId(privateIDInstance);
                    }
                    if ((statusElement = XmlUtility.getElementByTagNameNS((Node)deploymentElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Status")) != null && statusElement.getTextContent() != null && !statusElement.getTextContent().isEmpty()) {
                        DeploymentStatus statusInstance = DeploymentStatus.valueOf(statusElement.getTextContent());
                        result.setStatus(statusInstance);
                    }
                    if ((labelElement = XmlUtility.getElementByTagNameNS((Node)deploymentElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Label")) != null) {
                        String labelInstance = labelElement.getTextContent() != null ? new String(Base64.decode((String)labelElement.getTextContent())) : null;
                        result.setLabel(labelInstance);
                    }
                    if ((urlElement = XmlUtility.getElementByTagNameNS((Node)deploymentElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Url")) != null) {
                        URI urlInstance = new URI(urlElement.getTextContent());
                        result.setUri(urlInstance);
                    }
                    if ((configurationElement = XmlUtility.getElementByTagNameNS((Node)deploymentElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Configuration")) != null) {
                        String configurationInstance = configurationElement.getTextContent() != null ? new String(Base64.decode((String)configurationElement.getTextContent())) : null;
                        result.setConfiguration(configurationInstance);
                    }
                    if ((roleInstanceListSequenceElement = XmlUtility.getElementByTagNameNS((Node)deploymentElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"RoleInstanceList")) != null) {
                        for (int i1 = 0; i1 < XmlUtility.getElementsByTagNameNS((Node)roleInstanceListSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"RoleInstance").size(); ++i1) {
                            Element networkInterfacesSequenceElement;
                            Element publicIPsSequenceElement;
                            Element remoteAccessCertificateThumbprintElement;
                            Element hostNameElement;
                            Element powerStateElement;
                            Element resourceExtensionStatusListSequenceElement;
                            Element guestAgentStatusElement;
                            Element instanceEndpointsSequenceElement;
                            Element ipAddressElement;
                            Element instanceErrorCodeElement;
                            Element instanceStateDetailsElement;
                            Element instanceSizeElement;
                            Element instanceFaultDomainElement;
                            Element instanceUpgradeDomainElement;
                            Element instanceStatusElement;
                            Element instanceNameElement;
                            Element roleInstanceListElement = (Element)XmlUtility.getElementsByTagNameNS((Node)roleInstanceListSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"RoleInstance").get(i1);
                            RoleInstance roleInstanceInstance = new RoleInstance();
                            result.getRoleInstances().add(roleInstanceInstance);
                            Element roleNameElement = XmlUtility.getElementByTagNameNS((Node)roleInstanceListElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"RoleName");
                            if (roleNameElement != null) {
                                String roleNameInstance = roleNameElement.getTextContent();
                                roleInstanceInstance.setRoleName(roleNameInstance);
                            }
                            if ((instanceNameElement = XmlUtility.getElementByTagNameNS((Node)roleInstanceListElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"InstanceName")) != null) {
                                String instanceNameInstance = instanceNameElement.getTextContent();
                                roleInstanceInstance.setInstanceName(instanceNameInstance);
                            }
                            if ((instanceStatusElement = XmlUtility.getElementByTagNameNS((Node)roleInstanceListElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"InstanceStatus")) != null) {
                                String instanceStatusInstance = instanceStatusElement.getTextContent();
                                roleInstanceInstance.setInstanceStatus(instanceStatusInstance);
                            }
                            if ((instanceUpgradeDomainElement = XmlUtility.getElementByTagNameNS((Node)roleInstanceListElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"InstanceUpgradeDomain")) != null && instanceUpgradeDomainElement.getTextContent() != null && !instanceUpgradeDomainElement.getTextContent().isEmpty()) {
                                int instanceUpgradeDomainInstance = DatatypeConverter.parseInt((String)instanceUpgradeDomainElement.getTextContent());
                                roleInstanceInstance.setInstanceUpgradeDomain(instanceUpgradeDomainInstance);
                            }
                            if ((instanceFaultDomainElement = XmlUtility.getElementByTagNameNS((Node)roleInstanceListElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"InstanceFaultDomain")) != null && instanceFaultDomainElement.getTextContent() != null && !instanceFaultDomainElement.getTextContent().isEmpty()) {
                                int instanceFaultDomainInstance = DatatypeConverter.parseInt((String)instanceFaultDomainElement.getTextContent());
                                roleInstanceInstance.setInstanceFaultDomain(instanceFaultDomainInstance);
                            }
                            if ((instanceSizeElement = XmlUtility.getElementByTagNameNS((Node)roleInstanceListElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"InstanceSize")) != null) {
                                String instanceSizeInstance = instanceSizeElement.getTextContent();
                                roleInstanceInstance.setInstanceSize(instanceSizeInstance);
                            }
                            if ((instanceStateDetailsElement = XmlUtility.getElementByTagNameNS((Node)roleInstanceListElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"InstanceStateDetails")) != null) {
                                String instanceStateDetailsInstance = instanceStateDetailsElement.getTextContent();
                                roleInstanceInstance.setInstanceStateDetails(instanceStateDetailsInstance);
                            }
                            if ((instanceErrorCodeElement = XmlUtility.getElementByTagNameNS((Node)roleInstanceListElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"InstanceErrorCode")) != null) {
                                String instanceErrorCodeInstance = instanceErrorCodeElement.getTextContent();
                                roleInstanceInstance.setInstanceErrorCode(instanceErrorCodeInstance);
                            }
                            if ((ipAddressElement = XmlUtility.getElementByTagNameNS((Node)roleInstanceListElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"IpAddress")) != null) {
                                InetAddress ipAddressInstance = InetAddress.getByName(ipAddressElement.getTextContent());
                                roleInstanceInstance.setIPAddress(ipAddressInstance);
                            }
                            if ((instanceEndpointsSequenceElement = XmlUtility.getElementByTagNameNS((Node)roleInstanceListElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"InstanceEndpoints")) != null) {
                                for (int i2 = 0; i2 < XmlUtility.getElementsByTagNameNS((Node)instanceEndpointsSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"InstanceEndpoint").size(); ++i2) {
                                    Element idleTimeoutInMinutesElement;
                                    Element vipElement;
                                    Element protocolElement;
                                    Element publicPortElement;
                                    Element nameElement2;
                                    Element instanceEndpointsElement = (Element)XmlUtility.getElementsByTagNameNS((Node)instanceEndpointsSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"InstanceEndpoint").get(i2);
                                    InstanceEndpoint instanceEndpointInstance = new InstanceEndpoint();
                                    roleInstanceInstance.getInstanceEndpoints().add(instanceEndpointInstance);
                                    Element localPortElement = XmlUtility.getElementByTagNameNS((Node)instanceEndpointsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"LocalPort");
                                    if (localPortElement != null && localPortElement.getTextContent() != null && !localPortElement.getTextContent().isEmpty()) {
                                        int localPortInstance = DatatypeConverter.parseInt((String)localPortElement.getTextContent());
                                        instanceEndpointInstance.setLocalPort(localPortInstance);
                                    }
                                    if ((nameElement2 = XmlUtility.getElementByTagNameNS((Node)instanceEndpointsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Name")) != null) {
                                        String nameInstance2 = nameElement2.getTextContent();
                                        instanceEndpointInstance.setName(nameInstance2);
                                    }
                                    if ((publicPortElement = XmlUtility.getElementByTagNameNS((Node)instanceEndpointsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"PublicPort")) != null) {
                                        int publicPortInstance = DatatypeConverter.parseInt((String)publicPortElement.getTextContent());
                                        instanceEndpointInstance.setPort(publicPortInstance);
                                    }
                                    if ((protocolElement = XmlUtility.getElementByTagNameNS((Node)instanceEndpointsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Protocol")) != null) {
                                        String protocolInstance = protocolElement.getTextContent();
                                        instanceEndpointInstance.setProtocol(protocolInstance);
                                    }
                                    if ((vipElement = XmlUtility.getElementByTagNameNS((Node)instanceEndpointsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Vip")) != null) {
                                        InetAddress vipInstance = InetAddress.getByName(vipElement.getTextContent());
                                        instanceEndpointInstance.setVirtualIPAddress(vipInstance);
                                    }
                                    if ((idleTimeoutInMinutesElement = XmlUtility.getElementByTagNameNS((Node)instanceEndpointsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"IdleTimeoutInMinutes")) == null || idleTimeoutInMinutesElement.getTextContent() == null || idleTimeoutInMinutesElement.getTextContent().isEmpty()) continue;
                                    int idleTimeoutInMinutesInstance = DatatypeConverter.parseInt((String)idleTimeoutInMinutesElement.getTextContent());
                                    instanceEndpointInstance.setIdleTimeoutInMinutes(idleTimeoutInMinutesInstance);
                                }
                            }
                            if ((guestAgentStatusElement = XmlUtility.getElementByTagNameNS((Node)roleInstanceListElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"GuestAgentStatus")) != null) {
                                Element formattedMessageElement;
                                Element messageElement;
                                Element codeElement;
                                Element statusElement2;
                                Element guestAgentVersionElement;
                                Element timestampElement;
                                GuestAgentStatus guestAgentStatusInstance = new GuestAgentStatus();
                                roleInstanceInstance.setGuestAgentStatus(guestAgentStatusInstance);
                                Element protocolVersionElement = XmlUtility.getElementByTagNameNS((Node)guestAgentStatusElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ProtocolVersion");
                                if (protocolVersionElement != null) {
                                    String protocolVersionInstance = protocolVersionElement.getTextContent();
                                    guestAgentStatusInstance.setProtocolVersion(protocolVersionInstance);
                                }
                                if ((timestampElement = XmlUtility.getElementByTagNameNS((Node)guestAgentStatusElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Timestamp")) != null && timestampElement.getTextContent() != null && !timestampElement.getTextContent().isEmpty()) {
                                    Calendar timestampInstance = DatatypeConverter.parseDateTime((String)timestampElement.getTextContent());
                                    guestAgentStatusInstance.setTimestamp(timestampInstance);
                                }
                                if ((guestAgentVersionElement = XmlUtility.getElementByTagNameNS((Node)guestAgentStatusElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"GuestAgentVersion")) != null) {
                                    String guestAgentVersionInstance = guestAgentVersionElement.getTextContent();
                                    guestAgentStatusInstance.setGuestAgentVersion(guestAgentVersionInstance);
                                }
                                if ((statusElement2 = XmlUtility.getElementByTagNameNS((Node)guestAgentStatusElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Status")) != null) {
                                    String statusInstance2 = statusElement2.getTextContent();
                                    guestAgentStatusInstance.setStatus(statusInstance2);
                                }
                                if ((codeElement = XmlUtility.getElementByTagNameNS((Node)guestAgentStatusElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Code")) != null && codeElement.getTextContent() != null && !codeElement.getTextContent().isEmpty()) {
                                    int codeInstance = DatatypeConverter.parseInt((String)codeElement.getTextContent());
                                    guestAgentStatusInstance.setCode(codeInstance);
                                }
                                if ((messageElement = XmlUtility.getElementByTagNameNS((Node)guestAgentStatusElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Message")) != null) {
                                    Element paramListSequenceElement;
                                    GuestAgentMessage messageInstance = new GuestAgentMessage();
                                    guestAgentStatusInstance.setMessage(messageInstance);
                                    Element messageResourceIdElement = XmlUtility.getElementByTagNameNS((Node)messageElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"MessageResourceId");
                                    if (messageResourceIdElement != null) {
                                        String messageResourceIdInstance = messageResourceIdElement.getTextContent();
                                        messageInstance.setMessageResourceId(messageResourceIdInstance);
                                    }
                                    if ((paramListSequenceElement = XmlUtility.getElementByTagNameNS((Node)messageElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ParamList")) != null) {
                                        for (int i3 = 0; i3 < XmlUtility.getElementsByTagNameNS((Node)paramListSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Param").size(); ++i3) {
                                            Element paramListElement = (Element)XmlUtility.getElementsByTagNameNS((Node)paramListSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Param").get(i3);
                                            messageInstance.getParamList().add(paramListElement.getTextContent());
                                        }
                                    }
                                }
                                if ((formattedMessageElement = XmlUtility.getElementByTagNameNS((Node)guestAgentStatusElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"FormattedMessage")) != null) {
                                    Element messageElement2;
                                    GuestAgentFormattedMessage formattedMessageInstance = new GuestAgentFormattedMessage();
                                    guestAgentStatusInstance.setFormattedMessage(formattedMessageInstance);
                                    Element languageElement = XmlUtility.getElementByTagNameNS((Node)formattedMessageElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Language");
                                    if (languageElement != null) {
                                        String languageInstance = languageElement.getTextContent();
                                        formattedMessageInstance.setLanguage(languageInstance);
                                    }
                                    if ((messageElement2 = XmlUtility.getElementByTagNameNS((Node)formattedMessageElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Message")) != null) {
                                        String messageInstance2 = messageElement2.getTextContent();
                                        formattedMessageInstance.setMessage(messageInstance2);
                                    }
                                }
                            }
                            if ((resourceExtensionStatusListSequenceElement = XmlUtility.getElementByTagNameNS((Node)roleInstanceListElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ResourceExtensionStatusList")) != null) {
                                for (int i4 = 0; i4 < XmlUtility.getElementsByTagNameNS((Node)resourceExtensionStatusListSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ResourceExtensionStatus").size(); ++i4) {
                                    Element subStatusListSequenceElement;
                                    Element formattedMessageElement3;
                                    Element messageElement5;
                                    Element codeElement3;
                                    Element statusElement4;
                                    Element operationElement;
                                    Element nameElement3;
                                    Element configurationAppliedTimeElement;
                                    Element extensionSettingStatusElement;
                                    Element formattedMessageElement2;
                                    Element messageElement3;
                                    Element codeElement2;
                                    Element statusElement3;
                                    Element versionElement;
                                    Element resourceExtensionStatusListElement = (Element)XmlUtility.getElementsByTagNameNS((Node)resourceExtensionStatusListSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ResourceExtensionStatus").get(i4);
                                    ResourceExtensionStatus resourceExtensionStatusInstance = new ResourceExtensionStatus();
                                    roleInstanceInstance.getResourceExtensionStatusList().add(resourceExtensionStatusInstance);
                                    Element handlerNameElement = XmlUtility.getElementByTagNameNS((Node)resourceExtensionStatusListElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"HandlerName");
                                    if (handlerNameElement != null) {
                                        String handlerNameInstance = handlerNameElement.getTextContent();
                                        resourceExtensionStatusInstance.setHandlerName(handlerNameInstance);
                                    }
                                    if ((versionElement = XmlUtility.getElementByTagNameNS((Node)resourceExtensionStatusListElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Version")) != null) {
                                        String versionInstance = versionElement.getTextContent();
                                        resourceExtensionStatusInstance.setVersion(versionInstance);
                                    }
                                    if ((statusElement3 = XmlUtility.getElementByTagNameNS((Node)resourceExtensionStatusListElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Status")) != null) {
                                        String statusInstance3 = statusElement3.getTextContent();
                                        resourceExtensionStatusInstance.setStatus(statusInstance3);
                                    }
                                    if ((codeElement2 = XmlUtility.getElementByTagNameNS((Node)resourceExtensionStatusListElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Code")) != null && codeElement2.getTextContent() != null && !codeElement2.getTextContent().isEmpty()) {
                                        int codeInstance2 = DatatypeConverter.parseInt((String)codeElement2.getTextContent());
                                        resourceExtensionStatusInstance.setCode(codeInstance2);
                                    }
                                    if ((messageElement3 = XmlUtility.getElementByTagNameNS((Node)resourceExtensionStatusListElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Message")) != null) {
                                        Element paramListSequenceElement2;
                                        GuestAgentMessage messageInstance3 = new GuestAgentMessage();
                                        resourceExtensionStatusInstance.setMessage(messageInstance3);
                                        Element messageResourceIdElement2 = XmlUtility.getElementByTagNameNS((Node)messageElement3, (String)"http://schemas.microsoft.com/windowsazure", (String)"MessageResourceId");
                                        if (messageResourceIdElement2 != null) {
                                            String messageResourceIdInstance2 = messageResourceIdElement2.getTextContent();
                                            messageInstance3.setMessageResourceId(messageResourceIdInstance2);
                                        }
                                        if ((paramListSequenceElement2 = XmlUtility.getElementByTagNameNS((Node)messageElement3, (String)"http://schemas.microsoft.com/windowsazure", (String)"ParamList")) != null) {
                                            for (int i5 = 0; i5 < XmlUtility.getElementsByTagNameNS((Node)paramListSequenceElement2, (String)"http://schemas.microsoft.com/windowsazure", (String)"Param").size(); ++i5) {
                                                Element paramListElement2 = (Element)XmlUtility.getElementsByTagNameNS((Node)paramListSequenceElement2, (String)"http://schemas.microsoft.com/windowsazure", (String)"Param").get(i5);
                                                messageInstance3.getParamList().add(paramListElement2.getTextContent());
                                            }
                                        }
                                    }
                                    if ((formattedMessageElement2 = XmlUtility.getElementByTagNameNS((Node)resourceExtensionStatusListElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"FormattedMessage")) != null) {
                                        Element messageElement4;
                                        GuestAgentFormattedMessage formattedMessageInstance2 = new GuestAgentFormattedMessage();
                                        resourceExtensionStatusInstance.setFormattedMessage(formattedMessageInstance2);
                                        Element languageElement2 = XmlUtility.getElementByTagNameNS((Node)formattedMessageElement2, (String)"http://schemas.microsoft.com/windowsazure", (String)"Language");
                                        if (languageElement2 != null) {
                                            String languageInstance2 = languageElement2.getTextContent();
                                            formattedMessageInstance2.setLanguage(languageInstance2);
                                        }
                                        if ((messageElement4 = XmlUtility.getElementByTagNameNS((Node)formattedMessageElement2, (String)"http://schemas.microsoft.com/windowsazure", (String)"Message")) != null) {
                                            String messageInstance4 = messageElement4.getTextContent();
                                            formattedMessageInstance2.setMessage(messageInstance4);
                                        }
                                    }
                                    if ((extensionSettingStatusElement = XmlUtility.getElementByTagNameNS((Node)resourceExtensionStatusListElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ExtensionSettingStatus")) == null) continue;
                                    ResourceExtensionConfigurationStatus extensionSettingStatusInstance = new ResourceExtensionConfigurationStatus();
                                    resourceExtensionStatusInstance.setExtensionSettingStatus(extensionSettingStatusInstance);
                                    Element timestampElement2 = XmlUtility.getElementByTagNameNS((Node)extensionSettingStatusElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Timestamp");
                                    if (timestampElement2 != null && timestampElement2.getTextContent() != null && !timestampElement2.getTextContent().isEmpty()) {
                                        Calendar timestampInstance2 = DatatypeConverter.parseDateTime((String)timestampElement2.getTextContent());
                                        extensionSettingStatusInstance.setTimestamp(timestampInstance2);
                                    }
                                    if ((configurationAppliedTimeElement = XmlUtility.getElementByTagNameNS((Node)extensionSettingStatusElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ConfigurationAppliedTime")) != null && configurationAppliedTimeElement.getTextContent() != null && !configurationAppliedTimeElement.getTextContent().isEmpty()) {
                                        Calendar configurationAppliedTimeInstance = DatatypeConverter.parseDateTime((String)configurationAppliedTimeElement.getTextContent());
                                        extensionSettingStatusInstance.setConfigurationAppliedTime(configurationAppliedTimeInstance);
                                    }
                                    if ((nameElement3 = XmlUtility.getElementByTagNameNS((Node)extensionSettingStatusElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Name")) != null) {
                                        String nameInstance3 = nameElement3.getTextContent();
                                        extensionSettingStatusInstance.setName(nameInstance3);
                                    }
                                    if ((operationElement = XmlUtility.getElementByTagNameNS((Node)extensionSettingStatusElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Operation")) != null) {
                                        String operationInstance = operationElement.getTextContent();
                                        extensionSettingStatusInstance.setOperation(operationInstance);
                                    }
                                    if ((statusElement4 = XmlUtility.getElementByTagNameNS((Node)extensionSettingStatusElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Status")) != null) {
                                        String statusInstance4 = statusElement4.getTextContent();
                                        extensionSettingStatusInstance.setStatus(statusInstance4);
                                    }
                                    if ((codeElement3 = XmlUtility.getElementByTagNameNS((Node)extensionSettingStatusElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Code")) != null && codeElement3.getTextContent() != null && !codeElement3.getTextContent().isEmpty()) {
                                        int codeInstance3 = DatatypeConverter.parseInt((String)codeElement3.getTextContent());
                                        extensionSettingStatusInstance.setCode(codeInstance3);
                                    }
                                    if ((messageElement5 = XmlUtility.getElementByTagNameNS((Node)extensionSettingStatusElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Message")) != null) {
                                        Element paramListSequenceElement3;
                                        GuestAgentMessage messageInstance5 = new GuestAgentMessage();
                                        extensionSettingStatusInstance.setMessage(messageInstance5);
                                        Element messageResourceIdElement3 = XmlUtility.getElementByTagNameNS((Node)messageElement5, (String)"http://schemas.microsoft.com/windowsazure", (String)"MessageResourceId");
                                        if (messageResourceIdElement3 != null) {
                                            String messageResourceIdInstance3 = messageResourceIdElement3.getTextContent();
                                            messageInstance5.setMessageResourceId(messageResourceIdInstance3);
                                        }
                                        if ((paramListSequenceElement3 = XmlUtility.getElementByTagNameNS((Node)messageElement5, (String)"http://schemas.microsoft.com/windowsazure", (String)"ParamList")) != null) {
                                            for (int i6 = 0; i6 < XmlUtility.getElementsByTagNameNS((Node)paramListSequenceElement3, (String)"http://schemas.microsoft.com/windowsazure", (String)"Param").size(); ++i6) {
                                                Element paramListElement3 = (Element)XmlUtility.getElementsByTagNameNS((Node)paramListSequenceElement3, (String)"http://schemas.microsoft.com/windowsazure", (String)"Param").get(i6);
                                                messageInstance5.getParamList().add(paramListElement3.getTextContent());
                                            }
                                        }
                                    }
                                    if ((formattedMessageElement3 = XmlUtility.getElementByTagNameNS((Node)extensionSettingStatusElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"FormattedMessage")) != null) {
                                        Element messageElement6;
                                        GuestAgentFormattedMessage formattedMessageInstance3 = new GuestAgentFormattedMessage();
                                        extensionSettingStatusInstance.setFormattedMessage(formattedMessageInstance3);
                                        Element languageElement3 = XmlUtility.getElementByTagNameNS((Node)formattedMessageElement3, (String)"http://schemas.microsoft.com/windowsazure", (String)"Language");
                                        if (languageElement3 != null) {
                                            String languageInstance3 = languageElement3.getTextContent();
                                            formattedMessageInstance3.setLanguage(languageInstance3);
                                        }
                                        if ((messageElement6 = XmlUtility.getElementByTagNameNS((Node)formattedMessageElement3, (String)"http://schemas.microsoft.com/windowsazure", (String)"Message")) != null) {
                                            String messageInstance6 = messageElement6.getTextContent();
                                            formattedMessageInstance3.setMessage(messageInstance6);
                                        }
                                    }
                                    if ((subStatusListSequenceElement = XmlUtility.getElementByTagNameNS((Node)extensionSettingStatusElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"SubStatusList")) == null) continue;
                                    for (int i7 = 0; i7 < XmlUtility.getElementsByTagNameNS((Node)subStatusListSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"SubStatus").size(); ++i7) {
                                        Element messageElement8;
                                        Element formattedMessageElement4;
                                        Element messageElement7;
                                        Element codeElement4;
                                        Element statusElement5;
                                        Element subStatusListElement = (Element)XmlUtility.getElementsByTagNameNS((Node)subStatusListSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"SubStatus").get(i7);
                                        ResourceExtensionSubStatus subStatusInstance = new ResourceExtensionSubStatus();
                                        extensionSettingStatusInstance.getSubStatusList().add(subStatusInstance);
                                        Element nameElement4 = XmlUtility.getElementByTagNameNS((Node)subStatusListElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Name");
                                        if (nameElement4 != null) {
                                            String nameInstance4 = nameElement4.getTextContent();
                                            subStatusInstance.setName(nameInstance4);
                                        }
                                        if ((statusElement5 = XmlUtility.getElementByTagNameNS((Node)subStatusListElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Status")) != null) {
                                            String statusInstance5 = statusElement5.getTextContent();
                                            subStatusInstance.setStatus(statusInstance5);
                                        }
                                        if ((codeElement4 = XmlUtility.getElementByTagNameNS((Node)subStatusListElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Code")) != null && codeElement4.getTextContent() != null && !codeElement4.getTextContent().isEmpty()) {
                                            int codeInstance4 = DatatypeConverter.parseInt((String)codeElement4.getTextContent());
                                            subStatusInstance.setCode(codeInstance4);
                                        }
                                        if ((messageElement7 = XmlUtility.getElementByTagNameNS((Node)subStatusListElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Message")) != null) {
                                            Element paramListSequenceElement4;
                                            GuestAgentMessage messageInstance7 = new GuestAgentMessage();
                                            subStatusInstance.setMessage(messageInstance7);
                                            Element messageResourceIdElement4 = XmlUtility.getElementByTagNameNS((Node)messageElement7, (String)"http://schemas.microsoft.com/windowsazure", (String)"MessageResourceId");
                                            if (messageResourceIdElement4 != null) {
                                                String messageResourceIdInstance4 = messageResourceIdElement4.getTextContent();
                                                messageInstance7.setMessageResourceId(messageResourceIdInstance4);
                                            }
                                            if ((paramListSequenceElement4 = XmlUtility.getElementByTagNameNS((Node)messageElement7, (String)"http://schemas.microsoft.com/windowsazure", (String)"ParamList")) != null) {
                                                for (int i8 = 0; i8 < XmlUtility.getElementsByTagNameNS((Node)paramListSequenceElement4, (String)"http://schemas.microsoft.com/windowsazure", (String)"Param").size(); ++i8) {
                                                    Element paramListElement4 = (Element)XmlUtility.getElementsByTagNameNS((Node)paramListSequenceElement4, (String)"http://schemas.microsoft.com/windowsazure", (String)"Param").get(i8);
                                                    messageInstance7.getParamList().add(paramListElement4.getTextContent());
                                                }
                                            }
                                        }
                                        if ((formattedMessageElement4 = XmlUtility.getElementByTagNameNS((Node)subStatusListElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"FormattedMessage")) == null) continue;
                                        GuestAgentFormattedMessage formattedMessageInstance4 = new GuestAgentFormattedMessage();
                                        subStatusInstance.setFormattedMessage(formattedMessageInstance4);
                                        Element languageElement4 = XmlUtility.getElementByTagNameNS((Node)formattedMessageElement4, (String)"http://schemas.microsoft.com/windowsazure", (String)"Language");
                                        if (languageElement4 != null) {
                                            String languageInstance4 = languageElement4.getTextContent();
                                            formattedMessageInstance4.setLanguage(languageInstance4);
                                        }
                                        if ((messageElement8 = XmlUtility.getElementByTagNameNS((Node)formattedMessageElement4, (String)"http://schemas.microsoft.com/windowsazure", (String)"Message")) == null) continue;
                                        String messageInstance8 = messageElement8.getTextContent();
                                        formattedMessageInstance4.setMessage(messageInstance8);
                                    }
                                }
                            }
                            if ((powerStateElement = XmlUtility.getElementByTagNameNS((Node)roleInstanceListElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"PowerState")) != null && powerStateElement.getTextContent() != null && !powerStateElement.getTextContent().isEmpty()) {
                                RoleInstancePowerState powerStateInstance = RoleInstancePowerState.valueOf(powerStateElement.getTextContent());
                                roleInstanceInstance.setPowerState(powerStateInstance);
                            }
                            if ((hostNameElement = XmlUtility.getElementByTagNameNS((Node)roleInstanceListElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"HostName")) != null) {
                                String hostNameInstance = hostNameElement.getTextContent();
                                roleInstanceInstance.setHostName(hostNameInstance);
                            }
                            if ((remoteAccessCertificateThumbprintElement = XmlUtility.getElementByTagNameNS((Node)roleInstanceListElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"RemoteAccessCertificateThumbprint")) != null) {
                                String remoteAccessCertificateThumbprintInstance = remoteAccessCertificateThumbprintElement.getTextContent();
                                roleInstanceInstance.setRemoteAccessCertificateThumbprint(remoteAccessCertificateThumbprintInstance);
                            }
                            if ((publicIPsSequenceElement = XmlUtility.getElementByTagNameNS((Node)roleInstanceListElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"PublicIPs")) != null) {
                                for (int i9 = 0; i9 < XmlUtility.getElementsByTagNameNS((Node)publicIPsSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"PublicIP").size(); ++i9) {
                                    Element fqdnsSequenceElement;
                                    Element domainNameLabelElement;
                                    Element idleTimeoutInMinutesElement2;
                                    Element addressElement;
                                    Element publicIPsElement = (Element)XmlUtility.getElementsByTagNameNS((Node)publicIPsSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"PublicIP").get(i9);
                                    RoleInstance.PublicIP publicIPInstance = new RoleInstance.PublicIP();
                                    roleInstanceInstance.getPublicIPs().add(publicIPInstance);
                                    Element nameElement5 = XmlUtility.getElementByTagNameNS((Node)publicIPsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Name");
                                    if (nameElement5 != null) {
                                        String nameInstance5 = nameElement5.getTextContent();
                                        publicIPInstance.setName(nameInstance5);
                                    }
                                    if ((addressElement = XmlUtility.getElementByTagNameNS((Node)publicIPsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Address")) != null) {
                                        InetAddress addressInstance = InetAddress.getByName(addressElement.getTextContent());
                                        publicIPInstance.setAddress(addressInstance);
                                    }
                                    if ((idleTimeoutInMinutesElement2 = XmlUtility.getElementByTagNameNS((Node)publicIPsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"IdleTimeoutInMinutes")) != null && idleTimeoutInMinutesElement2.getTextContent() != null && !idleTimeoutInMinutesElement2.getTextContent().isEmpty()) {
                                        int idleTimeoutInMinutesInstance2 = DatatypeConverter.parseInt((String)idleTimeoutInMinutesElement2.getTextContent());
                                        publicIPInstance.setIdleTimeoutInMinutes(idleTimeoutInMinutesInstance2);
                                    }
                                    if ((domainNameLabelElement = XmlUtility.getElementByTagNameNS((Node)publicIPsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"DomainNameLabel")) != null) {
                                        String domainNameLabelInstance = domainNameLabelElement.getTextContent();
                                        publicIPInstance.setDomainNameLabel(domainNameLabelInstance);
                                    }
                                    if ((fqdnsSequenceElement = XmlUtility.getElementByTagNameNS((Node)publicIPsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Fqdns")) == null) continue;
                                    for (int i10 = 0; i10 < XmlUtility.getElementsByTagNameNS((Node)fqdnsSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Fqdn").size(); ++i10) {
                                        Element fqdnsElement = (Element)XmlUtility.getElementsByTagNameNS((Node)fqdnsSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Fqdn").get(i10);
                                        publicIPInstance.getFqdns().add(fqdnsElement.getTextContent());
                                    }
                                }
                            }
                            if ((networkInterfacesSequenceElement = XmlUtility.getElementByTagNameNS((Node)roleInstanceListElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"NetworkInterfaces")) == null) continue;
                            for (int i11 = 0; i11 < XmlUtility.getElementsByTagNameNS((Node)networkInterfacesSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"NetworkInterface").size(); ++i11) {
                                Element iPConfigurationsSequenceElement;
                                Element macAddressElement;
                                Element networkInterfacesElement = (Element)XmlUtility.getElementsByTagNameNS((Node)networkInterfacesSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"NetworkInterface").get(i11);
                                NetworkInterfaceInstance networkInterfaceInstance = new NetworkInterfaceInstance();
                                roleInstanceInstance.getNetworkInterfaces().add(networkInterfaceInstance);
                                Element nameElement6 = XmlUtility.getElementByTagNameNS((Node)networkInterfacesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Name");
                                if (nameElement6 != null) {
                                    String nameInstance6 = nameElement6.getTextContent();
                                    networkInterfaceInstance.setName(nameInstance6);
                                }
                                if ((macAddressElement = XmlUtility.getElementByTagNameNS((Node)networkInterfacesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"MacAddress")) != null) {
                                    String macAddressInstance = macAddressElement.getTextContent();
                                    networkInterfaceInstance.setMacAddress(macAddressInstance);
                                }
                                if ((iPConfigurationsSequenceElement = XmlUtility.getElementByTagNameNS((Node)networkInterfacesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"IPConfigurations")) == null) continue;
                                for (int i12 = 0; i12 < XmlUtility.getElementsByTagNameNS((Node)iPConfigurationsSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"IPConfiguration").size(); ++i12) {
                                    Element addressElement2;
                                    Element iPConfigurationsElement = (Element)XmlUtility.getElementsByTagNameNS((Node)iPConfigurationsSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"IPConfiguration").get(i12);
                                    IPConfigurationInstance iPConfigurationInstance = new IPConfigurationInstance();
                                    networkInterfaceInstance.getIPConfigurations().add(iPConfigurationInstance);
                                    Element subnetNameElement = XmlUtility.getElementByTagNameNS((Node)iPConfigurationsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"SubnetName");
                                    if (subnetNameElement != null) {
                                        String subnetNameInstance = subnetNameElement.getTextContent();
                                        iPConfigurationInstance.setSubnetName(subnetNameInstance);
                                    }
                                    if ((addressElement2 = XmlUtility.getElementByTagNameNS((Node)iPConfigurationsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Address")) == null) continue;
                                    String addressInstance2 = addressElement2.getTextContent();
                                    iPConfigurationInstance.setAddress(addressInstance2);
                                }
                            }
                        }
                    }
                    if ((upgradeStatusElement = XmlUtility.getElementByTagNameNS((Node)deploymentElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"UpgradeStatus")) != null) {
                        Element currentUpgradeDomainElement;
                        Element currentUpgradeDomainStateElement;
                        UpgradeStatus upgradeStatusInstance = new UpgradeStatus();
                        result.setUpgradeStatus(upgradeStatusInstance);
                        Element upgradeTypeElement = XmlUtility.getElementByTagNameNS((Node)upgradeStatusElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"UpgradeType");
                        if (upgradeTypeElement != null && upgradeTypeElement.getTextContent() != null && !upgradeTypeElement.getTextContent().isEmpty()) {
                            DeploymentUpgradeType upgradeTypeInstance = DeploymentUpgradeType.valueOf(upgradeTypeElement.getTextContent());
                            upgradeStatusInstance.setUpgradeType(upgradeTypeInstance);
                        }
                        if ((currentUpgradeDomainStateElement = XmlUtility.getElementByTagNameNS((Node)upgradeStatusElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"CurrentUpgradeDomainState")) != null && currentUpgradeDomainStateElement.getTextContent() != null && !currentUpgradeDomainStateElement.getTextContent().isEmpty()) {
                            UpgradeDomainState currentUpgradeDomainStateInstance = UpgradeDomainState.valueOf(currentUpgradeDomainStateElement.getTextContent());
                            upgradeStatusInstance.setCurrentUpgradeDomainState(currentUpgradeDomainStateInstance);
                        }
                        if ((currentUpgradeDomainElement = XmlUtility.getElementByTagNameNS((Node)upgradeStatusElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"CurrentUpgradeDomain")) != null) {
                            int currentUpgradeDomainInstance = DatatypeConverter.parseInt((String)currentUpgradeDomainElement.getTextContent());
                            upgradeStatusInstance.setCurrentUpgradeDomain(currentUpgradeDomainInstance);
                        }
                    }
                    if ((upgradeDomainCountElement = XmlUtility.getElementByTagNameNS((Node)deploymentElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"UpgradeDomainCount")) != null) {
                        int upgradeDomainCountInstance = DatatypeConverter.parseInt((String)upgradeDomainCountElement.getTextContent());
                        result.setUpgradeDomainCount(upgradeDomainCountInstance);
                    }
                    if ((roleListSequenceElement = XmlUtility.getElementByTagNameNS((Node)deploymentElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"RoleList")) != null) {
                        for (int i13 = 0; i13 < XmlUtility.getElementsByTagNameNS((Node)roleListSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Role").size(); ++i13) {
                            Element dataDiskConfigurationsSequenceElement;
                            Element vMImageInputElement;
                            Element provisionGuestAgentElement;
                            Element defaultWinRmCertificateThumbprintElement;
                            Element roleSizeElement;
                            Element oSVirtualHardDiskElement;
                            Element labelElement2;
                            Element dataVirtualHardDisksSequenceElement;
                            Element availabilitySetNameElement;
                            Element mediaLocationElement;
                            Element vMImageNameElement;
                            Element resourceExtensionReferencesSequenceElement;
                            Element configurationSetsSequenceElement;
                            Element roleTypeElement;
                            Element osVersionElement;
                            Element roleListElement = (Element)XmlUtility.getElementsByTagNameNS((Node)roleListSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Role").get(i13);
                            Role roleInstance = new Role();
                            result.getRoles().add(roleInstance);
                            Element roleNameElement2 = XmlUtility.getElementByTagNameNS((Node)roleListElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"RoleName");
                            if (roleNameElement2 != null) {
                                String roleNameInstance2 = roleNameElement2.getTextContent();
                                roleInstance.setRoleName(roleNameInstance2);
                            }
                            if ((osVersionElement = XmlUtility.getElementByTagNameNS((Node)roleListElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"OsVersion")) != null) {
                                String osVersionInstance = osVersionElement.getTextContent();
                                roleInstance.setOSVersion(osVersionInstance);
                            }
                            if ((roleTypeElement = XmlUtility.getElementByTagNameNS((Node)roleListElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"RoleType")) != null) {
                                String roleTypeInstance = roleTypeElement.getTextContent();
                                roleInstance.setRoleType(roleTypeInstance);
                            }
                            if ((configurationSetsSequenceElement = XmlUtility.getElementByTagNameNS((Node)roleListElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ConfigurationSets")) != null) {
                                for (int i14 = 0; i14 < XmlUtility.getElementsByTagNameNS((Node)configurationSetsSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ConfigurationSet").size(); ++i14) {
                                    Element customDataElement;
                                    Element sSHElement;
                                    Element disableSshPasswordAuthenticationElement;
                                    Element userPasswordElement;
                                    Element userNameElement;
                                    Element hostNameElement2;
                                    Element additionalUnattendContentElement;
                                    Element adminUsernameElement;
                                    Element winRMElement;
                                    Element storedCertificateSettingsSequenceElement;
                                    Element domainJoinElement;
                                    Element timeZoneElement;
                                    Element enableAutomaticUpdatesElement;
                                    Element resetPasswordOnFirstLogonElement;
                                    Element adminPasswordElement;
                                    Element computerNameElement;
                                    Element iPForwardingElement2;
                                    Element networkSecurityGroupElement2;
                                    Element networkInterfacesSequenceElement2;
                                    Element publicIPsSequenceElement2;
                                    Element staticVirtualNetworkIPAddressElement;
                                    Element subnetNamesSequenceElement;
                                    Element inputEndpointsSequenceElement;
                                    Element configurationSetsElement = (Element)XmlUtility.getElementsByTagNameNS((Node)configurationSetsSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ConfigurationSet").get(i14);
                                    ConfigurationSet configurationSetInstance = new ConfigurationSet();
                                    roleInstance.getConfigurationSets().add(configurationSetInstance);
                                    Element configurationSetTypeElement = XmlUtility.getElementByTagNameNS((Node)configurationSetsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ConfigurationSetType");
                                    if (configurationSetTypeElement != null) {
                                        String configurationSetTypeInstance = configurationSetTypeElement.getTextContent();
                                        configurationSetInstance.setConfigurationSetType(configurationSetTypeInstance);
                                    }
                                    if ((inputEndpointsSequenceElement = XmlUtility.getElementByTagNameNS((Node)configurationSetsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"InputEndpoints")) != null) {
                                        for (int i15 = 0; i15 < XmlUtility.getElementsByTagNameNS((Node)inputEndpointsSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"InputEndpoint").size(); ++i15) {
                                            Element virtualIPNameElement;
                                            Element loadBalancerDistributionElement;
                                            Element idleTimeoutInMinutesElement3;
                                            Element endpointAclElement;
                                            Element loadBalancerNameElement;
                                            Element enableDirectServerReturnElement;
                                            Element vipElement2;
                                            Element protocolElement3;
                                            Element loadBalancerProbeElement;
                                            Element portElement;
                                            Element nameElement7;
                                            Element localPortElement2;
                                            Element inputEndpointsElement = (Element)XmlUtility.getElementsByTagNameNS((Node)inputEndpointsSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"InputEndpoint").get(i15);
                                            InputEndpoint inputEndpointInstance = new InputEndpoint();
                                            configurationSetInstance.getInputEndpoints().add(inputEndpointInstance);
                                            Element loadBalancedEndpointSetNameElement = XmlUtility.getElementByTagNameNS((Node)inputEndpointsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"LoadBalancedEndpointSetName");
                                            if (loadBalancedEndpointSetNameElement != null) {
                                                String loadBalancedEndpointSetNameInstance = loadBalancedEndpointSetNameElement.getTextContent();
                                                inputEndpointInstance.setLoadBalancedEndpointSetName(loadBalancedEndpointSetNameInstance);
                                            }
                                            if ((localPortElement2 = XmlUtility.getElementByTagNameNS((Node)inputEndpointsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"LocalPort")) != null && localPortElement2.getTextContent() != null && !localPortElement2.getTextContent().isEmpty()) {
                                                int localPortInstance2 = DatatypeConverter.parseInt((String)localPortElement2.getTextContent());
                                                inputEndpointInstance.setLocalPort(localPortInstance2);
                                            }
                                            if ((nameElement7 = XmlUtility.getElementByTagNameNS((Node)inputEndpointsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Name")) != null) {
                                                String nameInstance7 = nameElement7.getTextContent();
                                                inputEndpointInstance.setName(nameInstance7);
                                            }
                                            if ((portElement = XmlUtility.getElementByTagNameNS((Node)inputEndpointsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Port")) != null && portElement.getTextContent() != null && !portElement.getTextContent().isEmpty()) {
                                                int portInstance = DatatypeConverter.parseInt((String)portElement.getTextContent());
                                                inputEndpointInstance.setPort(portInstance);
                                            }
                                            if ((loadBalancerProbeElement = XmlUtility.getElementByTagNameNS((Node)inputEndpointsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"LoadBalancerProbe")) != null) {
                                                Element timeoutInSecondsElement;
                                                Element intervalInSecondsElement;
                                                Element protocolElement2;
                                                Element portElement2;
                                                LoadBalancerProbe loadBalancerProbeInstance = new LoadBalancerProbe();
                                                inputEndpointInstance.setLoadBalancerProbe(loadBalancerProbeInstance);
                                                Element pathElement = XmlUtility.getElementByTagNameNS((Node)loadBalancerProbeElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Path");
                                                if (pathElement != null) {
                                                    String pathInstance = pathElement.getTextContent();
                                                    loadBalancerProbeInstance.setPath(pathInstance);
                                                }
                                                if ((portElement2 = XmlUtility.getElementByTagNameNS((Node)loadBalancerProbeElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Port")) != null) {
                                                    int portInstance2 = DatatypeConverter.parseInt((String)portElement2.getTextContent());
                                                    loadBalancerProbeInstance.setPort(portInstance2);
                                                }
                                                if ((protocolElement2 = XmlUtility.getElementByTagNameNS((Node)loadBalancerProbeElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Protocol")) != null && protocolElement2.getTextContent() != null && !protocolElement2.getTextContent().isEmpty()) {
                                                    LoadBalancerProbeTransportProtocol protocolInstance2 = ComputeManagementClientImpl.parseLoadBalancerProbeTransportProtocol(protocolElement2.getTextContent());
                                                    loadBalancerProbeInstance.setProtocol(protocolInstance2);
                                                }
                                                if ((intervalInSecondsElement = XmlUtility.getElementByTagNameNS((Node)loadBalancerProbeElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"IntervalInSeconds")) != null && intervalInSecondsElement.getTextContent() != null && !intervalInSecondsElement.getTextContent().isEmpty()) {
                                                    int intervalInSecondsInstance = DatatypeConverter.parseInt((String)intervalInSecondsElement.getTextContent());
                                                    loadBalancerProbeInstance.setIntervalInSeconds(intervalInSecondsInstance);
                                                }
                                                if ((timeoutInSecondsElement = XmlUtility.getElementByTagNameNS((Node)loadBalancerProbeElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"TimeoutInSeconds")) != null && timeoutInSecondsElement.getTextContent() != null && !timeoutInSecondsElement.getTextContent().isEmpty()) {
                                                    int timeoutInSecondsInstance = DatatypeConverter.parseInt((String)timeoutInSecondsElement.getTextContent());
                                                    loadBalancerProbeInstance.setTimeoutInSeconds(timeoutInSecondsInstance);
                                                }
                                            }
                                            if ((protocolElement3 = XmlUtility.getElementByTagNameNS((Node)inputEndpointsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Protocol")) != null) {
                                                String protocolInstance3 = protocolElement3.getTextContent();
                                                inputEndpointInstance.setProtocol(protocolInstance3);
                                            }
                                            if ((vipElement2 = XmlUtility.getElementByTagNameNS((Node)inputEndpointsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Vip")) != null) {
                                                InetAddress vipInstance2 = InetAddress.getByName(vipElement2.getTextContent());
                                                inputEndpointInstance.setVirtualIPAddress(vipInstance2);
                                            }
                                            if ((enableDirectServerReturnElement = XmlUtility.getElementByTagNameNS((Node)inputEndpointsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"EnableDirectServerReturn")) != null && enableDirectServerReturnElement.getTextContent() != null && !enableDirectServerReturnElement.getTextContent().isEmpty()) {
                                                boolean enableDirectServerReturnInstance = DatatypeConverter.parseBoolean((String)enableDirectServerReturnElement.getTextContent().toLowerCase());
                                                inputEndpointInstance.setEnableDirectServerReturn(enableDirectServerReturnInstance);
                                            }
                                            if ((loadBalancerNameElement = XmlUtility.getElementByTagNameNS((Node)inputEndpointsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"LoadBalancerName")) != null) {
                                                String loadBalancerNameInstance = loadBalancerNameElement.getTextContent();
                                                inputEndpointInstance.setLoadBalancerName(loadBalancerNameInstance);
                                            }
                                            if ((endpointAclElement = XmlUtility.getElementByTagNameNS((Node)inputEndpointsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"EndpointAcl")) != null) {
                                                EndpointAcl endpointAclInstance = new EndpointAcl();
                                                inputEndpointInstance.setEndpointAcl(endpointAclInstance);
                                                Element rulesSequenceElement = XmlUtility.getElementByTagNameNS((Node)endpointAclElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Rules");
                                                if (rulesSequenceElement != null) {
                                                    for (int i16 = 0; i16 < XmlUtility.getElementsByTagNameNS((Node)rulesSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Rule").size(); ++i16) {
                                                        Element descriptionElement;
                                                        Element remoteSubnetElement;
                                                        Element actionElement;
                                                        Element rulesElement = (Element)XmlUtility.getElementsByTagNameNS((Node)rulesSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Rule").get(i16);
                                                        AccessControlListRule ruleInstance = new AccessControlListRule();
                                                        endpointAclInstance.getRules().add(ruleInstance);
                                                        Element orderElement = XmlUtility.getElementByTagNameNS((Node)rulesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Order");
                                                        if (orderElement != null && orderElement.getTextContent() != null && !orderElement.getTextContent().isEmpty()) {
                                                            int orderInstance = DatatypeConverter.parseInt((String)orderElement.getTextContent());
                                                            ruleInstance.setOrder(orderInstance);
                                                        }
                                                        if ((actionElement = XmlUtility.getElementByTagNameNS((Node)rulesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Action")) != null) {
                                                            String actionInstance = actionElement.getTextContent();
                                                            ruleInstance.setAction(actionInstance);
                                                        }
                                                        if ((remoteSubnetElement = XmlUtility.getElementByTagNameNS((Node)rulesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"RemoteSubnet")) != null) {
                                                            String remoteSubnetInstance = remoteSubnetElement.getTextContent();
                                                            ruleInstance.setRemoteSubnet(remoteSubnetInstance);
                                                        }
                                                        if ((descriptionElement = XmlUtility.getElementByTagNameNS((Node)rulesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Description")) == null) continue;
                                                        String descriptionInstance = descriptionElement.getTextContent();
                                                        ruleInstance.setDescription(descriptionInstance);
                                                    }
                                                }
                                            }
                                            if ((idleTimeoutInMinutesElement3 = XmlUtility.getElementByTagNameNS((Node)inputEndpointsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"IdleTimeoutInMinutes")) != null && idleTimeoutInMinutesElement3.getTextContent() != null && !idleTimeoutInMinutesElement3.getTextContent().isEmpty()) {
                                                int idleTimeoutInMinutesInstance3 = DatatypeConverter.parseInt((String)idleTimeoutInMinutesElement3.getTextContent());
                                                inputEndpointInstance.setIdleTimeoutInMinutes(idleTimeoutInMinutesInstance3);
                                            }
                                            if ((loadBalancerDistributionElement = XmlUtility.getElementByTagNameNS((Node)inputEndpointsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"LoadBalancerDistribution")) != null) {
                                                String loadBalancerDistributionInstance = loadBalancerDistributionElement.getTextContent();
                                                inputEndpointInstance.setLoadBalancerDistribution(loadBalancerDistributionInstance);
                                            }
                                            if ((virtualIPNameElement = XmlUtility.getElementByTagNameNS((Node)inputEndpointsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"VirtualIPName")) == null) continue;
                                            String virtualIPNameInstance = virtualIPNameElement.getTextContent();
                                            inputEndpointInstance.setVirtualIPName(virtualIPNameInstance);
                                        }
                                    }
                                    if ((subnetNamesSequenceElement = XmlUtility.getElementByTagNameNS((Node)configurationSetsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"SubnetNames")) != null) {
                                        for (int i17 = 0; i17 < XmlUtility.getElementsByTagNameNS((Node)subnetNamesSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"SubnetName").size(); ++i17) {
                                            Element subnetNamesElement = (Element)XmlUtility.getElementsByTagNameNS((Node)subnetNamesSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"SubnetName").get(i17);
                                            configurationSetInstance.getSubnetNames().add(subnetNamesElement.getTextContent());
                                        }
                                    }
                                    if ((staticVirtualNetworkIPAddressElement = XmlUtility.getElementByTagNameNS((Node)configurationSetsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"StaticVirtualNetworkIPAddress")) != null) {
                                        String staticVirtualNetworkIPAddressInstance = staticVirtualNetworkIPAddressElement.getTextContent();
                                        configurationSetInstance.setStaticVirtualNetworkIPAddress(staticVirtualNetworkIPAddressInstance);
                                    }
                                    if ((publicIPsSequenceElement2 = XmlUtility.getElementByTagNameNS((Node)configurationSetsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"PublicIPs")) != null) {
                                        for (int i18 = 0; i18 < XmlUtility.getElementsByTagNameNS((Node)publicIPsSequenceElement2, (String)"http://schemas.microsoft.com/windowsazure", (String)"PublicIP").size(); ++i18) {
                                            Element domainNameLabelElement2;
                                            Element idleTimeoutInMinutesElement4;
                                            Element publicIPsElement2 = (Element)XmlUtility.getElementsByTagNameNS((Node)publicIPsSequenceElement2, (String)"http://schemas.microsoft.com/windowsazure", (String)"PublicIP").get(i18);
                                            ConfigurationSet.PublicIP publicIPInstance2 = new ConfigurationSet.PublicIP();
                                            configurationSetInstance.getPublicIPs().add(publicIPInstance2);
                                            Element nameElement8 = XmlUtility.getElementByTagNameNS((Node)publicIPsElement2, (String)"http://schemas.microsoft.com/windowsazure", (String)"Name");
                                            if (nameElement8 != null) {
                                                String nameInstance8 = nameElement8.getTextContent();
                                                publicIPInstance2.setName(nameInstance8);
                                            }
                                            if ((idleTimeoutInMinutesElement4 = XmlUtility.getElementByTagNameNS((Node)publicIPsElement2, (String)"http://schemas.microsoft.com/windowsazure", (String)"IdleTimeoutInMinutes")) != null && idleTimeoutInMinutesElement4.getTextContent() != null && !idleTimeoutInMinutesElement4.getTextContent().isEmpty()) {
                                                int idleTimeoutInMinutesInstance4 = DatatypeConverter.parseInt((String)idleTimeoutInMinutesElement4.getTextContent());
                                                publicIPInstance2.setIdleTimeoutInMinutes(idleTimeoutInMinutesInstance4);
                                            }
                                            if ((domainNameLabelElement2 = XmlUtility.getElementByTagNameNS((Node)publicIPsElement2, (String)"http://schemas.microsoft.com/windowsazure", (String)"DomainNameLabel")) == null) continue;
                                            String domainNameLabelInstance2 = domainNameLabelElement2.getTextContent();
                                            publicIPInstance2.setDomainNameLabel(domainNameLabelInstance2);
                                        }
                                    }
                                    if ((networkInterfacesSequenceElement2 = XmlUtility.getElementByTagNameNS((Node)configurationSetsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"NetworkInterfaces")) != null) {
                                        for (int i19 = 0; i19 < XmlUtility.getElementsByTagNameNS((Node)networkInterfacesSequenceElement2, (String)"http://schemas.microsoft.com/windowsazure", (String)"NetworkInterface").size(); ++i19) {
                                            Element iPForwardingElement;
                                            Element networkSecurityGroupElement;
                                            Element iPConfigurationsSequenceElement2;
                                            Element networkInterfacesElement2 = (Element)XmlUtility.getElementsByTagNameNS((Node)networkInterfacesSequenceElement2, (String)"http://schemas.microsoft.com/windowsazure", (String)"NetworkInterface").get(i19);
                                            NetworkInterface networkInterfaceInstance2 = new NetworkInterface();
                                            configurationSetInstance.getNetworkInterfaces().add(networkInterfaceInstance2);
                                            Element nameElement9 = XmlUtility.getElementByTagNameNS((Node)networkInterfacesElement2, (String)"http://schemas.microsoft.com/windowsazure", (String)"Name");
                                            if (nameElement9 != null) {
                                                String nameInstance9 = nameElement9.getTextContent();
                                                networkInterfaceInstance2.setName(nameInstance9);
                                            }
                                            if ((iPConfigurationsSequenceElement2 = XmlUtility.getElementByTagNameNS((Node)networkInterfacesElement2, (String)"http://schemas.microsoft.com/windowsazure", (String)"IPConfigurations")) != null) {
                                                for (int i20 = 0; i20 < XmlUtility.getElementsByTagNameNS((Node)iPConfigurationsSequenceElement2, (String)"http://schemas.microsoft.com/windowsazure", (String)"IPConfiguration").size(); ++i20) {
                                                    Element staticVirtualNetworkIPAddressElement2;
                                                    Element iPConfigurationsElement2 = (Element)XmlUtility.getElementsByTagNameNS((Node)iPConfigurationsSequenceElement2, (String)"http://schemas.microsoft.com/windowsazure", (String)"IPConfiguration").get(i20);
                                                    IPConfiguration iPConfigurationInstance2 = new IPConfiguration();
                                                    networkInterfaceInstance2.getIPConfigurations().add(iPConfigurationInstance2);
                                                    Element subnetNameElement2 = XmlUtility.getElementByTagNameNS((Node)iPConfigurationsElement2, (String)"http://schemas.microsoft.com/windowsazure", (String)"SubnetName");
                                                    if (subnetNameElement2 != null) {
                                                        String subnetNameInstance2 = subnetNameElement2.getTextContent();
                                                        iPConfigurationInstance2.setSubnetName(subnetNameInstance2);
                                                    }
                                                    if ((staticVirtualNetworkIPAddressElement2 = XmlUtility.getElementByTagNameNS((Node)iPConfigurationsElement2, (String)"http://schemas.microsoft.com/windowsazure", (String)"StaticVirtualNetworkIPAddress")) == null) continue;
                                                    String staticVirtualNetworkIPAddressInstance2 = staticVirtualNetworkIPAddressElement2.getTextContent();
                                                    iPConfigurationInstance2.setStaticVirtualNetworkIPAddress(staticVirtualNetworkIPAddressInstance2);
                                                }
                                            }
                                            if ((networkSecurityGroupElement = XmlUtility.getElementByTagNameNS((Node)networkInterfacesElement2, (String)"http://schemas.microsoft.com/windowsazure", (String)"NetworkSecurityGroup")) != null) {
                                                String networkSecurityGroupInstance = networkSecurityGroupElement.getTextContent();
                                                networkInterfaceInstance2.setNetworkSecurityGroup(networkSecurityGroupInstance);
                                            }
                                            if ((iPForwardingElement = XmlUtility.getElementByTagNameNS((Node)networkInterfacesElement2, (String)"http://schemas.microsoft.com/windowsazure", (String)"IPForwarding")) == null) continue;
                                            String iPForwardingInstance = iPForwardingElement.getTextContent();
                                            networkInterfaceInstance2.setIPForwarding(iPForwardingInstance);
                                        }
                                    }
                                    if ((networkSecurityGroupElement2 = XmlUtility.getElementByTagNameNS((Node)configurationSetsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"NetworkSecurityGroup")) != null) {
                                        String networkSecurityGroupInstance2 = networkSecurityGroupElement2.getTextContent();
                                        configurationSetInstance.setNetworkSecurityGroup(networkSecurityGroupInstance2);
                                    }
                                    if ((iPForwardingElement2 = XmlUtility.getElementByTagNameNS((Node)configurationSetsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"IPForwarding")) != null) {
                                        String iPForwardingInstance2 = iPForwardingElement2.getTextContent();
                                        configurationSetInstance.setIPForwarding(iPForwardingInstance2);
                                    }
                                    if ((computerNameElement = XmlUtility.getElementByTagNameNS((Node)configurationSetsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ComputerName")) != null) {
                                        String computerNameInstance = computerNameElement.getTextContent();
                                        configurationSetInstance.setComputerName(computerNameInstance);
                                    }
                                    if ((adminPasswordElement = XmlUtility.getElementByTagNameNS((Node)configurationSetsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"AdminPassword")) != null) {
                                        String adminPasswordInstance = adminPasswordElement.getTextContent();
                                        configurationSetInstance.setAdminPassword(adminPasswordInstance);
                                    }
                                    if ((resetPasswordOnFirstLogonElement = XmlUtility.getElementByTagNameNS((Node)configurationSetsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ResetPasswordOnFirstLogon")) != null && resetPasswordOnFirstLogonElement.getTextContent() != null && !resetPasswordOnFirstLogonElement.getTextContent().isEmpty()) {
                                        boolean resetPasswordOnFirstLogonInstance = DatatypeConverter.parseBoolean((String)resetPasswordOnFirstLogonElement.getTextContent().toLowerCase());
                                        configurationSetInstance.setResetPasswordOnFirstLogon(resetPasswordOnFirstLogonInstance);
                                    }
                                    if ((enableAutomaticUpdatesElement = XmlUtility.getElementByTagNameNS((Node)configurationSetsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"EnableAutomaticUpdates")) != null && enableAutomaticUpdatesElement.getTextContent() != null && !enableAutomaticUpdatesElement.getTextContent().isEmpty()) {
                                        boolean enableAutomaticUpdatesInstance = DatatypeConverter.parseBoolean((String)enableAutomaticUpdatesElement.getTextContent().toLowerCase());
                                        configurationSetInstance.setEnableAutomaticUpdates(enableAutomaticUpdatesInstance);
                                    }
                                    if ((timeZoneElement = XmlUtility.getElementByTagNameNS((Node)configurationSetsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"TimeZone")) != null) {
                                        String timeZoneInstance = timeZoneElement.getTextContent();
                                        configurationSetInstance.setTimeZone(timeZoneInstance);
                                    }
                                    if ((domainJoinElement = XmlUtility.getElementByTagNameNS((Node)configurationSetsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"DomainJoin")) != null) {
                                        Element provisioningElement;
                                        Element machineObjectOUElement;
                                        Element joinDomainElement;
                                        DomainJoinSettings domainJoinInstance = new DomainJoinSettings();
                                        configurationSetInstance.setDomainJoin(domainJoinInstance);
                                        Element credentialsElement = XmlUtility.getElementByTagNameNS((Node)domainJoinElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Credentials");
                                        if (credentialsElement != null) {
                                            Element passwordElement;
                                            Element usernameElement;
                                            DomainJoinCredentials credentialsInstance = new DomainJoinCredentials();
                                            domainJoinInstance.setCredentials(credentialsInstance);
                                            Element domainElement = XmlUtility.getElementByTagNameNS((Node)credentialsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Domain");
                                            if (domainElement != null) {
                                                String domainInstance = domainElement.getTextContent();
                                                credentialsInstance.setDomain(domainInstance);
                                            }
                                            if ((usernameElement = XmlUtility.getElementByTagNameNS((Node)credentialsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Username")) != null) {
                                                String usernameInstance = usernameElement.getTextContent();
                                                credentialsInstance.setUserName(usernameInstance);
                                            }
                                            if ((passwordElement = XmlUtility.getElementByTagNameNS((Node)credentialsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Password")) != null) {
                                                String passwordInstance = passwordElement.getTextContent();
                                                credentialsInstance.setPassword(passwordInstance);
                                            }
                                        }
                                        if ((joinDomainElement = XmlUtility.getElementByTagNameNS((Node)domainJoinElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"JoinDomain")) != null) {
                                            String joinDomainInstance = joinDomainElement.getTextContent();
                                            domainJoinInstance.setDomainToJoin(joinDomainInstance);
                                        }
                                        if ((machineObjectOUElement = XmlUtility.getElementByTagNameNS((Node)domainJoinElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"MachineObjectOU")) != null) {
                                            String machineObjectOUInstance = machineObjectOUElement.getTextContent();
                                            domainJoinInstance.setLdapMachineObjectOU(machineObjectOUInstance);
                                        }
                                        if ((provisioningElement = XmlUtility.getElementByTagNameNS((Node)domainJoinElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Provisioning")) != null) {
                                            DomainJoinProvisioning provisioningInstance = new DomainJoinProvisioning();
                                            domainJoinInstance.setProvisioning(provisioningInstance);
                                            Element accountDataElement = XmlUtility.getElementByTagNameNS((Node)provisioningElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"AccountData");
                                            if (accountDataElement != null) {
                                                String accountDataInstance = accountDataElement.getTextContent();
                                                provisioningInstance.setAccountData(accountDataInstance);
                                            }
                                        }
                                    }
                                    if ((storedCertificateSettingsSequenceElement = XmlUtility.getElementByTagNameNS((Node)configurationSetsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"StoredCertificateSettings")) != null) {
                                        for (int i21 = 0; i21 < XmlUtility.getElementsByTagNameNS((Node)storedCertificateSettingsSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"CertificateSetting").size(); ++i21) {
                                            Element thumbprintElement;
                                            Element storeNameElement;
                                            Element storedCertificateSettingsElement = (Element)XmlUtility.getElementsByTagNameNS((Node)storedCertificateSettingsSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"CertificateSetting").get(i21);
                                            StoredCertificateSettings certificateSettingInstance = new StoredCertificateSettings();
                                            configurationSetInstance.getStoredCertificateSettings().add(certificateSettingInstance);
                                            Element storeLocationElement = XmlUtility.getElementByTagNameNS((Node)storedCertificateSettingsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"StoreLocation");
                                            if (storeLocationElement != null) {
                                                // empty if block
                                            }
                                            if ((storeNameElement = XmlUtility.getElementByTagNameNS((Node)storedCertificateSettingsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"StoreName")) != null) {
                                                String storeNameInstance = storeNameElement.getTextContent();
                                                certificateSettingInstance.setStoreName(storeNameInstance);
                                            }
                                            if ((thumbprintElement = XmlUtility.getElementByTagNameNS((Node)storedCertificateSettingsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Thumbprint")) == null) continue;
                                            String thumbprintInstance = thumbprintElement.getTextContent();
                                            certificateSettingInstance.setThumbprint(thumbprintInstance);
                                        }
                                    }
                                    if ((winRMElement = XmlUtility.getElementByTagNameNS((Node)configurationSetsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"WinRM")) != null) {
                                        WindowsRemoteManagementSettings winRMInstance = new WindowsRemoteManagementSettings();
                                        configurationSetInstance.setWindowsRemoteManagement(winRMInstance);
                                        Element listenersSequenceElement = XmlUtility.getElementByTagNameNS((Node)winRMElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Listeners");
                                        if (listenersSequenceElement != null) {
                                            for (int i22 = 0; i22 < XmlUtility.getElementsByTagNameNS((Node)listenersSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Listener").size(); ++i22) {
                                                Element certificateThumbprintElement;
                                                Element listenersElement = (Element)XmlUtility.getElementsByTagNameNS((Node)listenersSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Listener").get(i22);
                                                WindowsRemoteManagementListener listenerInstance = new WindowsRemoteManagementListener();
                                                winRMInstance.getListeners().add(listenerInstance);
                                                Element protocolElement4 = XmlUtility.getElementByTagNameNS((Node)listenersElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Protocol");
                                                if (protocolElement4 != null && protocolElement4.getTextContent() != null && !protocolElement4.getTextContent().isEmpty()) {
                                                    VirtualMachineWindowsRemoteManagementListenerType protocolInstance4 = VirtualMachineWindowsRemoteManagementListenerType.valueOf(protocolElement4.getTextContent());
                                                    listenerInstance.setListenerType(protocolInstance4);
                                                }
                                                if ((certificateThumbprintElement = XmlUtility.getElementByTagNameNS((Node)listenersElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"CertificateThumbprint")) == null) continue;
                                                String certificateThumbprintInstance = certificateThumbprintElement.getTextContent();
                                                listenerInstance.setCertificateThumbprint(certificateThumbprintInstance);
                                            }
                                        }
                                    }
                                    if ((adminUsernameElement = XmlUtility.getElementByTagNameNS((Node)configurationSetsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"AdminUsername")) != null) {
                                        String adminUsernameInstance = adminUsernameElement.getTextContent();
                                        configurationSetInstance.setAdminUserName(adminUsernameInstance);
                                    }
                                    if ((additionalUnattendContentElement = XmlUtility.getElementByTagNameNS((Node)configurationSetsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"AdditionalUnattendContent")) != null) {
                                        AdditionalUnattendContentSettings additionalUnattendContentInstance = new AdditionalUnattendContentSettings();
                                        configurationSetInstance.setAdditionalUnattendContent(additionalUnattendContentInstance);
                                        Element passesSequenceElement = XmlUtility.getElementByTagNameNS((Node)additionalUnattendContentElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Passes");
                                        if (passesSequenceElement != null) {
                                            for (int i23 = 0; i23 < XmlUtility.getElementsByTagNameNS((Node)passesSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"UnattendPass").size(); ++i23) {
                                                Element componentsSequenceElement;
                                                Element passesElement = (Element)XmlUtility.getElementsByTagNameNS((Node)passesSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"UnattendPass").get(i23);
                                                UnattendPassSettings unattendPassInstance = new UnattendPassSettings();
                                                additionalUnattendContentInstance.getUnattendPasses().add(unattendPassInstance);
                                                Element passNameElement = XmlUtility.getElementByTagNameNS((Node)passesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"PassName");
                                                if (passNameElement != null) {
                                                    String passNameInstance = passNameElement.getTextContent();
                                                    unattendPassInstance.setPassName(passNameInstance);
                                                }
                                                if ((componentsSequenceElement = XmlUtility.getElementByTagNameNS((Node)passesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Components")) == null) continue;
                                                for (int i24 = 0; i24 < XmlUtility.getElementsByTagNameNS((Node)componentsSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"UnattendComponent").size(); ++i24) {
                                                    Element componentSettingsSequenceElement;
                                                    Element componentsElement = (Element)XmlUtility.getElementsByTagNameNS((Node)componentsSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"UnattendComponent").get(i24);
                                                    UnattendComponent unattendComponentInstance = new UnattendComponent();
                                                    unattendPassInstance.getUnattendComponents().add(unattendComponentInstance);
                                                    Element componentNameElement = XmlUtility.getElementByTagNameNS((Node)componentsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ComponentName");
                                                    if (componentNameElement != null) {
                                                        String componentNameInstance = componentNameElement.getTextContent();
                                                        unattendComponentInstance.setComponentName(componentNameInstance);
                                                    }
                                                    if ((componentSettingsSequenceElement = XmlUtility.getElementByTagNameNS((Node)componentsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ComponentSettings")) == null) continue;
                                                    for (int i25 = 0; i25 < XmlUtility.getElementsByTagNameNS((Node)componentSettingsSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ComponentSetting").size(); ++i25) {
                                                        Element contentElement;
                                                        Element componentSettingsElement = (Element)XmlUtility.getElementsByTagNameNS((Node)componentSettingsSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ComponentSetting").get(i25);
                                                        ComponentSetting componentSettingInstance = new ComponentSetting();
                                                        unattendComponentInstance.getUnattendComponentSettings().add(componentSettingInstance);
                                                        Element settingNameElement = XmlUtility.getElementByTagNameNS((Node)componentSettingsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"SettingName");
                                                        if (settingNameElement != null) {
                                                            String settingNameInstance = settingNameElement.getTextContent();
                                                            componentSettingInstance.setSettingName(settingNameInstance);
                                                        }
                                                        if ((contentElement = XmlUtility.getElementByTagNameNS((Node)componentSettingsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Content")) == null) continue;
                                                        String contentInstance = contentElement.getTextContent() != null ? new String(Base64.decode((String)contentElement.getTextContent())) : null;
                                                        componentSettingInstance.setContent(contentInstance);
                                                    }
                                                }
                                            }
                                        }
                                    }
                                    if ((hostNameElement2 = XmlUtility.getElementByTagNameNS((Node)configurationSetsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"HostName")) != null) {
                                        String hostNameInstance2 = hostNameElement2.getTextContent();
                                        configurationSetInstance.setHostName(hostNameInstance2);
                                    }
                                    if ((userNameElement = XmlUtility.getElementByTagNameNS((Node)configurationSetsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"UserName")) != null) {
                                        String userNameInstance = userNameElement.getTextContent();
                                        configurationSetInstance.setUserName(userNameInstance);
                                    }
                                    if ((userPasswordElement = XmlUtility.getElementByTagNameNS((Node)configurationSetsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"UserPassword")) != null) {
                                        String userPasswordInstance = userPasswordElement.getTextContent();
                                        configurationSetInstance.setUserPassword(userPasswordInstance);
                                    }
                                    if ((disableSshPasswordAuthenticationElement = XmlUtility.getElementByTagNameNS((Node)configurationSetsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"DisableSshPasswordAuthentication")) != null && disableSshPasswordAuthenticationElement.getTextContent() != null && !disableSshPasswordAuthenticationElement.getTextContent().isEmpty()) {
                                        boolean disableSshPasswordAuthenticationInstance = DatatypeConverter.parseBoolean((String)disableSshPasswordAuthenticationElement.getTextContent().toLowerCase());
                                        configurationSetInstance.setDisableSshPasswordAuthentication(disableSshPasswordAuthenticationInstance);
                                    }
                                    if ((sSHElement = XmlUtility.getElementByTagNameNS((Node)configurationSetsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"SSH")) != null) {
                                        Element keyPairsSequenceElement;
                                        SshSettings sSHInstance = new SshSettings();
                                        configurationSetInstance.setSshSettings(sSHInstance);
                                        Element publicKeysSequenceElement = XmlUtility.getElementByTagNameNS((Node)sSHElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"PublicKeys");
                                        if (publicKeysSequenceElement != null) {
                                            for (int i26 = 0; i26 < XmlUtility.getElementsByTagNameNS((Node)publicKeysSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"PublicKey").size(); ++i26) {
                                                Element pathElement2;
                                                Element publicKeysElement = (Element)XmlUtility.getElementsByTagNameNS((Node)publicKeysSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"PublicKey").get(i26);
                                                SshSettingPublicKey publicKeyInstance = new SshSettingPublicKey();
                                                sSHInstance.getPublicKeys().add(publicKeyInstance);
                                                Element fingerprintElement = XmlUtility.getElementByTagNameNS((Node)publicKeysElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Fingerprint");
                                                if (fingerprintElement != null) {
                                                    String fingerprintInstance = fingerprintElement.getTextContent();
                                                    publicKeyInstance.setFingerprint(fingerprintInstance);
                                                }
                                                if ((pathElement2 = XmlUtility.getElementByTagNameNS((Node)publicKeysElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Path")) == null) continue;
                                                String pathInstance2 = pathElement2.getTextContent();
                                                publicKeyInstance.setPath(pathInstance2);
                                            }
                                        }
                                        if ((keyPairsSequenceElement = XmlUtility.getElementByTagNameNS((Node)sSHElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"KeyPairs")) != null) {
                                            for (int i27 = 0; i27 < XmlUtility.getElementsByTagNameNS((Node)keyPairsSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"KeyPair").size(); ++i27) {
                                                Element pathElement3;
                                                Element keyPairsElement = (Element)XmlUtility.getElementsByTagNameNS((Node)keyPairsSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"KeyPair").get(i27);
                                                SshSettingKeyPair keyPairInstance = new SshSettingKeyPair();
                                                sSHInstance.getKeyPairs().add(keyPairInstance);
                                                Element fingerprintElement2 = XmlUtility.getElementByTagNameNS((Node)keyPairsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Fingerprint");
                                                if (fingerprintElement2 != null) {
                                                    String fingerprintInstance2 = fingerprintElement2.getTextContent();
                                                    keyPairInstance.setFingerprint(fingerprintInstance2);
                                                }
                                                if ((pathElement3 = XmlUtility.getElementByTagNameNS((Node)keyPairsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Path")) == null) continue;
                                                String pathInstance3 = pathElement3.getTextContent();
                                                keyPairInstance.setPath(pathInstance3);
                                            }
                                        }
                                    }
                                    if ((customDataElement = XmlUtility.getElementByTagNameNS((Node)configurationSetsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"CustomData")) == null) continue;
                                    String customDataInstance = customDataElement.getTextContent();
                                    configurationSetInstance.setCustomData(customDataInstance);
                                }
                            }
                            if ((resourceExtensionReferencesSequenceElement = XmlUtility.getElementByTagNameNS((Node)roleListElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ResourceExtensionReferences")) != null) {
                                for (int i28 = 0; i28 < XmlUtility.getElementsByTagNameNS((Node)resourceExtensionReferencesSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ResourceExtensionReference").size(); ++i28) {
                                    Element forceUpdateElement;
                                    Element stateElement;
                                    Element resourceExtensionParameterValuesSequenceElement;
                                    Element versionElement2;
                                    Element nameElement10;
                                    Element publisherElement;
                                    Element resourceExtensionReferencesElement = (Element)XmlUtility.getElementsByTagNameNS((Node)resourceExtensionReferencesSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ResourceExtensionReference").get(i28);
                                    ResourceExtensionReference resourceExtensionReferenceInstance = new ResourceExtensionReference();
                                    roleInstance.getResourceExtensionReferences().add(resourceExtensionReferenceInstance);
                                    Element referenceNameElement = XmlUtility.getElementByTagNameNS((Node)resourceExtensionReferencesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ReferenceName");
                                    if (referenceNameElement != null) {
                                        String referenceNameInstance = referenceNameElement.getTextContent();
                                        resourceExtensionReferenceInstance.setReferenceName(referenceNameInstance);
                                    }
                                    if ((publisherElement = XmlUtility.getElementByTagNameNS((Node)resourceExtensionReferencesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Publisher")) != null) {
                                        String publisherInstance = publisherElement.getTextContent();
                                        resourceExtensionReferenceInstance.setPublisher(publisherInstance);
                                    }
                                    if ((nameElement10 = XmlUtility.getElementByTagNameNS((Node)resourceExtensionReferencesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Name")) != null) {
                                        String nameInstance10 = nameElement10.getTextContent();
                                        resourceExtensionReferenceInstance.setName(nameInstance10);
                                    }
                                    if ((versionElement2 = XmlUtility.getElementByTagNameNS((Node)resourceExtensionReferencesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Version")) != null) {
                                        String versionInstance2 = versionElement2.getTextContent();
                                        resourceExtensionReferenceInstance.setVersion(versionInstance2);
                                    }
                                    if ((resourceExtensionParameterValuesSequenceElement = XmlUtility.getElementByTagNameNS((Node)resourceExtensionReferencesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ResourceExtensionParameterValues")) != null) {
                                        for (int i29 = 0; i29 < XmlUtility.getElementsByTagNameNS((Node)resourceExtensionParameterValuesSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ResourceExtensionParameterValue").size(); ++i29) {
                                            Element typeElement;
                                            Element valueElement;
                                            Element resourceExtensionParameterValuesElement = (Element)XmlUtility.getElementsByTagNameNS((Node)resourceExtensionParameterValuesSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ResourceExtensionParameterValue").get(i29);
                                            ResourceExtensionParameterValue resourceExtensionParameterValueInstance = new ResourceExtensionParameterValue();
                                            resourceExtensionReferenceInstance.getResourceExtensionParameterValues().add(resourceExtensionParameterValueInstance);
                                            Element keyElement = XmlUtility.getElementByTagNameNS((Node)resourceExtensionParameterValuesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Key");
                                            if (keyElement != null) {
                                                String keyInstance = keyElement.getTextContent();
                                                resourceExtensionParameterValueInstance.setKey(keyInstance);
                                            }
                                            if ((valueElement = XmlUtility.getElementByTagNameNS((Node)resourceExtensionParameterValuesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Value")) != null) {
                                                String valueInstance = valueElement.getTextContent() != null ? new String(Base64.decode((String)valueElement.getTextContent())) : null;
                                                resourceExtensionParameterValueInstance.setValue(valueInstance);
                                            }
                                            if ((typeElement = XmlUtility.getElementByTagNameNS((Node)resourceExtensionParameterValuesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Type")) == null) continue;
                                            String typeInstance = typeElement.getTextContent();
                                            resourceExtensionParameterValueInstance.setType(typeInstance);
                                        }
                                    }
                                    if ((stateElement = XmlUtility.getElementByTagNameNS((Node)resourceExtensionReferencesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"State")) != null) {
                                        String stateInstance = stateElement.getTextContent();
                                        resourceExtensionReferenceInstance.setState(stateInstance);
                                    }
                                    if ((forceUpdateElement = XmlUtility.getElementByTagNameNS((Node)resourceExtensionReferencesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ForceUpdate")) == null || forceUpdateElement.getTextContent() == null || forceUpdateElement.getTextContent().isEmpty()) continue;
                                    boolean forceUpdateInstance = DatatypeConverter.parseBoolean((String)forceUpdateElement.getTextContent().toLowerCase());
                                    resourceExtensionReferenceInstance.setForceUpdate(forceUpdateInstance);
                                }
                            }
                            if ((vMImageNameElement = XmlUtility.getElementByTagNameNS((Node)roleListElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"VMImageName")) != null) {
                                String vMImageNameInstance = vMImageNameElement.getTextContent();
                                roleInstance.setVMImageName(vMImageNameInstance);
                            }
                            if ((mediaLocationElement = XmlUtility.getElementByTagNameNS((Node)roleListElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"MediaLocation")) != null) {
                                URI mediaLocationInstance = new URI(mediaLocationElement.getTextContent());
                                roleInstance.setMediaLocation(mediaLocationInstance);
                            }
                            if ((availabilitySetNameElement = XmlUtility.getElementByTagNameNS((Node)roleListElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"AvailabilitySetName")) != null) {
                                String availabilitySetNameInstance = availabilitySetNameElement.getTextContent();
                                roleInstance.setAvailabilitySetName(availabilitySetNameInstance);
                            }
                            if ((dataVirtualHardDisksSequenceElement = XmlUtility.getElementByTagNameNS((Node)roleListElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"DataVirtualHardDisks")) != null) {
                                for (int i30 = 0; i30 < XmlUtility.getElementsByTagNameNS((Node)dataVirtualHardDisksSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"DataVirtualHardDisk").size(); ++i30) {
                                    Element iOTypeElement;
                                    Element sourceMediaLinkElement;
                                    Element mediaLinkElement;
                                    Element logicalDiskSizeInGBElement;
                                    Element lunElement;
                                    Element diskNameElement;
                                    Element diskLabelElement;
                                    Element dataVirtualHardDisksElement = (Element)XmlUtility.getElementsByTagNameNS((Node)dataVirtualHardDisksSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"DataVirtualHardDisk").get(i30);
                                    DataVirtualHardDisk dataVirtualHardDiskInstance = new DataVirtualHardDisk();
                                    roleInstance.getDataVirtualHardDisks().add(dataVirtualHardDiskInstance);
                                    Element hostCachingElement = XmlUtility.getElementByTagNameNS((Node)dataVirtualHardDisksElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"HostCaching");
                                    if (hostCachingElement != null) {
                                        String hostCachingInstance = hostCachingElement.getTextContent();
                                        dataVirtualHardDiskInstance.setHostCaching(hostCachingInstance);
                                    }
                                    if ((diskLabelElement = XmlUtility.getElementByTagNameNS((Node)dataVirtualHardDisksElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"DiskLabel")) != null) {
                                        String diskLabelInstance = diskLabelElement.getTextContent();
                                        dataVirtualHardDiskInstance.setLabel(diskLabelInstance);
                                    }
                                    if ((diskNameElement = XmlUtility.getElementByTagNameNS((Node)dataVirtualHardDisksElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"DiskName")) != null) {
                                        String diskNameInstance = diskNameElement.getTextContent();
                                        dataVirtualHardDiskInstance.setName(diskNameInstance);
                                    }
                                    if ((lunElement = XmlUtility.getElementByTagNameNS((Node)dataVirtualHardDisksElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Lun")) != null && lunElement.getTextContent() != null && !lunElement.getTextContent().isEmpty()) {
                                        int lunInstance = DatatypeConverter.parseInt((String)lunElement.getTextContent());
                                        dataVirtualHardDiskInstance.setLogicalUnitNumber(lunInstance);
                                    }
                                    if ((logicalDiskSizeInGBElement = XmlUtility.getElementByTagNameNS((Node)dataVirtualHardDisksElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"LogicalDiskSizeInGB")) != null && logicalDiskSizeInGBElement.getTextContent() != null && !logicalDiskSizeInGBElement.getTextContent().isEmpty()) {
                                        int logicalDiskSizeInGBInstance = DatatypeConverter.parseInt((String)logicalDiskSizeInGBElement.getTextContent());
                                        dataVirtualHardDiskInstance.setLogicalDiskSizeInGB(logicalDiskSizeInGBInstance);
                                    }
                                    if ((mediaLinkElement = XmlUtility.getElementByTagNameNS((Node)dataVirtualHardDisksElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"MediaLink")) != null) {
                                        URI mediaLinkInstance = new URI(mediaLinkElement.getTextContent());
                                        dataVirtualHardDiskInstance.setMediaLink(mediaLinkInstance);
                                    }
                                    if ((sourceMediaLinkElement = XmlUtility.getElementByTagNameNS((Node)dataVirtualHardDisksElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"SourceMediaLink")) != null) {
                                        URI sourceMediaLinkInstance = new URI(sourceMediaLinkElement.getTextContent());
                                        dataVirtualHardDiskInstance.setSourceMediaLink(sourceMediaLinkInstance);
                                    }
                                    if ((iOTypeElement = XmlUtility.getElementByTagNameNS((Node)dataVirtualHardDisksElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"IOType")) == null) continue;
                                    String iOTypeInstance = iOTypeElement.getTextContent();
                                    dataVirtualHardDiskInstance.setIOType(iOTypeInstance);
                                }
                            }
                            if ((labelElement2 = XmlUtility.getElementByTagNameNS((Node)roleListElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Label")) != null) {
                                String labelInstance2 = labelElement2.getTextContent();
                                roleInstance.setLabel(labelInstance2);
                            }
                            if ((oSVirtualHardDiskElement = XmlUtility.getElementByTagNameNS((Node)roleListElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"OSVirtualHardDisk")) != null) {
                                Element resizedSizeInGBElement;
                                Element iOTypeElement2;
                                Element remoteSourceImageLinkElement;
                                Element osElement;
                                Element sourceImageNameElement;
                                Element mediaLinkElement2;
                                Element diskNameElement2;
                                Element diskLabelElement2;
                                OSVirtualHardDisk oSVirtualHardDiskInstance = new OSVirtualHardDisk();
                                roleInstance.setOSVirtualHardDisk(oSVirtualHardDiskInstance);
                                Element hostCachingElement2 = XmlUtility.getElementByTagNameNS((Node)oSVirtualHardDiskElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"HostCaching");
                                if (hostCachingElement2 != null) {
                                    String hostCachingInstance2 = hostCachingElement2.getTextContent();
                                    oSVirtualHardDiskInstance.setHostCaching(hostCachingInstance2);
                                }
                                if ((diskLabelElement2 = XmlUtility.getElementByTagNameNS((Node)oSVirtualHardDiskElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"DiskLabel")) != null) {
                                    String diskLabelInstance2 = diskLabelElement2.getTextContent();
                                    oSVirtualHardDiskInstance.setLabel(diskLabelInstance2);
                                }
                                if ((diskNameElement2 = XmlUtility.getElementByTagNameNS((Node)oSVirtualHardDiskElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"DiskName")) != null) {
                                    String diskNameInstance2 = diskNameElement2.getTextContent();
                                    oSVirtualHardDiskInstance.setName(diskNameInstance2);
                                }
                                if ((mediaLinkElement2 = XmlUtility.getElementByTagNameNS((Node)oSVirtualHardDiskElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"MediaLink")) != null) {
                                    URI mediaLinkInstance2 = new URI(mediaLinkElement2.getTextContent());
                                    oSVirtualHardDiskInstance.setMediaLink(mediaLinkInstance2);
                                }
                                if ((sourceImageNameElement = XmlUtility.getElementByTagNameNS((Node)oSVirtualHardDiskElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"SourceImageName")) != null) {
                                    String sourceImageNameInstance = sourceImageNameElement.getTextContent();
                                    oSVirtualHardDiskInstance.setSourceImageName(sourceImageNameInstance);
                                }
                                if ((osElement = XmlUtility.getElementByTagNameNS((Node)oSVirtualHardDiskElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"OS")) != null) {
                                    String osInstance = osElement.getTextContent();
                                    oSVirtualHardDiskInstance.setOperatingSystem(osInstance);
                                }
                                if ((remoteSourceImageLinkElement = XmlUtility.getElementByTagNameNS((Node)oSVirtualHardDiskElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"RemoteSourceImageLink")) != null) {
                                    URI remoteSourceImageLinkInstance = new URI(remoteSourceImageLinkElement.getTextContent());
                                    oSVirtualHardDiskInstance.setRemoteSourceImageLink(remoteSourceImageLinkInstance);
                                }
                                if ((iOTypeElement2 = XmlUtility.getElementByTagNameNS((Node)oSVirtualHardDiskElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"IOType")) != null) {
                                    String iOTypeInstance2 = iOTypeElement2.getTextContent();
                                    oSVirtualHardDiskInstance.setIOType(iOTypeInstance2);
                                }
                                if ((resizedSizeInGBElement = XmlUtility.getElementByTagNameNS((Node)oSVirtualHardDiskElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ResizedSizeInGB")) != null && resizedSizeInGBElement.getTextContent() != null && !resizedSizeInGBElement.getTextContent().isEmpty()) {
                                    int resizedSizeInGBInstance = DatatypeConverter.parseInt((String)resizedSizeInGBElement.getTextContent());
                                    oSVirtualHardDiskInstance.setResizedSizeInGB(resizedSizeInGBInstance);
                                }
                            }
                            if ((roleSizeElement = XmlUtility.getElementByTagNameNS((Node)roleListElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"RoleSize")) != null) {
                                String roleSizeInstance = roleSizeElement.getTextContent();
                                roleInstance.setRoleSize(roleSizeInstance);
                            }
                            if ((defaultWinRmCertificateThumbprintElement = XmlUtility.getElementByTagNameNS((Node)roleListElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"DefaultWinRmCertificateThumbprint")) != null) {
                                String defaultWinRmCertificateThumbprintInstance = defaultWinRmCertificateThumbprintElement.getTextContent();
                                roleInstance.setDefaultWinRmCertificateThumbprint(defaultWinRmCertificateThumbprintInstance);
                            }
                            if ((provisionGuestAgentElement = XmlUtility.getElementByTagNameNS((Node)roleListElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ProvisionGuestAgent")) != null && provisionGuestAgentElement.getTextContent() != null && !provisionGuestAgentElement.getTextContent().isEmpty()) {
                                boolean provisionGuestAgentInstance = DatatypeConverter.parseBoolean((String)provisionGuestAgentElement.getTextContent().toLowerCase());
                                roleInstance.setProvisionGuestAgent(provisionGuestAgentInstance);
                            }
                            if ((vMImageInputElement = XmlUtility.getElementByTagNameNS((Node)roleListElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"VMImageInput")) == null) continue;
                            VMImageInput vMImageInputInstance = new VMImageInput();
                            roleInstance.setVMImageInput(vMImageInputInstance);
                            Element oSDiskConfigurationElement = XmlUtility.getElementByTagNameNS((Node)vMImageInputElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"OSDiskConfiguration");
                            if (oSDiskConfigurationElement != null) {
                                OSDiskConfiguration oSDiskConfigurationInstance = new OSDiskConfiguration();
                                vMImageInputInstance.setOSDiskConfiguration(oSDiskConfigurationInstance);
                                Element resizedSizeInGBElement2 = XmlUtility.getElementByTagNameNS((Node)oSDiskConfigurationElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ResizedSizeInGB");
                                if (resizedSizeInGBElement2 != null && resizedSizeInGBElement2.getTextContent() != null && !resizedSizeInGBElement2.getTextContent().isEmpty()) {
                                    int resizedSizeInGBInstance2 = DatatypeConverter.parseInt((String)resizedSizeInGBElement2.getTextContent());
                                    oSDiskConfigurationInstance.setResizedSizeInGB(resizedSizeInGBInstance2);
                                }
                            }
                            if ((dataDiskConfigurationsSequenceElement = XmlUtility.getElementByTagNameNS((Node)vMImageInputElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"DataDiskConfigurations")) == null) continue;
                            for (int i31 = 0; i31 < XmlUtility.getElementsByTagNameNS((Node)dataDiskConfigurationsSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"DataDiskConfiguration").size(); ++i31) {
                                Element resizedSizeInGBElement3;
                                Element dataDiskConfigurationsElement = (Element)XmlUtility.getElementsByTagNameNS((Node)dataDiskConfigurationsSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"DataDiskConfiguration").get(i31);
                                DataDiskConfiguration dataDiskConfigurationInstance = new DataDiskConfiguration();
                                vMImageInputInstance.getDataDiskConfigurations().add(dataDiskConfigurationInstance);
                                Element nameElement11 = XmlUtility.getElementByTagNameNS((Node)dataDiskConfigurationsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Name");
                                if (nameElement11 != null) {
                                    String nameInstance11 = nameElement11.getTextContent();
                                    dataDiskConfigurationInstance.setDiskName(nameInstance11);
                                }
                                if ((resizedSizeInGBElement3 = XmlUtility.getElementByTagNameNS((Node)dataDiskConfigurationsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ResizedSizeInGB")) == null || resizedSizeInGBElement3.getTextContent() == null || resizedSizeInGBElement3.getTextContent().isEmpty()) continue;
                                int resizedSizeInGBInstance3 = DatatypeConverter.parseInt((String)resizedSizeInGBElement3.getTextContent());
                                dataDiskConfigurationInstance.setResizedSizeInGB(resizedSizeInGBInstance3);
                            }
                        }
                    }
                    if ((sdkVersionElement = XmlUtility.getElementByTagNameNS((Node)deploymentElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"SdkVersion")) != null) {
                        String sdkVersionInstance = sdkVersionElement.getTextContent();
                        result.setSdkVersion(sdkVersionInstance);
                    }
                    if ((lockedElement = XmlUtility.getElementByTagNameNS((Node)deploymentElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Locked")) != null && lockedElement.getTextContent() != null && !lockedElement.getTextContent().isEmpty()) {
                        boolean lockedInstance = DatatypeConverter.parseBoolean((String)lockedElement.getTextContent().toLowerCase());
                        result.setLocked(lockedInstance);
                    }
                    if ((rollbackAllowedElement = XmlUtility.getElementByTagNameNS((Node)deploymentElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"RollbackAllowed")) != null && rollbackAllowedElement.getTextContent() != null && !rollbackAllowedElement.getTextContent().isEmpty()) {
                        boolean rollbackAllowedInstance = DatatypeConverter.parseBoolean((String)rollbackAllowedElement.getTextContent().toLowerCase());
                        result.setRollbackAllowed(rollbackAllowedInstance);
                    }
                    if ((virtualNetworkNameElement = XmlUtility.getElementByTagNameNS((Node)deploymentElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"VirtualNetworkName")) != null) {
                        String virtualNetworkNameInstance = virtualNetworkNameElement.getTextContent();
                        result.setVirtualNetworkName(virtualNetworkNameInstance);
                    }
                    if ((createdTimeElement = XmlUtility.getElementByTagNameNS((Node)deploymentElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"CreatedTime")) != null) {
                        Calendar createdTimeInstance = DatatypeConverter.parseDateTime((String)createdTimeElement.getTextContent());
                        result.setCreatedTime(createdTimeInstance);
                    }
                    if ((lastModifiedTimeElement = XmlUtility.getElementByTagNameNS((Node)deploymentElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"LastModifiedTime")) != null) {
                        Calendar lastModifiedTimeInstance = DatatypeConverter.parseDateTime((String)lastModifiedTimeElement.getTextContent());
                        result.setLastModifiedTime(lastModifiedTimeInstance);
                    }
                    if ((extendedPropertiesSequenceElement = XmlUtility.getElementByTagNameNS((Node)deploymentElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ExtendedProperties")) != null) {
                        for (int i32 = 0; i32 < XmlUtility.getElementsByTagNameNS((Node)extendedPropertiesSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ExtendedProperty").size(); ++i32) {
                            Element extendedPropertiesElement = (Element)XmlUtility.getElementsByTagNameNS((Node)extendedPropertiesSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ExtendedProperty").get(i32);
                            String extendedPropertiesKey = XmlUtility.getElementByTagNameNS((Node)extendedPropertiesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Name").getTextContent();
                            String extendedPropertiesValue = XmlUtility.getElementByTagNameNS((Node)extendedPropertiesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Value").getTextContent();
                            result.getExtendedProperties().put(extendedPropertiesKey, extendedPropertiesValue);
                        }
                    }
                    if ((dnsElement = XmlUtility.getElementByTagNameNS((Node)deploymentElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Dns")) != null) {
                        DnsSettings dnsInstance = new DnsSettings();
                        result.setDnsSettings(dnsInstance);
                        Element dnsServersSequenceElement = XmlUtility.getElementByTagNameNS((Node)dnsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"DnsServers");
                        if (dnsServersSequenceElement != null) {
                            for (int i33 = 0; i33 < XmlUtility.getElementsByTagNameNS((Node)dnsServersSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"DnsServer").size(); ++i33) {
                                Element addressElement3;
                                Element dnsServersElement = (Element)XmlUtility.getElementsByTagNameNS((Node)dnsServersSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"DnsServer").get(i33);
                                DnsServer dnsServerInstance = new DnsServer();
                                dnsInstance.getDnsServers().add(dnsServerInstance);
                                Element nameElement12 = XmlUtility.getElementByTagNameNS((Node)dnsServersElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Name");
                                if (nameElement12 != null) {
                                    String nameInstance12 = nameElement12.getTextContent();
                                    dnsServerInstance.setName(nameInstance12);
                                }
                                if ((addressElement3 = XmlUtility.getElementByTagNameNS((Node)dnsServersElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Address")) == null) continue;
                                InetAddress addressInstance3 = InetAddress.getByName(addressElement3.getTextContent());
                                dnsServerInstance.setAddress(addressInstance3);
                            }
                        }
                    }
                    if ((persistentVMDowntimeElement = XmlUtility.getElementByTagNameNS((Node)deploymentElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"PersistentVMDowntime")) != null) {
                        Element statusElement6;
                        Element endTimeElement;
                        PersistentVMDowntime persistentVMDowntimeInstance = new PersistentVMDowntime();
                        result.setPersistentVMDowntime(persistentVMDowntimeInstance);
                        Element startTimeElement = XmlUtility.getElementByTagNameNS((Node)persistentVMDowntimeElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"StartTime");
                        if (startTimeElement != null) {
                            Calendar startTimeInstance = DatatypeConverter.parseDateTime((String)startTimeElement.getTextContent());
                            persistentVMDowntimeInstance.setStartTime(startTimeInstance);
                        }
                        if ((endTimeElement = XmlUtility.getElementByTagNameNS((Node)persistentVMDowntimeElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"EndTime")) != null) {
                            Calendar endTimeInstance = DatatypeConverter.parseDateTime((String)endTimeElement.getTextContent());
                            persistentVMDowntimeInstance.setEndTime(endTimeInstance);
                        }
                        if ((statusElement6 = XmlUtility.getElementByTagNameNS((Node)persistentVMDowntimeElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Status")) != null) {
                            String statusInstance6 = statusElement6.getTextContent();
                            persistentVMDowntimeInstance.setStatus(statusInstance6);
                        }
                    }
                    if ((virtualIPsSequenceElement = XmlUtility.getElementByTagNameNS((Node)deploymentElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"VirtualIPs")) != null) {
                        for (int i34 = 0; i34 < XmlUtility.getElementsByTagNameNS((Node)virtualIPsSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"VirtualIP").size(); ++i34) {
                            Element reservedIPNameElement;
                            Element nameElement13;
                            Element isDnsProgrammedElement;
                            Element virtualIPsElement = (Element)XmlUtility.getElementsByTagNameNS((Node)virtualIPsSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"VirtualIP").get(i34);
                            VirtualIPAddress virtualIPInstance = new VirtualIPAddress();
                            result.getVirtualIPAddresses().add(virtualIPInstance);
                            Element addressElement4 = XmlUtility.getElementByTagNameNS((Node)virtualIPsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Address");
                            if (addressElement4 != null) {
                                InetAddress addressInstance4 = InetAddress.getByName(addressElement4.getTextContent());
                                virtualIPInstance.setAddress(addressInstance4);
                            }
                            if ((isDnsProgrammedElement = XmlUtility.getElementByTagNameNS((Node)virtualIPsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"IsDnsProgrammed")) != null && isDnsProgrammedElement.getTextContent() != null && !isDnsProgrammedElement.getTextContent().isEmpty()) {
                                boolean isDnsProgrammedInstance = DatatypeConverter.parseBoolean((String)isDnsProgrammedElement.getTextContent().toLowerCase());
                                virtualIPInstance.setIsDnsProgrammed(isDnsProgrammedInstance);
                            }
                            if ((nameElement13 = XmlUtility.getElementByTagNameNS((Node)virtualIPsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Name")) != null) {
                                String nameInstance13 = nameElement13.getTextContent();
                                virtualIPInstance.setName(nameInstance13);
                            }
                            if ((reservedIPNameElement = XmlUtility.getElementByTagNameNS((Node)virtualIPsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ReservedIPName")) == null) continue;
                            String reservedIPNameInstance = reservedIPNameElement.getTextContent();
                            virtualIPInstance.setReservedIPName(reservedIPNameInstance);
                        }
                    }
                    if ((extensionConfigurationElement = XmlUtility.getElementByTagNameNS((Node)deploymentElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ExtensionConfiguration")) != null) {
                        Element namedRolesSequenceElement;
                        ExtensionConfiguration extensionConfigurationInstance = new ExtensionConfiguration();
                        result.setExtensionConfiguration(extensionConfigurationInstance);
                        Element allRolesSequenceElement = XmlUtility.getElementByTagNameNS((Node)extensionConfigurationElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"AllRoles");
                        if (allRolesSequenceElement != null) {
                            for (int i35 = 0; i35 < XmlUtility.getElementsByTagNameNS((Node)allRolesSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Extension").size(); ++i35) {
                                Element allRolesElement = (Element)XmlUtility.getElementsByTagNameNS((Node)allRolesSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Extension").get(i35);
                                ExtensionConfiguration.Extension extensionInstance = new ExtensionConfiguration.Extension();
                                extensionConfigurationInstance.getAllRoles().add(extensionInstance);
                                Element idElement = XmlUtility.getElementByTagNameNS((Node)allRolesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Id");
                                if (idElement == null) continue;
                                String idInstance = idElement.getTextContent();
                                extensionInstance.setId(idInstance);
                            }
                        }
                        if ((namedRolesSequenceElement = XmlUtility.getElementByTagNameNS((Node)extensionConfigurationElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"NamedRoles")) != null) {
                            for (int i36 = 0; i36 < XmlUtility.getElementsByTagNameNS((Node)namedRolesSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Role").size(); ++i36) {
                                Element extensionsSequenceElement;
                                Element namedRolesElement = (Element)XmlUtility.getElementsByTagNameNS((Node)namedRolesSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Role").get(i36);
                                ExtensionConfiguration.NamedRole roleInstance2 = new ExtensionConfiguration.NamedRole();
                                extensionConfigurationInstance.getNamedRoles().add(roleInstance2);
                                Element roleNameElement3 = XmlUtility.getElementByTagNameNS((Node)namedRolesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"RoleName");
                                if (roleNameElement3 != null) {
                                    String roleNameInstance3 = roleNameElement3.getTextContent();
                                    roleInstance2.setRoleName(roleNameInstance3);
                                }
                                if ((extensionsSequenceElement = XmlUtility.getElementByTagNameNS((Node)namedRolesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Extensions")) == null) continue;
                                for (int i37 = 0; i37 < XmlUtility.getElementsByTagNameNS((Node)extensionsSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Extension").size(); ++i37) {
                                    Element extensionsElement = (Element)XmlUtility.getElementsByTagNameNS((Node)extensionsSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Extension").get(i37);
                                    ExtensionConfiguration.Extension extensionInstance2 = new ExtensionConfiguration.Extension();
                                    roleInstance2.getExtensions().add(extensionInstance2);
                                    Element idElement2 = XmlUtility.getElementByTagNameNS((Node)extensionsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Id");
                                    if (idElement2 == null) continue;
                                    String idInstance2 = idElement2.getTextContent();
                                    extensionInstance2.setId(idInstance2);
                                }
                            }
                        }
                    }
                    if ((reservedIPNameElement2 = XmlUtility.getElementByTagNameNS((Node)deploymentElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ReservedIPName")) != null) {
                        String reservedIPNameInstance2 = reservedIPNameElement2.getTextContent();
                        result.setReservedIPName(reservedIPNameInstance2);
                    }
                    if ((loadBalancersSequenceElement = XmlUtility.getElementByTagNameNS((Node)deploymentElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"LoadBalancers")) != null) {
                        for (int i38 = 0; i38 < XmlUtility.getElementsByTagNameNS((Node)loadBalancersSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"LoadBalancer").size(); ++i38) {
                            Element staticVirtualNetworkIPAddressElement3;
                            Element subnetNameElement3;
                            Element frontendIpConfigurationElement;
                            Element loadBalancersElement = (Element)XmlUtility.getElementsByTagNameNS((Node)loadBalancersSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"LoadBalancer").get(i38);
                            LoadBalancer loadBalancerInstance = new LoadBalancer();
                            result.getLoadBalancers().add(loadBalancerInstance);
                            Element nameElement14 = XmlUtility.getElementByTagNameNS((Node)loadBalancersElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Name");
                            if (nameElement14 != null) {
                                String nameInstance14 = nameElement14.getTextContent();
                                loadBalancerInstance.setName(nameInstance14);
                            }
                            if ((frontendIpConfigurationElement = XmlUtility.getElementByTagNameNS((Node)loadBalancersElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"FrontendIpConfiguration")) == null) continue;
                            FrontendIPConfiguration frontendIpConfigurationInstance = new FrontendIPConfiguration();
                            loadBalancerInstance.setFrontendIPConfiguration(frontendIpConfigurationInstance);
                            Element typeElement2 = XmlUtility.getElementByTagNameNS((Node)frontendIpConfigurationElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Type");
                            if (typeElement2 != null) {
                                String typeInstance2 = typeElement2.getTextContent();
                                frontendIpConfigurationInstance.setType(typeInstance2);
                            }
                            if ((subnetNameElement3 = XmlUtility.getElementByTagNameNS((Node)frontendIpConfigurationElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"SubnetName")) != null) {
                                String subnetNameInstance3 = subnetNameElement3.getTextContent();
                                frontendIpConfigurationInstance.setSubnetName(subnetNameInstance3);
                            }
                            if ((staticVirtualNetworkIPAddressElement3 = XmlUtility.getElementByTagNameNS((Node)frontendIpConfigurationElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"StaticVirtualNetworkIPAddress")) == null) continue;
                            InetAddress staticVirtualNetworkIPAddressInstance3 = InetAddress.getByName(staticVirtualNetworkIPAddressElement3.getTextContent());
                            frontendIpConfigurationInstance.setStaticVirtualNetworkIPAddress(staticVirtualNetworkIPAddressInstance3);
                        }
                    }
                }
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            DeploymentGetResponse deploymentGetResponse = result;
            return deploymentGetResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<DeploymentGetResponse> getBySlotAsync(final String serviceName, final DeploymentSlot deploymentSlot) {
        return this.getClient().getExecutorService().submit(new Callable<DeploymentGetResponse>(){

            @Override
            public DeploymentGetResponse call() throws Exception {
                return DeploymentOperationsImpl.this.getBySlot(serviceName, deploymentSlot);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeploymentGetResponse getBySlot(String serviceName, DeploymentSlot deploymentSlot) throws IOException, ServiceException, ParserConfigurationException, SAXException, URISyntaxException {
        if (serviceName == null) {
            throw new NullPointerException("serviceName");
        }
        if (deploymentSlot == null) {
            throw new NullPointerException("deploymentSlot");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("serviceName", serviceName);
            tracingParameters.put("deploymentSlot", (Object)deploymentSlot);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"getBySlotAsync", tracingParameters);
        }
        String url = "";
        url = url + "/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/services/hostedservices/";
        url = url + URLEncoder.encode(serviceName, "UTF-8");
        url = url + "/deploymentslots/";
        url = url + URLEncoder.encode(deploymentSlot.toString(), "UTF-8");
        String baseUrl = this.getClient().getBaseUri().toString();
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpGet httpRequest = new HttpGet(url);
        httpRequest.setHeader("x-ms-version", "2015-04-01");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            DeploymentGetResponse result = null;
            if (statusCode == 200) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new DeploymentGetResponse();
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                documentBuilderFactory.setNamespaceAware(true);
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                Document responseDoc = documentBuilder.parse((InputStream)new BOMInputStream(responseContent));
                Element deploymentElement = XmlUtility.getElementByTagNameNS((Node)responseDoc, (String)"http://schemas.microsoft.com/windowsazure", (String)"Deployment");
                if (deploymentElement != null) {
                    Element loadBalancersSequenceElement;
                    Element reservedIPNameElement2;
                    Element extensionConfigurationElement;
                    Element virtualIPsSequenceElement;
                    Element persistentVMDowntimeElement;
                    Element dnsElement;
                    Element extendedPropertiesSequenceElement;
                    Element lastModifiedTimeElement;
                    Element createdTimeElement;
                    Element virtualNetworkNameElement;
                    Element rollbackAllowedElement;
                    Element lockedElement;
                    Element sdkVersionElement;
                    Element roleListSequenceElement;
                    Element upgradeDomainCountElement;
                    Element upgradeStatusElement;
                    Element roleInstanceListSequenceElement;
                    Element configurationElement;
                    Element urlElement;
                    Element labelElement;
                    Element statusElement;
                    Element privateIDElement;
                    Element deploymentSlotElement;
                    Element nameElement = XmlUtility.getElementByTagNameNS((Node)deploymentElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Name");
                    if (nameElement != null) {
                        String nameInstance = nameElement.getTextContent();
                        result.setName(nameInstance);
                    }
                    if ((deploymentSlotElement = XmlUtility.getElementByTagNameNS((Node)deploymentElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"DeploymentSlot")) != null && deploymentSlotElement.getTextContent() != null && !deploymentSlotElement.getTextContent().isEmpty()) {
                        DeploymentSlot deploymentSlotInstance = DeploymentSlot.valueOf(deploymentSlotElement.getTextContent());
                        result.setDeploymentSlot(deploymentSlotInstance);
                    }
                    if ((privateIDElement = XmlUtility.getElementByTagNameNS((Node)deploymentElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"PrivateID")) != null) {
                        String privateIDInstance = privateIDElement.getTextContent();
                        result.setPrivateId(privateIDInstance);
                    }
                    if ((statusElement = XmlUtility.getElementByTagNameNS((Node)deploymentElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Status")) != null && statusElement.getTextContent() != null && !statusElement.getTextContent().isEmpty()) {
                        DeploymentStatus statusInstance = DeploymentStatus.valueOf(statusElement.getTextContent());
                        result.setStatus(statusInstance);
                    }
                    if ((labelElement = XmlUtility.getElementByTagNameNS((Node)deploymentElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Label")) != null) {
                        String labelInstance = labelElement.getTextContent() != null ? new String(Base64.decode((String)labelElement.getTextContent())) : null;
                        result.setLabel(labelInstance);
                    }
                    if ((urlElement = XmlUtility.getElementByTagNameNS((Node)deploymentElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Url")) != null) {
                        URI urlInstance = new URI(urlElement.getTextContent());
                        result.setUri(urlInstance);
                    }
                    if ((configurationElement = XmlUtility.getElementByTagNameNS((Node)deploymentElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Configuration")) != null) {
                        String configurationInstance = configurationElement.getTextContent() != null ? new String(Base64.decode((String)configurationElement.getTextContent())) : null;
                        result.setConfiguration(configurationInstance);
                    }
                    if ((roleInstanceListSequenceElement = XmlUtility.getElementByTagNameNS((Node)deploymentElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"RoleInstanceList")) != null) {
                        for (int i1 = 0; i1 < XmlUtility.getElementsByTagNameNS((Node)roleInstanceListSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"RoleInstance").size(); ++i1) {
                            Element networkInterfacesSequenceElement;
                            Element publicIPsSequenceElement;
                            Element remoteAccessCertificateThumbprintElement;
                            Element hostNameElement;
                            Element powerStateElement;
                            Element resourceExtensionStatusListSequenceElement;
                            Element guestAgentStatusElement;
                            Element instanceEndpointsSequenceElement;
                            Element ipAddressElement;
                            Element instanceErrorCodeElement;
                            Element instanceStateDetailsElement;
                            Element instanceSizeElement;
                            Element instanceFaultDomainElement;
                            Element instanceUpgradeDomainElement;
                            Element instanceStatusElement;
                            Element instanceNameElement;
                            Element roleInstanceListElement = (Element)XmlUtility.getElementsByTagNameNS((Node)roleInstanceListSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"RoleInstance").get(i1);
                            RoleInstance roleInstanceInstance = new RoleInstance();
                            result.getRoleInstances().add(roleInstanceInstance);
                            Element roleNameElement = XmlUtility.getElementByTagNameNS((Node)roleInstanceListElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"RoleName");
                            if (roleNameElement != null) {
                                String roleNameInstance = roleNameElement.getTextContent();
                                roleInstanceInstance.setRoleName(roleNameInstance);
                            }
                            if ((instanceNameElement = XmlUtility.getElementByTagNameNS((Node)roleInstanceListElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"InstanceName")) != null) {
                                String instanceNameInstance = instanceNameElement.getTextContent();
                                roleInstanceInstance.setInstanceName(instanceNameInstance);
                            }
                            if ((instanceStatusElement = XmlUtility.getElementByTagNameNS((Node)roleInstanceListElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"InstanceStatus")) != null) {
                                String instanceStatusInstance = instanceStatusElement.getTextContent();
                                roleInstanceInstance.setInstanceStatus(instanceStatusInstance);
                            }
                            if ((instanceUpgradeDomainElement = XmlUtility.getElementByTagNameNS((Node)roleInstanceListElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"InstanceUpgradeDomain")) != null && instanceUpgradeDomainElement.getTextContent() != null && !instanceUpgradeDomainElement.getTextContent().isEmpty()) {
                                int instanceUpgradeDomainInstance = DatatypeConverter.parseInt((String)instanceUpgradeDomainElement.getTextContent());
                                roleInstanceInstance.setInstanceUpgradeDomain(instanceUpgradeDomainInstance);
                            }
                            if ((instanceFaultDomainElement = XmlUtility.getElementByTagNameNS((Node)roleInstanceListElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"InstanceFaultDomain")) != null && instanceFaultDomainElement.getTextContent() != null && !instanceFaultDomainElement.getTextContent().isEmpty()) {
                                int instanceFaultDomainInstance = DatatypeConverter.parseInt((String)instanceFaultDomainElement.getTextContent());
                                roleInstanceInstance.setInstanceFaultDomain(instanceFaultDomainInstance);
                            }
                            if ((instanceSizeElement = XmlUtility.getElementByTagNameNS((Node)roleInstanceListElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"InstanceSize")) != null) {
                                String instanceSizeInstance = instanceSizeElement.getTextContent();
                                roleInstanceInstance.setInstanceSize(instanceSizeInstance);
                            }
                            if ((instanceStateDetailsElement = XmlUtility.getElementByTagNameNS((Node)roleInstanceListElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"InstanceStateDetails")) != null) {
                                String instanceStateDetailsInstance = instanceStateDetailsElement.getTextContent();
                                roleInstanceInstance.setInstanceStateDetails(instanceStateDetailsInstance);
                            }
                            if ((instanceErrorCodeElement = XmlUtility.getElementByTagNameNS((Node)roleInstanceListElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"InstanceErrorCode")) != null) {
                                String instanceErrorCodeInstance = instanceErrorCodeElement.getTextContent();
                                roleInstanceInstance.setInstanceErrorCode(instanceErrorCodeInstance);
                            }
                            if ((ipAddressElement = XmlUtility.getElementByTagNameNS((Node)roleInstanceListElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"IpAddress")) != null) {
                                InetAddress ipAddressInstance = InetAddress.getByName(ipAddressElement.getTextContent());
                                roleInstanceInstance.setIPAddress(ipAddressInstance);
                            }
                            if ((instanceEndpointsSequenceElement = XmlUtility.getElementByTagNameNS((Node)roleInstanceListElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"InstanceEndpoints")) != null) {
                                for (int i2 = 0; i2 < XmlUtility.getElementsByTagNameNS((Node)instanceEndpointsSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"InstanceEndpoint").size(); ++i2) {
                                    Element idleTimeoutInMinutesElement;
                                    Element vipElement;
                                    Element protocolElement;
                                    Element publicPortElement;
                                    Element nameElement2;
                                    Element instanceEndpointsElement = (Element)XmlUtility.getElementsByTagNameNS((Node)instanceEndpointsSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"InstanceEndpoint").get(i2);
                                    InstanceEndpoint instanceEndpointInstance = new InstanceEndpoint();
                                    roleInstanceInstance.getInstanceEndpoints().add(instanceEndpointInstance);
                                    Element localPortElement = XmlUtility.getElementByTagNameNS((Node)instanceEndpointsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"LocalPort");
                                    if (localPortElement != null && localPortElement.getTextContent() != null && !localPortElement.getTextContent().isEmpty()) {
                                        int localPortInstance = DatatypeConverter.parseInt((String)localPortElement.getTextContent());
                                        instanceEndpointInstance.setLocalPort(localPortInstance);
                                    }
                                    if ((nameElement2 = XmlUtility.getElementByTagNameNS((Node)instanceEndpointsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Name")) != null) {
                                        String nameInstance2 = nameElement2.getTextContent();
                                        instanceEndpointInstance.setName(nameInstance2);
                                    }
                                    if ((publicPortElement = XmlUtility.getElementByTagNameNS((Node)instanceEndpointsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"PublicPort")) != null) {
                                        int publicPortInstance = DatatypeConverter.parseInt((String)publicPortElement.getTextContent());
                                        instanceEndpointInstance.setPort(publicPortInstance);
                                    }
                                    if ((protocolElement = XmlUtility.getElementByTagNameNS((Node)instanceEndpointsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Protocol")) != null) {
                                        String protocolInstance = protocolElement.getTextContent();
                                        instanceEndpointInstance.setProtocol(protocolInstance);
                                    }
                                    if ((vipElement = XmlUtility.getElementByTagNameNS((Node)instanceEndpointsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Vip")) != null) {
                                        InetAddress vipInstance = InetAddress.getByName(vipElement.getTextContent());
                                        instanceEndpointInstance.setVirtualIPAddress(vipInstance);
                                    }
                                    if ((idleTimeoutInMinutesElement = XmlUtility.getElementByTagNameNS((Node)instanceEndpointsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"IdleTimeoutInMinutes")) == null || idleTimeoutInMinutesElement.getTextContent() == null || idleTimeoutInMinutesElement.getTextContent().isEmpty()) continue;
                                    int idleTimeoutInMinutesInstance = DatatypeConverter.parseInt((String)idleTimeoutInMinutesElement.getTextContent());
                                    instanceEndpointInstance.setIdleTimeoutInMinutes(idleTimeoutInMinutesInstance);
                                }
                            }
                            if ((guestAgentStatusElement = XmlUtility.getElementByTagNameNS((Node)roleInstanceListElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"GuestAgentStatus")) != null) {
                                Element formattedMessageElement;
                                Element messageElement;
                                Element codeElement;
                                Element statusElement2;
                                Element guestAgentVersionElement;
                                Element timestampElement;
                                GuestAgentStatus guestAgentStatusInstance = new GuestAgentStatus();
                                roleInstanceInstance.setGuestAgentStatus(guestAgentStatusInstance);
                                Element protocolVersionElement = XmlUtility.getElementByTagNameNS((Node)guestAgentStatusElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ProtocolVersion");
                                if (protocolVersionElement != null) {
                                    String protocolVersionInstance = protocolVersionElement.getTextContent();
                                    guestAgentStatusInstance.setProtocolVersion(protocolVersionInstance);
                                }
                                if ((timestampElement = XmlUtility.getElementByTagNameNS((Node)guestAgentStatusElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Timestamp")) != null && timestampElement.getTextContent() != null && !timestampElement.getTextContent().isEmpty()) {
                                    Calendar timestampInstance = DatatypeConverter.parseDateTime((String)timestampElement.getTextContent());
                                    guestAgentStatusInstance.setTimestamp(timestampInstance);
                                }
                                if ((guestAgentVersionElement = XmlUtility.getElementByTagNameNS((Node)guestAgentStatusElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"GuestAgentVersion")) != null) {
                                    String guestAgentVersionInstance = guestAgentVersionElement.getTextContent();
                                    guestAgentStatusInstance.setGuestAgentVersion(guestAgentVersionInstance);
                                }
                                if ((statusElement2 = XmlUtility.getElementByTagNameNS((Node)guestAgentStatusElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Status")) != null) {
                                    String statusInstance2 = statusElement2.getTextContent();
                                    guestAgentStatusInstance.setStatus(statusInstance2);
                                }
                                if ((codeElement = XmlUtility.getElementByTagNameNS((Node)guestAgentStatusElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Code")) != null && codeElement.getTextContent() != null && !codeElement.getTextContent().isEmpty()) {
                                    int codeInstance = DatatypeConverter.parseInt((String)codeElement.getTextContent());
                                    guestAgentStatusInstance.setCode(codeInstance);
                                }
                                if ((messageElement = XmlUtility.getElementByTagNameNS((Node)guestAgentStatusElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Message")) != null) {
                                    Element paramListSequenceElement;
                                    GuestAgentMessage messageInstance = new GuestAgentMessage();
                                    guestAgentStatusInstance.setMessage(messageInstance);
                                    Element messageResourceIdElement = XmlUtility.getElementByTagNameNS((Node)messageElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"MessageResourceId");
                                    if (messageResourceIdElement != null) {
                                        String messageResourceIdInstance = messageResourceIdElement.getTextContent();
                                        messageInstance.setMessageResourceId(messageResourceIdInstance);
                                    }
                                    if ((paramListSequenceElement = XmlUtility.getElementByTagNameNS((Node)messageElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ParamList")) != null) {
                                        for (int i3 = 0; i3 < XmlUtility.getElementsByTagNameNS((Node)paramListSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Param").size(); ++i3) {
                                            Element paramListElement = (Element)XmlUtility.getElementsByTagNameNS((Node)paramListSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Param").get(i3);
                                            messageInstance.getParamList().add(paramListElement.getTextContent());
                                        }
                                    }
                                }
                                if ((formattedMessageElement = XmlUtility.getElementByTagNameNS((Node)guestAgentStatusElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"FormattedMessage")) != null) {
                                    Element messageElement2;
                                    GuestAgentFormattedMessage formattedMessageInstance = new GuestAgentFormattedMessage();
                                    guestAgentStatusInstance.setFormattedMessage(formattedMessageInstance);
                                    Element languageElement = XmlUtility.getElementByTagNameNS((Node)formattedMessageElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Language");
                                    if (languageElement != null) {
                                        String languageInstance = languageElement.getTextContent();
                                        formattedMessageInstance.setLanguage(languageInstance);
                                    }
                                    if ((messageElement2 = XmlUtility.getElementByTagNameNS((Node)formattedMessageElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Message")) != null) {
                                        String messageInstance2 = messageElement2.getTextContent();
                                        formattedMessageInstance.setMessage(messageInstance2);
                                    }
                                }
                            }
                            if ((resourceExtensionStatusListSequenceElement = XmlUtility.getElementByTagNameNS((Node)roleInstanceListElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ResourceExtensionStatusList")) != null) {
                                for (int i4 = 0; i4 < XmlUtility.getElementsByTagNameNS((Node)resourceExtensionStatusListSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ResourceExtensionStatus").size(); ++i4) {
                                    Element subStatusListSequenceElement;
                                    Element formattedMessageElement3;
                                    Element messageElement5;
                                    Element codeElement3;
                                    Element statusElement4;
                                    Element operationElement;
                                    Element nameElement3;
                                    Element configurationAppliedTimeElement;
                                    Element extensionSettingStatusElement;
                                    Element formattedMessageElement2;
                                    Element messageElement3;
                                    Element codeElement2;
                                    Element statusElement3;
                                    Element versionElement;
                                    Element resourceExtensionStatusListElement = (Element)XmlUtility.getElementsByTagNameNS((Node)resourceExtensionStatusListSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ResourceExtensionStatus").get(i4);
                                    ResourceExtensionStatus resourceExtensionStatusInstance = new ResourceExtensionStatus();
                                    roleInstanceInstance.getResourceExtensionStatusList().add(resourceExtensionStatusInstance);
                                    Element handlerNameElement = XmlUtility.getElementByTagNameNS((Node)resourceExtensionStatusListElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"HandlerName");
                                    if (handlerNameElement != null) {
                                        String handlerNameInstance = handlerNameElement.getTextContent();
                                        resourceExtensionStatusInstance.setHandlerName(handlerNameInstance);
                                    }
                                    if ((versionElement = XmlUtility.getElementByTagNameNS((Node)resourceExtensionStatusListElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Version")) != null) {
                                        String versionInstance = versionElement.getTextContent();
                                        resourceExtensionStatusInstance.setVersion(versionInstance);
                                    }
                                    if ((statusElement3 = XmlUtility.getElementByTagNameNS((Node)resourceExtensionStatusListElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Status")) != null) {
                                        String statusInstance3 = statusElement3.getTextContent();
                                        resourceExtensionStatusInstance.setStatus(statusInstance3);
                                    }
                                    if ((codeElement2 = XmlUtility.getElementByTagNameNS((Node)resourceExtensionStatusListElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Code")) != null && codeElement2.getTextContent() != null && !codeElement2.getTextContent().isEmpty()) {
                                        int codeInstance2 = DatatypeConverter.parseInt((String)codeElement2.getTextContent());
                                        resourceExtensionStatusInstance.setCode(codeInstance2);
                                    }
                                    if ((messageElement3 = XmlUtility.getElementByTagNameNS((Node)resourceExtensionStatusListElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Message")) != null) {
                                        Element paramListSequenceElement2;
                                        GuestAgentMessage messageInstance3 = new GuestAgentMessage();
                                        resourceExtensionStatusInstance.setMessage(messageInstance3);
                                        Element messageResourceIdElement2 = XmlUtility.getElementByTagNameNS((Node)messageElement3, (String)"http://schemas.microsoft.com/windowsazure", (String)"MessageResourceId");
                                        if (messageResourceIdElement2 != null) {
                                            String messageResourceIdInstance2 = messageResourceIdElement2.getTextContent();
                                            messageInstance3.setMessageResourceId(messageResourceIdInstance2);
                                        }
                                        if ((paramListSequenceElement2 = XmlUtility.getElementByTagNameNS((Node)messageElement3, (String)"http://schemas.microsoft.com/windowsazure", (String)"ParamList")) != null) {
                                            for (int i5 = 0; i5 < XmlUtility.getElementsByTagNameNS((Node)paramListSequenceElement2, (String)"http://schemas.microsoft.com/windowsazure", (String)"Param").size(); ++i5) {
                                                Element paramListElement2 = (Element)XmlUtility.getElementsByTagNameNS((Node)paramListSequenceElement2, (String)"http://schemas.microsoft.com/windowsazure", (String)"Param").get(i5);
                                                messageInstance3.getParamList().add(paramListElement2.getTextContent());
                                            }
                                        }
                                    }
                                    if ((formattedMessageElement2 = XmlUtility.getElementByTagNameNS((Node)resourceExtensionStatusListElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"FormattedMessage")) != null) {
                                        Element messageElement4;
                                        GuestAgentFormattedMessage formattedMessageInstance2 = new GuestAgentFormattedMessage();
                                        resourceExtensionStatusInstance.setFormattedMessage(formattedMessageInstance2);
                                        Element languageElement2 = XmlUtility.getElementByTagNameNS((Node)formattedMessageElement2, (String)"http://schemas.microsoft.com/windowsazure", (String)"Language");
                                        if (languageElement2 != null) {
                                            String languageInstance2 = languageElement2.getTextContent();
                                            formattedMessageInstance2.setLanguage(languageInstance2);
                                        }
                                        if ((messageElement4 = XmlUtility.getElementByTagNameNS((Node)formattedMessageElement2, (String)"http://schemas.microsoft.com/windowsazure", (String)"Message")) != null) {
                                            String messageInstance4 = messageElement4.getTextContent();
                                            formattedMessageInstance2.setMessage(messageInstance4);
                                        }
                                    }
                                    if ((extensionSettingStatusElement = XmlUtility.getElementByTagNameNS((Node)resourceExtensionStatusListElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ExtensionSettingStatus")) == null) continue;
                                    ResourceExtensionConfigurationStatus extensionSettingStatusInstance = new ResourceExtensionConfigurationStatus();
                                    resourceExtensionStatusInstance.setExtensionSettingStatus(extensionSettingStatusInstance);
                                    Element timestampElement2 = XmlUtility.getElementByTagNameNS((Node)extensionSettingStatusElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Timestamp");
                                    if (timestampElement2 != null && timestampElement2.getTextContent() != null && !timestampElement2.getTextContent().isEmpty()) {
                                        Calendar timestampInstance2 = DatatypeConverter.parseDateTime((String)timestampElement2.getTextContent());
                                        extensionSettingStatusInstance.setTimestamp(timestampInstance2);
                                    }
                                    if ((configurationAppliedTimeElement = XmlUtility.getElementByTagNameNS((Node)extensionSettingStatusElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ConfigurationAppliedTime")) != null && configurationAppliedTimeElement.getTextContent() != null && !configurationAppliedTimeElement.getTextContent().isEmpty()) {
                                        Calendar configurationAppliedTimeInstance = DatatypeConverter.parseDateTime((String)configurationAppliedTimeElement.getTextContent());
                                        extensionSettingStatusInstance.setConfigurationAppliedTime(configurationAppliedTimeInstance);
                                    }
                                    if ((nameElement3 = XmlUtility.getElementByTagNameNS((Node)extensionSettingStatusElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Name")) != null) {
                                        String nameInstance3 = nameElement3.getTextContent();
                                        extensionSettingStatusInstance.setName(nameInstance3);
                                    }
                                    if ((operationElement = XmlUtility.getElementByTagNameNS((Node)extensionSettingStatusElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Operation")) != null) {
                                        String operationInstance = operationElement.getTextContent();
                                        extensionSettingStatusInstance.setOperation(operationInstance);
                                    }
                                    if ((statusElement4 = XmlUtility.getElementByTagNameNS((Node)extensionSettingStatusElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Status")) != null) {
                                        String statusInstance4 = statusElement4.getTextContent();
                                        extensionSettingStatusInstance.setStatus(statusInstance4);
                                    }
                                    if ((codeElement3 = XmlUtility.getElementByTagNameNS((Node)extensionSettingStatusElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Code")) != null && codeElement3.getTextContent() != null && !codeElement3.getTextContent().isEmpty()) {
                                        int codeInstance3 = DatatypeConverter.parseInt((String)codeElement3.getTextContent());
                                        extensionSettingStatusInstance.setCode(codeInstance3);
                                    }
                                    if ((messageElement5 = XmlUtility.getElementByTagNameNS((Node)extensionSettingStatusElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Message")) != null) {
                                        Element paramListSequenceElement3;
                                        GuestAgentMessage messageInstance5 = new GuestAgentMessage();
                                        extensionSettingStatusInstance.setMessage(messageInstance5);
                                        Element messageResourceIdElement3 = XmlUtility.getElementByTagNameNS((Node)messageElement5, (String)"http://schemas.microsoft.com/windowsazure", (String)"MessageResourceId");
                                        if (messageResourceIdElement3 != null) {
                                            String messageResourceIdInstance3 = messageResourceIdElement3.getTextContent();
                                            messageInstance5.setMessageResourceId(messageResourceIdInstance3);
                                        }
                                        if ((paramListSequenceElement3 = XmlUtility.getElementByTagNameNS((Node)messageElement5, (String)"http://schemas.microsoft.com/windowsazure", (String)"ParamList")) != null) {
                                            for (int i6 = 0; i6 < XmlUtility.getElementsByTagNameNS((Node)paramListSequenceElement3, (String)"http://schemas.microsoft.com/windowsazure", (String)"Param").size(); ++i6) {
                                                Element paramListElement3 = (Element)XmlUtility.getElementsByTagNameNS((Node)paramListSequenceElement3, (String)"http://schemas.microsoft.com/windowsazure", (String)"Param").get(i6);
                                                messageInstance5.getParamList().add(paramListElement3.getTextContent());
                                            }
                                        }
                                    }
                                    if ((formattedMessageElement3 = XmlUtility.getElementByTagNameNS((Node)extensionSettingStatusElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"FormattedMessage")) != null) {
                                        Element messageElement6;
                                        GuestAgentFormattedMessage formattedMessageInstance3 = new GuestAgentFormattedMessage();
                                        extensionSettingStatusInstance.setFormattedMessage(formattedMessageInstance3);
                                        Element languageElement3 = XmlUtility.getElementByTagNameNS((Node)formattedMessageElement3, (String)"http://schemas.microsoft.com/windowsazure", (String)"Language");
                                        if (languageElement3 != null) {
                                            String languageInstance3 = languageElement3.getTextContent();
                                            formattedMessageInstance3.setLanguage(languageInstance3);
                                        }
                                        if ((messageElement6 = XmlUtility.getElementByTagNameNS((Node)formattedMessageElement3, (String)"http://schemas.microsoft.com/windowsazure", (String)"Message")) != null) {
                                            String messageInstance6 = messageElement6.getTextContent();
                                            formattedMessageInstance3.setMessage(messageInstance6);
                                        }
                                    }
                                    if ((subStatusListSequenceElement = XmlUtility.getElementByTagNameNS((Node)extensionSettingStatusElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"SubStatusList")) == null) continue;
                                    for (int i7 = 0; i7 < XmlUtility.getElementsByTagNameNS((Node)subStatusListSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"SubStatus").size(); ++i7) {
                                        Element messageElement8;
                                        Element formattedMessageElement4;
                                        Element messageElement7;
                                        Element codeElement4;
                                        Element statusElement5;
                                        Element subStatusListElement = (Element)XmlUtility.getElementsByTagNameNS((Node)subStatusListSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"SubStatus").get(i7);
                                        ResourceExtensionSubStatus subStatusInstance = new ResourceExtensionSubStatus();
                                        extensionSettingStatusInstance.getSubStatusList().add(subStatusInstance);
                                        Element nameElement4 = XmlUtility.getElementByTagNameNS((Node)subStatusListElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Name");
                                        if (nameElement4 != null) {
                                            String nameInstance4 = nameElement4.getTextContent();
                                            subStatusInstance.setName(nameInstance4);
                                        }
                                        if ((statusElement5 = XmlUtility.getElementByTagNameNS((Node)subStatusListElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Status")) != null) {
                                            String statusInstance5 = statusElement5.getTextContent();
                                            subStatusInstance.setStatus(statusInstance5);
                                        }
                                        if ((codeElement4 = XmlUtility.getElementByTagNameNS((Node)subStatusListElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Code")) != null && codeElement4.getTextContent() != null && !codeElement4.getTextContent().isEmpty()) {
                                            int codeInstance4 = DatatypeConverter.parseInt((String)codeElement4.getTextContent());
                                            subStatusInstance.setCode(codeInstance4);
                                        }
                                        if ((messageElement7 = XmlUtility.getElementByTagNameNS((Node)subStatusListElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Message")) != null) {
                                            Element paramListSequenceElement4;
                                            GuestAgentMessage messageInstance7 = new GuestAgentMessage();
                                            subStatusInstance.setMessage(messageInstance7);
                                            Element messageResourceIdElement4 = XmlUtility.getElementByTagNameNS((Node)messageElement7, (String)"http://schemas.microsoft.com/windowsazure", (String)"MessageResourceId");
                                            if (messageResourceIdElement4 != null) {
                                                String messageResourceIdInstance4 = messageResourceIdElement4.getTextContent();
                                                messageInstance7.setMessageResourceId(messageResourceIdInstance4);
                                            }
                                            if ((paramListSequenceElement4 = XmlUtility.getElementByTagNameNS((Node)messageElement7, (String)"http://schemas.microsoft.com/windowsazure", (String)"ParamList")) != null) {
                                                for (int i8 = 0; i8 < XmlUtility.getElementsByTagNameNS((Node)paramListSequenceElement4, (String)"http://schemas.microsoft.com/windowsazure", (String)"Param").size(); ++i8) {
                                                    Element paramListElement4 = (Element)XmlUtility.getElementsByTagNameNS((Node)paramListSequenceElement4, (String)"http://schemas.microsoft.com/windowsazure", (String)"Param").get(i8);
                                                    messageInstance7.getParamList().add(paramListElement4.getTextContent());
                                                }
                                            }
                                        }
                                        if ((formattedMessageElement4 = XmlUtility.getElementByTagNameNS((Node)subStatusListElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"FormattedMessage")) == null) continue;
                                        GuestAgentFormattedMessage formattedMessageInstance4 = new GuestAgentFormattedMessage();
                                        subStatusInstance.setFormattedMessage(formattedMessageInstance4);
                                        Element languageElement4 = XmlUtility.getElementByTagNameNS((Node)formattedMessageElement4, (String)"http://schemas.microsoft.com/windowsazure", (String)"Language");
                                        if (languageElement4 != null) {
                                            String languageInstance4 = languageElement4.getTextContent();
                                            formattedMessageInstance4.setLanguage(languageInstance4);
                                        }
                                        if ((messageElement8 = XmlUtility.getElementByTagNameNS((Node)formattedMessageElement4, (String)"http://schemas.microsoft.com/windowsazure", (String)"Message")) == null) continue;
                                        String messageInstance8 = messageElement8.getTextContent();
                                        formattedMessageInstance4.setMessage(messageInstance8);
                                    }
                                }
                            }
                            if ((powerStateElement = XmlUtility.getElementByTagNameNS((Node)roleInstanceListElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"PowerState")) != null && powerStateElement.getTextContent() != null && !powerStateElement.getTextContent().isEmpty()) {
                                RoleInstancePowerState powerStateInstance = RoleInstancePowerState.valueOf(powerStateElement.getTextContent());
                                roleInstanceInstance.setPowerState(powerStateInstance);
                            }
                            if ((hostNameElement = XmlUtility.getElementByTagNameNS((Node)roleInstanceListElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"HostName")) != null) {
                                String hostNameInstance = hostNameElement.getTextContent();
                                roleInstanceInstance.setHostName(hostNameInstance);
                            }
                            if ((remoteAccessCertificateThumbprintElement = XmlUtility.getElementByTagNameNS((Node)roleInstanceListElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"RemoteAccessCertificateThumbprint")) != null) {
                                String remoteAccessCertificateThumbprintInstance = remoteAccessCertificateThumbprintElement.getTextContent();
                                roleInstanceInstance.setRemoteAccessCertificateThumbprint(remoteAccessCertificateThumbprintInstance);
                            }
                            if ((publicIPsSequenceElement = XmlUtility.getElementByTagNameNS((Node)roleInstanceListElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"PublicIPs")) != null) {
                                for (int i9 = 0; i9 < XmlUtility.getElementsByTagNameNS((Node)publicIPsSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"PublicIP").size(); ++i9) {
                                    Element fqdnsSequenceElement;
                                    Element domainNameLabelElement;
                                    Element idleTimeoutInMinutesElement2;
                                    Element addressElement;
                                    Element publicIPsElement = (Element)XmlUtility.getElementsByTagNameNS((Node)publicIPsSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"PublicIP").get(i9);
                                    RoleInstance.PublicIP publicIPInstance = new RoleInstance.PublicIP();
                                    roleInstanceInstance.getPublicIPs().add(publicIPInstance);
                                    Element nameElement5 = XmlUtility.getElementByTagNameNS((Node)publicIPsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Name");
                                    if (nameElement5 != null) {
                                        String nameInstance5 = nameElement5.getTextContent();
                                        publicIPInstance.setName(nameInstance5);
                                    }
                                    if ((addressElement = XmlUtility.getElementByTagNameNS((Node)publicIPsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Address")) != null) {
                                        InetAddress addressInstance = InetAddress.getByName(addressElement.getTextContent());
                                        publicIPInstance.setAddress(addressInstance);
                                    }
                                    if ((idleTimeoutInMinutesElement2 = XmlUtility.getElementByTagNameNS((Node)publicIPsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"IdleTimeoutInMinutes")) != null && idleTimeoutInMinutesElement2.getTextContent() != null && !idleTimeoutInMinutesElement2.getTextContent().isEmpty()) {
                                        int idleTimeoutInMinutesInstance2 = DatatypeConverter.parseInt((String)idleTimeoutInMinutesElement2.getTextContent());
                                        publicIPInstance.setIdleTimeoutInMinutes(idleTimeoutInMinutesInstance2);
                                    }
                                    if ((domainNameLabelElement = XmlUtility.getElementByTagNameNS((Node)publicIPsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"DomainNameLabel")) != null) {
                                        String domainNameLabelInstance = domainNameLabelElement.getTextContent();
                                        publicIPInstance.setDomainNameLabel(domainNameLabelInstance);
                                    }
                                    if ((fqdnsSequenceElement = XmlUtility.getElementByTagNameNS((Node)publicIPsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Fqdns")) == null) continue;
                                    for (int i10 = 0; i10 < XmlUtility.getElementsByTagNameNS((Node)fqdnsSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Fqdn").size(); ++i10) {
                                        Element fqdnsElement = (Element)XmlUtility.getElementsByTagNameNS((Node)fqdnsSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Fqdn").get(i10);
                                        publicIPInstance.getFqdns().add(fqdnsElement.getTextContent());
                                    }
                                }
                            }
                            if ((networkInterfacesSequenceElement = XmlUtility.getElementByTagNameNS((Node)roleInstanceListElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"NetworkInterfaces")) == null) continue;
                            for (int i11 = 0; i11 < XmlUtility.getElementsByTagNameNS((Node)networkInterfacesSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"NetworkInterface").size(); ++i11) {
                                Element iPConfigurationsSequenceElement;
                                Element macAddressElement;
                                Element networkInterfacesElement = (Element)XmlUtility.getElementsByTagNameNS((Node)networkInterfacesSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"NetworkInterface").get(i11);
                                NetworkInterfaceInstance networkInterfaceInstance = new NetworkInterfaceInstance();
                                roleInstanceInstance.getNetworkInterfaces().add(networkInterfaceInstance);
                                Element nameElement6 = XmlUtility.getElementByTagNameNS((Node)networkInterfacesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Name");
                                if (nameElement6 != null) {
                                    String nameInstance6 = nameElement6.getTextContent();
                                    networkInterfaceInstance.setName(nameInstance6);
                                }
                                if ((macAddressElement = XmlUtility.getElementByTagNameNS((Node)networkInterfacesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"MacAddress")) != null) {
                                    String macAddressInstance = macAddressElement.getTextContent();
                                    networkInterfaceInstance.setMacAddress(macAddressInstance);
                                }
                                if ((iPConfigurationsSequenceElement = XmlUtility.getElementByTagNameNS((Node)networkInterfacesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"IPConfigurations")) == null) continue;
                                for (int i12 = 0; i12 < XmlUtility.getElementsByTagNameNS((Node)iPConfigurationsSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"IPConfiguration").size(); ++i12) {
                                    Element addressElement2;
                                    Element iPConfigurationsElement = (Element)XmlUtility.getElementsByTagNameNS((Node)iPConfigurationsSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"IPConfiguration").get(i12);
                                    IPConfigurationInstance iPConfigurationInstance = new IPConfigurationInstance();
                                    networkInterfaceInstance.getIPConfigurations().add(iPConfigurationInstance);
                                    Element subnetNameElement = XmlUtility.getElementByTagNameNS((Node)iPConfigurationsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"SubnetName");
                                    if (subnetNameElement != null) {
                                        String subnetNameInstance = subnetNameElement.getTextContent();
                                        iPConfigurationInstance.setSubnetName(subnetNameInstance);
                                    }
                                    if ((addressElement2 = XmlUtility.getElementByTagNameNS((Node)iPConfigurationsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Address")) == null) continue;
                                    String addressInstance2 = addressElement2.getTextContent();
                                    iPConfigurationInstance.setAddress(addressInstance2);
                                }
                            }
                        }
                    }
                    if ((upgradeStatusElement = XmlUtility.getElementByTagNameNS((Node)deploymentElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"UpgradeStatus")) != null) {
                        Element currentUpgradeDomainElement;
                        Element currentUpgradeDomainStateElement;
                        UpgradeStatus upgradeStatusInstance = new UpgradeStatus();
                        result.setUpgradeStatus(upgradeStatusInstance);
                        Element upgradeTypeElement = XmlUtility.getElementByTagNameNS((Node)upgradeStatusElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"UpgradeType");
                        if (upgradeTypeElement != null && upgradeTypeElement.getTextContent() != null && !upgradeTypeElement.getTextContent().isEmpty()) {
                            DeploymentUpgradeType upgradeTypeInstance = DeploymentUpgradeType.valueOf(upgradeTypeElement.getTextContent());
                            upgradeStatusInstance.setUpgradeType(upgradeTypeInstance);
                        }
                        if ((currentUpgradeDomainStateElement = XmlUtility.getElementByTagNameNS((Node)upgradeStatusElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"CurrentUpgradeDomainState")) != null && currentUpgradeDomainStateElement.getTextContent() != null && !currentUpgradeDomainStateElement.getTextContent().isEmpty()) {
                            UpgradeDomainState currentUpgradeDomainStateInstance = UpgradeDomainState.valueOf(currentUpgradeDomainStateElement.getTextContent());
                            upgradeStatusInstance.setCurrentUpgradeDomainState(currentUpgradeDomainStateInstance);
                        }
                        if ((currentUpgradeDomainElement = XmlUtility.getElementByTagNameNS((Node)upgradeStatusElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"CurrentUpgradeDomain")) != null) {
                            int currentUpgradeDomainInstance = DatatypeConverter.parseInt((String)currentUpgradeDomainElement.getTextContent());
                            upgradeStatusInstance.setCurrentUpgradeDomain(currentUpgradeDomainInstance);
                        }
                    }
                    if ((upgradeDomainCountElement = XmlUtility.getElementByTagNameNS((Node)deploymentElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"UpgradeDomainCount")) != null) {
                        int upgradeDomainCountInstance = DatatypeConverter.parseInt((String)upgradeDomainCountElement.getTextContent());
                        result.setUpgradeDomainCount(upgradeDomainCountInstance);
                    }
                    if ((roleListSequenceElement = XmlUtility.getElementByTagNameNS((Node)deploymentElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"RoleList")) != null) {
                        for (int i13 = 0; i13 < XmlUtility.getElementsByTagNameNS((Node)roleListSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Role").size(); ++i13) {
                            Element dataDiskConfigurationsSequenceElement;
                            Element vMImageInputElement;
                            Element provisionGuestAgentElement;
                            Element defaultWinRmCertificateThumbprintElement;
                            Element roleSizeElement;
                            Element oSVirtualHardDiskElement;
                            Element labelElement2;
                            Element dataVirtualHardDisksSequenceElement;
                            Element availabilitySetNameElement;
                            Element mediaLocationElement;
                            Element vMImageNameElement;
                            Element resourceExtensionReferencesSequenceElement;
                            Element configurationSetsSequenceElement;
                            Element roleTypeElement;
                            Element osVersionElement;
                            Element roleListElement = (Element)XmlUtility.getElementsByTagNameNS((Node)roleListSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Role").get(i13);
                            Role roleInstance = new Role();
                            result.getRoles().add(roleInstance);
                            Element roleNameElement2 = XmlUtility.getElementByTagNameNS((Node)roleListElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"RoleName");
                            if (roleNameElement2 != null) {
                                String roleNameInstance2 = roleNameElement2.getTextContent();
                                roleInstance.setRoleName(roleNameInstance2);
                            }
                            if ((osVersionElement = XmlUtility.getElementByTagNameNS((Node)roleListElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"OsVersion")) != null) {
                                String osVersionInstance = osVersionElement.getTextContent();
                                roleInstance.setOSVersion(osVersionInstance);
                            }
                            if ((roleTypeElement = XmlUtility.getElementByTagNameNS((Node)roleListElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"RoleType")) != null) {
                                String roleTypeInstance = roleTypeElement.getTextContent();
                                roleInstance.setRoleType(roleTypeInstance);
                            }
                            if ((configurationSetsSequenceElement = XmlUtility.getElementByTagNameNS((Node)roleListElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ConfigurationSets")) != null) {
                                for (int i14 = 0; i14 < XmlUtility.getElementsByTagNameNS((Node)configurationSetsSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ConfigurationSet").size(); ++i14) {
                                    Element customDataElement;
                                    Element sSHElement;
                                    Element disableSshPasswordAuthenticationElement;
                                    Element userPasswordElement;
                                    Element userNameElement;
                                    Element hostNameElement2;
                                    Element additionalUnattendContentElement;
                                    Element adminUsernameElement;
                                    Element winRMElement;
                                    Element storedCertificateSettingsSequenceElement;
                                    Element domainJoinElement;
                                    Element timeZoneElement;
                                    Element enableAutomaticUpdatesElement;
                                    Element resetPasswordOnFirstLogonElement;
                                    Element adminPasswordElement;
                                    Element computerNameElement;
                                    Element iPForwardingElement2;
                                    Element networkSecurityGroupElement2;
                                    Element networkInterfacesSequenceElement2;
                                    Element publicIPsSequenceElement2;
                                    Element staticVirtualNetworkIPAddressElement;
                                    Element subnetNamesSequenceElement;
                                    Element inputEndpointsSequenceElement;
                                    Element configurationSetsElement = (Element)XmlUtility.getElementsByTagNameNS((Node)configurationSetsSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ConfigurationSet").get(i14);
                                    ConfigurationSet configurationSetInstance = new ConfigurationSet();
                                    roleInstance.getConfigurationSets().add(configurationSetInstance);
                                    Element configurationSetTypeElement = XmlUtility.getElementByTagNameNS((Node)configurationSetsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ConfigurationSetType");
                                    if (configurationSetTypeElement != null) {
                                        String configurationSetTypeInstance = configurationSetTypeElement.getTextContent();
                                        configurationSetInstance.setConfigurationSetType(configurationSetTypeInstance);
                                    }
                                    if ((inputEndpointsSequenceElement = XmlUtility.getElementByTagNameNS((Node)configurationSetsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"InputEndpoints")) != null) {
                                        for (int i15 = 0; i15 < XmlUtility.getElementsByTagNameNS((Node)inputEndpointsSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"InputEndpoint").size(); ++i15) {
                                            Element virtualIPNameElement;
                                            Element loadBalancerDistributionElement;
                                            Element idleTimeoutInMinutesElement3;
                                            Element endpointAclElement;
                                            Element loadBalancerNameElement;
                                            Element enableDirectServerReturnElement;
                                            Element vipElement2;
                                            Element protocolElement3;
                                            Element loadBalancerProbeElement;
                                            Element portElement;
                                            Element nameElement7;
                                            Element localPortElement2;
                                            Element inputEndpointsElement = (Element)XmlUtility.getElementsByTagNameNS((Node)inputEndpointsSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"InputEndpoint").get(i15);
                                            InputEndpoint inputEndpointInstance = new InputEndpoint();
                                            configurationSetInstance.getInputEndpoints().add(inputEndpointInstance);
                                            Element loadBalancedEndpointSetNameElement = XmlUtility.getElementByTagNameNS((Node)inputEndpointsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"LoadBalancedEndpointSetName");
                                            if (loadBalancedEndpointSetNameElement != null) {
                                                String loadBalancedEndpointSetNameInstance = loadBalancedEndpointSetNameElement.getTextContent();
                                                inputEndpointInstance.setLoadBalancedEndpointSetName(loadBalancedEndpointSetNameInstance);
                                            }
                                            if ((localPortElement2 = XmlUtility.getElementByTagNameNS((Node)inputEndpointsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"LocalPort")) != null && localPortElement2.getTextContent() != null && !localPortElement2.getTextContent().isEmpty()) {
                                                int localPortInstance2 = DatatypeConverter.parseInt((String)localPortElement2.getTextContent());
                                                inputEndpointInstance.setLocalPort(localPortInstance2);
                                            }
                                            if ((nameElement7 = XmlUtility.getElementByTagNameNS((Node)inputEndpointsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Name")) != null) {
                                                String nameInstance7 = nameElement7.getTextContent();
                                                inputEndpointInstance.setName(nameInstance7);
                                            }
                                            if ((portElement = XmlUtility.getElementByTagNameNS((Node)inputEndpointsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Port")) != null && portElement.getTextContent() != null && !portElement.getTextContent().isEmpty()) {
                                                int portInstance = DatatypeConverter.parseInt((String)portElement.getTextContent());
                                                inputEndpointInstance.setPort(portInstance);
                                            }
                                            if ((loadBalancerProbeElement = XmlUtility.getElementByTagNameNS((Node)inputEndpointsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"LoadBalancerProbe")) != null) {
                                                Element timeoutInSecondsElement;
                                                Element intervalInSecondsElement;
                                                Element protocolElement2;
                                                Element portElement2;
                                                LoadBalancerProbe loadBalancerProbeInstance = new LoadBalancerProbe();
                                                inputEndpointInstance.setLoadBalancerProbe(loadBalancerProbeInstance);
                                                Element pathElement = XmlUtility.getElementByTagNameNS((Node)loadBalancerProbeElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Path");
                                                if (pathElement != null) {
                                                    String pathInstance = pathElement.getTextContent();
                                                    loadBalancerProbeInstance.setPath(pathInstance);
                                                }
                                                if ((portElement2 = XmlUtility.getElementByTagNameNS((Node)loadBalancerProbeElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Port")) != null) {
                                                    int portInstance2 = DatatypeConverter.parseInt((String)portElement2.getTextContent());
                                                    loadBalancerProbeInstance.setPort(portInstance2);
                                                }
                                                if ((protocolElement2 = XmlUtility.getElementByTagNameNS((Node)loadBalancerProbeElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Protocol")) != null && protocolElement2.getTextContent() != null && !protocolElement2.getTextContent().isEmpty()) {
                                                    LoadBalancerProbeTransportProtocol protocolInstance2 = ComputeManagementClientImpl.parseLoadBalancerProbeTransportProtocol(protocolElement2.getTextContent());
                                                    loadBalancerProbeInstance.setProtocol(protocolInstance2);
                                                }
                                                if ((intervalInSecondsElement = XmlUtility.getElementByTagNameNS((Node)loadBalancerProbeElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"IntervalInSeconds")) != null && intervalInSecondsElement.getTextContent() != null && !intervalInSecondsElement.getTextContent().isEmpty()) {
                                                    int intervalInSecondsInstance = DatatypeConverter.parseInt((String)intervalInSecondsElement.getTextContent());
                                                    loadBalancerProbeInstance.setIntervalInSeconds(intervalInSecondsInstance);
                                                }
                                                if ((timeoutInSecondsElement = XmlUtility.getElementByTagNameNS((Node)loadBalancerProbeElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"TimeoutInSeconds")) != null && timeoutInSecondsElement.getTextContent() != null && !timeoutInSecondsElement.getTextContent().isEmpty()) {
                                                    int timeoutInSecondsInstance = DatatypeConverter.parseInt((String)timeoutInSecondsElement.getTextContent());
                                                    loadBalancerProbeInstance.setTimeoutInSeconds(timeoutInSecondsInstance);
                                                }
                                            }
                                            if ((protocolElement3 = XmlUtility.getElementByTagNameNS((Node)inputEndpointsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Protocol")) != null) {
                                                String protocolInstance3 = protocolElement3.getTextContent();
                                                inputEndpointInstance.setProtocol(protocolInstance3);
                                            }
                                            if ((vipElement2 = XmlUtility.getElementByTagNameNS((Node)inputEndpointsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Vip")) != null) {
                                                InetAddress vipInstance2 = InetAddress.getByName(vipElement2.getTextContent());
                                                inputEndpointInstance.setVirtualIPAddress(vipInstance2);
                                            }
                                            if ((enableDirectServerReturnElement = XmlUtility.getElementByTagNameNS((Node)inputEndpointsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"EnableDirectServerReturn")) != null && enableDirectServerReturnElement.getTextContent() != null && !enableDirectServerReturnElement.getTextContent().isEmpty()) {
                                                boolean enableDirectServerReturnInstance = DatatypeConverter.parseBoolean((String)enableDirectServerReturnElement.getTextContent().toLowerCase());
                                                inputEndpointInstance.setEnableDirectServerReturn(enableDirectServerReturnInstance);
                                            }
                                            if ((loadBalancerNameElement = XmlUtility.getElementByTagNameNS((Node)inputEndpointsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"LoadBalancerName")) != null) {
                                                String loadBalancerNameInstance = loadBalancerNameElement.getTextContent();
                                                inputEndpointInstance.setLoadBalancerName(loadBalancerNameInstance);
                                            }
                                            if ((endpointAclElement = XmlUtility.getElementByTagNameNS((Node)inputEndpointsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"EndpointAcl")) != null) {
                                                EndpointAcl endpointAclInstance = new EndpointAcl();
                                                inputEndpointInstance.setEndpointAcl(endpointAclInstance);
                                                Element rulesSequenceElement = XmlUtility.getElementByTagNameNS((Node)endpointAclElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Rules");
                                                if (rulesSequenceElement != null) {
                                                    for (int i16 = 0; i16 < XmlUtility.getElementsByTagNameNS((Node)rulesSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Rule").size(); ++i16) {
                                                        Element descriptionElement;
                                                        Element remoteSubnetElement;
                                                        Element actionElement;
                                                        Element rulesElement = (Element)XmlUtility.getElementsByTagNameNS((Node)rulesSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Rule").get(i16);
                                                        AccessControlListRule ruleInstance = new AccessControlListRule();
                                                        endpointAclInstance.getRules().add(ruleInstance);
                                                        Element orderElement = XmlUtility.getElementByTagNameNS((Node)rulesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Order");
                                                        if (orderElement != null && orderElement.getTextContent() != null && !orderElement.getTextContent().isEmpty()) {
                                                            int orderInstance = DatatypeConverter.parseInt((String)orderElement.getTextContent());
                                                            ruleInstance.setOrder(orderInstance);
                                                        }
                                                        if ((actionElement = XmlUtility.getElementByTagNameNS((Node)rulesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Action")) != null) {
                                                            String actionInstance = actionElement.getTextContent();
                                                            ruleInstance.setAction(actionInstance);
                                                        }
                                                        if ((remoteSubnetElement = XmlUtility.getElementByTagNameNS((Node)rulesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"RemoteSubnet")) != null) {
                                                            String remoteSubnetInstance = remoteSubnetElement.getTextContent();
                                                            ruleInstance.setRemoteSubnet(remoteSubnetInstance);
                                                        }
                                                        if ((descriptionElement = XmlUtility.getElementByTagNameNS((Node)rulesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Description")) == null) continue;
                                                        String descriptionInstance = descriptionElement.getTextContent();
                                                        ruleInstance.setDescription(descriptionInstance);
                                                    }
                                                }
                                            }
                                            if ((idleTimeoutInMinutesElement3 = XmlUtility.getElementByTagNameNS((Node)inputEndpointsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"IdleTimeoutInMinutes")) != null && idleTimeoutInMinutesElement3.getTextContent() != null && !idleTimeoutInMinutesElement3.getTextContent().isEmpty()) {
                                                int idleTimeoutInMinutesInstance3 = DatatypeConverter.parseInt((String)idleTimeoutInMinutesElement3.getTextContent());
                                                inputEndpointInstance.setIdleTimeoutInMinutes(idleTimeoutInMinutesInstance3);
                                            }
                                            if ((loadBalancerDistributionElement = XmlUtility.getElementByTagNameNS((Node)inputEndpointsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"LoadBalancerDistribution")) != null) {
                                                String loadBalancerDistributionInstance = loadBalancerDistributionElement.getTextContent();
                                                inputEndpointInstance.setLoadBalancerDistribution(loadBalancerDistributionInstance);
                                            }
                                            if ((virtualIPNameElement = XmlUtility.getElementByTagNameNS((Node)inputEndpointsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"VirtualIPName")) == null) continue;
                                            String virtualIPNameInstance = virtualIPNameElement.getTextContent();
                                            inputEndpointInstance.setVirtualIPName(virtualIPNameInstance);
                                        }
                                    }
                                    if ((subnetNamesSequenceElement = XmlUtility.getElementByTagNameNS((Node)configurationSetsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"SubnetNames")) != null) {
                                        for (int i17 = 0; i17 < XmlUtility.getElementsByTagNameNS((Node)subnetNamesSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"SubnetName").size(); ++i17) {
                                            Element subnetNamesElement = (Element)XmlUtility.getElementsByTagNameNS((Node)subnetNamesSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"SubnetName").get(i17);
                                            configurationSetInstance.getSubnetNames().add(subnetNamesElement.getTextContent());
                                        }
                                    }
                                    if ((staticVirtualNetworkIPAddressElement = XmlUtility.getElementByTagNameNS((Node)configurationSetsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"StaticVirtualNetworkIPAddress")) != null) {
                                        String staticVirtualNetworkIPAddressInstance = staticVirtualNetworkIPAddressElement.getTextContent();
                                        configurationSetInstance.setStaticVirtualNetworkIPAddress(staticVirtualNetworkIPAddressInstance);
                                    }
                                    if ((publicIPsSequenceElement2 = XmlUtility.getElementByTagNameNS((Node)configurationSetsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"PublicIPs")) != null) {
                                        for (int i18 = 0; i18 < XmlUtility.getElementsByTagNameNS((Node)publicIPsSequenceElement2, (String)"http://schemas.microsoft.com/windowsazure", (String)"PublicIP").size(); ++i18) {
                                            Element domainNameLabelElement2;
                                            Element idleTimeoutInMinutesElement4;
                                            Element publicIPsElement2 = (Element)XmlUtility.getElementsByTagNameNS((Node)publicIPsSequenceElement2, (String)"http://schemas.microsoft.com/windowsazure", (String)"PublicIP").get(i18);
                                            ConfigurationSet.PublicIP publicIPInstance2 = new ConfigurationSet.PublicIP();
                                            configurationSetInstance.getPublicIPs().add(publicIPInstance2);
                                            Element nameElement8 = XmlUtility.getElementByTagNameNS((Node)publicIPsElement2, (String)"http://schemas.microsoft.com/windowsazure", (String)"Name");
                                            if (nameElement8 != null) {
                                                String nameInstance8 = nameElement8.getTextContent();
                                                publicIPInstance2.setName(nameInstance8);
                                            }
                                            if ((idleTimeoutInMinutesElement4 = XmlUtility.getElementByTagNameNS((Node)publicIPsElement2, (String)"http://schemas.microsoft.com/windowsazure", (String)"IdleTimeoutInMinutes")) != null && idleTimeoutInMinutesElement4.getTextContent() != null && !idleTimeoutInMinutesElement4.getTextContent().isEmpty()) {
                                                int idleTimeoutInMinutesInstance4 = DatatypeConverter.parseInt((String)idleTimeoutInMinutesElement4.getTextContent());
                                                publicIPInstance2.setIdleTimeoutInMinutes(idleTimeoutInMinutesInstance4);
                                            }
                                            if ((domainNameLabelElement2 = XmlUtility.getElementByTagNameNS((Node)publicIPsElement2, (String)"http://schemas.microsoft.com/windowsazure", (String)"DomainNameLabel")) == null) continue;
                                            String domainNameLabelInstance2 = domainNameLabelElement2.getTextContent();
                                            publicIPInstance2.setDomainNameLabel(domainNameLabelInstance2);
                                        }
                                    }
                                    if ((networkInterfacesSequenceElement2 = XmlUtility.getElementByTagNameNS((Node)configurationSetsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"NetworkInterfaces")) != null) {
                                        for (int i19 = 0; i19 < XmlUtility.getElementsByTagNameNS((Node)networkInterfacesSequenceElement2, (String)"http://schemas.microsoft.com/windowsazure", (String)"NetworkInterface").size(); ++i19) {
                                            Element iPForwardingElement;
                                            Element networkSecurityGroupElement;
                                            Element iPConfigurationsSequenceElement2;
                                            Element networkInterfacesElement2 = (Element)XmlUtility.getElementsByTagNameNS((Node)networkInterfacesSequenceElement2, (String)"http://schemas.microsoft.com/windowsazure", (String)"NetworkInterface").get(i19);
                                            NetworkInterface networkInterfaceInstance2 = new NetworkInterface();
                                            configurationSetInstance.getNetworkInterfaces().add(networkInterfaceInstance2);
                                            Element nameElement9 = XmlUtility.getElementByTagNameNS((Node)networkInterfacesElement2, (String)"http://schemas.microsoft.com/windowsazure", (String)"Name");
                                            if (nameElement9 != null) {
                                                String nameInstance9 = nameElement9.getTextContent();
                                                networkInterfaceInstance2.setName(nameInstance9);
                                            }
                                            if ((iPConfigurationsSequenceElement2 = XmlUtility.getElementByTagNameNS((Node)networkInterfacesElement2, (String)"http://schemas.microsoft.com/windowsazure", (String)"IPConfigurations")) != null) {
                                                for (int i20 = 0; i20 < XmlUtility.getElementsByTagNameNS((Node)iPConfigurationsSequenceElement2, (String)"http://schemas.microsoft.com/windowsazure", (String)"IPConfiguration").size(); ++i20) {
                                                    Element staticVirtualNetworkIPAddressElement2;
                                                    Element iPConfigurationsElement2 = (Element)XmlUtility.getElementsByTagNameNS((Node)iPConfigurationsSequenceElement2, (String)"http://schemas.microsoft.com/windowsazure", (String)"IPConfiguration").get(i20);
                                                    IPConfiguration iPConfigurationInstance2 = new IPConfiguration();
                                                    networkInterfaceInstance2.getIPConfigurations().add(iPConfigurationInstance2);
                                                    Element subnetNameElement2 = XmlUtility.getElementByTagNameNS((Node)iPConfigurationsElement2, (String)"http://schemas.microsoft.com/windowsazure", (String)"SubnetName");
                                                    if (subnetNameElement2 != null) {
                                                        String subnetNameInstance2 = subnetNameElement2.getTextContent();
                                                        iPConfigurationInstance2.setSubnetName(subnetNameInstance2);
                                                    }
                                                    if ((staticVirtualNetworkIPAddressElement2 = XmlUtility.getElementByTagNameNS((Node)iPConfigurationsElement2, (String)"http://schemas.microsoft.com/windowsazure", (String)"StaticVirtualNetworkIPAddress")) == null) continue;
                                                    String staticVirtualNetworkIPAddressInstance2 = staticVirtualNetworkIPAddressElement2.getTextContent();
                                                    iPConfigurationInstance2.setStaticVirtualNetworkIPAddress(staticVirtualNetworkIPAddressInstance2);
                                                }
                                            }
                                            if ((networkSecurityGroupElement = XmlUtility.getElementByTagNameNS((Node)networkInterfacesElement2, (String)"http://schemas.microsoft.com/windowsazure", (String)"NetworkSecurityGroup")) != null) {
                                                String networkSecurityGroupInstance = networkSecurityGroupElement.getTextContent();
                                                networkInterfaceInstance2.setNetworkSecurityGroup(networkSecurityGroupInstance);
                                            }
                                            if ((iPForwardingElement = XmlUtility.getElementByTagNameNS((Node)networkInterfacesElement2, (String)"http://schemas.microsoft.com/windowsazure", (String)"IPForwarding")) == null) continue;
                                            String iPForwardingInstance = iPForwardingElement.getTextContent();
                                            networkInterfaceInstance2.setIPForwarding(iPForwardingInstance);
                                        }
                                    }
                                    if ((networkSecurityGroupElement2 = XmlUtility.getElementByTagNameNS((Node)configurationSetsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"NetworkSecurityGroup")) != null) {
                                        String networkSecurityGroupInstance2 = networkSecurityGroupElement2.getTextContent();
                                        configurationSetInstance.setNetworkSecurityGroup(networkSecurityGroupInstance2);
                                    }
                                    if ((iPForwardingElement2 = XmlUtility.getElementByTagNameNS((Node)configurationSetsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"IPForwarding")) != null) {
                                        String iPForwardingInstance2 = iPForwardingElement2.getTextContent();
                                        configurationSetInstance.setIPForwarding(iPForwardingInstance2);
                                    }
                                    if ((computerNameElement = XmlUtility.getElementByTagNameNS((Node)configurationSetsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ComputerName")) != null) {
                                        String computerNameInstance = computerNameElement.getTextContent();
                                        configurationSetInstance.setComputerName(computerNameInstance);
                                    }
                                    if ((adminPasswordElement = XmlUtility.getElementByTagNameNS((Node)configurationSetsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"AdminPassword")) != null) {
                                        String adminPasswordInstance = adminPasswordElement.getTextContent();
                                        configurationSetInstance.setAdminPassword(adminPasswordInstance);
                                    }
                                    if ((resetPasswordOnFirstLogonElement = XmlUtility.getElementByTagNameNS((Node)configurationSetsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ResetPasswordOnFirstLogon")) != null && resetPasswordOnFirstLogonElement.getTextContent() != null && !resetPasswordOnFirstLogonElement.getTextContent().isEmpty()) {
                                        boolean resetPasswordOnFirstLogonInstance = DatatypeConverter.parseBoolean((String)resetPasswordOnFirstLogonElement.getTextContent().toLowerCase());
                                        configurationSetInstance.setResetPasswordOnFirstLogon(resetPasswordOnFirstLogonInstance);
                                    }
                                    if ((enableAutomaticUpdatesElement = XmlUtility.getElementByTagNameNS((Node)configurationSetsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"EnableAutomaticUpdates")) != null && enableAutomaticUpdatesElement.getTextContent() != null && !enableAutomaticUpdatesElement.getTextContent().isEmpty()) {
                                        boolean enableAutomaticUpdatesInstance = DatatypeConverter.parseBoolean((String)enableAutomaticUpdatesElement.getTextContent().toLowerCase());
                                        configurationSetInstance.setEnableAutomaticUpdates(enableAutomaticUpdatesInstance);
                                    }
                                    if ((timeZoneElement = XmlUtility.getElementByTagNameNS((Node)configurationSetsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"TimeZone")) != null) {
                                        String timeZoneInstance = timeZoneElement.getTextContent();
                                        configurationSetInstance.setTimeZone(timeZoneInstance);
                                    }
                                    if ((domainJoinElement = XmlUtility.getElementByTagNameNS((Node)configurationSetsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"DomainJoin")) != null) {
                                        Element provisioningElement;
                                        Element machineObjectOUElement;
                                        Element joinDomainElement;
                                        DomainJoinSettings domainJoinInstance = new DomainJoinSettings();
                                        configurationSetInstance.setDomainJoin(domainJoinInstance);
                                        Element credentialsElement = XmlUtility.getElementByTagNameNS((Node)domainJoinElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Credentials");
                                        if (credentialsElement != null) {
                                            Element passwordElement;
                                            Element usernameElement;
                                            DomainJoinCredentials credentialsInstance = new DomainJoinCredentials();
                                            domainJoinInstance.setCredentials(credentialsInstance);
                                            Element domainElement = XmlUtility.getElementByTagNameNS((Node)credentialsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Domain");
                                            if (domainElement != null) {
                                                String domainInstance = domainElement.getTextContent();
                                                credentialsInstance.setDomain(domainInstance);
                                            }
                                            if ((usernameElement = XmlUtility.getElementByTagNameNS((Node)credentialsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Username")) != null) {
                                                String usernameInstance = usernameElement.getTextContent();
                                                credentialsInstance.setUserName(usernameInstance);
                                            }
                                            if ((passwordElement = XmlUtility.getElementByTagNameNS((Node)credentialsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Password")) != null) {
                                                String passwordInstance = passwordElement.getTextContent();
                                                credentialsInstance.setPassword(passwordInstance);
                                            }
                                        }
                                        if ((joinDomainElement = XmlUtility.getElementByTagNameNS((Node)domainJoinElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"JoinDomain")) != null) {
                                            String joinDomainInstance = joinDomainElement.getTextContent();
                                            domainJoinInstance.setDomainToJoin(joinDomainInstance);
                                        }
                                        if ((machineObjectOUElement = XmlUtility.getElementByTagNameNS((Node)domainJoinElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"MachineObjectOU")) != null) {
                                            String machineObjectOUInstance = machineObjectOUElement.getTextContent();
                                            domainJoinInstance.setLdapMachineObjectOU(machineObjectOUInstance);
                                        }
                                        if ((provisioningElement = XmlUtility.getElementByTagNameNS((Node)domainJoinElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Provisioning")) != null) {
                                            DomainJoinProvisioning provisioningInstance = new DomainJoinProvisioning();
                                            domainJoinInstance.setProvisioning(provisioningInstance);
                                            Element accountDataElement = XmlUtility.getElementByTagNameNS((Node)provisioningElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"AccountData");
                                            if (accountDataElement != null) {
                                                String accountDataInstance = accountDataElement.getTextContent();
                                                provisioningInstance.setAccountData(accountDataInstance);
                                            }
                                        }
                                    }
                                    if ((storedCertificateSettingsSequenceElement = XmlUtility.getElementByTagNameNS((Node)configurationSetsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"StoredCertificateSettings")) != null) {
                                        for (int i21 = 0; i21 < XmlUtility.getElementsByTagNameNS((Node)storedCertificateSettingsSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"CertificateSetting").size(); ++i21) {
                                            Element thumbprintElement;
                                            Element storeNameElement;
                                            Element storedCertificateSettingsElement = (Element)XmlUtility.getElementsByTagNameNS((Node)storedCertificateSettingsSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"CertificateSetting").get(i21);
                                            StoredCertificateSettings certificateSettingInstance = new StoredCertificateSettings();
                                            configurationSetInstance.getStoredCertificateSettings().add(certificateSettingInstance);
                                            Element storeLocationElement = XmlUtility.getElementByTagNameNS((Node)storedCertificateSettingsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"StoreLocation");
                                            if (storeLocationElement != null) {
                                                // empty if block
                                            }
                                            if ((storeNameElement = XmlUtility.getElementByTagNameNS((Node)storedCertificateSettingsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"StoreName")) != null) {
                                                String storeNameInstance = storeNameElement.getTextContent();
                                                certificateSettingInstance.setStoreName(storeNameInstance);
                                            }
                                            if ((thumbprintElement = XmlUtility.getElementByTagNameNS((Node)storedCertificateSettingsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Thumbprint")) == null) continue;
                                            String thumbprintInstance = thumbprintElement.getTextContent();
                                            certificateSettingInstance.setThumbprint(thumbprintInstance);
                                        }
                                    }
                                    if ((winRMElement = XmlUtility.getElementByTagNameNS((Node)configurationSetsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"WinRM")) != null) {
                                        WindowsRemoteManagementSettings winRMInstance = new WindowsRemoteManagementSettings();
                                        configurationSetInstance.setWindowsRemoteManagement(winRMInstance);
                                        Element listenersSequenceElement = XmlUtility.getElementByTagNameNS((Node)winRMElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Listeners");
                                        if (listenersSequenceElement != null) {
                                            for (int i22 = 0; i22 < XmlUtility.getElementsByTagNameNS((Node)listenersSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Listener").size(); ++i22) {
                                                Element certificateThumbprintElement;
                                                Element listenersElement = (Element)XmlUtility.getElementsByTagNameNS((Node)listenersSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Listener").get(i22);
                                                WindowsRemoteManagementListener listenerInstance = new WindowsRemoteManagementListener();
                                                winRMInstance.getListeners().add(listenerInstance);
                                                Element protocolElement4 = XmlUtility.getElementByTagNameNS((Node)listenersElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Protocol");
                                                if (protocolElement4 != null && protocolElement4.getTextContent() != null && !protocolElement4.getTextContent().isEmpty()) {
                                                    VirtualMachineWindowsRemoteManagementListenerType protocolInstance4 = VirtualMachineWindowsRemoteManagementListenerType.valueOf(protocolElement4.getTextContent());
                                                    listenerInstance.setListenerType(protocolInstance4);
                                                }
                                                if ((certificateThumbprintElement = XmlUtility.getElementByTagNameNS((Node)listenersElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"CertificateThumbprint")) == null) continue;
                                                String certificateThumbprintInstance = certificateThumbprintElement.getTextContent();
                                                listenerInstance.setCertificateThumbprint(certificateThumbprintInstance);
                                            }
                                        }
                                    }
                                    if ((adminUsernameElement = XmlUtility.getElementByTagNameNS((Node)configurationSetsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"AdminUsername")) != null) {
                                        String adminUsernameInstance = adminUsernameElement.getTextContent();
                                        configurationSetInstance.setAdminUserName(adminUsernameInstance);
                                    }
                                    if ((additionalUnattendContentElement = XmlUtility.getElementByTagNameNS((Node)configurationSetsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"AdditionalUnattendContent")) != null) {
                                        AdditionalUnattendContentSettings additionalUnattendContentInstance = new AdditionalUnattendContentSettings();
                                        configurationSetInstance.setAdditionalUnattendContent(additionalUnattendContentInstance);
                                        Element passesSequenceElement = XmlUtility.getElementByTagNameNS((Node)additionalUnattendContentElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Passes");
                                        if (passesSequenceElement != null) {
                                            for (int i23 = 0; i23 < XmlUtility.getElementsByTagNameNS((Node)passesSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"UnattendPass").size(); ++i23) {
                                                Element componentsSequenceElement;
                                                Element passesElement = (Element)XmlUtility.getElementsByTagNameNS((Node)passesSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"UnattendPass").get(i23);
                                                UnattendPassSettings unattendPassInstance = new UnattendPassSettings();
                                                additionalUnattendContentInstance.getUnattendPasses().add(unattendPassInstance);
                                                Element passNameElement = XmlUtility.getElementByTagNameNS((Node)passesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"PassName");
                                                if (passNameElement != null) {
                                                    String passNameInstance = passNameElement.getTextContent();
                                                    unattendPassInstance.setPassName(passNameInstance);
                                                }
                                                if ((componentsSequenceElement = XmlUtility.getElementByTagNameNS((Node)passesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Components")) == null) continue;
                                                for (int i24 = 0; i24 < XmlUtility.getElementsByTagNameNS((Node)componentsSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"UnattendComponent").size(); ++i24) {
                                                    Element componentSettingsSequenceElement;
                                                    Element componentsElement = (Element)XmlUtility.getElementsByTagNameNS((Node)componentsSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"UnattendComponent").get(i24);
                                                    UnattendComponent unattendComponentInstance = new UnattendComponent();
                                                    unattendPassInstance.getUnattendComponents().add(unattendComponentInstance);
                                                    Element componentNameElement = XmlUtility.getElementByTagNameNS((Node)componentsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ComponentName");
                                                    if (componentNameElement != null) {
                                                        String componentNameInstance = componentNameElement.getTextContent();
                                                        unattendComponentInstance.setComponentName(componentNameInstance);
                                                    }
                                                    if ((componentSettingsSequenceElement = XmlUtility.getElementByTagNameNS((Node)componentsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ComponentSettings")) == null) continue;
                                                    for (int i25 = 0; i25 < XmlUtility.getElementsByTagNameNS((Node)componentSettingsSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ComponentSetting").size(); ++i25) {
                                                        Element contentElement;
                                                        Element componentSettingsElement = (Element)XmlUtility.getElementsByTagNameNS((Node)componentSettingsSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ComponentSetting").get(i25);
                                                        ComponentSetting componentSettingInstance = new ComponentSetting();
                                                        unattendComponentInstance.getUnattendComponentSettings().add(componentSettingInstance);
                                                        Element settingNameElement = XmlUtility.getElementByTagNameNS((Node)componentSettingsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"SettingName");
                                                        if (settingNameElement != null) {
                                                            String settingNameInstance = settingNameElement.getTextContent();
                                                            componentSettingInstance.setSettingName(settingNameInstance);
                                                        }
                                                        if ((contentElement = XmlUtility.getElementByTagNameNS((Node)componentSettingsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Content")) == null) continue;
                                                        String contentInstance = contentElement.getTextContent() != null ? new String(Base64.decode((String)contentElement.getTextContent())) : null;
                                                        componentSettingInstance.setContent(contentInstance);
                                                    }
                                                }
                                            }
                                        }
                                    }
                                    if ((hostNameElement2 = XmlUtility.getElementByTagNameNS((Node)configurationSetsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"HostName")) != null) {
                                        String hostNameInstance2 = hostNameElement2.getTextContent();
                                        configurationSetInstance.setHostName(hostNameInstance2);
                                    }
                                    if ((userNameElement = XmlUtility.getElementByTagNameNS((Node)configurationSetsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"UserName")) != null) {
                                        String userNameInstance = userNameElement.getTextContent();
                                        configurationSetInstance.setUserName(userNameInstance);
                                    }
                                    if ((userPasswordElement = XmlUtility.getElementByTagNameNS((Node)configurationSetsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"UserPassword")) != null) {
                                        String userPasswordInstance = userPasswordElement.getTextContent();
                                        configurationSetInstance.setUserPassword(userPasswordInstance);
                                    }
                                    if ((disableSshPasswordAuthenticationElement = XmlUtility.getElementByTagNameNS((Node)configurationSetsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"DisableSshPasswordAuthentication")) != null && disableSshPasswordAuthenticationElement.getTextContent() != null && !disableSshPasswordAuthenticationElement.getTextContent().isEmpty()) {
                                        boolean disableSshPasswordAuthenticationInstance = DatatypeConverter.parseBoolean((String)disableSshPasswordAuthenticationElement.getTextContent().toLowerCase());
                                        configurationSetInstance.setDisableSshPasswordAuthentication(disableSshPasswordAuthenticationInstance);
                                    }
                                    if ((sSHElement = XmlUtility.getElementByTagNameNS((Node)configurationSetsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"SSH")) != null) {
                                        Element keyPairsSequenceElement;
                                        SshSettings sSHInstance = new SshSettings();
                                        configurationSetInstance.setSshSettings(sSHInstance);
                                        Element publicKeysSequenceElement = XmlUtility.getElementByTagNameNS((Node)sSHElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"PublicKeys");
                                        if (publicKeysSequenceElement != null) {
                                            for (int i26 = 0; i26 < XmlUtility.getElementsByTagNameNS((Node)publicKeysSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"PublicKey").size(); ++i26) {
                                                Element pathElement2;
                                                Element publicKeysElement = (Element)XmlUtility.getElementsByTagNameNS((Node)publicKeysSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"PublicKey").get(i26);
                                                SshSettingPublicKey publicKeyInstance = new SshSettingPublicKey();
                                                sSHInstance.getPublicKeys().add(publicKeyInstance);
                                                Element fingerprintElement = XmlUtility.getElementByTagNameNS((Node)publicKeysElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Fingerprint");
                                                if (fingerprintElement != null) {
                                                    String fingerprintInstance = fingerprintElement.getTextContent();
                                                    publicKeyInstance.setFingerprint(fingerprintInstance);
                                                }
                                                if ((pathElement2 = XmlUtility.getElementByTagNameNS((Node)publicKeysElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Path")) == null) continue;
                                                String pathInstance2 = pathElement2.getTextContent();
                                                publicKeyInstance.setPath(pathInstance2);
                                            }
                                        }
                                        if ((keyPairsSequenceElement = XmlUtility.getElementByTagNameNS((Node)sSHElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"KeyPairs")) != null) {
                                            for (int i27 = 0; i27 < XmlUtility.getElementsByTagNameNS((Node)keyPairsSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"KeyPair").size(); ++i27) {
                                                Element pathElement3;
                                                Element keyPairsElement = (Element)XmlUtility.getElementsByTagNameNS((Node)keyPairsSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"KeyPair").get(i27);
                                                SshSettingKeyPair keyPairInstance = new SshSettingKeyPair();
                                                sSHInstance.getKeyPairs().add(keyPairInstance);
                                                Element fingerprintElement2 = XmlUtility.getElementByTagNameNS((Node)keyPairsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Fingerprint");
                                                if (fingerprintElement2 != null) {
                                                    String fingerprintInstance2 = fingerprintElement2.getTextContent();
                                                    keyPairInstance.setFingerprint(fingerprintInstance2);
                                                }
                                                if ((pathElement3 = XmlUtility.getElementByTagNameNS((Node)keyPairsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Path")) == null) continue;
                                                String pathInstance3 = pathElement3.getTextContent();
                                                keyPairInstance.setPath(pathInstance3);
                                            }
                                        }
                                    }
                                    if ((customDataElement = XmlUtility.getElementByTagNameNS((Node)configurationSetsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"CustomData")) == null) continue;
                                    String customDataInstance = customDataElement.getTextContent();
                                    configurationSetInstance.setCustomData(customDataInstance);
                                }
                            }
                            if ((resourceExtensionReferencesSequenceElement = XmlUtility.getElementByTagNameNS((Node)roleListElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ResourceExtensionReferences")) != null) {
                                for (int i28 = 0; i28 < XmlUtility.getElementsByTagNameNS((Node)resourceExtensionReferencesSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ResourceExtensionReference").size(); ++i28) {
                                    Element forceUpdateElement;
                                    Element stateElement;
                                    Element resourceExtensionParameterValuesSequenceElement;
                                    Element versionElement2;
                                    Element nameElement10;
                                    Element publisherElement;
                                    Element resourceExtensionReferencesElement = (Element)XmlUtility.getElementsByTagNameNS((Node)resourceExtensionReferencesSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ResourceExtensionReference").get(i28);
                                    ResourceExtensionReference resourceExtensionReferenceInstance = new ResourceExtensionReference();
                                    roleInstance.getResourceExtensionReferences().add(resourceExtensionReferenceInstance);
                                    Element referenceNameElement = XmlUtility.getElementByTagNameNS((Node)resourceExtensionReferencesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ReferenceName");
                                    if (referenceNameElement != null) {
                                        String referenceNameInstance = referenceNameElement.getTextContent();
                                        resourceExtensionReferenceInstance.setReferenceName(referenceNameInstance);
                                    }
                                    if ((publisherElement = XmlUtility.getElementByTagNameNS((Node)resourceExtensionReferencesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Publisher")) != null) {
                                        String publisherInstance = publisherElement.getTextContent();
                                        resourceExtensionReferenceInstance.setPublisher(publisherInstance);
                                    }
                                    if ((nameElement10 = XmlUtility.getElementByTagNameNS((Node)resourceExtensionReferencesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Name")) != null) {
                                        String nameInstance10 = nameElement10.getTextContent();
                                        resourceExtensionReferenceInstance.setName(nameInstance10);
                                    }
                                    if ((versionElement2 = XmlUtility.getElementByTagNameNS((Node)resourceExtensionReferencesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Version")) != null) {
                                        String versionInstance2 = versionElement2.getTextContent();
                                        resourceExtensionReferenceInstance.setVersion(versionInstance2);
                                    }
                                    if ((resourceExtensionParameterValuesSequenceElement = XmlUtility.getElementByTagNameNS((Node)resourceExtensionReferencesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ResourceExtensionParameterValues")) != null) {
                                        for (int i29 = 0; i29 < XmlUtility.getElementsByTagNameNS((Node)resourceExtensionParameterValuesSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ResourceExtensionParameterValue").size(); ++i29) {
                                            Element typeElement;
                                            Element valueElement;
                                            Element resourceExtensionParameterValuesElement = (Element)XmlUtility.getElementsByTagNameNS((Node)resourceExtensionParameterValuesSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ResourceExtensionParameterValue").get(i29);
                                            ResourceExtensionParameterValue resourceExtensionParameterValueInstance = new ResourceExtensionParameterValue();
                                            resourceExtensionReferenceInstance.getResourceExtensionParameterValues().add(resourceExtensionParameterValueInstance);
                                            Element keyElement = XmlUtility.getElementByTagNameNS((Node)resourceExtensionParameterValuesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Key");
                                            if (keyElement != null) {
                                                String keyInstance = keyElement.getTextContent();
                                                resourceExtensionParameterValueInstance.setKey(keyInstance);
                                            }
                                            if ((valueElement = XmlUtility.getElementByTagNameNS((Node)resourceExtensionParameterValuesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Value")) != null) {
                                                String valueInstance = valueElement.getTextContent() != null ? new String(Base64.decode((String)valueElement.getTextContent())) : null;
                                                resourceExtensionParameterValueInstance.setValue(valueInstance);
                                            }
                                            if ((typeElement = XmlUtility.getElementByTagNameNS((Node)resourceExtensionParameterValuesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Type")) == null) continue;
                                            String typeInstance = typeElement.getTextContent();
                                            resourceExtensionParameterValueInstance.setType(typeInstance);
                                        }
                                    }
                                    if ((stateElement = XmlUtility.getElementByTagNameNS((Node)resourceExtensionReferencesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"State")) != null) {
                                        String stateInstance = stateElement.getTextContent();
                                        resourceExtensionReferenceInstance.setState(stateInstance);
                                    }
                                    if ((forceUpdateElement = XmlUtility.getElementByTagNameNS((Node)resourceExtensionReferencesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ForceUpdate")) == null || forceUpdateElement.getTextContent() == null || forceUpdateElement.getTextContent().isEmpty()) continue;
                                    boolean forceUpdateInstance = DatatypeConverter.parseBoolean((String)forceUpdateElement.getTextContent().toLowerCase());
                                    resourceExtensionReferenceInstance.setForceUpdate(forceUpdateInstance);
                                }
                            }
                            if ((vMImageNameElement = XmlUtility.getElementByTagNameNS((Node)roleListElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"VMImageName")) != null) {
                                String vMImageNameInstance = vMImageNameElement.getTextContent();
                                roleInstance.setVMImageName(vMImageNameInstance);
                            }
                            if ((mediaLocationElement = XmlUtility.getElementByTagNameNS((Node)roleListElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"MediaLocation")) != null) {
                                URI mediaLocationInstance = new URI(mediaLocationElement.getTextContent());
                                roleInstance.setMediaLocation(mediaLocationInstance);
                            }
                            if ((availabilitySetNameElement = XmlUtility.getElementByTagNameNS((Node)roleListElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"AvailabilitySetName")) != null) {
                                String availabilitySetNameInstance = availabilitySetNameElement.getTextContent();
                                roleInstance.setAvailabilitySetName(availabilitySetNameInstance);
                            }
                            if ((dataVirtualHardDisksSequenceElement = XmlUtility.getElementByTagNameNS((Node)roleListElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"DataVirtualHardDisks")) != null) {
                                for (int i30 = 0; i30 < XmlUtility.getElementsByTagNameNS((Node)dataVirtualHardDisksSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"DataVirtualHardDisk").size(); ++i30) {
                                    Element iOTypeElement;
                                    Element sourceMediaLinkElement;
                                    Element mediaLinkElement;
                                    Element logicalDiskSizeInGBElement;
                                    Element lunElement;
                                    Element diskNameElement;
                                    Element diskLabelElement;
                                    Element dataVirtualHardDisksElement = (Element)XmlUtility.getElementsByTagNameNS((Node)dataVirtualHardDisksSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"DataVirtualHardDisk").get(i30);
                                    DataVirtualHardDisk dataVirtualHardDiskInstance = new DataVirtualHardDisk();
                                    roleInstance.getDataVirtualHardDisks().add(dataVirtualHardDiskInstance);
                                    Element hostCachingElement = XmlUtility.getElementByTagNameNS((Node)dataVirtualHardDisksElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"HostCaching");
                                    if (hostCachingElement != null) {
                                        String hostCachingInstance = hostCachingElement.getTextContent();
                                        dataVirtualHardDiskInstance.setHostCaching(hostCachingInstance);
                                    }
                                    if ((diskLabelElement = XmlUtility.getElementByTagNameNS((Node)dataVirtualHardDisksElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"DiskLabel")) != null) {
                                        String diskLabelInstance = diskLabelElement.getTextContent();
                                        dataVirtualHardDiskInstance.setLabel(diskLabelInstance);
                                    }
                                    if ((diskNameElement = XmlUtility.getElementByTagNameNS((Node)dataVirtualHardDisksElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"DiskName")) != null) {
                                        String diskNameInstance = diskNameElement.getTextContent();
                                        dataVirtualHardDiskInstance.setName(diskNameInstance);
                                    }
                                    if ((lunElement = XmlUtility.getElementByTagNameNS((Node)dataVirtualHardDisksElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Lun")) != null && lunElement.getTextContent() != null && !lunElement.getTextContent().isEmpty()) {
                                        int lunInstance = DatatypeConverter.parseInt((String)lunElement.getTextContent());
                                        dataVirtualHardDiskInstance.setLogicalUnitNumber(lunInstance);
                                    }
                                    if ((logicalDiskSizeInGBElement = XmlUtility.getElementByTagNameNS((Node)dataVirtualHardDisksElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"LogicalDiskSizeInGB")) != null && logicalDiskSizeInGBElement.getTextContent() != null && !logicalDiskSizeInGBElement.getTextContent().isEmpty()) {
                                        int logicalDiskSizeInGBInstance = DatatypeConverter.parseInt((String)logicalDiskSizeInGBElement.getTextContent());
                                        dataVirtualHardDiskInstance.setLogicalDiskSizeInGB(logicalDiskSizeInGBInstance);
                                    }
                                    if ((mediaLinkElement = XmlUtility.getElementByTagNameNS((Node)dataVirtualHardDisksElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"MediaLink")) != null) {
                                        URI mediaLinkInstance = new URI(mediaLinkElement.getTextContent());
                                        dataVirtualHardDiskInstance.setMediaLink(mediaLinkInstance);
                                    }
                                    if ((sourceMediaLinkElement = XmlUtility.getElementByTagNameNS((Node)dataVirtualHardDisksElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"SourceMediaLink")) != null) {
                                        URI sourceMediaLinkInstance = new URI(sourceMediaLinkElement.getTextContent());
                                        dataVirtualHardDiskInstance.setSourceMediaLink(sourceMediaLinkInstance);
                                    }
                                    if ((iOTypeElement = XmlUtility.getElementByTagNameNS((Node)dataVirtualHardDisksElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"IOType")) == null) continue;
                                    String iOTypeInstance = iOTypeElement.getTextContent();
                                    dataVirtualHardDiskInstance.setIOType(iOTypeInstance);
                                }
                            }
                            if ((labelElement2 = XmlUtility.getElementByTagNameNS((Node)roleListElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Label")) != null) {
                                String labelInstance2 = labelElement2.getTextContent();
                                roleInstance.setLabel(labelInstance2);
                            }
                            if ((oSVirtualHardDiskElement = XmlUtility.getElementByTagNameNS((Node)roleListElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"OSVirtualHardDisk")) != null) {
                                Element resizedSizeInGBElement;
                                Element iOTypeElement2;
                                Element remoteSourceImageLinkElement;
                                Element osElement;
                                Element sourceImageNameElement;
                                Element mediaLinkElement2;
                                Element diskNameElement2;
                                Element diskLabelElement2;
                                OSVirtualHardDisk oSVirtualHardDiskInstance = new OSVirtualHardDisk();
                                roleInstance.setOSVirtualHardDisk(oSVirtualHardDiskInstance);
                                Element hostCachingElement2 = XmlUtility.getElementByTagNameNS((Node)oSVirtualHardDiskElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"HostCaching");
                                if (hostCachingElement2 != null) {
                                    String hostCachingInstance2 = hostCachingElement2.getTextContent();
                                    oSVirtualHardDiskInstance.setHostCaching(hostCachingInstance2);
                                }
                                if ((diskLabelElement2 = XmlUtility.getElementByTagNameNS((Node)oSVirtualHardDiskElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"DiskLabel")) != null) {
                                    String diskLabelInstance2 = diskLabelElement2.getTextContent();
                                    oSVirtualHardDiskInstance.setLabel(diskLabelInstance2);
                                }
                                if ((diskNameElement2 = XmlUtility.getElementByTagNameNS((Node)oSVirtualHardDiskElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"DiskName")) != null) {
                                    String diskNameInstance2 = diskNameElement2.getTextContent();
                                    oSVirtualHardDiskInstance.setName(diskNameInstance2);
                                }
                                if ((mediaLinkElement2 = XmlUtility.getElementByTagNameNS((Node)oSVirtualHardDiskElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"MediaLink")) != null) {
                                    URI mediaLinkInstance2 = new URI(mediaLinkElement2.getTextContent());
                                    oSVirtualHardDiskInstance.setMediaLink(mediaLinkInstance2);
                                }
                                if ((sourceImageNameElement = XmlUtility.getElementByTagNameNS((Node)oSVirtualHardDiskElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"SourceImageName")) != null) {
                                    String sourceImageNameInstance = sourceImageNameElement.getTextContent();
                                    oSVirtualHardDiskInstance.setSourceImageName(sourceImageNameInstance);
                                }
                                if ((osElement = XmlUtility.getElementByTagNameNS((Node)oSVirtualHardDiskElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"OS")) != null) {
                                    String osInstance = osElement.getTextContent();
                                    oSVirtualHardDiskInstance.setOperatingSystem(osInstance);
                                }
                                if ((remoteSourceImageLinkElement = XmlUtility.getElementByTagNameNS((Node)oSVirtualHardDiskElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"RemoteSourceImageLink")) != null) {
                                    URI remoteSourceImageLinkInstance = new URI(remoteSourceImageLinkElement.getTextContent());
                                    oSVirtualHardDiskInstance.setRemoteSourceImageLink(remoteSourceImageLinkInstance);
                                }
                                if ((iOTypeElement2 = XmlUtility.getElementByTagNameNS((Node)oSVirtualHardDiskElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"IOType")) != null) {
                                    String iOTypeInstance2 = iOTypeElement2.getTextContent();
                                    oSVirtualHardDiskInstance.setIOType(iOTypeInstance2);
                                }
                                if ((resizedSizeInGBElement = XmlUtility.getElementByTagNameNS((Node)oSVirtualHardDiskElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ResizedSizeInGB")) != null && resizedSizeInGBElement.getTextContent() != null && !resizedSizeInGBElement.getTextContent().isEmpty()) {
                                    int resizedSizeInGBInstance = DatatypeConverter.parseInt((String)resizedSizeInGBElement.getTextContent());
                                    oSVirtualHardDiskInstance.setResizedSizeInGB(resizedSizeInGBInstance);
                                }
                            }
                            if ((roleSizeElement = XmlUtility.getElementByTagNameNS((Node)roleListElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"RoleSize")) != null) {
                                String roleSizeInstance = roleSizeElement.getTextContent();
                                roleInstance.setRoleSize(roleSizeInstance);
                            }
                            if ((defaultWinRmCertificateThumbprintElement = XmlUtility.getElementByTagNameNS((Node)roleListElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"DefaultWinRmCertificateThumbprint")) != null) {
                                String defaultWinRmCertificateThumbprintInstance = defaultWinRmCertificateThumbprintElement.getTextContent();
                                roleInstance.setDefaultWinRmCertificateThumbprint(defaultWinRmCertificateThumbprintInstance);
                            }
                            if ((provisionGuestAgentElement = XmlUtility.getElementByTagNameNS((Node)roleListElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ProvisionGuestAgent")) != null && provisionGuestAgentElement.getTextContent() != null && !provisionGuestAgentElement.getTextContent().isEmpty()) {
                                boolean provisionGuestAgentInstance = DatatypeConverter.parseBoolean((String)provisionGuestAgentElement.getTextContent().toLowerCase());
                                roleInstance.setProvisionGuestAgent(provisionGuestAgentInstance);
                            }
                            if ((vMImageInputElement = XmlUtility.getElementByTagNameNS((Node)roleListElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"VMImageInput")) == null) continue;
                            VMImageInput vMImageInputInstance = new VMImageInput();
                            roleInstance.setVMImageInput(vMImageInputInstance);
                            Element oSDiskConfigurationElement = XmlUtility.getElementByTagNameNS((Node)vMImageInputElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"OSDiskConfiguration");
                            if (oSDiskConfigurationElement != null) {
                                OSDiskConfiguration oSDiskConfigurationInstance = new OSDiskConfiguration();
                                vMImageInputInstance.setOSDiskConfiguration(oSDiskConfigurationInstance);
                                Element resizedSizeInGBElement2 = XmlUtility.getElementByTagNameNS((Node)oSDiskConfigurationElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ResizedSizeInGB");
                                if (resizedSizeInGBElement2 != null && resizedSizeInGBElement2.getTextContent() != null && !resizedSizeInGBElement2.getTextContent().isEmpty()) {
                                    int resizedSizeInGBInstance2 = DatatypeConverter.parseInt((String)resizedSizeInGBElement2.getTextContent());
                                    oSDiskConfigurationInstance.setResizedSizeInGB(resizedSizeInGBInstance2);
                                }
                            }
                            if ((dataDiskConfigurationsSequenceElement = XmlUtility.getElementByTagNameNS((Node)vMImageInputElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"DataDiskConfigurations")) == null) continue;
                            for (int i31 = 0; i31 < XmlUtility.getElementsByTagNameNS((Node)dataDiskConfigurationsSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"DataDiskConfiguration").size(); ++i31) {
                                Element resizedSizeInGBElement3;
                                Element dataDiskConfigurationsElement = (Element)XmlUtility.getElementsByTagNameNS((Node)dataDiskConfigurationsSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"DataDiskConfiguration").get(i31);
                                DataDiskConfiguration dataDiskConfigurationInstance = new DataDiskConfiguration();
                                vMImageInputInstance.getDataDiskConfigurations().add(dataDiskConfigurationInstance);
                                Element nameElement11 = XmlUtility.getElementByTagNameNS((Node)dataDiskConfigurationsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Name");
                                if (nameElement11 != null) {
                                    String nameInstance11 = nameElement11.getTextContent();
                                    dataDiskConfigurationInstance.setDiskName(nameInstance11);
                                }
                                if ((resizedSizeInGBElement3 = XmlUtility.getElementByTagNameNS((Node)dataDiskConfigurationsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ResizedSizeInGB")) == null || resizedSizeInGBElement3.getTextContent() == null || resizedSizeInGBElement3.getTextContent().isEmpty()) continue;
                                int resizedSizeInGBInstance3 = DatatypeConverter.parseInt((String)resizedSizeInGBElement3.getTextContent());
                                dataDiskConfigurationInstance.setResizedSizeInGB(resizedSizeInGBInstance3);
                            }
                        }
                    }
                    if ((sdkVersionElement = XmlUtility.getElementByTagNameNS((Node)deploymentElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"SdkVersion")) != null) {
                        String sdkVersionInstance = sdkVersionElement.getTextContent();
                        result.setSdkVersion(sdkVersionInstance);
                    }
                    if ((lockedElement = XmlUtility.getElementByTagNameNS((Node)deploymentElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Locked")) != null && lockedElement.getTextContent() != null && !lockedElement.getTextContent().isEmpty()) {
                        boolean lockedInstance = DatatypeConverter.parseBoolean((String)lockedElement.getTextContent().toLowerCase());
                        result.setLocked(lockedInstance);
                    }
                    if ((rollbackAllowedElement = XmlUtility.getElementByTagNameNS((Node)deploymentElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"RollbackAllowed")) != null && rollbackAllowedElement.getTextContent() != null && !rollbackAllowedElement.getTextContent().isEmpty()) {
                        boolean rollbackAllowedInstance = DatatypeConverter.parseBoolean((String)rollbackAllowedElement.getTextContent().toLowerCase());
                        result.setRollbackAllowed(rollbackAllowedInstance);
                    }
                    if ((virtualNetworkNameElement = XmlUtility.getElementByTagNameNS((Node)deploymentElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"VirtualNetworkName")) != null) {
                        String virtualNetworkNameInstance = virtualNetworkNameElement.getTextContent();
                        result.setVirtualNetworkName(virtualNetworkNameInstance);
                    }
                    if ((createdTimeElement = XmlUtility.getElementByTagNameNS((Node)deploymentElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"CreatedTime")) != null) {
                        Calendar createdTimeInstance = DatatypeConverter.parseDateTime((String)createdTimeElement.getTextContent());
                        result.setCreatedTime(createdTimeInstance);
                    }
                    if ((lastModifiedTimeElement = XmlUtility.getElementByTagNameNS((Node)deploymentElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"LastModifiedTime")) != null) {
                        Calendar lastModifiedTimeInstance = DatatypeConverter.parseDateTime((String)lastModifiedTimeElement.getTextContent());
                        result.setLastModifiedTime(lastModifiedTimeInstance);
                    }
                    if ((extendedPropertiesSequenceElement = XmlUtility.getElementByTagNameNS((Node)deploymentElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ExtendedProperties")) != null) {
                        for (int i32 = 0; i32 < XmlUtility.getElementsByTagNameNS((Node)extendedPropertiesSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ExtendedProperty").size(); ++i32) {
                            Element extendedPropertiesElement = (Element)XmlUtility.getElementsByTagNameNS((Node)extendedPropertiesSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ExtendedProperty").get(i32);
                            String extendedPropertiesKey = XmlUtility.getElementByTagNameNS((Node)extendedPropertiesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Name").getTextContent();
                            String extendedPropertiesValue = XmlUtility.getElementByTagNameNS((Node)extendedPropertiesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Value").getTextContent();
                            result.getExtendedProperties().put(extendedPropertiesKey, extendedPropertiesValue);
                        }
                    }
                    if ((dnsElement = XmlUtility.getElementByTagNameNS((Node)deploymentElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Dns")) != null) {
                        DnsSettings dnsInstance = new DnsSettings();
                        result.setDnsSettings(dnsInstance);
                        Element dnsServersSequenceElement = XmlUtility.getElementByTagNameNS((Node)dnsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"DnsServers");
                        if (dnsServersSequenceElement != null) {
                            for (int i33 = 0; i33 < XmlUtility.getElementsByTagNameNS((Node)dnsServersSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"DnsServer").size(); ++i33) {
                                Element addressElement3;
                                Element dnsServersElement = (Element)XmlUtility.getElementsByTagNameNS((Node)dnsServersSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"DnsServer").get(i33);
                                DnsServer dnsServerInstance = new DnsServer();
                                dnsInstance.getDnsServers().add(dnsServerInstance);
                                Element nameElement12 = XmlUtility.getElementByTagNameNS((Node)dnsServersElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Name");
                                if (nameElement12 != null) {
                                    String nameInstance12 = nameElement12.getTextContent();
                                    dnsServerInstance.setName(nameInstance12);
                                }
                                if ((addressElement3 = XmlUtility.getElementByTagNameNS((Node)dnsServersElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Address")) == null) continue;
                                InetAddress addressInstance3 = InetAddress.getByName(addressElement3.getTextContent());
                                dnsServerInstance.setAddress(addressInstance3);
                            }
                        }
                    }
                    if ((persistentVMDowntimeElement = XmlUtility.getElementByTagNameNS((Node)deploymentElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"PersistentVMDowntime")) != null) {
                        Element statusElement6;
                        Element endTimeElement;
                        PersistentVMDowntime persistentVMDowntimeInstance = new PersistentVMDowntime();
                        result.setPersistentVMDowntime(persistentVMDowntimeInstance);
                        Element startTimeElement = XmlUtility.getElementByTagNameNS((Node)persistentVMDowntimeElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"StartTime");
                        if (startTimeElement != null) {
                            Calendar startTimeInstance = DatatypeConverter.parseDateTime((String)startTimeElement.getTextContent());
                            persistentVMDowntimeInstance.setStartTime(startTimeInstance);
                        }
                        if ((endTimeElement = XmlUtility.getElementByTagNameNS((Node)persistentVMDowntimeElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"EndTime")) != null) {
                            Calendar endTimeInstance = DatatypeConverter.parseDateTime((String)endTimeElement.getTextContent());
                            persistentVMDowntimeInstance.setEndTime(endTimeInstance);
                        }
                        if ((statusElement6 = XmlUtility.getElementByTagNameNS((Node)persistentVMDowntimeElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Status")) != null) {
                            String statusInstance6 = statusElement6.getTextContent();
                            persistentVMDowntimeInstance.setStatus(statusInstance6);
                        }
                    }
                    if ((virtualIPsSequenceElement = XmlUtility.getElementByTagNameNS((Node)deploymentElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"VirtualIPs")) != null) {
                        for (int i34 = 0; i34 < XmlUtility.getElementsByTagNameNS((Node)virtualIPsSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"VirtualIP").size(); ++i34) {
                            Element reservedIPNameElement;
                            Element nameElement13;
                            Element isDnsProgrammedElement;
                            Element virtualIPsElement = (Element)XmlUtility.getElementsByTagNameNS((Node)virtualIPsSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"VirtualIP").get(i34);
                            VirtualIPAddress virtualIPInstance = new VirtualIPAddress();
                            result.getVirtualIPAddresses().add(virtualIPInstance);
                            Element addressElement4 = XmlUtility.getElementByTagNameNS((Node)virtualIPsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Address");
                            if (addressElement4 != null) {
                                InetAddress addressInstance4 = InetAddress.getByName(addressElement4.getTextContent());
                                virtualIPInstance.setAddress(addressInstance4);
                            }
                            if ((isDnsProgrammedElement = XmlUtility.getElementByTagNameNS((Node)virtualIPsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"IsDnsProgrammed")) != null && isDnsProgrammedElement.getTextContent() != null && !isDnsProgrammedElement.getTextContent().isEmpty()) {
                                boolean isDnsProgrammedInstance = DatatypeConverter.parseBoolean((String)isDnsProgrammedElement.getTextContent().toLowerCase());
                                virtualIPInstance.setIsDnsProgrammed(isDnsProgrammedInstance);
                            }
                            if ((nameElement13 = XmlUtility.getElementByTagNameNS((Node)virtualIPsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Name")) != null) {
                                String nameInstance13 = nameElement13.getTextContent();
                                virtualIPInstance.setName(nameInstance13);
                            }
                            if ((reservedIPNameElement = XmlUtility.getElementByTagNameNS((Node)virtualIPsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ReservedIPName")) == null) continue;
                            String reservedIPNameInstance = reservedIPNameElement.getTextContent();
                            virtualIPInstance.setReservedIPName(reservedIPNameInstance);
                        }
                    }
                    if ((extensionConfigurationElement = XmlUtility.getElementByTagNameNS((Node)deploymentElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ExtensionConfiguration")) != null) {
                        Element namedRolesSequenceElement;
                        ExtensionConfiguration extensionConfigurationInstance = new ExtensionConfiguration();
                        result.setExtensionConfiguration(extensionConfigurationInstance);
                        Element allRolesSequenceElement = XmlUtility.getElementByTagNameNS((Node)extensionConfigurationElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"AllRoles");
                        if (allRolesSequenceElement != null) {
                            for (int i35 = 0; i35 < XmlUtility.getElementsByTagNameNS((Node)allRolesSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Extension").size(); ++i35) {
                                Element allRolesElement = (Element)XmlUtility.getElementsByTagNameNS((Node)allRolesSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Extension").get(i35);
                                ExtensionConfiguration.Extension extensionInstance = new ExtensionConfiguration.Extension();
                                extensionConfigurationInstance.getAllRoles().add(extensionInstance);
                                Element idElement = XmlUtility.getElementByTagNameNS((Node)allRolesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Id");
                                if (idElement == null) continue;
                                String idInstance = idElement.getTextContent();
                                extensionInstance.setId(idInstance);
                            }
                        }
                        if ((namedRolesSequenceElement = XmlUtility.getElementByTagNameNS((Node)extensionConfigurationElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"NamedRoles")) != null) {
                            for (int i36 = 0; i36 < XmlUtility.getElementsByTagNameNS((Node)namedRolesSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Role").size(); ++i36) {
                                Element extensionsSequenceElement;
                                Element namedRolesElement = (Element)XmlUtility.getElementsByTagNameNS((Node)namedRolesSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Role").get(i36);
                                ExtensionConfiguration.NamedRole roleInstance2 = new ExtensionConfiguration.NamedRole();
                                extensionConfigurationInstance.getNamedRoles().add(roleInstance2);
                                Element roleNameElement3 = XmlUtility.getElementByTagNameNS((Node)namedRolesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"RoleName");
                                if (roleNameElement3 != null) {
                                    String roleNameInstance3 = roleNameElement3.getTextContent();
                                    roleInstance2.setRoleName(roleNameInstance3);
                                }
                                if ((extensionsSequenceElement = XmlUtility.getElementByTagNameNS((Node)namedRolesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Extensions")) == null) continue;
                                for (int i37 = 0; i37 < XmlUtility.getElementsByTagNameNS((Node)extensionsSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Extension").size(); ++i37) {
                                    Element extensionsElement = (Element)XmlUtility.getElementsByTagNameNS((Node)extensionsSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Extension").get(i37);
                                    ExtensionConfiguration.Extension extensionInstance2 = new ExtensionConfiguration.Extension();
                                    roleInstance2.getExtensions().add(extensionInstance2);
                                    Element idElement2 = XmlUtility.getElementByTagNameNS((Node)extensionsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Id");
                                    if (idElement2 == null) continue;
                                    String idInstance2 = idElement2.getTextContent();
                                    extensionInstance2.setId(idInstance2);
                                }
                            }
                        }
                    }
                    if ((reservedIPNameElement2 = XmlUtility.getElementByTagNameNS((Node)deploymentElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ReservedIPName")) != null) {
                        String reservedIPNameInstance2 = reservedIPNameElement2.getTextContent();
                        result.setReservedIPName(reservedIPNameInstance2);
                    }
                    if ((loadBalancersSequenceElement = XmlUtility.getElementByTagNameNS((Node)deploymentElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"LoadBalancers")) != null) {
                        for (int i38 = 0; i38 < XmlUtility.getElementsByTagNameNS((Node)loadBalancersSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"LoadBalancer").size(); ++i38) {
                            Element staticVirtualNetworkIPAddressElement3;
                            Element subnetNameElement3;
                            Element frontendIpConfigurationElement;
                            Element loadBalancersElement = (Element)XmlUtility.getElementsByTagNameNS((Node)loadBalancersSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"LoadBalancer").get(i38);
                            LoadBalancer loadBalancerInstance = new LoadBalancer();
                            result.getLoadBalancers().add(loadBalancerInstance);
                            Element nameElement14 = XmlUtility.getElementByTagNameNS((Node)loadBalancersElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Name");
                            if (nameElement14 != null) {
                                String nameInstance14 = nameElement14.getTextContent();
                                loadBalancerInstance.setName(nameInstance14);
                            }
                            if ((frontendIpConfigurationElement = XmlUtility.getElementByTagNameNS((Node)loadBalancersElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"FrontendIpConfiguration")) == null) continue;
                            FrontendIPConfiguration frontendIpConfigurationInstance = new FrontendIPConfiguration();
                            loadBalancerInstance.setFrontendIPConfiguration(frontendIpConfigurationInstance);
                            Element typeElement2 = XmlUtility.getElementByTagNameNS((Node)frontendIpConfigurationElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Type");
                            if (typeElement2 != null) {
                                String typeInstance2 = typeElement2.getTextContent();
                                frontendIpConfigurationInstance.setType(typeInstance2);
                            }
                            if ((subnetNameElement3 = XmlUtility.getElementByTagNameNS((Node)frontendIpConfigurationElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"SubnetName")) != null) {
                                String subnetNameInstance3 = subnetNameElement3.getTextContent();
                                frontendIpConfigurationInstance.setSubnetName(subnetNameInstance3);
                            }
                            if ((staticVirtualNetworkIPAddressElement3 = XmlUtility.getElementByTagNameNS((Node)frontendIpConfigurationElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"StaticVirtualNetworkIPAddress")) == null) continue;
                            InetAddress staticVirtualNetworkIPAddressInstance3 = InetAddress.getByName(staticVirtualNetworkIPAddressElement3.getTextContent());
                            frontendIpConfigurationInstance.setStaticVirtualNetworkIPAddress(staticVirtualNetworkIPAddressInstance3);
                        }
                    }
                }
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            DeploymentGetResponse deploymentGetResponse = result;
            return deploymentGetResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<OperationStatusResponse> getPackageByNameAsync(final String serviceName, final String deploymentName, final DeploymentGetPackageParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<OperationStatusResponse>(){

            @Override
            public OperationStatusResponse call() throws Exception {
                return DeploymentOperationsImpl.this.getPackageByName(serviceName, deploymentName, parameters);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationStatusResponse getPackageByName(String serviceName, String deploymentName, DeploymentGetPackageParameters parameters) throws InterruptedException, ExecutionException, ServiceException, IOException {
        ComputeManagementClient client2 = this.getClient();
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("serviceName", serviceName);
            tracingParameters.put("deploymentName", deploymentName);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"getPackageByNameAsync", tracingParameters);
        }
        try {
            if (shouldTrace) {
                client2 = (ComputeManagementClient)((ComputeManagementClient)this.getClient().withRequestFilterLast((ServiceRequestFilter)new ClientRequestTrackingHandler(invocationId))).withResponseFilterLast((ServiceResponseFilter)new ClientRequestTrackingHandler(invocationId));
            }
            OperationResponse response = client2.getDeploymentsOperations().beginGettingPackageByNameAsync(serviceName, deploymentName, parameters).get();
            OperationStatusResponse result = client2.getOperationStatusAsync(response.getRequestId()).get();
            int delayInSeconds = 30;
            if (client2.getLongRunningOperationInitialTimeout() >= 0) {
                delayInSeconds = client2.getLongRunningOperationInitialTimeout();
            }
            while (result.getStatus() != null && result.getStatus().equals((Object)OperationStatus.InProgress)) {
                Thread.sleep(delayInSeconds * 1000);
                result = client2.getOperationStatusAsync(response.getRequestId()).get();
                delayInSeconds = 30;
                if (client2.getLongRunningOperationRetryTimeout() < 0) continue;
                delayInSeconds = client2.getLongRunningOperationRetryTimeout();
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)result);
            }
            if (result.getStatus() != OperationStatus.Succeeded) {
                if (result.getError() != null) {
                    ServiceException ex = new ServiceException(result.getError().getCode() + " : " + result.getError().getMessage());
                    ex.setError(new CloudError());
                    ex.getError().setCode(result.getError().getCode());
                    ex.getError().setMessage(result.getError().getMessage());
                    if (shouldTrace) {
                        CloudTracing.error((String)invocationId, (Exception)ex);
                    }
                    throw ex;
                }
                ServiceException ex = new ServiceException("");
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            OperationStatusResponse operationStatusResponse = result;
            return operationStatusResponse;
        }
        finally {
            if (client2 != null && shouldTrace) {
                client2.close();
            }
        }
    }

    @Override
    public Future<OperationStatusResponse> getPackageBySlotAsync(final String serviceName, final DeploymentSlot deploymentSlot, final DeploymentGetPackageParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<OperationStatusResponse>(){

            @Override
            public OperationStatusResponse call() throws Exception {
                return DeploymentOperationsImpl.this.getPackageBySlot(serviceName, deploymentSlot, parameters);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationStatusResponse getPackageBySlot(String serviceName, DeploymentSlot deploymentSlot, DeploymentGetPackageParameters parameters) throws InterruptedException, ExecutionException, ServiceException, IOException {
        ComputeManagementClient client2 = this.getClient();
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("serviceName", serviceName);
            tracingParameters.put("deploymentSlot", (Object)deploymentSlot);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"getPackageBySlotAsync", tracingParameters);
        }
        try {
            if (shouldTrace) {
                client2 = (ComputeManagementClient)((ComputeManagementClient)this.getClient().withRequestFilterLast((ServiceRequestFilter)new ClientRequestTrackingHandler(invocationId))).withResponseFilterLast((ServiceResponseFilter)new ClientRequestTrackingHandler(invocationId));
            }
            OperationResponse response = client2.getDeploymentsOperations().beginGettingPackageBySlotAsync(serviceName, deploymentSlot, parameters).get();
            OperationStatusResponse result = client2.getOperationStatusAsync(response.getRequestId()).get();
            int delayInSeconds = 30;
            if (client2.getLongRunningOperationInitialTimeout() >= 0) {
                delayInSeconds = client2.getLongRunningOperationInitialTimeout();
            }
            while (result.getStatus() != null && result.getStatus().equals((Object)OperationStatus.InProgress)) {
                Thread.sleep(delayInSeconds * 1000);
                result = client2.getOperationStatusAsync(response.getRequestId()).get();
                delayInSeconds = 30;
                if (client2.getLongRunningOperationRetryTimeout() < 0) continue;
                delayInSeconds = client2.getLongRunningOperationRetryTimeout();
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)result);
            }
            if (result.getStatus() != OperationStatus.Succeeded) {
                if (result.getError() != null) {
                    ServiceException ex = new ServiceException(result.getError().getCode() + " : " + result.getError().getMessage());
                    ex.setError(new CloudError());
                    ex.getError().setCode(result.getError().getCode());
                    ex.getError().setMessage(result.getError().getMessage());
                    if (shouldTrace) {
                        CloudTracing.error((String)invocationId, (Exception)ex);
                    }
                    throw ex;
                }
                ServiceException ex = new ServiceException("");
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            OperationStatusResponse operationStatusResponse = result;
            return operationStatusResponse;
        }
        finally {
            if (client2 != null && shouldTrace) {
                client2.close();
            }
        }
    }

    @Override
    public Future<DeploymentEventListResponse> listEventsAsync(final String serviceName, final String deploymentName, final Calendar startTime, final Calendar endTime) {
        return this.getClient().getExecutorService().submit(new Callable<DeploymentEventListResponse>(){

            @Override
            public DeploymentEventListResponse call() throws Exception {
                return DeploymentOperationsImpl.this.listEvents(serviceName, deploymentName, startTime, endTime);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeploymentEventListResponse listEvents(String serviceName, String deploymentName, Calendar startTime, Calendar endTime) throws IOException, ServiceException, ParserConfigurationException, SAXException {
        String baseUrl;
        if (serviceName == null) {
            throw new NullPointerException("serviceName");
        }
        if (deploymentName == null) {
            throw new NullPointerException("deploymentName");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("serviceName", serviceName);
            tracingParameters.put("deploymentName", deploymentName);
            tracingParameters.put("startTime", startTime);
            tracingParameters.put("endTime", endTime);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"listEventsAsync", tracingParameters);
        }
        String url = "";
        url = url + "/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/services/hostedservices/";
        url = url + URLEncoder.encode(serviceName, "UTF-8");
        url = url + "/deployments/";
        url = url + URLEncoder.encode(deploymentName, "UTF-8");
        url = url + "/events";
        ArrayList<String> queryParameters = new ArrayList<String>();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSSSSS'Z'");
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        queryParameters.add("starttime=" + URLEncoder.encode(simpleDateFormat.format(startTime.getTime()), "UTF-8"));
        SimpleDateFormat simpleDateFormat2 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSSSSS'Z'");
        simpleDateFormat2.setTimeZone(TimeZone.getTimeZone("UTC"));
        queryParameters.add("endtime=" + URLEncoder.encode(simpleDateFormat2.format(endTime.getTime()), "UTF-8"));
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, (String)"&");
        }
        if ((baseUrl = this.getClient().getBaseUri().toString()).charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpGet httpRequest = new HttpGet(url);
        httpRequest.setHeader("x-ms-version", "2015-04-01");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            DeploymentEventListResponse result = null;
            if (statusCode == 200) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new DeploymentEventListResponse();
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                documentBuilderFactory.setNamespaceAware(true);
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                Document responseDoc = documentBuilder.parse((InputStream)new BOMInputStream(responseContent));
                Element deploymentEventCollectionElement = XmlUtility.getElementByTagNameNS((Node)responseDoc, (String)"http://schemas.microsoft.com/windowsazure", (String)"DeploymentEventCollection");
                if (deploymentEventCollectionElement != null) {
                    Element continuationTokenElement;
                    Element rebootEventsSequenceElement = XmlUtility.getElementByTagNameNS((Node)deploymentEventCollectionElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"RebootEvents");
                    if (rebootEventsSequenceElement != null) {
                        for (int i1 = 0; i1 < XmlUtility.getElementsByTagNameNS((Node)rebootEventsSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"RebootEvent").size(); ++i1) {
                            Element rebootStartTimeElement;
                            Element rebootReasonElement;
                            Element instanceNameElement;
                            Element rebootEventsElement = (Element)XmlUtility.getElementsByTagNameNS((Node)rebootEventsSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"RebootEvent").get(i1);
                            RebootEvent rebootEventInstance = new RebootEvent();
                            result.getDeploymentEvents().add(rebootEventInstance);
                            Element roleNameElement = XmlUtility.getElementByTagNameNS((Node)rebootEventsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"RoleName");
                            if (roleNameElement != null) {
                                String roleNameInstance = roleNameElement.getTextContent();
                                rebootEventInstance.setRoleName(roleNameInstance);
                            }
                            if ((instanceNameElement = XmlUtility.getElementByTagNameNS((Node)rebootEventsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"InstanceName")) != null) {
                                String instanceNameInstance = instanceNameElement.getTextContent();
                                rebootEventInstance.setInstanceName(instanceNameInstance);
                            }
                            if ((rebootReasonElement = XmlUtility.getElementByTagNameNS((Node)rebootEventsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"RebootReason")) != null) {
                                String rebootReasonInstance = rebootReasonElement.getTextContent();
                                rebootEventInstance.setRebootReason(rebootReasonInstance);
                            }
                            if ((rebootStartTimeElement = XmlUtility.getElementByTagNameNS((Node)rebootEventsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"RebootStartTime")) == null || rebootStartTimeElement.getTextContent() == null || rebootStartTimeElement.getTextContent().isEmpty()) continue;
                            Calendar rebootStartTimeInstance = DatatypeConverter.parseDateTime((String)rebootStartTimeElement.getTextContent());
                            rebootEventInstance.setRebootStartTime(rebootStartTimeInstance);
                        }
                    }
                    if ((continuationTokenElement = XmlUtility.getElementByTagNameNS((Node)deploymentEventCollectionElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ContinuationToken")) != null) {
                        String continuationTokenInstance = continuationTokenElement.getTextContent();
                        result.setContinuationToken(continuationTokenInstance);
                    }
                }
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            DeploymentEventListResponse deploymentEventListResponse = result;
            return deploymentEventListResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<DeploymentEventListResponse> listEventsBySlotAsync(final String serviceName, final DeploymentSlot deploymentSlot, final Calendar startTime, final Calendar endTime) {
        return this.getClient().getExecutorService().submit(new Callable<DeploymentEventListResponse>(){

            @Override
            public DeploymentEventListResponse call() throws Exception {
                return DeploymentOperationsImpl.this.listEventsBySlot(serviceName, deploymentSlot, startTime, endTime);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeploymentEventListResponse listEventsBySlot(String serviceName, DeploymentSlot deploymentSlot, Calendar startTime, Calendar endTime) throws IOException, ServiceException, ParserConfigurationException, SAXException {
        String baseUrl;
        if (serviceName == null) {
            throw new NullPointerException("serviceName");
        }
        if (deploymentSlot == null) {
            throw new NullPointerException("deploymentSlot");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("serviceName", serviceName);
            tracingParameters.put("deploymentSlot", (Object)deploymentSlot);
            tracingParameters.put("startTime", startTime);
            tracingParameters.put("endTime", endTime);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"listEventsBySlotAsync", tracingParameters);
        }
        String url = "";
        url = url + "/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/services/hostedservices/";
        url = url + URLEncoder.encode(serviceName, "UTF-8");
        url = url + "/deploymentslots/";
        url = url + URLEncoder.encode(deploymentSlot.toString(), "UTF-8");
        url = url + "/events";
        ArrayList<String> queryParameters = new ArrayList<String>();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSSSSS'Z'");
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        queryParameters.add("starttime=" + URLEncoder.encode(simpleDateFormat.format(startTime.getTime()), "UTF-8"));
        SimpleDateFormat simpleDateFormat2 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSSSSS'Z'");
        simpleDateFormat2.setTimeZone(TimeZone.getTimeZone("UTC"));
        queryParameters.add("endtime=" + URLEncoder.encode(simpleDateFormat2.format(endTime.getTime()), "UTF-8"));
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, (String)"&");
        }
        if ((baseUrl = this.getClient().getBaseUri().toString()).charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpGet httpRequest = new HttpGet(url);
        httpRequest.setHeader("x-ms-version", "2015-04-01");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            DeploymentEventListResponse result = null;
            if (statusCode == 200) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new DeploymentEventListResponse();
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                documentBuilderFactory.setNamespaceAware(true);
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                Document responseDoc = documentBuilder.parse((InputStream)new BOMInputStream(responseContent));
                Element deploymentEventCollectionElement = XmlUtility.getElementByTagNameNS((Node)responseDoc, (String)"http://schemas.microsoft.com/windowsazure", (String)"DeploymentEventCollection");
                if (deploymentEventCollectionElement != null) {
                    Element continuationTokenElement;
                    Element rebootEventsSequenceElement = XmlUtility.getElementByTagNameNS((Node)deploymentEventCollectionElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"RebootEvents");
                    if (rebootEventsSequenceElement != null) {
                        for (int i1 = 0; i1 < XmlUtility.getElementsByTagNameNS((Node)rebootEventsSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"RebootEvent").size(); ++i1) {
                            Element rebootStartTimeElement;
                            Element rebootReasonElement;
                            Element instanceNameElement;
                            Element rebootEventsElement = (Element)XmlUtility.getElementsByTagNameNS((Node)rebootEventsSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"RebootEvent").get(i1);
                            RebootEvent rebootEventInstance = new RebootEvent();
                            result.getDeploymentEvents().add(rebootEventInstance);
                            Element roleNameElement = XmlUtility.getElementByTagNameNS((Node)rebootEventsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"RoleName");
                            if (roleNameElement != null) {
                                String roleNameInstance = roleNameElement.getTextContent();
                                rebootEventInstance.setRoleName(roleNameInstance);
                            }
                            if ((instanceNameElement = XmlUtility.getElementByTagNameNS((Node)rebootEventsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"InstanceName")) != null) {
                                String instanceNameInstance = instanceNameElement.getTextContent();
                                rebootEventInstance.setInstanceName(instanceNameInstance);
                            }
                            if ((rebootReasonElement = XmlUtility.getElementByTagNameNS((Node)rebootEventsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"RebootReason")) != null) {
                                String rebootReasonInstance = rebootReasonElement.getTextContent();
                                rebootEventInstance.setRebootReason(rebootReasonInstance);
                            }
                            if ((rebootStartTimeElement = XmlUtility.getElementByTagNameNS((Node)rebootEventsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"RebootStartTime")) == null || rebootStartTimeElement.getTextContent() == null || rebootStartTimeElement.getTextContent().isEmpty()) continue;
                            Calendar rebootStartTimeInstance = DatatypeConverter.parseDateTime((String)rebootStartTimeElement.getTextContent());
                            rebootEventInstance.setRebootStartTime(rebootStartTimeInstance);
                        }
                    }
                    if ((continuationTokenElement = XmlUtility.getElementByTagNameNS((Node)deploymentEventCollectionElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ContinuationToken")) != null) {
                        String continuationTokenInstance = continuationTokenElement.getTextContent();
                        result.setContinuationToken(continuationTokenInstance);
                    }
                }
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            DeploymentEventListResponse deploymentEventListResponse = result;
            return deploymentEventListResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<OperationStatusResponse> rebootRoleInstanceByDeploymentNameAsync(final String serviceName, final String deploymentName, final String roleInstanceName) {
        return this.getClient().getExecutorService().submit(new Callable<OperationStatusResponse>(){

            @Override
            public OperationStatusResponse call() throws Exception {
                return DeploymentOperationsImpl.this.rebootRoleInstanceByDeploymentName(serviceName, deploymentName, roleInstanceName);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationStatusResponse rebootRoleInstanceByDeploymentName(String serviceName, String deploymentName, String roleInstanceName) throws InterruptedException, ExecutionException, ServiceException, IOException {
        ComputeManagementClient client2 = this.getClient();
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("serviceName", serviceName);
            tracingParameters.put("deploymentName", deploymentName);
            tracingParameters.put("roleInstanceName", roleInstanceName);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"rebootRoleInstanceByDeploymentNameAsync", tracingParameters);
        }
        try {
            if (shouldTrace) {
                client2 = (ComputeManagementClient)((ComputeManagementClient)this.getClient().withRequestFilterLast((ServiceRequestFilter)new ClientRequestTrackingHandler(invocationId))).withResponseFilterLast((ServiceResponseFilter)new ClientRequestTrackingHandler(invocationId));
            }
            OperationResponse response = client2.getDeploymentsOperations().beginRebootingRoleInstanceByDeploymentNameAsync(serviceName, deploymentName, roleInstanceName).get();
            OperationStatusResponse result = client2.getOperationStatusAsync(response.getRequestId()).get();
            int delayInSeconds = 30;
            if (client2.getLongRunningOperationInitialTimeout() >= 0) {
                delayInSeconds = client2.getLongRunningOperationInitialTimeout();
            }
            while (result.getStatus() != null && result.getStatus().equals((Object)OperationStatus.InProgress)) {
                Thread.sleep(delayInSeconds * 1000);
                result = client2.getOperationStatusAsync(response.getRequestId()).get();
                delayInSeconds = 30;
                if (client2.getLongRunningOperationRetryTimeout() < 0) continue;
                delayInSeconds = client2.getLongRunningOperationRetryTimeout();
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)result);
            }
            if (result.getStatus() != OperationStatus.Succeeded) {
                if (result.getError() != null) {
                    ServiceException ex = new ServiceException(result.getError().getCode() + " : " + result.getError().getMessage());
                    ex.setError(new CloudError());
                    ex.getError().setCode(result.getError().getCode());
                    ex.getError().setMessage(result.getError().getMessage());
                    if (shouldTrace) {
                        CloudTracing.error((String)invocationId, (Exception)ex);
                    }
                    throw ex;
                }
                ServiceException ex = new ServiceException("");
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            OperationStatusResponse operationStatusResponse = result;
            return operationStatusResponse;
        }
        finally {
            if (client2 != null && shouldTrace) {
                client2.close();
            }
        }
    }

    @Override
    public Future<OperationStatusResponse> rebootRoleInstanceByDeploymentSlotAsync(final String serviceName, final DeploymentSlot deploymentSlot, final String roleInstanceName) {
        return this.getClient().getExecutorService().submit(new Callable<OperationStatusResponse>(){

            @Override
            public OperationStatusResponse call() throws Exception {
                return DeploymentOperationsImpl.this.rebootRoleInstanceByDeploymentSlot(serviceName, deploymentSlot, roleInstanceName);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationStatusResponse rebootRoleInstanceByDeploymentSlot(String serviceName, DeploymentSlot deploymentSlot, String roleInstanceName) throws InterruptedException, ExecutionException, ServiceException, IOException {
        ComputeManagementClient client2 = this.getClient();
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("serviceName", serviceName);
            tracingParameters.put("deploymentSlot", (Object)deploymentSlot);
            tracingParameters.put("roleInstanceName", roleInstanceName);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"rebootRoleInstanceByDeploymentSlotAsync", tracingParameters);
        }
        try {
            if (shouldTrace) {
                client2 = (ComputeManagementClient)((ComputeManagementClient)this.getClient().withRequestFilterLast((ServiceRequestFilter)new ClientRequestTrackingHandler(invocationId))).withResponseFilterLast((ServiceResponseFilter)new ClientRequestTrackingHandler(invocationId));
            }
            OperationResponse response = client2.getDeploymentsOperations().beginRebootingRoleInstanceByDeploymentSlotAsync(serviceName, deploymentSlot, roleInstanceName).get();
            OperationStatusResponse result = client2.getOperationStatusAsync(response.getRequestId()).get();
            int delayInSeconds = 30;
            if (client2.getLongRunningOperationInitialTimeout() >= 0) {
                delayInSeconds = client2.getLongRunningOperationInitialTimeout();
            }
            while (result.getStatus() != null && result.getStatus().equals((Object)OperationStatus.InProgress)) {
                Thread.sleep(delayInSeconds * 1000);
                result = client2.getOperationStatusAsync(response.getRequestId()).get();
                delayInSeconds = 30;
                if (client2.getLongRunningOperationRetryTimeout() < 0) continue;
                delayInSeconds = client2.getLongRunningOperationRetryTimeout();
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)result);
            }
            if (result.getStatus() != OperationStatus.Succeeded) {
                if (result.getError() != null) {
                    ServiceException ex = new ServiceException(result.getError().getCode() + " : " + result.getError().getMessage());
                    ex.setError(new CloudError());
                    ex.getError().setCode(result.getError().getCode());
                    ex.getError().setMessage(result.getError().getMessage());
                    if (shouldTrace) {
                        CloudTracing.error((String)invocationId, (Exception)ex);
                    }
                    throw ex;
                }
                ServiceException ex = new ServiceException("");
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            OperationStatusResponse operationStatusResponse = result;
            return operationStatusResponse;
        }
        finally {
            if (client2 != null && shouldTrace) {
                client2.close();
            }
        }
    }

    @Override
    public Future<OperationStatusResponse> rebuildRoleInstanceByDeploymentNameAsync(final String serviceName, final String deploymentName, final String roleInstanceName, final String resources) {
        return this.getClient().getExecutorService().submit(new Callable<OperationStatusResponse>(){

            @Override
            public OperationStatusResponse call() throws Exception {
                return DeploymentOperationsImpl.this.rebuildRoleInstanceByDeploymentName(serviceName, deploymentName, roleInstanceName, resources);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationStatusResponse rebuildRoleInstanceByDeploymentName(String serviceName, String deploymentName, String roleInstanceName, String resources) throws InterruptedException, ExecutionException, ServiceException, IOException {
        ComputeManagementClient client2 = this.getClient();
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("serviceName", serviceName);
            tracingParameters.put("deploymentName", deploymentName);
            tracingParameters.put("roleInstanceName", roleInstanceName);
            tracingParameters.put("resources", resources);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"rebuildRoleInstanceByDeploymentNameAsync", tracingParameters);
        }
        try {
            if (shouldTrace) {
                client2 = (ComputeManagementClient)((ComputeManagementClient)this.getClient().withRequestFilterLast((ServiceRequestFilter)new ClientRequestTrackingHandler(invocationId))).withResponseFilterLast((ServiceResponseFilter)new ClientRequestTrackingHandler(invocationId));
            }
            OperationResponse response = client2.getDeploymentsOperations().beginRebuildingRoleInstanceByDeploymentNameAsync(serviceName, deploymentName, roleInstanceName, resources).get();
            OperationStatusResponse result = client2.getOperationStatusAsync(response.getRequestId()).get();
            int delayInSeconds = 30;
            if (client2.getLongRunningOperationInitialTimeout() >= 0) {
                delayInSeconds = client2.getLongRunningOperationInitialTimeout();
            }
            while (result.getStatus() != null && result.getStatus().equals((Object)OperationStatus.InProgress)) {
                Thread.sleep(delayInSeconds * 1000);
                result = client2.getOperationStatusAsync(response.getRequestId()).get();
                delayInSeconds = 30;
                if (client2.getLongRunningOperationRetryTimeout() < 0) continue;
                delayInSeconds = client2.getLongRunningOperationRetryTimeout();
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)result);
            }
            if (result.getStatus() != OperationStatus.Succeeded) {
                if (result.getError() != null) {
                    ServiceException ex = new ServiceException(result.getError().getCode() + " : " + result.getError().getMessage());
                    ex.setError(new CloudError());
                    ex.getError().setCode(result.getError().getCode());
                    ex.getError().setMessage(result.getError().getMessage());
                    if (shouldTrace) {
                        CloudTracing.error((String)invocationId, (Exception)ex);
                    }
                    throw ex;
                }
                ServiceException ex = new ServiceException("");
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            OperationStatusResponse operationStatusResponse = result;
            return operationStatusResponse;
        }
        finally {
            if (client2 != null && shouldTrace) {
                client2.close();
            }
        }
    }

    @Override
    public Future<OperationStatusResponse> rebuildRoleInstanceByDeploymentSlotAsync(final String serviceName, final String deploymentSlot, final String roleInstanceName, final String resources) {
        return this.getClient().getExecutorService().submit(new Callable<OperationStatusResponse>(){

            @Override
            public OperationStatusResponse call() throws Exception {
                return DeploymentOperationsImpl.this.rebuildRoleInstanceByDeploymentSlot(serviceName, deploymentSlot, roleInstanceName, resources);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationStatusResponse rebuildRoleInstanceByDeploymentSlot(String serviceName, String deploymentSlot, String roleInstanceName, String resources) throws InterruptedException, ExecutionException, ServiceException, IOException {
        ComputeManagementClient client2 = this.getClient();
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("serviceName", serviceName);
            tracingParameters.put("deploymentSlot", deploymentSlot);
            tracingParameters.put("roleInstanceName", roleInstanceName);
            tracingParameters.put("resources", resources);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"rebuildRoleInstanceByDeploymentSlotAsync", tracingParameters);
        }
        try {
            if (shouldTrace) {
                client2 = (ComputeManagementClient)((ComputeManagementClient)this.getClient().withRequestFilterLast((ServiceRequestFilter)new ClientRequestTrackingHandler(invocationId))).withResponseFilterLast((ServiceResponseFilter)new ClientRequestTrackingHandler(invocationId));
            }
            OperationResponse response = client2.getDeploymentsOperations().beginRebuildingRoleInstanceByDeploymentSlotAsync(serviceName, deploymentSlot, roleInstanceName, resources).get();
            OperationStatusResponse result = client2.getOperationStatusAsync(response.getRequestId()).get();
            int delayInSeconds = 30;
            if (client2.getLongRunningOperationInitialTimeout() >= 0) {
                delayInSeconds = client2.getLongRunningOperationInitialTimeout();
            }
            while (result.getStatus() != null && result.getStatus().equals((Object)OperationStatus.InProgress)) {
                Thread.sleep(delayInSeconds * 1000);
                result = client2.getOperationStatusAsync(response.getRequestId()).get();
                delayInSeconds = 30;
                if (client2.getLongRunningOperationRetryTimeout() < 0) continue;
                delayInSeconds = client2.getLongRunningOperationRetryTimeout();
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)result);
            }
            if (result.getStatus() != OperationStatus.Succeeded) {
                if (result.getError() != null) {
                    ServiceException ex = new ServiceException(result.getError().getCode() + " : " + result.getError().getMessage());
                    ex.setError(new CloudError());
                    ex.getError().setCode(result.getError().getCode());
                    ex.getError().setMessage(result.getError().getMessage());
                    if (shouldTrace) {
                        CloudTracing.error((String)invocationId, (Exception)ex);
                    }
                    throw ex;
                }
                ServiceException ex = new ServiceException("");
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            OperationStatusResponse operationStatusResponse = result;
            return operationStatusResponse;
        }
        finally {
            if (client2 != null && shouldTrace) {
                client2.close();
            }
        }
    }

    @Override
    public Future<OperationStatusResponse> reimageRoleInstanceByDeploymentNameAsync(final String serviceName, final String deploymentName, final String roleInstanceName) {
        return this.getClient().getExecutorService().submit(new Callable<OperationStatusResponse>(){

            @Override
            public OperationStatusResponse call() throws Exception {
                return DeploymentOperationsImpl.this.reimageRoleInstanceByDeploymentName(serviceName, deploymentName, roleInstanceName);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationStatusResponse reimageRoleInstanceByDeploymentName(String serviceName, String deploymentName, String roleInstanceName) throws InterruptedException, ExecutionException, ServiceException, IOException {
        ComputeManagementClient client2 = this.getClient();
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("serviceName", serviceName);
            tracingParameters.put("deploymentName", deploymentName);
            tracingParameters.put("roleInstanceName", roleInstanceName);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"reimageRoleInstanceByDeploymentNameAsync", tracingParameters);
        }
        try {
            if (shouldTrace) {
                client2 = (ComputeManagementClient)((ComputeManagementClient)this.getClient().withRequestFilterLast((ServiceRequestFilter)new ClientRequestTrackingHandler(invocationId))).withResponseFilterLast((ServiceResponseFilter)new ClientRequestTrackingHandler(invocationId));
            }
            OperationResponse response = client2.getDeploymentsOperations().beginReimagingRoleInstanceByDeploymentNameAsync(serviceName, deploymentName, roleInstanceName).get();
            OperationStatusResponse result = client2.getOperationStatusAsync(response.getRequestId()).get();
            int delayInSeconds = 30;
            if (client2.getLongRunningOperationInitialTimeout() >= 0) {
                delayInSeconds = client2.getLongRunningOperationInitialTimeout();
            }
            while (result.getStatus() != null && result.getStatus().equals((Object)OperationStatus.InProgress)) {
                Thread.sleep(delayInSeconds * 1000);
                result = client2.getOperationStatusAsync(response.getRequestId()).get();
                delayInSeconds = 30;
                if (client2.getLongRunningOperationRetryTimeout() < 0) continue;
                delayInSeconds = client2.getLongRunningOperationRetryTimeout();
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)result);
            }
            if (result.getStatus() != OperationStatus.Succeeded) {
                if (result.getError() != null) {
                    ServiceException ex = new ServiceException(result.getError().getCode() + " : " + result.getError().getMessage());
                    ex.setError(new CloudError());
                    ex.getError().setCode(result.getError().getCode());
                    ex.getError().setMessage(result.getError().getMessage());
                    if (shouldTrace) {
                        CloudTracing.error((String)invocationId, (Exception)ex);
                    }
                    throw ex;
                }
                ServiceException ex = new ServiceException("");
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            OperationStatusResponse operationStatusResponse = result;
            return operationStatusResponse;
        }
        finally {
            if (client2 != null && shouldTrace) {
                client2.close();
            }
        }
    }

    @Override
    public Future<OperationStatusResponse> reimageRoleInstanceByDeploymentSlotAsync(final String serviceName, final DeploymentSlot deploymentSlot, final String roleInstanceName) {
        return this.getClient().getExecutorService().submit(new Callable<OperationStatusResponse>(){

            @Override
            public OperationStatusResponse call() throws Exception {
                return DeploymentOperationsImpl.this.reimageRoleInstanceByDeploymentSlot(serviceName, deploymentSlot, roleInstanceName);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationStatusResponse reimageRoleInstanceByDeploymentSlot(String serviceName, DeploymentSlot deploymentSlot, String roleInstanceName) throws InterruptedException, ExecutionException, ServiceException, IOException {
        ComputeManagementClient client2 = this.getClient();
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("serviceName", serviceName);
            tracingParameters.put("deploymentSlot", (Object)deploymentSlot);
            tracingParameters.put("roleInstanceName", roleInstanceName);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"reimageRoleInstanceByDeploymentSlotAsync", tracingParameters);
        }
        try {
            if (shouldTrace) {
                client2 = (ComputeManagementClient)((ComputeManagementClient)this.getClient().withRequestFilterLast((ServiceRequestFilter)new ClientRequestTrackingHandler(invocationId))).withResponseFilterLast((ServiceResponseFilter)new ClientRequestTrackingHandler(invocationId));
            }
            OperationResponse response = client2.getDeploymentsOperations().beginReimagingRoleInstanceByDeploymentSlotAsync(serviceName, deploymentSlot, roleInstanceName).get();
            OperationStatusResponse result = client2.getOperationStatusAsync(response.getRequestId()).get();
            int delayInSeconds = 30;
            if (client2.getLongRunningOperationInitialTimeout() >= 0) {
                delayInSeconds = client2.getLongRunningOperationInitialTimeout();
            }
            while (result.getStatus() != null && result.getStatus().equals((Object)OperationStatus.InProgress)) {
                Thread.sleep(delayInSeconds * 1000);
                result = client2.getOperationStatusAsync(response.getRequestId()).get();
                delayInSeconds = 30;
                if (client2.getLongRunningOperationRetryTimeout() < 0) continue;
                delayInSeconds = client2.getLongRunningOperationRetryTimeout();
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)result);
            }
            if (result.getStatus() != OperationStatus.Succeeded) {
                if (result.getError() != null) {
                    ServiceException ex = new ServiceException(result.getError().getCode() + " : " + result.getError().getMessage());
                    ex.setError(new CloudError());
                    ex.getError().setCode(result.getError().getCode());
                    ex.getError().setMessage(result.getError().getMessage());
                    if (shouldTrace) {
                        CloudTracing.error((String)invocationId, (Exception)ex);
                    }
                    throw ex;
                }
                ServiceException ex = new ServiceException("");
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            OperationStatusResponse operationStatusResponse = result;
            return operationStatusResponse;
        }
        finally {
            if (client2 != null && shouldTrace) {
                client2.close();
            }
        }
    }

    @Override
    public Future<OperationResponse> rollbackUpdateOrUpgradeByDeploymentNameAsync(final String serviceName, final String deploymentName, final DeploymentRollbackUpdateOrUpgradeParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<OperationResponse>(){

            @Override
            public OperationResponse call() throws Exception {
                return DeploymentOperationsImpl.this.rollbackUpdateOrUpgradeByDeploymentName(serviceName, deploymentName, parameters);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResponse rollbackUpdateOrUpgradeByDeploymentName(String serviceName, String deploymentName, DeploymentRollbackUpdateOrUpgradeParameters parameters) throws ParserConfigurationException, SAXException, TransformerException, IOException, ServiceException {
        String baseUrl;
        if (serviceName == null) {
            throw new NullPointerException("serviceName");
        }
        if (deploymentName == null) {
            throw new NullPointerException("deploymentName");
        }
        if (parameters == null) {
            throw new NullPointerException("parameters");
        }
        if (parameters.getMode() == null) {
            throw new NullPointerException("parameters.Mode");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("serviceName", serviceName);
            tracingParameters.put("deploymentName", deploymentName);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"rollbackUpdateOrUpgradeByDeploymentNameAsync", tracingParameters);
        }
        String url = "";
        url = url + "/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/services/hostedservices/";
        url = url + URLEncoder.encode(serviceName, "UTF-8");
        url = url + "/deployments/";
        url = url + URLEncoder.encode(deploymentName, "UTF-8");
        url = url + "/";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("comp=rollback");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, (String)"&");
        }
        if ((baseUrl = this.getClient().getBaseUri().toString()).charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpPost httpRequest = new HttpPost(url);
        httpRequest.setHeader("Content-Type", "application/xml");
        httpRequest.setHeader("x-ms-version", "2015-04-01");
        String requestContent = null;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document requestDoc = documentBuilder.newDocument();
        Element rollbackUpdateOrUpgradeElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "RollbackUpdateOrUpgrade");
        requestDoc.appendChild(rollbackUpdateOrUpgradeElement);
        Element modeElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Mode");
        modeElement.appendChild(requestDoc.createTextNode(parameters.getMode().toString()));
        rollbackUpdateOrUpgradeElement.appendChild(modeElement);
        Element forceElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Force");
        forceElement.appendChild(requestDoc.createTextNode(Boolean.toString(parameters.isForce()).toLowerCase()));
        rollbackUpdateOrUpgradeElement.appendChild(forceElement);
        DOMSource domSource = new DOMSource(requestDoc);
        StringWriter stringWriter = new StringWriter();
        StreamResult streamResult = new StreamResult(stringWriter);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.transform(domSource, streamResult);
        requestContent = stringWriter.toString();
        StringEntity entity = new StringEntity(requestContent);
        httpRequest.setEntity((HttpEntity)entity);
        httpRequest.setHeader("Content-Type", "application/xml");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, (String)requestContent, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            OperationResponse result = null;
            result = new OperationResponse();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)result);
            }
            OperationResponse operationResponse = result;
            return operationResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<OperationResponse> rollbackUpdateOrUpgradeByDeploymentSlotAsync(final String serviceName, final DeploymentSlot deploymentSlot, final DeploymentRollbackUpdateOrUpgradeParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<OperationResponse>(){

            @Override
            public OperationResponse call() throws Exception {
                return DeploymentOperationsImpl.this.rollbackUpdateOrUpgradeByDeploymentSlot(serviceName, deploymentSlot, parameters);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResponse rollbackUpdateOrUpgradeByDeploymentSlot(String serviceName, DeploymentSlot deploymentSlot, DeploymentRollbackUpdateOrUpgradeParameters parameters) throws ParserConfigurationException, SAXException, TransformerException, IOException, ServiceException {
        String baseUrl;
        if (serviceName == null) {
            throw new NullPointerException("serviceName");
        }
        if (deploymentSlot == null) {
            throw new NullPointerException("deploymentSlot");
        }
        if (parameters == null) {
            throw new NullPointerException("parameters");
        }
        if (parameters.getMode() == null) {
            throw new NullPointerException("parameters.Mode");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("serviceName", serviceName);
            tracingParameters.put("deploymentSlot", (Object)deploymentSlot);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"rollbackUpdateOrUpgradeByDeploymentSlotAsync", tracingParameters);
        }
        String url = "";
        url = url + "/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/services/hostedservices/";
        url = url + URLEncoder.encode(serviceName, "UTF-8");
        url = url + "/deploymentslots/";
        url = url + URLEncoder.encode(deploymentSlot.toString(), "UTF-8");
        url = url + "/";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("comp=rollback");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, (String)"&");
        }
        if ((baseUrl = this.getClient().getBaseUri().toString()).charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpPost httpRequest = new HttpPost(url);
        httpRequest.setHeader("Content-Type", "application/xml");
        httpRequest.setHeader("x-ms-version", "2015-04-01");
        String requestContent = null;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document requestDoc = documentBuilder.newDocument();
        Element rollbackUpdateOrUpgradeElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "RollbackUpdateOrUpgrade");
        requestDoc.appendChild(rollbackUpdateOrUpgradeElement);
        Element modeElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Mode");
        modeElement.appendChild(requestDoc.createTextNode(parameters.getMode().toString()));
        rollbackUpdateOrUpgradeElement.appendChild(modeElement);
        Element forceElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Force");
        forceElement.appendChild(requestDoc.createTextNode(Boolean.toString(parameters.isForce()).toLowerCase()));
        rollbackUpdateOrUpgradeElement.appendChild(forceElement);
        DOMSource domSource = new DOMSource(requestDoc);
        StringWriter stringWriter = new StringWriter();
        StreamResult streamResult = new StreamResult(stringWriter);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.transform(domSource, streamResult);
        requestContent = stringWriter.toString();
        StringEntity entity = new StringEntity(requestContent);
        httpRequest.setEntity((HttpEntity)entity);
        httpRequest.setHeader("Content-Type", "application/xml");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 202) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, (String)requestContent, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            OperationResponse result = null;
            result = new OperationResponse();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)result);
            }
            OperationResponse operationResponse = result;
            return operationResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<OperationStatusResponse> swapAsync(final String serviceName, final DeploymentSwapParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<OperationStatusResponse>(){

            @Override
            public OperationStatusResponse call() throws Exception {
                return DeploymentOperationsImpl.this.swap(serviceName, parameters);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationStatusResponse swap(String serviceName, DeploymentSwapParameters parameters) throws InterruptedException, ExecutionException, ServiceException, IOException {
        ComputeManagementClient client2 = this.getClient();
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("serviceName", serviceName);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"swapAsync", tracingParameters);
        }
        try {
            if (shouldTrace) {
                client2 = (ComputeManagementClient)((ComputeManagementClient)this.getClient().withRequestFilterLast((ServiceRequestFilter)new ClientRequestTrackingHandler(invocationId))).withResponseFilterLast((ServiceResponseFilter)new ClientRequestTrackingHandler(invocationId));
            }
            OperationResponse response = client2.getDeploymentsOperations().beginSwappingAsync(serviceName, parameters).get();
            OperationStatusResponse result = client2.getOperationStatusAsync(response.getRequestId()).get();
            int delayInSeconds = 30;
            if (client2.getLongRunningOperationInitialTimeout() >= 0) {
                delayInSeconds = client2.getLongRunningOperationInitialTimeout();
            }
            while (result.getStatus() != null && result.getStatus().equals((Object)OperationStatus.InProgress)) {
                Thread.sleep(delayInSeconds * 1000);
                result = client2.getOperationStatusAsync(response.getRequestId()).get();
                delayInSeconds = 30;
                if (client2.getLongRunningOperationRetryTimeout() < 0) continue;
                delayInSeconds = client2.getLongRunningOperationRetryTimeout();
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)result);
            }
            if (result.getStatus() != OperationStatus.Succeeded) {
                if (result.getError() != null) {
                    ServiceException ex = new ServiceException(result.getError().getCode() + " : " + result.getError().getMessage());
                    ex.setError(new CloudError());
                    ex.getError().setCode(result.getError().getCode());
                    ex.getError().setMessage(result.getError().getMessage());
                    if (shouldTrace) {
                        CloudTracing.error((String)invocationId, (Exception)ex);
                    }
                    throw ex;
                }
                ServiceException ex = new ServiceException("");
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            OperationStatusResponse operationStatusResponse = result;
            return operationStatusResponse;
        }
        finally {
            if (client2 != null && shouldTrace) {
                client2.close();
            }
        }
    }

    @Override
    public Future<OperationStatusResponse> updateStatusByDeploymentNameAsync(final String serviceName, final String deploymentName, final DeploymentUpdateStatusParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<OperationStatusResponse>(){

            @Override
            public OperationStatusResponse call() throws Exception {
                return DeploymentOperationsImpl.this.updateStatusByDeploymentName(serviceName, deploymentName, parameters);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationStatusResponse updateStatusByDeploymentName(String serviceName, String deploymentName, DeploymentUpdateStatusParameters parameters) throws InterruptedException, ExecutionException, ServiceException, IOException {
        ComputeManagementClient client2 = this.getClient();
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("serviceName", serviceName);
            tracingParameters.put("deploymentName", deploymentName);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"updateStatusByDeploymentNameAsync", tracingParameters);
        }
        try {
            if (shouldTrace) {
                client2 = (ComputeManagementClient)((ComputeManagementClient)this.getClient().withRequestFilterLast((ServiceRequestFilter)new ClientRequestTrackingHandler(invocationId))).withResponseFilterLast((ServiceResponseFilter)new ClientRequestTrackingHandler(invocationId));
            }
            OperationResponse response = client2.getDeploymentsOperations().beginUpdatingStatusByDeploymentNameAsync(serviceName, deploymentName, parameters).get();
            OperationStatusResponse result = client2.getOperationStatusAsync(response.getRequestId()).get();
            int delayInSeconds = 30;
            if (client2.getLongRunningOperationInitialTimeout() >= 0) {
                delayInSeconds = client2.getLongRunningOperationInitialTimeout();
            }
            while (result.getStatus() != null && result.getStatus().equals((Object)OperationStatus.InProgress)) {
                Thread.sleep(delayInSeconds * 1000);
                result = client2.getOperationStatusAsync(response.getRequestId()).get();
                delayInSeconds = 30;
                if (client2.getLongRunningOperationRetryTimeout() < 0) continue;
                delayInSeconds = client2.getLongRunningOperationRetryTimeout();
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)result);
            }
            if (result.getStatus() != OperationStatus.Succeeded) {
                if (result.getError() != null) {
                    ServiceException ex = new ServiceException(result.getError().getCode() + " : " + result.getError().getMessage());
                    ex.setError(new CloudError());
                    ex.getError().setCode(result.getError().getCode());
                    ex.getError().setMessage(result.getError().getMessage());
                    if (shouldTrace) {
                        CloudTracing.error((String)invocationId, (Exception)ex);
                    }
                    throw ex;
                }
                ServiceException ex = new ServiceException("");
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            OperationStatusResponse operationStatusResponse = result;
            return operationStatusResponse;
        }
        finally {
            if (client2 != null && shouldTrace) {
                client2.close();
            }
        }
    }

    @Override
    public Future<OperationStatusResponse> updateStatusByDeploymentSlotAsync(final String serviceName, final DeploymentSlot deploymentSlot, final DeploymentUpdateStatusParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<OperationStatusResponse>(){

            @Override
            public OperationStatusResponse call() throws Exception {
                return DeploymentOperationsImpl.this.updateStatusByDeploymentSlot(serviceName, deploymentSlot, parameters);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationStatusResponse updateStatusByDeploymentSlot(String serviceName, DeploymentSlot deploymentSlot, DeploymentUpdateStatusParameters parameters) throws InterruptedException, ExecutionException, ServiceException, IOException {
        ComputeManagementClient client2 = this.getClient();
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("serviceName", serviceName);
            tracingParameters.put("deploymentSlot", (Object)deploymentSlot);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"updateStatusByDeploymentSlotAsync", tracingParameters);
        }
        try {
            if (shouldTrace) {
                client2 = (ComputeManagementClient)((ComputeManagementClient)this.getClient().withRequestFilterLast((ServiceRequestFilter)new ClientRequestTrackingHandler(invocationId))).withResponseFilterLast((ServiceResponseFilter)new ClientRequestTrackingHandler(invocationId));
            }
            OperationResponse response = client2.getDeploymentsOperations().beginUpdatingStatusByDeploymentSlotAsync(serviceName, deploymentSlot, parameters).get();
            OperationStatusResponse result = client2.getOperationStatusAsync(response.getRequestId()).get();
            int delayInSeconds = 30;
            if (client2.getLongRunningOperationInitialTimeout() >= 0) {
                delayInSeconds = client2.getLongRunningOperationInitialTimeout();
            }
            while (result.getStatus() != null && result.getStatus().equals((Object)OperationStatus.InProgress)) {
                Thread.sleep(delayInSeconds * 1000);
                result = client2.getOperationStatusAsync(response.getRequestId()).get();
                delayInSeconds = 30;
                if (client2.getLongRunningOperationRetryTimeout() < 0) continue;
                delayInSeconds = client2.getLongRunningOperationRetryTimeout();
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)result);
            }
            if (result.getStatus() != OperationStatus.Succeeded) {
                if (result.getError() != null) {
                    ServiceException ex = new ServiceException(result.getError().getCode() + " : " + result.getError().getMessage());
                    ex.setError(new CloudError());
                    ex.getError().setCode(result.getError().getCode());
                    ex.getError().setMessage(result.getError().getMessage());
                    if (shouldTrace) {
                        CloudTracing.error((String)invocationId, (Exception)ex);
                    }
                    throw ex;
                }
                ServiceException ex = new ServiceException("");
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            OperationStatusResponse operationStatusResponse = result;
            return operationStatusResponse;
        }
        finally {
            if (client2 != null && shouldTrace) {
                client2.close();
            }
        }
    }

    @Override
    public Future<OperationStatusResponse> upgradeByNameAsync(final String serviceName, final String deploymentName, final DeploymentUpgradeParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<OperationStatusResponse>(){

            @Override
            public OperationStatusResponse call() throws Exception {
                return DeploymentOperationsImpl.this.upgradeByName(serviceName, deploymentName, parameters);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationStatusResponse upgradeByName(String serviceName, String deploymentName, DeploymentUpgradeParameters parameters) throws InterruptedException, ExecutionException, ServiceException, IOException {
        ComputeManagementClient client2 = this.getClient();
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("serviceName", serviceName);
            tracingParameters.put("deploymentName", deploymentName);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"upgradeByNameAsync", tracingParameters);
        }
        try {
            if (shouldTrace) {
                client2 = (ComputeManagementClient)((ComputeManagementClient)this.getClient().withRequestFilterLast((ServiceRequestFilter)new ClientRequestTrackingHandler(invocationId))).withResponseFilterLast((ServiceResponseFilter)new ClientRequestTrackingHandler(invocationId));
            }
            OperationResponse response = client2.getDeploymentsOperations().beginUpgradingByNameAsync(serviceName, deploymentName, parameters).get();
            OperationStatusResponse result = client2.getOperationStatusAsync(response.getRequestId()).get();
            int delayInSeconds = 30;
            if (client2.getLongRunningOperationInitialTimeout() >= 0) {
                delayInSeconds = client2.getLongRunningOperationInitialTimeout();
            }
            while (result.getStatus() != null && result.getStatus().equals((Object)OperationStatus.InProgress)) {
                Thread.sleep(delayInSeconds * 1000);
                result = client2.getOperationStatusAsync(response.getRequestId()).get();
                delayInSeconds = 30;
                if (client2.getLongRunningOperationRetryTimeout() < 0) continue;
                delayInSeconds = client2.getLongRunningOperationRetryTimeout();
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)result);
            }
            if (result.getStatus() != OperationStatus.Succeeded) {
                if (result.getError() != null) {
                    ServiceException ex = new ServiceException(result.getError().getCode() + " : " + result.getError().getMessage());
                    ex.setError(new CloudError());
                    ex.getError().setCode(result.getError().getCode());
                    ex.getError().setMessage(result.getError().getMessage());
                    if (shouldTrace) {
                        CloudTracing.error((String)invocationId, (Exception)ex);
                    }
                    throw ex;
                }
                ServiceException ex = new ServiceException("");
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            OperationStatusResponse operationStatusResponse = result;
            return operationStatusResponse;
        }
        finally {
            if (client2 != null && shouldTrace) {
                client2.close();
            }
        }
    }

    @Override
    public Future<OperationStatusResponse> upgradeBySlotAsync(final String serviceName, final DeploymentSlot deploymentSlot, final DeploymentUpgradeParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<OperationStatusResponse>(){

            @Override
            public OperationStatusResponse call() throws Exception {
                return DeploymentOperationsImpl.this.upgradeBySlot(serviceName, deploymentSlot, parameters);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationStatusResponse upgradeBySlot(String serviceName, DeploymentSlot deploymentSlot, DeploymentUpgradeParameters parameters) throws InterruptedException, ExecutionException, ServiceException, IOException {
        ComputeManagementClient client2 = this.getClient();
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("serviceName", serviceName);
            tracingParameters.put("deploymentSlot", (Object)deploymentSlot);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"upgradeBySlotAsync", tracingParameters);
        }
        try {
            if (shouldTrace) {
                client2 = (ComputeManagementClient)((ComputeManagementClient)this.getClient().withRequestFilterLast((ServiceRequestFilter)new ClientRequestTrackingHandler(invocationId))).withResponseFilterLast((ServiceResponseFilter)new ClientRequestTrackingHandler(invocationId));
            }
            OperationResponse response = client2.getDeploymentsOperations().beginUpgradingBySlotAsync(serviceName, deploymentSlot, parameters).get();
            OperationStatusResponse result = client2.getOperationStatusAsync(response.getRequestId()).get();
            int delayInSeconds = 30;
            if (client2.getLongRunningOperationInitialTimeout() >= 0) {
                delayInSeconds = client2.getLongRunningOperationInitialTimeout();
            }
            while (result.getStatus() != null && result.getStatus().equals((Object)OperationStatus.InProgress)) {
                Thread.sleep(delayInSeconds * 1000);
                result = client2.getOperationStatusAsync(response.getRequestId()).get();
                delayInSeconds = 30;
                if (client2.getLongRunningOperationRetryTimeout() < 0) continue;
                delayInSeconds = client2.getLongRunningOperationRetryTimeout();
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)result);
            }
            if (result.getStatus() != OperationStatus.Succeeded) {
                if (result.getError() != null) {
                    ServiceException ex = new ServiceException(result.getError().getCode() + " : " + result.getError().getMessage());
                    ex.setError(new CloudError());
                    ex.getError().setCode(result.getError().getCode());
                    ex.getError().setMessage(result.getError().getMessage());
                    if (shouldTrace) {
                        CloudTracing.error((String)invocationId, (Exception)ex);
                    }
                    throw ex;
                }
                ServiceException ex = new ServiceException("");
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            OperationStatusResponse operationStatusResponse = result;
            return operationStatusResponse;
        }
        finally {
            if (client2 != null && shouldTrace) {
                client2.close();
            }
        }
    }

    @Override
    public Future<OperationStatusResponse> walkUpgradeDomainByDeploymentNameAsync(final String serviceName, final String deploymentName, final DeploymentWalkUpgradeDomainParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<OperationStatusResponse>(){

            @Override
            public OperationStatusResponse call() throws Exception {
                return DeploymentOperationsImpl.this.walkUpgradeDomainByDeploymentName(serviceName, deploymentName, parameters);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationStatusResponse walkUpgradeDomainByDeploymentName(String serviceName, String deploymentName, DeploymentWalkUpgradeDomainParameters parameters) throws InterruptedException, ExecutionException, ServiceException, IOException {
        ComputeManagementClient client2 = this.getClient();
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("serviceName", serviceName);
            tracingParameters.put("deploymentName", deploymentName);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"walkUpgradeDomainByDeploymentNameAsync", tracingParameters);
        }
        try {
            if (shouldTrace) {
                client2 = (ComputeManagementClient)((ComputeManagementClient)this.getClient().withRequestFilterLast((ServiceRequestFilter)new ClientRequestTrackingHandler(invocationId))).withResponseFilterLast((ServiceResponseFilter)new ClientRequestTrackingHandler(invocationId));
            }
            OperationResponse response = client2.getDeploymentsOperations().beginWalkingUpgradeDomainByDeploymentNameAsync(serviceName, deploymentName, parameters).get();
            OperationStatusResponse result = client2.getOperationStatusAsync(response.getRequestId()).get();
            int delayInSeconds = 30;
            if (client2.getLongRunningOperationInitialTimeout() >= 0) {
                delayInSeconds = client2.getLongRunningOperationInitialTimeout();
            }
            while (result.getStatus() != null && result.getStatus().equals((Object)OperationStatus.InProgress)) {
                Thread.sleep(delayInSeconds * 1000);
                result = client2.getOperationStatusAsync(response.getRequestId()).get();
                delayInSeconds = 30;
                if (client2.getLongRunningOperationRetryTimeout() < 0) continue;
                delayInSeconds = client2.getLongRunningOperationRetryTimeout();
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)result);
            }
            if (result.getStatus() != OperationStatus.Succeeded) {
                if (result.getError() != null) {
                    ServiceException ex = new ServiceException(result.getError().getCode() + " : " + result.getError().getMessage());
                    ex.setError(new CloudError());
                    ex.getError().setCode(result.getError().getCode());
                    ex.getError().setMessage(result.getError().getMessage());
                    if (shouldTrace) {
                        CloudTracing.error((String)invocationId, (Exception)ex);
                    }
                    throw ex;
                }
                ServiceException ex = new ServiceException("");
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            OperationStatusResponse operationStatusResponse = result;
            return operationStatusResponse;
        }
        finally {
            if (client2 != null && shouldTrace) {
                client2.close();
            }
        }
    }

    @Override
    public Future<OperationStatusResponse> walkUpgradeDomainByDeploymentSlotAsync(final String serviceName, final DeploymentSlot deploymentSlot, final DeploymentWalkUpgradeDomainParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<OperationStatusResponse>(){

            @Override
            public OperationStatusResponse call() throws Exception {
                return DeploymentOperationsImpl.this.walkUpgradeDomainByDeploymentSlot(serviceName, deploymentSlot, parameters);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationStatusResponse walkUpgradeDomainByDeploymentSlot(String serviceName, DeploymentSlot deploymentSlot, DeploymentWalkUpgradeDomainParameters parameters) throws InterruptedException, ExecutionException, ServiceException, IOException {
        ComputeManagementClient client2 = this.getClient();
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("serviceName", serviceName);
            tracingParameters.put("deploymentSlot", (Object)deploymentSlot);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"walkUpgradeDomainByDeploymentSlotAsync", tracingParameters);
        }
        try {
            if (shouldTrace) {
                client2 = (ComputeManagementClient)((ComputeManagementClient)this.getClient().withRequestFilterLast((ServiceRequestFilter)new ClientRequestTrackingHandler(invocationId))).withResponseFilterLast((ServiceResponseFilter)new ClientRequestTrackingHandler(invocationId));
            }
            OperationResponse response = client2.getDeploymentsOperations().beginWalkingUpgradeDomainByDeploymentSlotAsync(serviceName, deploymentSlot, parameters).get();
            OperationStatusResponse result = client2.getOperationStatusAsync(response.getRequestId()).get();
            int delayInSeconds = 30;
            if (client2.getLongRunningOperationInitialTimeout() >= 0) {
                delayInSeconds = client2.getLongRunningOperationInitialTimeout();
            }
            while (result.getStatus() != null && result.getStatus().equals((Object)OperationStatus.InProgress)) {
                Thread.sleep(delayInSeconds * 1000);
                result = client2.getOperationStatusAsync(response.getRequestId()).get();
                delayInSeconds = 30;
                if (client2.getLongRunningOperationRetryTimeout() < 0) continue;
                delayInSeconds = client2.getLongRunningOperationRetryTimeout();
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)result);
            }
            if (result.getStatus() != OperationStatus.Succeeded) {
                if (result.getError() != null) {
                    ServiceException ex = new ServiceException(result.getError().getCode() + " : " + result.getError().getMessage());
                    ex.setError(new CloudError());
                    ex.getError().setCode(result.getError().getCode());
                    ex.getError().setMessage(result.getError().getMessage());
                    if (shouldTrace) {
                        CloudTracing.error((String)invocationId, (Exception)ex);
                    }
                    throw ex;
                }
                ServiceException ex = new ServiceException("");
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            OperationStatusResponse operationStatusResponse = result;
            return operationStatusResponse;
        }
        finally {
            if (client2 != null && shouldTrace) {
                client2.close();
            }
        }
    }
}

