/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum AllocationStrategy {
    LOWEST_PRICE("lowestPrice"),
    DIVERSIFIED("diversified"),
    CAPACITY_OPTIMIZED("capacityOptimized"),
    CAPACITY_OPTIMIZED_PRIORITIZED("capacityOptimizedPrioritized"),
    PRICE_CAPACITY_OPTIMIZED("priceCapacityOptimized"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, AllocationStrategy> VALUE_MAP;
    private final String value;

    private AllocationStrategy(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AllocationStrategy fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AllocationStrategy> knownValues() {
        EnumSet<AllocationStrategy> knownValues = EnumSet.allOf(AllocationStrategy.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(AllocationStrategy.class, AllocationStrategy::toString);
    }
}

