/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.ServiceDetail;
import software.amazon.awssdk.services.ec2.model.ServiceDetailSetCopier;
import software.amazon.awssdk.services.ec2.model.ValueStringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeVpcEndpointServicesResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, DescribeVpcEndpointServicesResponse> {
    private static final SdkField<List<String>> SERVICE_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ServiceNames").getter(DescribeVpcEndpointServicesResponse.getter(DescribeVpcEndpointServicesResponse::serviceNames)).setter(DescribeVpcEndpointServicesResponse.setter(Builder::serviceNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceNameSet").unmarshallLocationName("serviceNameSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<List<ServiceDetail>> SERVICE_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ServiceDetails").getter(DescribeVpcEndpointServicesResponse.getter(DescribeVpcEndpointServicesResponse::serviceDetails)).setter(DescribeVpcEndpointServicesResponse.setter(Builder::serviceDetails)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceDetailSet").unmarshallLocationName("serviceDetailSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ServiceDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeVpcEndpointServicesResponse.getter(DescribeVpcEndpointServicesResponse::nextToken)).setter(DescribeVpcEndpointServicesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").unmarshallLocationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_NAMES_FIELD, SERVICE_DETAILS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeVpcEndpointServicesResponse.memberNameToFieldInitializer();
    private final List<String> serviceNames;
    private final List<ServiceDetail> serviceDetails;
    private final String nextToken;

    private DescribeVpcEndpointServicesResponse(BuilderImpl builder) {
        super(builder);
        this.serviceNames = builder.serviceNames;
        this.serviceDetails = builder.serviceDetails;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasServiceNames() {
        return this.serviceNames != null && !(this.serviceNames instanceof SdkAutoConstructList);
    }

    public final List<String> serviceNames() {
        return this.serviceNames;
    }

    public final boolean hasServiceDetails() {
        return this.serviceDetails != null && !(this.serviceDetails instanceof SdkAutoConstructList);
    }

    public final List<ServiceDetail> serviceDetails() {
        return this.serviceDetails;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasServiceNames() ? this.serviceNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasServiceDetails() ? this.serviceDetails() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeVpcEndpointServicesResponse)) {
            return false;
        }
        DescribeVpcEndpointServicesResponse other = (DescribeVpcEndpointServicesResponse)((Object)obj);
        return this.hasServiceNames() == other.hasServiceNames() && Objects.equals(this.serviceNames(), other.serviceNames()) && this.hasServiceDetails() == other.hasServiceDetails() && Objects.equals(this.serviceDetails(), other.serviceDetails()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeVpcEndpointServicesResponse").add("ServiceNames", this.hasServiceNames() ? this.serviceNames() : null).add("ServiceDetails", this.hasServiceDetails() ? this.serviceDetails() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ServiceNames": {
                return Optional.ofNullable(clazz.cast(this.serviceNames()));
            }
            case "ServiceDetails": {
                return Optional.ofNullable(clazz.cast(this.serviceDetails()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ServiceNameSet", SERVICE_NAMES_FIELD);
        map.put("ServiceDetailSet", SERVICE_DETAILS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeVpcEndpointServicesResponse, T> g) {
        return obj -> g.apply((DescribeVpcEndpointServicesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private List<String> serviceNames = DefaultSdkAutoConstructList.getInstance();
        private List<ServiceDetail> serviceDetails = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeVpcEndpointServicesResponse model) {
            super(model);
            this.serviceNames(model.serviceNames);
            this.serviceDetails(model.serviceDetails);
            this.nextToken(model.nextToken);
        }

        public final Collection<String> getServiceNames() {
            if (this.serviceNames instanceof SdkAutoConstructList) {
                return null;
            }
            return this.serviceNames;
        }

        public final void setServiceNames(Collection<String> serviceNames) {
            this.serviceNames = ValueStringListCopier.copy(serviceNames);
        }

        @Override
        public final Builder serviceNames(Collection<String> serviceNames) {
            this.serviceNames = ValueStringListCopier.copy(serviceNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceNames(String ... serviceNames) {
            this.serviceNames(Arrays.asList(serviceNames));
            return this;
        }

        public final List<ServiceDetail.Builder> getServiceDetails() {
            List<ServiceDetail.Builder> result = ServiceDetailSetCopier.copyToBuilder(this.serviceDetails);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setServiceDetails(Collection<ServiceDetail.BuilderImpl> serviceDetails) {
            this.serviceDetails = ServiceDetailSetCopier.copyFromBuilder(serviceDetails);
        }

        @Override
        public final Builder serviceDetails(Collection<ServiceDetail> serviceDetails) {
            this.serviceDetails = ServiceDetailSetCopier.copy(serviceDetails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceDetails(ServiceDetail ... serviceDetails) {
            this.serviceDetails(Arrays.asList(serviceDetails));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceDetails(Consumer<ServiceDetail.Builder> ... serviceDetails) {
            this.serviceDetails(Stream.of(serviceDetails).map(c -> (ServiceDetail)((ServiceDetail.Builder)ServiceDetail.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeVpcEndpointServicesResponse build() {
            return new DescribeVpcEndpointServicesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeVpcEndpointServicesResponse> {
        public Builder serviceNames(Collection<String> var1);

        public Builder serviceNames(String ... var1);

        public Builder serviceDetails(Collection<ServiceDetail> var1);

        public Builder serviceDetails(ServiceDetail ... var1);

        public Builder serviceDetails(Consumer<ServiceDetail.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

