/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.AsnAuthorizationContext;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ProvisionIpamByoasnRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, ProvisionIpamByoasnRequest> {
    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DryRun").getter(ProvisionIpamByoasnRequest.getter(ProvisionIpamByoasnRequest::dryRun)).setter(ProvisionIpamByoasnRequest.setter(Builder::dryRun)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun").unmarshallLocationName("DryRun").build()}).build();
    private static final SdkField<String> IPAM_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IpamId").getter(ProvisionIpamByoasnRequest.getter(ProvisionIpamByoasnRequest::ipamId)).setter(ProvisionIpamByoasnRequest.setter(Builder::ipamId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpamId").unmarshallLocationName("IpamId").build()}).build();
    private static final SdkField<String> ASN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Asn").getter(ProvisionIpamByoasnRequest.getter(ProvisionIpamByoasnRequest::asn)).setter(ProvisionIpamByoasnRequest.setter(Builder::asn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Asn").unmarshallLocationName("Asn").build()}).build();
    private static final SdkField<AsnAuthorizationContext> ASN_AUTHORIZATION_CONTEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AsnAuthorizationContext").getter(ProvisionIpamByoasnRequest.getter(ProvisionIpamByoasnRequest::asnAuthorizationContext)).setter(ProvisionIpamByoasnRequest.setter(Builder::asnAuthorizationContext)).constructor(AsnAuthorizationContext::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AsnAuthorizationContext").unmarshallLocationName("AsnAuthorizationContext").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DRY_RUN_FIELD, IPAM_ID_FIELD, ASN_FIELD, ASN_AUTHORIZATION_CONTEXT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ProvisionIpamByoasnRequest.memberNameToFieldInitializer();
    private final Boolean dryRun;
    private final String ipamId;
    private final String asn;
    private final AsnAuthorizationContext asnAuthorizationContext;

    private ProvisionIpamByoasnRequest(BuilderImpl builder) {
        super(builder);
        this.dryRun = builder.dryRun;
        this.ipamId = builder.ipamId;
        this.asn = builder.asn;
        this.asnAuthorizationContext = builder.asnAuthorizationContext;
    }

    public final Boolean dryRun() {
        return this.dryRun;
    }

    public final String ipamId() {
        return this.ipamId;
    }

    public final String asn() {
        return this.asn;
    }

    public final AsnAuthorizationContext asnAuthorizationContext() {
        return this.asnAuthorizationContext;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.dryRun());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipamId());
        hashCode = 31 * hashCode + Objects.hashCode(this.asn());
        hashCode = 31 * hashCode + Objects.hashCode(this.asnAuthorizationContext());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProvisionIpamByoasnRequest)) {
            return false;
        }
        ProvisionIpamByoasnRequest other = (ProvisionIpamByoasnRequest)((Object)obj);
        return Objects.equals(this.dryRun(), other.dryRun()) && Objects.equals(this.ipamId(), other.ipamId()) && Objects.equals(this.asn(), other.asn()) && Objects.equals(this.asnAuthorizationContext(), other.asnAuthorizationContext());
    }

    public final String toString() {
        return ToString.builder((String)"ProvisionIpamByoasnRequest").add("DryRun", (Object)this.dryRun()).add("IpamId", (Object)this.ipamId()).add("Asn", (Object)this.asn()).add("AsnAuthorizationContext", (Object)this.asnAuthorizationContext()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DryRun": {
                return Optional.ofNullable(clazz.cast(this.dryRun()));
            }
            case "IpamId": {
                return Optional.ofNullable(clazz.cast(this.ipamId()));
            }
            case "Asn": {
                return Optional.ofNullable(clazz.cast(this.asn()));
            }
            case "AsnAuthorizationContext": {
                return Optional.ofNullable(clazz.cast(this.asnAuthorizationContext()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DryRun", DRY_RUN_FIELD);
        map.put("IpamId", IPAM_ID_FIELD);
        map.put("Asn", ASN_FIELD);
        map.put("AsnAuthorizationContext", ASN_AUTHORIZATION_CONTEXT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ProvisionIpamByoasnRequest, T> g) {
        return obj -> g.apply((ProvisionIpamByoasnRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private Boolean dryRun;
        private String ipamId;
        private String asn;
        private AsnAuthorizationContext asnAuthorizationContext;

        private BuilderImpl() {
        }

        private BuilderImpl(ProvisionIpamByoasnRequest model) {
            super(model);
            this.dryRun(model.dryRun);
            this.ipamId(model.ipamId);
            this.asn(model.asn);
            this.asnAuthorizationContext(model.asnAuthorizationContext);
        }

        public final Boolean getDryRun() {
            return this.dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final String getIpamId() {
            return this.ipamId;
        }

        public final void setIpamId(String ipamId) {
            this.ipamId = ipamId;
        }

        @Override
        public final Builder ipamId(String ipamId) {
            this.ipamId = ipamId;
            return this;
        }

        public final String getAsn() {
            return this.asn;
        }

        public final void setAsn(String asn) {
            this.asn = asn;
        }

        @Override
        public final Builder asn(String asn) {
            this.asn = asn;
            return this;
        }

        public final AsnAuthorizationContext.Builder getAsnAuthorizationContext() {
            return this.asnAuthorizationContext != null ? this.asnAuthorizationContext.toBuilder() : null;
        }

        public final void setAsnAuthorizationContext(AsnAuthorizationContext.BuilderImpl asnAuthorizationContext) {
            this.asnAuthorizationContext = asnAuthorizationContext != null ? asnAuthorizationContext.build() : null;
        }

        @Override
        public final Builder asnAuthorizationContext(AsnAuthorizationContext asnAuthorizationContext) {
            this.asnAuthorizationContext = asnAuthorizationContext;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ProvisionIpamByoasnRequest build() {
            return new ProvisionIpamByoasnRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ProvisionIpamByoasnRequest> {
        public Builder dryRun(Boolean var1);

        public Builder ipamId(String var1);

        public Builder asn(String var1);

        public Builder asnAuthorizationContext(AsnAuthorizationContext var1);

        default public Builder asnAuthorizationContext(Consumer<AsnAuthorizationContext.Builder> asnAuthorizationContext) {
            return this.asnAuthorizationContext((AsnAuthorizationContext)((AsnAuthorizationContext.Builder)AsnAuthorizationContext.builder().applyMutation(asnAuthorizationContext)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

