/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2Client;
import software.amazon.awssdk.services.ec2.internal.UserAgentUtils;
import software.amazon.awssdk.services.ec2.model.GetTransitGatewayPolicyTableAssociationsRequest;
import software.amazon.awssdk.services.ec2.model.GetTransitGatewayPolicyTableAssociationsResponse;
import software.amazon.awssdk.services.ec2.model.TransitGatewayPolicyTableAssociation;

public class GetTransitGatewayPolicyTableAssociationsIterable
implements SdkIterable<GetTransitGatewayPolicyTableAssociationsResponse> {
    private final Ec2Client client;
    private final GetTransitGatewayPolicyTableAssociationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetTransitGatewayPolicyTableAssociationsIterable(Ec2Client client, GetTransitGatewayPolicyTableAssociationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new GetTransitGatewayPolicyTableAssociationsResponseFetcher();
    }

    public Iterator<GetTransitGatewayPolicyTableAssociationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<TransitGatewayPolicyTableAssociation> associations() {
        Function<GetTransitGatewayPolicyTableAssociationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.associations() != null) {
                return response.associations().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class GetTransitGatewayPolicyTableAssociationsResponseFetcher
    implements SyncPageFetcher<GetTransitGatewayPolicyTableAssociationsResponse> {
        private GetTransitGatewayPolicyTableAssociationsResponseFetcher() {
        }

        public boolean hasNextPage(GetTransitGatewayPolicyTableAssociationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public GetTransitGatewayPolicyTableAssociationsResponse nextPage(GetTransitGatewayPolicyTableAssociationsResponse previousPage) {
            if (previousPage == null) {
                return GetTransitGatewayPolicyTableAssociationsIterable.this.client.getTransitGatewayPolicyTableAssociations(GetTransitGatewayPolicyTableAssociationsIterable.this.firstRequest);
            }
            return GetTransitGatewayPolicyTableAssociationsIterable.this.client.getTransitGatewayPolicyTableAssociations((GetTransitGatewayPolicyTableAssociationsRequest)((Object)GetTransitGatewayPolicyTableAssociationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

