/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2Client;
import software.amazon.awssdk.services.ec2.internal.UserAgentUtils;
import software.amazon.awssdk.services.ec2.model.DescribeInstanceImageMetadataRequest;
import software.amazon.awssdk.services.ec2.model.DescribeInstanceImageMetadataResponse;
import software.amazon.awssdk.services.ec2.model.InstanceImageMetadata;

public class DescribeInstanceImageMetadataIterable
implements SdkIterable<DescribeInstanceImageMetadataResponse> {
    private final Ec2Client client;
    private final DescribeInstanceImageMetadataRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeInstanceImageMetadataIterable(Ec2Client client, DescribeInstanceImageMetadataRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeInstanceImageMetadataResponseFetcher();
    }

    public Iterator<DescribeInstanceImageMetadataResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<InstanceImageMetadata> instanceImageMetadata() {
        Function<DescribeInstanceImageMetadataResponse, Iterator> getIterator = response -> {
            if (response != null && response.instanceImageMetadata() != null) {
                return response.instanceImageMetadata().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeInstanceImageMetadataResponseFetcher
    implements SyncPageFetcher<DescribeInstanceImageMetadataResponse> {
        private DescribeInstanceImageMetadataResponseFetcher() {
        }

        public boolean hasNextPage(DescribeInstanceImageMetadataResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeInstanceImageMetadataResponse nextPage(DescribeInstanceImageMetadataResponse previousPage) {
            if (previousPage == null) {
                return DescribeInstanceImageMetadataIterable.this.client.describeInstanceImageMetadata(DescribeInstanceImageMetadataIterable.this.firstRequest);
            }
            return DescribeInstanceImageMetadataIterable.this.client.describeInstanceImageMetadata((DescribeInstanceImageMetadataRequest)((Object)DescribeInstanceImageMetadataIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

