/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.geo.search.aggregations.bucket.geogrid.cells;

import java.io.IOException;
import java.util.List;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedNumericDocValues;
import org.opensearch.common.geo.GeoBoundingBox;
import org.opensearch.common.geo.GeoShapeDocValue;
import org.opensearch.geo.search.aggregations.bucket.geogrid.cells.GeoShapeCellValues;
import org.opensearch.index.fielddata.SortedBinaryDocValues;
import org.opensearch.index.fielddata.SortedNumericDoubleValues;
import org.opensearch.search.aggregations.support.ValuesSource;

public class GeoShapeCellIdSource
extends ValuesSource.Numeric {
    private final ValuesSource.GeoShape geoShape;
    private final int precision;
    private final GeoBoundingBox geoBoundingBox;
    private final GeoShapeLongEncoder encoder;

    public GeoShapeCellIdSource(ValuesSource.GeoShape geoShape, int precision, GeoBoundingBox geoBoundingBox, GeoShapeLongEncoder encoder) {
        this.geoShape = geoShape;
        this.geoBoundingBox = geoBoundingBox;
        this.precision = precision;
        this.encoder = encoder;
    }

    public SortedBinaryDocValues bytesValues(LeafReaderContext context) throws IOException {
        throw new UnsupportedOperationException("The bytesValues operation is not supported on GeoShapeCellIdSource");
    }

    public boolean isFloatingPoint() {
        return false;
    }

    public boolean isBigInteger() {
        return false;
    }

    public SortedNumericDocValues longValues(LeafReaderContext context) {
        if (this.geoBoundingBox.isUnbounded()) {
            return new GeoShapeCellValues.UnboundedCellValues(this.geoShape.getGeoShapeValues(context), this.precision, this.encoder);
        }
        return new GeoShapeCellValues.BoundedCellValues(this.geoShape.getGeoShapeValues(context), this.precision, this.encoder, this.geoBoundingBox);
    }

    public SortedNumericDoubleValues doubleValues(LeafReaderContext context) {
        throw new UnsupportedOperationException("The doubleValues operation is not supported on GeoShapeCellIdSource");
    }

    @FunctionalInterface
    public static interface GeoShapeLongEncoder {
        public List<Long> encode(GeoShapeDocValue var1, int var2);
    }
}

