/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.geo.search.aggregations.bucket.geogrid.cells;

import java.io.IOException;
import java.util.List;
import org.opensearch.common.geo.GeoBoundingBox;
import org.opensearch.common.geo.GeoShapeDocValue;
import org.opensearch.geo.search.aggregations.bucket.geogrid.cells.GeoShapeCellIdSource;
import org.opensearch.geometry.Rectangle;
import org.opensearch.index.fielddata.AbstractSortingNumericDocValues;
import org.opensearch.index.fielddata.GeoShapeValue;

abstract class GeoShapeCellValues
extends AbstractSortingNumericDocValues {
    private final GeoShapeValue geoShapeValue;
    protected int precision;
    protected final GeoShapeCellIdSource.GeoShapeLongEncoder encoder;

    public GeoShapeCellValues(GeoShapeValue geoShapeValue, int precision, GeoShapeCellIdSource.GeoShapeLongEncoder encoder) {
        this.geoShapeValue = geoShapeValue;
        this.precision = precision;
        this.encoder = encoder;
    }

    public boolean advanceExact(int docId) throws IOException {
        if (this.geoShapeValue.advanceExact(docId)) {
            GeoShapeDocValue geoShapeDocValue = this.geoShapeValue.nextValue();
            this.relateShape(geoShapeDocValue);
            this.sort();
            return true;
        }
        return false;
    }

    abstract void relateShape(GeoShapeDocValue var1);

    static class UnboundedCellValues
    extends GeoShapeCellValues {
        public UnboundedCellValues(GeoShapeValue geoShapeValue, int precision, GeoShapeCellIdSource.GeoShapeLongEncoder encoder) {
            super(geoShapeValue, precision, encoder);
        }

        @Override
        void relateShape(GeoShapeDocValue geoShapeDocValue) {
            List<Long> encodedValues = this.encoder.encode(geoShapeDocValue, this.precision);
            this.resize(encodedValues.size());
            for (int i = 0; i < encodedValues.size(); ++i) {
                this.values[i] = encodedValues.get(i);
            }
        }
    }

    static class BoundedCellValues
    extends GeoShapeCellValues {
        private final Rectangle geoBoundingBox;

        public BoundedCellValues(GeoShapeValue geoShapeValue, int precision, GeoShapeCellIdSource.GeoShapeLongEncoder encoder, GeoBoundingBox boundingBox) {
            super(geoShapeValue, precision, encoder);
            this.geoBoundingBox = new Rectangle(boundingBox.left(), boundingBox.right(), boundingBox.top(), boundingBox.bottom());
        }

        @Override
        void relateShape(GeoShapeDocValue geoShapeDocValue) {
            if (geoShapeDocValue.isIntersectingRectangle(this.geoBoundingBox)) {
                List<Long> encodedValues = this.encoder.encode(geoShapeDocValue, this.precision);
                this.resize(encodedValues.size());
                for (int i = 0; i < encodedValues.size(); ++i) {
                    this.values[i] = encodedValues.get(i);
                }
            } else {
                this.resize(0);
            }
        }
    }
}

