/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft.onenote;

import java.util.HashMap;
import java.util.Map;

public enum OneNotePropertyEnum {
    LayoutTightLayout(134224896L),
    PageWidth(335551489L),
    PageHeight(335551490L),
    OutlineElementChildLevel(201333763L),
    Bold(134224900L),
    Italic(134224901L),
    Underline(134224902L),
    Strikethrough(134224903L),
    Superscript(134224904L),
    Subscript(134224905L),
    Font(469769226L),
    FontSize(268442635L),
    FontColor(335551500L),
    Highlight(335551501L),
    RgOutlineIndentDistance(469769234L),
    BodyTextAlignment(201333779L),
    OffsetFromParentHoriz(335551508L),
    OffsetFromParentVert(335551509L),
    NumberListFormat(469769242L),
    LayoutMaxWidth(335551515L),
    LayoutMaxHeight(335551516L),
    ContentChildNodesOfOutlineElement(603986975L),
    ContentChildNodesOfPageManifest(603986975L),
    ElementChildNodesOfSection(603986976L),
    ElementChildNodesOfPage(603986976L),
    ElementChildNodesOfTitle(603986976L),
    ElementChildNodesOfOutline(603986976L),
    ElementChildNodesOfOutlineElement(603986976L),
    ElementChildNodesOfTable(603986976L),
    ElementChildNodesOfTableRow(603986976L),
    ElementChildNodesOfTableCell(603986976L),
    ElementChildNodesOfVersionHistory(603986976L),
    EnableHistory(134225438L),
    RichEditTextUnicode(469769250L),
    ListNodes(603986982L),
    NotebookManagementEntityGuid(469769264L),
    OutlineElementRTL(134224948L),
    LanguageID(335551547L),
    LayoutAlignmentInParent(335551550L),
    PictureContainer(536878143L),
    PageMarginTop(335551564L),
    PageMarginBottom(335551565L),
    PageMarginLeft(335551566L),
    PageMarginRight(335551567L),
    ListFont(469769298L),
    TopologyCreationTimeStamp(402660453L),
    LayoutAlignmentSelf(335551620L),
    IsTitleTime(134225031L),
    IsBoilerText(134225032L),
    PageSize(335551627L),
    PortraitPage(134225038L),
    EnforceOutlineStructure(134225041L),
    EditRootRTL(134225042L),
    CannotBeSelected(134225074L),
    IsTitleText(134225076L),
    IsTitleDate(134225077L),
    ListRestart(335551671L),
    IsLayoutSizeSetByUser(134225085L),
    ListSpacingMu(335551691L),
    LayoutOutlineReservedWidth(335551707L),
    LayoutResolveChildCollisions(134225116L),
    IsReadOnly(134225118L),
    LayoutMinimumOutlineWidth(335551724L),
    LayoutCollisionPriority(335551729L),
    CachedTitleString(469769459L),
    DescendantsCannotBeMoved(134225145L),
    RichEditTextLangID(268442878L),
    LayoutTightAlignment(134225151L),
    Charset(201334017L),
    CreationTimeStamp(335551753L),
    Deletable(134225164L),
    ListMSAAIndex(268442894L),
    IsBackground(134225171L),
    IRecordMedia(335551780L),
    CachedTitleStringFromPage(469769532L),
    RowCount(335551831L),
    ColumnCount(335551832L),
    TableBordersVisible(134225246L),
    StructureElementChildNodes(603987295L),
    ChildGraphSpaceElementNodes(738205027L),
    TableColumnWidths(469769574L),
    Author(469769589L),
    LastModifiedTimeStamp(402660727L),
    AuthorOriginal(536878456L),
    AuthorMostRecent(536878457L),
    LastModifiedTime(335551866L),
    IsConflictPage(134225276L),
    TableColumnsLocked(469769597L),
    SchemaRevisionInOrderToRead(335551874L),
    IsConflictObjectForRender(134225302L),
    EmbeddedFileContainer(536878491L),
    EmbeddedFileName(469769628L),
    SourceFilepath(469769629L),
    ConflictingUserName(469769630L),
    ImageFilename(469769687L),
    IsConflictObjectForSelection(134225371L),
    PageLevel(335551999L),
    TextRunIndex(469769746L),
    TextRunFormatting(603987475L),
    Hyperlink(134225428L),
    UnderlineType(201334293L),
    Hidden(134225430L),
    HyperlinkProtected(134225433L),
    TextRunIsEmbeddedObject(134225442L),
    ImageAltText(469769816L),
    MathFormatting(134231041L),
    ParagraphStyle(536884268L),
    ParagraphSpaceBefore(335557678L),
    ParagraphSpaceAfter(335557679L),
    ParagraphLineSpacingExact(335557680L),
    MetaDataObjectsAboveGraphSpace(603993154L),
    TextRunDataObject(603993176L),
    TextRunData(1073755289L),
    ParagraphStyleId(469775450L),
    HasVersionPages(134231138L),
    ActionItemType(268448867L),
    NoteTagShape(268448868L),
    NoteTagHighlightColor(335557733L),
    NoteTagTextColor(335557734L),
    NoteTagPropertyStatus(335557735L),
    NoteTagLabel(469775464L),
    NoteTagCreated(335557742L),
    NoteTagCompleted(335557743L),
    NoteTagDefinitionOid(536884360L),
    NoteTagStates(67122313L),
    ActionItemStatus(268448880L),
    ActionItemSchemaVersion(201340019L),
    ReadingOrderRTL(134231158L),
    ParagraphAlignment(201340023L),
    VersionHistoryGraphSpaceContextNodes(872428667L),
    DisplayedPageNumber(335557760L),
    SectionDisplayName(469775515L),
    NextStyle(469775498L),
    WebPictureContainer14(536884424L),
    ImageUploadState(335557835L),
    TextExtendedAscii(469775512L),
    PictureWidth(335557837L),
    PictureHeight(335557838L),
    PageMarginOriginX(335551759L),
    PageMarginOriginY(335551760L),
    WzHyperlinkUrl(469769760L),
    TaskTagDueDate(335557739L),
    NotebookElementOrderingID(335551673L),
    Unknown(0L);

    private static final Map<Long, OneNotePropertyEnum> BY_ID;
    private final long id;

    private OneNotePropertyEnum(long id) {
        this.id = id;
    }

    public static OneNotePropertyEnum of(Long id) {
        OneNotePropertyEnum result = BY_ID.get(id);
        if (result == null) {
            return Unknown;
        }
        return result;
    }

    public static long getType(OneNotePropertyEnum propertyEnum) {
        long pid = propertyEnum.id;
        long id = pid & 0x3FFFFFFL;
        return pid >> 26 & 0x1FL;
    }

    public static boolean getInlineBool(OneNotePropertyEnum propertyEnum) {
        long pid = propertyEnum.id;
        long id = pid & 0x3FFFFFFL;
        long type = pid >> 26 & 0x1FL;
        boolean inlineBool = false;
        if (type == 2L) {
            inlineBool = (pid >> 31 & 1L) > 0L;
        } else if ((pid >> 31 & 1L) > 0L) {
            throw new IllegalArgumentException("Reserved non-zero");
        }
        return inlineBool;
    }

    static {
        BY_ID = new HashMap<Long, OneNotePropertyEnum>();
        for (OneNotePropertyEnum e : OneNotePropertyEnum.values()) {
            BY_ID.put(e.id, e);
        }
    }
}

