/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.dbf;

import java.util.Arrays;
import org.apache.tika.parser.dbf.DBFCell;
import org.apache.tika.parser.dbf.DBFColumnHeader;
import org.apache.tika.parser.dbf.DBFFileHeader;

class DBFRow {
    DBFCell[] cells;
    private boolean isDeleted = false;

    DBFRow(DBFFileHeader header) {
        this.cells = new DBFCell[header.getCols().length];
        for (int i = 0; i < this.cells.length; ++i) {
            DBFColumnHeader columnHeader = header.getCols()[i];
            this.cells[i] = new DBFCell(columnHeader.getColType(), columnHeader.fieldLength, columnHeader.decimalCount);
        }
    }

    private DBFRow() {
    }

    boolean isDeleted() {
        return this.isDeleted;
    }

    void setDeleted(boolean deleted) {
        this.isDeleted = deleted;
    }

    DBFRow deepCopy() {
        DBFRow row = new DBFRow();
        row.isDeleted = this.isDeleted;
        row.cells = new DBFCell[this.cells.length];
        for (int i = 0; i < this.cells.length; ++i) {
            row.cells[i] = this.cells[i].deepCopy();
        }
        return row;
    }

    public String toString() {
        return "DBFRow{cells=" + Arrays.toString(this.cells) + '}';
    }
}

