/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index.engine.faiss;

import com.google.common.collect.ImmutableSet;
import java.util.Objects;
import java.util.Set;
import org.opensearch.common.TriFunction;
import org.opensearch.knn.common.KNNConstants;
import org.opensearch.knn.index.VectorDataType;
import org.opensearch.knn.index.engine.Encoder;
import org.opensearch.knn.index.engine.KNNLibraryIndexingContext;
import org.opensearch.knn.index.engine.KNNMethodConfigContext;
import org.opensearch.knn.index.engine.MethodComponent;
import org.opensearch.knn.index.engine.MethodComponentContext;
import org.opensearch.knn.index.engine.Parameter;
import org.opensearch.knn.index.engine.faiss.MethodAsMapBuilder;
import org.opensearch.knn.index.mapper.CompressionLevel;

public class FaissSQEncoder
implements Encoder {
    private static final Set<VectorDataType> SUPPORTED_DATA_TYPES = ImmutableSet.of((Object)((Object)VectorDataType.FLOAT));
    private static final MethodComponent METHOD_COMPONENT = MethodComponent.Builder.builder("sq").addSupportedDataTypes(SUPPORTED_DATA_TYPES).addParameter("type", new Parameter.StringParameter("type", "fp16", (v, context) -> KNNConstants.FAISS_SQ_ENCODER_TYPES.contains(v))).addParameter("clip", new Parameter.BooleanParameter("clip", false, (v, context) -> Objects.nonNull(v))).setKnnLibraryIndexingContextGenerator((TriFunction<MethodComponent, MethodComponentContext, KNNMethodConfigContext, KNNLibraryIndexingContext>)((TriFunction)(methodComponent, methodComponentContext, knnMethodConfigContext) -> MethodAsMapBuilder.builder("SQ", methodComponent, methodComponentContext, knnMethodConfigContext).addParameter("type", "", "").build())).build();

    @Override
    public MethodComponent getMethodComponent() {
        return METHOD_COMPONENT;
    }

    @Override
    public CompressionLevel calculateCompressionLevel(MethodComponentContext methodComponentContext, KNNMethodConfigContext knnMethodConfigContext) {
        return CompressionLevel.x2;
    }
}

