/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index.engine.lucene;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.lucene.util.Version;
import org.opensearch.knn.index.SpaceType;
import org.opensearch.knn.index.engine.JVMLibrary;
import org.opensearch.knn.index.engine.KNNMethod;
import org.opensearch.knn.index.engine.KNNMethodConfigContext;
import org.opensearch.knn.index.engine.KNNMethodContext;
import org.opensearch.knn.index.engine.MethodResolver;
import org.opensearch.knn.index.engine.ResolvedMethodContext;
import org.opensearch.knn.index.engine.lucene.LuceneHNSWMethod;
import org.opensearch.knn.index.engine.lucene.LuceneMethodResolver;

public class Lucene
extends JVMLibrary {
    Map<SpaceType, Function<Float, Float>> distanceTransform;
    static final Map<String, KNNMethod> METHODS = ImmutableMap.of((Object)"hnsw", (Object)new LuceneHNSWMethod());
    private static final Map<SpaceType, Function<Float, Float>> DISTANCE_TRANSLATIONS = ImmutableMap.builder().put((Object)SpaceType.COSINESIMIL, distance -> Float.valueOf((2.0f - distance.floatValue()) / 2.0f)).put((Object)SpaceType.INNER_PRODUCT, distance -> Float.valueOf(distance.floatValue() <= 0.0f ? 1.0f / (1.0f - distance.floatValue()) : distance.floatValue() + 1.0f)).build();
    public static final Lucene INSTANCE = new Lucene(METHODS, Version.LATEST.toString(), DISTANCE_TRANSLATIONS);
    private final MethodResolver methodResolver;

    Lucene(Map<String, KNNMethod> methods, String version, Map<SpaceType, Function<Float, Float>> distanceTransform) {
        super(methods, version);
        this.distanceTransform = distanceTransform;
        this.methodResolver = new LuceneMethodResolver();
    }

    @Override
    public String getExtension() {
        throw new UnsupportedOperationException("Getting extension for Lucene is not supported");
    }

    @Override
    public String getCompoundExtension() {
        throw new UnsupportedOperationException("Getting compound extension for Lucene is not supported");
    }

    @Override
    public float score(float rawScore, SpaceType spaceType) {
        return rawScore;
    }

    @Override
    public Float distanceToRadialThreshold(Float distance, SpaceType spaceType) {
        if (this.distanceTransform.containsKey((Object)spaceType)) {
            return this.distanceTransform.get((Object)spaceType).apply(distance);
        }
        return Float.valueOf(spaceType.scoreTranslation(distance.floatValue()));
    }

    @Override
    public Float scoreToRadialThreshold(Float score, SpaceType spaceType) {
        return score;
    }

    @Override
    public List<String> mmapFileExtensions() {
        return List.of("vec", "vex");
    }

    @Override
    public ResolvedMethodContext resolveMethod(KNNMethodContext knnMethodContext, KNNMethodConfigContext knnMethodConfigContext, boolean shouldRequireTraining, SpaceType spaceType) {
        return this.methodResolver.resolveMethod(knnMethodContext, knnMethodConfigContext, shouldRequireTraining, spaceType);
    }
}

