/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index.util;

import lombok.Generated;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.Version;
import org.opensearch.knn.index.KNNSettings;

public class IndexHyperParametersUtil {
    @Generated
    private static final Logger log = LogManager.getLogger(IndexHyperParametersUtil.class);
    private static final int INDEX_KNN_DEFAULT_ALGO_PARAM_EF_CONSTRUCTION_OLD_VALUE = 512;
    private static final int INDEX_KNN_DEFAULT_ALGO_PARAM_EF_SEARCH_OLD_VALUE = 512;
    private static final int INDEX_BINARY_QUANTIZATION_KNN_DEFAULT_ALGO_PARAM_EF_CONSTRUCTION = 256;
    private static final int INDEX_BINARY_QUANTIZATION_KNN_DEFAULT_ALGO_PARAM_EF_SEARCH = 256;

    public static int getHNSWEFConstructionValue(@NonNull Version indexVersion) {
        if (indexVersion == null) {
            throw new NullPointerException("indexVersion is marked non-null but is null");
        }
        if (indexVersion.before(Version.V_2_12_0)) {
            log.debug("Picking up old values of ef_construction : index version : {}, value: {}", (Object)indexVersion, (Object)512);
            return 512;
        }
        log.debug("Picking up new values of ef_construction : index version : {}, value: {}", (Object)indexVersion, (Object)KNNSettings.INDEX_KNN_DEFAULT_ALGO_PARAM_EF_CONSTRUCTION);
        return KNNSettings.INDEX_KNN_DEFAULT_ALGO_PARAM_EF_CONSTRUCTION;
    }

    public static int getHNSWEFSearchValue(@NonNull Version indexVersion) {
        if (indexVersion == null) {
            throw new NullPointerException("indexVersion is marked non-null but is null");
        }
        if (indexVersion.before(Version.V_2_12_0)) {
            log.debug("Picking up old values of ef_search : index version : {}, value: {}", (Object)indexVersion, (Object)512);
            return 512;
        }
        log.debug("Picking up new values of ef_search : index version : {}, value: {}", (Object)indexVersion, (Object)KNNSettings.INDEX_KNN_DEFAULT_ALGO_PARAM_EF_SEARCH);
        return KNNSettings.INDEX_KNN_DEFAULT_ALGO_PARAM_EF_SEARCH;
    }

    public static int getBinaryQuantizationEFConstructionValue() {
        return 256;
    }

    public static int getBinaryQuantizationEFSearchValue() {
        return 256;
    }

    @Generated
    private IndexHyperParametersUtil() {
    }
}

