/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.plugin.script;

import java.io.IOException;
import java.math.BigInteger;
import java.util.Map;
import java.util.function.BiFunction;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.IndexSearcher;
import org.opensearch.index.fielddata.ScriptDocValues;
import org.opensearch.knn.index.KNNVectorScriptDocValues;
import org.opensearch.script.ScoreScript;
import org.opensearch.search.lookup.SearchLookup;

public abstract class KNNScoreScript<T>
extends ScoreScript {
    protected final T queryValue;
    protected final String field;
    protected final BiFunction<T, T, Float> scoringMethod;

    public KNNScoreScript(Map<String, Object> params, T queryValue, String field, BiFunction<T, T, Float> scoringMethod, SearchLookup lookup, LeafReaderContext leafContext, IndexSearcher searcher) {
        super(params, lookup, searcher, leafContext);
        this.queryValue = queryValue;
        this.field = field;
        this.scoringMethod = scoringMethod;
    }

    public static class KNNByteVectorType
    extends KNNScoreScript<byte[]> {
        public KNNByteVectorType(Map<String, Object> params, byte[] queryValue, String field, BiFunction<byte[], byte[], Float> scoringMethod, SearchLookup lookup, LeafReaderContext leafContext, IndexSearcher searcher) throws IOException {
            super(params, queryValue, field, scoringMethod, lookup, leafContext, searcher);
        }

        public double execute(ScoreScript.ExplanationHolder explanationHolder) {
            KNNVectorScriptDocValues scriptDocValues = (KNNVectorScriptDocValues)((Object)this.getDoc().get(this.field));
            if (scriptDocValues.isEmpty()) {
                return 0.0;
            }
            return ((Float)this.scoringMethod.apply((byte[])this.queryValue, (byte[])scriptDocValues.getValue())).floatValue();
        }
    }

    public static class KNNFloatVectorType
    extends KNNScoreScript<float[]> {
        public KNNFloatVectorType(Map<String, Object> params, float[] queryValue, String field, BiFunction<float[], float[], Float> scoringMethod, SearchLookup lookup, LeafReaderContext leafContext, IndexSearcher searcher) throws IOException {
            super(params, queryValue, field, scoringMethod, lookup, leafContext, searcher);
        }

        public double execute(ScoreScript.ExplanationHolder explanationHolder) {
            KNNVectorScriptDocValues scriptDocValues = (KNNVectorScriptDocValues)((Object)this.getDoc().get(this.field));
            if (scriptDocValues.isEmpty()) {
                return 0.0;
            }
            return ((Float)this.scoringMethod.apply((float[])this.queryValue, (float[])scriptDocValues.getValue())).floatValue();
        }
    }

    public static class BigIntegerType
    extends KNNScoreScript<BigInteger> {
        public BigIntegerType(Map<String, Object> params, BigInteger queryValue, String field, BiFunction<BigInteger, BigInteger, Float> scoringMethod, SearchLookup lookup, LeafReaderContext leafContext, IndexSearcher searcher) {
            super(params, queryValue, field, scoringMethod, lookup, leafContext, searcher);
        }

        public double execute(ScoreScript.ExplanationHolder explanationHolder) {
            ScriptDocValues.BytesRefs scriptDocValues = (ScriptDocValues.BytesRefs)this.getDoc().get(this.field);
            if (scriptDocValues.isEmpty()) {
                return 0.0;
            }
            return ((Float)this.scoringMethod.apply((BigInteger)this.queryValue, new BigInteger(1, scriptDocValues.getValue().bytes))).floatValue();
        }
    }

    public static class LongType
    extends KNNScoreScript<Long> {
        public LongType(Map<String, Object> params, Long queryValue, String field, BiFunction<Long, Long, Float> scoringMethod, SearchLookup lookup, LeafReaderContext leafContext, IndexSearcher searcher) {
            super(params, queryValue, field, scoringMethod, lookup, leafContext, searcher);
        }

        public double execute(ScoreScript.ExplanationHolder explanationHolder) {
            ScriptDocValues.Longs scriptDocValues = (ScriptDocValues.Longs)this.getDoc().get(this.field);
            if (scriptDocValues.isEmpty()) {
                return 0.0;
            }
            return ((Float)this.scoringMethod.apply((Long)this.queryValue, scriptDocValues.getValue())).floatValue();
        }
    }
}

