/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.common;

import java.util.HashSet;
import java.util.Locale;
import java.util.Set;

public enum FunctionName {
    LINEAR_REGRESSION,
    KMEANS,
    AD_LIBSVM,
    SAMPLE_ALGO,
    LOCAL_SAMPLE_CALCULATOR,
    FIT_RCF,
    BATCH_RCF,
    ANOMALY_LOCALIZATION,
    RCF_SUMMARIZE,
    LOGISTIC_REGRESSION,
    TEXT_EMBEDDING,
    METRICS_CORRELATION,
    REMOTE,
    SPARSE_ENCODING,
    SPARSE_TOKENIZE,
    TEXT_SIMILARITY,
    QUESTION_ANSWERING,
    AGENT,
    CONNECTOR,
    TOOL;

    private static final HashSet<FunctionName> DL_MODELS;

    public static FunctionName from(String value) {
        try {
            return FunctionName.valueOf(value.toUpperCase(Locale.ROOT));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Wrong function name");
        }
    }

    public static boolean isDLModel(FunctionName functionName) {
        return DL_MODELS.contains((Object)functionName);
    }

    public static boolean needDeployFirst(FunctionName functionName) {
        return DL_MODELS.contains((Object)functionName) || functionName == REMOTE;
    }

    public static boolean isAutoDeployEnabled(boolean autoDeploymentEnabled, FunctionName functionName) {
        return autoDeploymentEnabled && functionName == REMOTE;
    }

    static {
        DL_MODELS = new HashSet<FunctionName>(Set.of(TEXT_EMBEDDING, TEXT_SIMILARITY, SPARSE_ENCODING, SPARSE_TOKENIZE, QUESTION_ANSWERING));
    }
}

