/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum AttributeAction {
    ADD("ADD"),
    PUT("PUT"),
    DELETE("DELETE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, AttributeAction> VALUE_MAP;
    private final String value;

    private AttributeAction(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AttributeAction fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AttributeAction> knownValues() {
        EnumSet<AttributeAction> knownValues = EnumSet.allOf(AttributeAction.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(AttributeAction.class, AttributeAction::toString);
    }
}

