/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.notifications.core.repackage.com.amazonaws.services.simpleemail.model.transform;

import org.opensearch.notifications.core.repackage.com.amazonaws.DefaultRequest;
import org.opensearch.notifications.core.repackage.com.amazonaws.Request;
import org.opensearch.notifications.core.repackage.com.amazonaws.SdkClientException;
import org.opensearch.notifications.core.repackage.com.amazonaws.http.HttpMethodName;
import org.opensearch.notifications.core.repackage.com.amazonaws.services.simpleemail.model.CreateTemplateRequest;
import org.opensearch.notifications.core.repackage.com.amazonaws.services.simpleemail.model.Template;
import org.opensearch.notifications.core.repackage.com.amazonaws.transform.Marshaller;
import org.opensearch.notifications.core.repackage.com.amazonaws.util.StringUtils;

public class CreateTemplateRequestMarshaller
implements Marshaller<Request<CreateTemplateRequest>, CreateTemplateRequest> {
    @Override
    public Request<CreateTemplateRequest> marshall(CreateTemplateRequest createTemplateRequest) {
        if (createTemplateRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateTemplateRequest> request = new DefaultRequest<CreateTemplateRequest>(createTemplateRequest, "AmazonSimpleEmailService");
        request.addParameter("Action", "CreateTemplate");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        Template template = createTemplateRequest.getTemplate();
        if (template != null) {
            if (template.getTemplateName() != null) {
                request.addParameter("Template.TemplateName", StringUtils.fromString(template.getTemplateName()));
            }
            if (template.getSubjectPart() != null) {
                request.addParameter("Template.SubjectPart", StringUtils.fromString(template.getSubjectPart()));
            }
            if (template.getTextPart() != null) {
                request.addParameter("Template.TextPart", StringUtils.fromString(template.getTextPart()));
            }
            if (template.getHtmlPart() != null) {
                request.addParameter("Template.HtmlPart", StringUtils.fromString(template.getHtmlPart()));
            }
        }
        return request;
    }
}

