/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.aggregations;

import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch._types.Script;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class WeightedAverageValue
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, WeightedAverageValue> {
    @Nullable
    private final String field;
    @Nullable
    private final Double missing;
    @Nullable
    private final Script script;
    public static final JsonpDeserializer<WeightedAverageValue> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, WeightedAverageValue::setupWeightedAverageValueDeserializer);

    private WeightedAverageValue(Builder builder) {
        this.field = builder.field;
        this.missing = builder.missing;
        this.script = builder.script;
    }

    public static WeightedAverageValue of(Function<Builder, ObjectBuilder<WeightedAverageValue>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final String field() {
        return this.field;
    }

    @Nullable
    public final Double missing() {
        return this.missing;
    }

    @Nullable
    public final Script script() {
        return this.script;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.field != null) {
            generator.writeKey("field");
            generator.write(this.field);
        }
        if (this.missing != null) {
            generator.writeKey("missing");
            generator.write(this.missing.doubleValue());
        }
        if (this.script != null) {
            generator.writeKey("script");
            this.script.serialize(generator, mapper);
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupWeightedAverageValueDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::field, JsonpDeserializer.stringDeserializer(), "field");
        op.add(Builder::missing, JsonpDeserializer.doubleDeserializer(), "missing");
        op.add(Builder::script, Script._DESERIALIZER, "script");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.field);
        result = 31 * result + Objects.hashCode(this.missing);
        result = 31 * result + Objects.hashCode(this.script);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WeightedAverageValue other = (WeightedAverageValue)o;
        return Objects.equals(this.field, other.field) && Objects.equals(this.missing, other.missing) && Objects.equals(this.script, other.script);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, WeightedAverageValue> {
        @Nullable
        private String field;
        @Nullable
        private Double missing;
        @Nullable
        private Script script;

        public Builder() {
        }

        private Builder(WeightedAverageValue o) {
            this.field = o.field;
            this.missing = o.missing;
            this.script = o.script;
        }

        private Builder(Builder o) {
            this.field = o.field;
            this.missing = o.missing;
            this.script = o.script;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder field(@Nullable String value) {
            this.field = value;
            return this;
        }

        @Nonnull
        public final Builder missing(@Nullable Double value) {
            this.missing = value;
            return this;
        }

        @Nonnull
        public final Builder script(@Nullable Script value) {
            this.script = value;
            return this;
        }

        @Nonnull
        public final Builder script(Function<Script.Builder, ObjectBuilder<Script>> fn) {
            return this.script(fn.apply(new Script.Builder()).build());
        }

        @Override
        @Nonnull
        public WeightedAverageValue build() {
            this._checkSingleUse();
            return new WeightedAverageValue(this);
        }
    }
}

