/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.mapping;

import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.mapping.Property;
import org.opensearch.client.opensearch._types.mapping.PropertyBase;
import org.opensearch.client.opensearch._types.mapping.PropertyVariant;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class HistogramProperty
extends PropertyBase
implements PropertyVariant,
ToCopyableBuilder<Builder, HistogramProperty> {
    @Nullable
    private final Boolean ignoreMalformed;
    public static final JsonpDeserializer<HistogramProperty> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, HistogramProperty::setupHistogramPropertyDeserializer);

    private HistogramProperty(Builder builder) {
        super(builder);
        this.ignoreMalformed = builder.ignoreMalformed;
    }

    public static HistogramProperty of(Function<Builder, ObjectBuilder<HistogramProperty>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Property.Kind _propertyKind() {
        return Property.Kind.Histogram;
    }

    @Nullable
    public final Boolean ignoreMalformed() {
        return this.ignoreMalformed;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "histogram");
        super.serializeInternal(generator, mapper);
        if (this.ignoreMalformed != null) {
            generator.writeKey("ignore_malformed");
            generator.write(this.ignoreMalformed.booleanValue());
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupHistogramPropertyDeserializer(ObjectDeserializer<Builder> op) {
        HistogramProperty.setupPropertyBaseDeserializer(op);
        op.add(Builder::ignoreMalformed, JsonpDeserializer.booleanDeserializer(), "ignore_malformed");
        op.ignore("type");
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Objects.hashCode(this.ignoreMalformed);
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HistogramProperty other = (HistogramProperty)o;
        return Objects.equals(this.ignoreMalformed, other.ignoreMalformed);
    }

    public static class Builder
    extends PropertyBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, HistogramProperty> {
        @Nullable
        private Boolean ignoreMalformed;

        public Builder() {
        }

        private Builder(HistogramProperty o) {
            super(o);
            this.ignoreMalformed = o.ignoreMalformed;
        }

        private Builder(Builder o) {
            super(o);
            this.ignoreMalformed = o.ignoreMalformed;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder ignoreMalformed(@Nullable Boolean value) {
            this.ignoreMalformed = value;
            return this;
        }

        @Override
        @Nonnull
        public HistogramProperty build() {
            this._checkSingleUse();
            return new HistogramProperty(this);
        }
    }
}

