/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.mapping;

import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.mapping.CorePropertyBase;
import org.opensearch.client.opensearch._types.mapping.Property;
import org.opensearch.client.opensearch._types.mapping.PropertyVariant;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class ObjectProperty
extends CorePropertyBase
implements PropertyVariant,
ToCopyableBuilder<Builder, ObjectProperty> {
    @Nullable
    private final Boolean enabled;
    public static final JsonpDeserializer<ObjectProperty> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ObjectProperty::setupObjectPropertyDeserializer);

    private ObjectProperty(Builder builder) {
        super(builder);
        this.enabled = builder.enabled;
    }

    public static ObjectProperty of(Function<Builder, ObjectBuilder<ObjectProperty>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Property.Kind _propertyKind() {
        return Property.Kind.Object;
    }

    @Nullable
    public final Boolean enabled() {
        return this.enabled;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "object");
        super.serializeInternal(generator, mapper);
        if (this.enabled != null) {
            generator.writeKey("enabled");
            generator.write(this.enabled.booleanValue());
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupObjectPropertyDeserializer(ObjectDeserializer<Builder> op) {
        ObjectProperty.setupCorePropertyBaseDeserializer(op);
        op.add(Builder::enabled, JsonpDeserializer.booleanDeserializer(), "enabled");
        op.ignore("type");
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Objects.hashCode(this.enabled);
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ObjectProperty other = (ObjectProperty)o;
        return Objects.equals(this.enabled, other.enabled);
    }

    public static class Builder
    extends CorePropertyBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, ObjectProperty> {
        @Nullable
        private Boolean enabled;

        public Builder() {
        }

        private Builder(ObjectProperty o) {
            super(o);
            this.enabled = o.enabled;
        }

        private Builder(Builder o) {
            super(o);
            this.enabled = o.enabled;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder enabled(@Nullable Boolean value) {
            this.enabled = value;
            return this;
        }

        @Override
        @Nonnull
        public ObjectProperty build() {
            this._checkSingleUse();
            return new ObjectProperty(this);
        }
    }
}

