/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.cluster.stats;

import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class ClusterJvmMemory
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, ClusterJvmMemory> {
    @Nullable
    private final String heapMax;
    private final long heapMaxInBytes;
    @Nullable
    private final String heapUsed;
    private final long heapUsedInBytes;
    public static final JsonpDeserializer<ClusterJvmMemory> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ClusterJvmMemory::setupClusterJvmMemoryDeserializer);

    private ClusterJvmMemory(Builder builder) {
        this.heapMax = builder.heapMax;
        this.heapMaxInBytes = ApiTypeHelper.requireNonNull(builder.heapMaxInBytes, this, "heapMaxInBytes");
        this.heapUsed = builder.heapUsed;
        this.heapUsedInBytes = ApiTypeHelper.requireNonNull(builder.heapUsedInBytes, this, "heapUsedInBytes");
    }

    public static ClusterJvmMemory of(Function<Builder, ObjectBuilder<ClusterJvmMemory>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final String heapMax() {
        return this.heapMax;
    }

    public final long heapMaxInBytes() {
        return this.heapMaxInBytes;
    }

    @Nullable
    public final String heapUsed() {
        return this.heapUsed;
    }

    public final long heapUsedInBytes() {
        return this.heapUsedInBytes;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.heapMax != null) {
            generator.writeKey("heap_max");
            generator.write(this.heapMax);
        }
        generator.writeKey("heap_max_in_bytes");
        generator.write(this.heapMaxInBytes);
        if (this.heapUsed != null) {
            generator.writeKey("heap_used");
            generator.write(this.heapUsed);
        }
        generator.writeKey("heap_used_in_bytes");
        generator.write(this.heapUsedInBytes);
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupClusterJvmMemoryDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::heapMax, JsonpDeserializer.stringDeserializer(), "heap_max");
        op.add(Builder::heapMaxInBytes, JsonpDeserializer.longDeserializer(), "heap_max_in_bytes");
        op.add(Builder::heapUsed, JsonpDeserializer.stringDeserializer(), "heap_used");
        op.add(Builder::heapUsedInBytes, JsonpDeserializer.longDeserializer(), "heap_used_in_bytes");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.heapMax);
        result = 31 * result + Long.hashCode(this.heapMaxInBytes);
        result = 31 * result + Objects.hashCode(this.heapUsed);
        result = 31 * result + Long.hashCode(this.heapUsedInBytes);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClusterJvmMemory other = (ClusterJvmMemory)o;
        return Objects.equals(this.heapMax, other.heapMax) && this.heapMaxInBytes == other.heapMaxInBytes && Objects.equals(this.heapUsed, other.heapUsed) && this.heapUsedInBytes == other.heapUsedInBytes;
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, ClusterJvmMemory> {
        @Nullable
        private String heapMax;
        private Long heapMaxInBytes;
        @Nullable
        private String heapUsed;
        private Long heapUsedInBytes;

        public Builder() {
        }

        private Builder(ClusterJvmMemory o) {
            this.heapMax = o.heapMax;
            this.heapMaxInBytes = o.heapMaxInBytes;
            this.heapUsed = o.heapUsed;
            this.heapUsedInBytes = o.heapUsedInBytes;
        }

        private Builder(Builder o) {
            this.heapMax = o.heapMax;
            this.heapMaxInBytes = o.heapMaxInBytes;
            this.heapUsed = o.heapUsed;
            this.heapUsedInBytes = o.heapUsedInBytes;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder heapMax(@Nullable String value) {
            this.heapMax = value;
            return this;
        }

        @Nonnull
        public final Builder heapMaxInBytes(long value) {
            this.heapMaxInBytes = value;
            return this;
        }

        @Nonnull
        public final Builder heapUsed(@Nullable String value) {
            this.heapUsed = value;
            return this;
        }

        @Nonnull
        public final Builder heapUsedInBytes(long value) {
            this.heapUsedInBytes = value;
            return this;
        }

        @Override
        @Nonnull
        public ClusterJvmMemory build() {
            this._checkSingleUse();
            return new ClusterJvmMemory(this);
        }
    }
}

