/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.core;

import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch._types.ErrorResponse;
import org.opensearch.client.opensearch._types.RequestBase;
import org.opensearch.client.opensearch.core.DeletePitResponse;
import org.opensearch.client.transport.Endpoint;
import org.opensearch.client.transport.endpoints.SimpleEndpoint;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public final class DeletePitRequest
extends RequestBase
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, DeletePitRequest> {
    @Nonnull
    private final List<String> pitId;
    public static final JsonpDeserializer<DeletePitRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, DeletePitRequest::setupDeletePitRequestDeserializer);
    public static final Endpoint<DeletePitRequest, DeletePitResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<DeletePitRequest, DeletePitResponse>(request -> "DELETE", request -> "/_search/point_in_time", request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        request.applyQueryParameters(params);
        return params;
    }, SimpleEndpoint.emptyMap(), true, DeletePitResponse._DESERIALIZER);

    private DeletePitRequest(Builder builder) {
        super(builder);
        this.pitId = ApiTypeHelper.unmodifiableRequired(builder.pitId, (Object)this, "pitId");
    }

    public static DeletePitRequest of(Function<Builder, ObjectBuilder<DeletePitRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nonnull
    public final List<String> pitId() {
        return this.pitId;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("pit_id");
        generator.writeStartArray();
        for (String item0 : this.pitId) {
            generator.write(item0);
        }
        generator.writeEnd();
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupDeletePitRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::pitId, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "pit_id");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.pitId.hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeletePitRequest other = (DeletePitRequest)o;
        return this.pitId.equals(other.pitId);
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, DeletePitRequest> {
        private List<String> pitId;

        public Builder() {
        }

        private Builder(DeletePitRequest o) {
            super(o);
            this.pitId = Builder._listCopy(o.pitId);
        }

        private Builder(Builder o) {
            super(o);
            this.pitId = Builder._listCopy(o.pitId);
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder pitId(List<String> list) {
            this.pitId = Builder._listAddAll(this.pitId, list);
            return this;
        }

        @Nonnull
        public final Builder pitId(String value, String ... values) {
            this.pitId = Builder._listAdd(this.pitId, value, values);
            return this;
        }

        @Override
        @Nonnull
        public DeletePitRequest build() {
            this._checkSingleUse();
            return new DeletePitRequest(this);
        }
    }
}

