/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.core.search;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class Collector
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, Collector> {
    @Nonnull
    private final List<Collector> children;
    @Nonnull
    private final String name;
    @Nonnull
    private final String reason;
    private final long timeInNanos;
    public static final JsonpDeserializer<Collector> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Collector::setupCollectorDeserializer);

    private Collector(Builder builder) {
        this.children = ApiTypeHelper.unmodifiable(builder.children);
        this.name = ApiTypeHelper.requireNonNull(builder.name, this, "name");
        this.reason = ApiTypeHelper.requireNonNull(builder.reason, this, "reason");
        this.timeInNanos = ApiTypeHelper.requireNonNull(builder.timeInNanos, this, "timeInNanos");
    }

    public static Collector of(Function<Builder, ObjectBuilder<Collector>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nonnull
    public final List<Collector> children() {
        return this.children;
    }

    @Nonnull
    public final String name() {
        return this.name;
    }

    @Nonnull
    public final String reason() {
        return this.reason;
    }

    public final long timeInNanos() {
        return this.timeInNanos;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.children)) {
            generator.writeKey("children");
            generator.writeStartArray();
            for (Collector item0 : this.children) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        generator.writeKey("name");
        generator.write(this.name);
        generator.writeKey("reason");
        generator.write(this.reason);
        generator.writeKey("time_in_nanos");
        generator.write(this.timeInNanos);
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupCollectorDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::children, JsonpDeserializer.arrayDeserializer(_DESERIALIZER), "children");
        op.add(Builder::name, JsonpDeserializer.stringDeserializer(), "name");
        op.add(Builder::reason, JsonpDeserializer.stringDeserializer(), "reason");
        op.add(Builder::timeInNanos, JsonpDeserializer.longDeserializer(), "time_in_nanos");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.children);
        result = 31 * result + this.name.hashCode();
        result = 31 * result + this.reason.hashCode();
        result = 31 * result + Long.hashCode(this.timeInNanos);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Collector other = (Collector)o;
        return Objects.equals(this.children, other.children) && this.name.equals(other.name) && this.reason.equals(other.reason) && this.timeInNanos == other.timeInNanos;
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, Collector> {
        @Nullable
        private List<Collector> children;
        private String name;
        private String reason;
        private Long timeInNanos;

        public Builder() {
        }

        private Builder(Collector o) {
            this.children = Builder._listCopy(o.children);
            this.name = o.name;
            this.reason = o.reason;
            this.timeInNanos = o.timeInNanos;
        }

        private Builder(Builder o) {
            this.children = Builder._listCopy(o.children);
            this.name = o.name;
            this.reason = o.reason;
            this.timeInNanos = o.timeInNanos;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder children(List<Collector> list) {
            this.children = Builder._listAddAll(this.children, list);
            return this;
        }

        @Nonnull
        public final Builder children(Collector value, Collector ... values) {
            this.children = Builder._listAdd(this.children, value, values);
            return this;
        }

        @Nonnull
        public final Builder children(Function<Builder, ObjectBuilder<Collector>> fn) {
            return this.children(fn.apply(new Builder()).build(), new Collector[0]);
        }

        @Nonnull
        public final Builder name(String value) {
            this.name = value;
            return this;
        }

        @Nonnull
        public final Builder reason(String value) {
            this.reason = value;
            return this;
        }

        @Nonnull
        public final Builder timeInNanos(long value) {
            this.timeInNanos = value;
            return this;
        }

        @Override
        @Nonnull
        public Collector build() {
            this._checkSingleUse();
            return new Collector(this);
        }
    }
}

