/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.nodes.stats;

import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch.nodes.stats.LastGcStats;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class Pool
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, Pool> {
    @Nullable
    private final LastGcStats lastGcStats;
    @Nullable
    private final String max;
    @Nullable
    private final Long maxInBytes;
    @Nullable
    private final String peakMax;
    @Nullable
    private final Long peakMaxInBytes;
    @Nullable
    private final String peakUsed;
    @Nullable
    private final Long peakUsedInBytes;
    @Nullable
    private final String used;
    @Nullable
    private final Long usedInBytes;
    public static final JsonpDeserializer<Pool> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Pool::setupPoolDeserializer);

    private Pool(Builder builder) {
        this.lastGcStats = builder.lastGcStats;
        this.max = builder.max;
        this.maxInBytes = builder.maxInBytes;
        this.peakMax = builder.peakMax;
        this.peakMaxInBytes = builder.peakMaxInBytes;
        this.peakUsed = builder.peakUsed;
        this.peakUsedInBytes = builder.peakUsedInBytes;
        this.used = builder.used;
        this.usedInBytes = builder.usedInBytes;
    }

    public static Pool of(Function<Builder, ObjectBuilder<Pool>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final LastGcStats lastGcStats() {
        return this.lastGcStats;
    }

    @Nullable
    public final String max() {
        return this.max;
    }

    @Nullable
    public final Long maxInBytes() {
        return this.maxInBytes;
    }

    @Nullable
    public final String peakMax() {
        return this.peakMax;
    }

    @Nullable
    public final Long peakMaxInBytes() {
        return this.peakMaxInBytes;
    }

    @Nullable
    public final String peakUsed() {
        return this.peakUsed;
    }

    @Nullable
    public final Long peakUsedInBytes() {
        return this.peakUsedInBytes;
    }

    @Nullable
    public final String used() {
        return this.used;
    }

    @Nullable
    public final Long usedInBytes() {
        return this.usedInBytes;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.lastGcStats != null) {
            generator.writeKey("last_gc_stats");
            this.lastGcStats.serialize(generator, mapper);
        }
        if (this.max != null) {
            generator.writeKey("max");
            generator.write(this.max);
        }
        if (this.maxInBytes != null) {
            generator.writeKey("max_in_bytes");
            generator.write(this.maxInBytes.longValue());
        }
        if (this.peakMax != null) {
            generator.writeKey("peak_max");
            generator.write(this.peakMax);
        }
        if (this.peakMaxInBytes != null) {
            generator.writeKey("peak_max_in_bytes");
            generator.write(this.peakMaxInBytes.longValue());
        }
        if (this.peakUsed != null) {
            generator.writeKey("peak_used");
            generator.write(this.peakUsed);
        }
        if (this.peakUsedInBytes != null) {
            generator.writeKey("peak_used_in_bytes");
            generator.write(this.peakUsedInBytes.longValue());
        }
        if (this.used != null) {
            generator.writeKey("used");
            generator.write(this.used);
        }
        if (this.usedInBytes != null) {
            generator.writeKey("used_in_bytes");
            generator.write(this.usedInBytes.longValue());
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupPoolDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::lastGcStats, LastGcStats._DESERIALIZER, "last_gc_stats");
        op.add(Builder::max, JsonpDeserializer.stringDeserializer(), "max");
        op.add(Builder::maxInBytes, JsonpDeserializer.longDeserializer(), "max_in_bytes");
        op.add(Builder::peakMax, JsonpDeserializer.stringDeserializer(), "peak_max");
        op.add(Builder::peakMaxInBytes, JsonpDeserializer.longDeserializer(), "peak_max_in_bytes");
        op.add(Builder::peakUsed, JsonpDeserializer.stringDeserializer(), "peak_used");
        op.add(Builder::peakUsedInBytes, JsonpDeserializer.longDeserializer(), "peak_used_in_bytes");
        op.add(Builder::used, JsonpDeserializer.stringDeserializer(), "used");
        op.add(Builder::usedInBytes, JsonpDeserializer.longDeserializer(), "used_in_bytes");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.lastGcStats);
        result = 31 * result + Objects.hashCode(this.max);
        result = 31 * result + Objects.hashCode(this.maxInBytes);
        result = 31 * result + Objects.hashCode(this.peakMax);
        result = 31 * result + Objects.hashCode(this.peakMaxInBytes);
        result = 31 * result + Objects.hashCode(this.peakUsed);
        result = 31 * result + Objects.hashCode(this.peakUsedInBytes);
        result = 31 * result + Objects.hashCode(this.used);
        result = 31 * result + Objects.hashCode(this.usedInBytes);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Pool other = (Pool)o;
        return Objects.equals(this.lastGcStats, other.lastGcStats) && Objects.equals(this.max, other.max) && Objects.equals(this.maxInBytes, other.maxInBytes) && Objects.equals(this.peakMax, other.peakMax) && Objects.equals(this.peakMaxInBytes, other.peakMaxInBytes) && Objects.equals(this.peakUsed, other.peakUsed) && Objects.equals(this.peakUsedInBytes, other.peakUsedInBytes) && Objects.equals(this.used, other.used) && Objects.equals(this.usedInBytes, other.usedInBytes);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, Pool> {
        @Nullable
        private LastGcStats lastGcStats;
        @Nullable
        private String max;
        @Nullable
        private Long maxInBytes;
        @Nullable
        private String peakMax;
        @Nullable
        private Long peakMaxInBytes;
        @Nullable
        private String peakUsed;
        @Nullable
        private Long peakUsedInBytes;
        @Nullable
        private String used;
        @Nullable
        private Long usedInBytes;

        public Builder() {
        }

        private Builder(Pool o) {
            this.lastGcStats = o.lastGcStats;
            this.max = o.max;
            this.maxInBytes = o.maxInBytes;
            this.peakMax = o.peakMax;
            this.peakMaxInBytes = o.peakMaxInBytes;
            this.peakUsed = o.peakUsed;
            this.peakUsedInBytes = o.peakUsedInBytes;
            this.used = o.used;
            this.usedInBytes = o.usedInBytes;
        }

        private Builder(Builder o) {
            this.lastGcStats = o.lastGcStats;
            this.max = o.max;
            this.maxInBytes = o.maxInBytes;
            this.peakMax = o.peakMax;
            this.peakMaxInBytes = o.peakMaxInBytes;
            this.peakUsed = o.peakUsed;
            this.peakUsedInBytes = o.peakUsedInBytes;
            this.used = o.used;
            this.usedInBytes = o.usedInBytes;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder lastGcStats(@Nullable LastGcStats value) {
            this.lastGcStats = value;
            return this;
        }

        @Nonnull
        public final Builder lastGcStats(Function<LastGcStats.Builder, ObjectBuilder<LastGcStats>> fn) {
            return this.lastGcStats(fn.apply(new LastGcStats.Builder()).build());
        }

        @Nonnull
        public final Builder max(@Nullable String value) {
            this.max = value;
            return this;
        }

        @Nonnull
        public final Builder maxInBytes(@Nullable Long value) {
            this.maxInBytes = value;
            return this;
        }

        @Nonnull
        public final Builder peakMax(@Nullable String value) {
            this.peakMax = value;
            return this;
        }

        @Nonnull
        public final Builder peakMaxInBytes(@Nullable Long value) {
            this.peakMaxInBytes = value;
            return this;
        }

        @Nonnull
        public final Builder peakUsed(@Nullable String value) {
            this.peakUsed = value;
            return this;
        }

        @Nonnull
        public final Builder peakUsedInBytes(@Nullable Long value) {
            this.peakUsedInBytes = value;
            return this;
        }

        @Nonnull
        public final Builder used(@Nullable String value) {
            this.used = value;
            return this;
        }

        @Nonnull
        public final Builder usedInBytes(@Nullable Long value) {
            this.usedInBytes = value;
            return this;
        }

        @Override
        @Nonnull
        public Pool build() {
            this._checkSingleUse();
            return new Pool(this);
        }
    }
}

