/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.notifications.core.client;

import jakarta.activation.CommandMap;
import jakarta.activation.DataHandler;
import jakarta.activation.DataSource;
import jakarta.activation.MailcapCommandMap;
import jakarta.mail.BodyPart;
import jakarta.mail.Message;
import jakarta.mail.Multipart;
import jakarta.mail.Session;
import jakarta.mail.internet.MimeBodyPart;
import jakarta.mail.internet.MimeMessage;
import jakarta.mail.internet.MimeMultipart;
import jakarta.mail.util.ByteArrayDataSource;
import java.util.Base64;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.opensearch.notifications.spi.model.MessageContent;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J&\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u000f"}, d2={"Lorg/opensearch/notifications/core/client/EmailMimeProvider;", "", "()V", "createBinaryAttachmentPart", "Ljakarta/mail/internet/MimeBodyPart;", "messageContent", "Lorg/opensearch/notifications/spi/model/MessageContent;", "createTextAttachmentPart", "prepareMimeMessage", "Ljakarta/mail/internet/MimeMessage;", "session", "Ljakarta/mail/Session;", "fromAddress", "", "recipient", "opensearch-notifications-core"})
public final class EmailMimeProvider {
    @NotNull
    public static final EmailMimeProvider INSTANCE = new EmailMimeProvider();

    private EmailMimeProvider() {
    }

    @NotNull
    public final MimeMessage prepareMimeMessage(@NotNull Session session, @NotNull String fromAddress, @NotNull String recipient, @NotNull MessageContent messageContent) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)fromAddress, (String)"fromAddress");
        Intrinsics.checkNotNullParameter((Object)recipient, (String)"recipient");
        Intrinsics.checkNotNullParameter((Object)messageContent, (String)"messageContent");
        CommandMap commandMap = CommandMap.getDefaultCommandMap();
        Intrinsics.checkNotNull((Object)commandMap, (String)"null cannot be cast to non-null type jakarta.activation.MailcapCommandMap");
        MailcapCommandMap mc = (MailcapCommandMap)commandMap;
        mc.addMailcap("text/html;; x-java-content-handler=org.eclipse.angus.mail.handlers.text_html");
        mc.addMailcap("text/xml;; x-java-content-handler=org.eclipse.angus.mail.handlers.text_xml");
        mc.addMailcap("text/plain;; x-java-content-handler=org.eclipse.angus.mail.handlers.text_plain");
        mc.addMailcap("multipart/*;; x-java-content-handler=org.eclipse.angus.mail.handlers.multipart_mixed");
        mc.addMailcap("message/rfc822;; x-java-content-handler=org.eclipse.angus.mail.handlers.message_rfc822");
        MimeMessage mimeMessage = new MimeMessage(session);
        mimeMessage.setFrom(fromAddress);
        mimeMessage.setRecipients(Message.RecipientType.TO, recipient);
        mimeMessage.setSubject(messageContent.getTitle(), "UTF-8");
        MimeMultipart msgBody = new MimeMultipart("alternative");
        MimeBodyPart bodyWrapper = new MimeBodyPart();
        MimeBodyPart textPart = new MimeBodyPart();
        textPart.setContent((Object)messageContent.getTextDescription(), "text/plain; charset=UTF-8");
        msgBody.addBodyPart((BodyPart)textPart);
        if (messageContent.getHtmlDescription() != null) {
            MimeBodyPart htmlPart = new MimeBodyPart();
            htmlPart.setContent((Object)messageContent.getHtmlDescription(), "text/html; charset=UTF-8");
            msgBody.addBodyPart((BodyPart)htmlPart);
        }
        bodyWrapper.setContent((Multipart)msgBody);
        MimeMultipart msg = new MimeMultipart("mixed");
        mimeMessage.setContent((Multipart)msg);
        msg.addBodyPart((BodyPart)bodyWrapper);
        if (messageContent.getFileName() != null && messageContent.getFileData() != null && messageContent.getFileContentType() != null && messageContent.getFileEncoding() != null) {
            MimeBodyPart attachmentMime = null;
            String string = messageContent.getFileEncoding();
            if (Intrinsics.areEqual((Object)string, (Object)"text")) {
                attachmentMime = this.createTextAttachmentPart(messageContent);
            } else if (Intrinsics.areEqual((Object)string, (Object)"base64")) {
                attachmentMime = this.createBinaryAttachmentPart(messageContent);
            }
            if (attachmentMime != null) {
                msg.addBodyPart((BodyPart)attachmentMime);
            }
        }
        return mimeMessage;
    }

    private final MimeBodyPart createBinaryAttachmentPart(MessageContent messageContent) {
        MimeBodyPart attachmentMime = new MimeBodyPart();
        byte[] byArray = Base64.getMimeDecoder().decode(messageContent.getFileData());
        String string = messageContent.getFileContentType();
        if (string == null) {
            string = "application/octet-stream";
        }
        ByteArrayDataSource fds = new ByteArrayDataSource(byArray, string);
        attachmentMime.setDataHandler(new DataHandler((DataSource)fds));
        attachmentMime.setFileName(messageContent.getFileName());
        return attachmentMime;
    }

    private final MimeBodyPart createTextAttachmentPart(MessageContent messageContent) {
        MimeBodyPart attachmentMime = new MimeBodyPart();
        String string = messageContent.getFileContentType();
        if (string == null || (string = StringsKt.substringAfterLast$default((String)string, (char)'/', null, (int)2, null)) == null) {
            string = "plain";
        }
        String subContentType = string;
        attachmentMime.setText(messageContent.getFileData(), "UTF-8", subContentType);
        attachmentMime.setFileName(messageContent.getFileName());
        return attachmentMime;
    }
}

