/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.internal.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.internal.BufferedBlockCipher;
import org.bouncycastle.crypto.internal.SkippingCipher;
import org.bouncycastle.crypto.internal.StreamCipher;
import org.bouncycastle.crypto.internal.io.StreamIOException;
import org.bouncycastle.crypto.internal.io.Utils;
import org.bouncycastle.crypto.internal.modes.AEADCipher;
import org.bouncycastle.util.Arrays;

public class CipherInputStream
extends FilterInputStream {
    private static final int INPUT_BUF_SIZE = 2048;
    private final String algorithmName;
    private final boolean isApprovedMode;
    private BufferedBlockCipher bufferedBlockCipher;
    private StreamCipher streamCipher;
    private AEADCipher aeadBlockCipher;
    private byte[] buf;
    private byte[] markBuf;
    private final byte[] inBuf = new byte[2048];
    private int bufOff;
    private int maxBuf;
    private boolean finalized;
    private long markPosition;
    private int markBufOff;

    public CipherInputStream(InputStream inputStream, BufferedBlockCipher bufferedBlockCipher) {
        super(inputStream);
        this.isApprovedMode = CryptoServicesRegistrar.isInApprovedOnlyMode();
        this.algorithmName = bufferedBlockCipher.getUnderlyingCipher().getAlgorithmName();
        this.bufferedBlockCipher = bufferedBlockCipher;
    }

    public CipherInputStream(InputStream inputStream, StreamCipher streamCipher) {
        super(inputStream);
        this.isApprovedMode = CryptoServicesRegistrar.isInApprovedOnlyMode();
        this.algorithmName = streamCipher.getAlgorithmName();
        this.streamCipher = streamCipher;
    }

    public CipherInputStream(InputStream inputStream, AEADCipher aEADCipher) {
        super(inputStream);
        this.isApprovedMode = CryptoServicesRegistrar.isInApprovedOnlyMode();
        this.algorithmName = aEADCipher.getAlgorithmName();
        this.aeadBlockCipher = aEADCipher;
    }

    private int nextChunk() throws IOException {
        if (this.finalized) {
            return -1;
        }
        this.bufOff = 0;
        this.maxBuf = 0;
        while (this.maxBuf == 0) {
            int n = this.in.read(this.inBuf);
            if (n == -1) {
                this.finaliseCipher();
                if (this.maxBuf == 0) {
                    return -1;
                }
                return this.maxBuf;
            }
            try {
                this.ensureCapacity(n, false);
                if (this.bufferedBlockCipher != null) {
                    this.maxBuf = this.bufferedBlockCipher.processBytes(this.inBuf, 0, n, this.buf, 0);
                    continue;
                }
                if (this.aeadBlockCipher != null) {
                    this.maxBuf = this.aeadBlockCipher.processBytes(this.inBuf, 0, n, this.buf, 0);
                    continue;
                }
                this.streamCipher.processBytes(this.inBuf, 0, n, this.buf, 0);
                this.maxBuf = n;
            }
            catch (Exception exception) {
                throw new StreamIOException("Error processing stream ", exception);
            }
        }
        return this.maxBuf;
    }

    private void finaliseCipher() throws IOException {
        try {
            this.finalized = true;
            this.ensureCapacity(0, true);
            this.maxBuf = this.bufferedBlockCipher != null ? this.bufferedBlockCipher.doFinal(this.buf, 0) : (this.aeadBlockCipher != null ? this.aeadBlockCipher.doFinal(this.buf, 0) : 0);
        }
        catch (org.bouncycastle.crypto.internal.InvalidCipherTextException invalidCipherTextException) {
            throw new InvalidCipherTextException("Error finalising cipher", invalidCipherTextException);
        }
        catch (Exception exception) {
            throw new IOException("Error finalising cipher " + exception);
        }
    }

    @Override
    public int read() throws IOException {
        Utils.approvedModeCheck(this.isApprovedMode, this.algorithmName);
        if (this.bufOff >= this.maxBuf && this.nextChunk() < 0) {
            return -1;
        }
        return this.buf[this.bufOff++] & 0xFF;
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        Utils.approvedModeCheck(this.isApprovedMode, this.algorithmName);
        if (this.bufOff >= this.maxBuf && this.nextChunk() < 0) {
            return -1;
        }
        int n3 = Math.min(n2, this.available());
        System.arraycopy(this.buf, this.bufOff, byArray, n, n3);
        this.bufOff += n3;
        return n3;
    }

    @Override
    public long skip(long l) throws IOException {
        Utils.approvedModeCheck(this.isApprovedMode, this.algorithmName);
        if (l <= 0L) {
            return 0L;
        }
        if (this.streamCipher instanceof SkippingCipher) {
            long l2;
            int n = this.available();
            if (l <= (long)n) {
                this.bufOff = (int)((long)this.bufOff + l);
                return l;
            }
            this.bufOff = this.maxBuf;
            long l3 = this.in.skip(l - (long)n);
            if (l3 != (l2 = ((SkippingCipher)((Object)this.streamCipher)).skip(l3))) {
                throw new IOException("Unable to skip cipher " + l3 + " bytes.");
            }
            return l3 + (long)n;
        }
        int n = (int)Math.min(l, (long)this.available());
        this.bufOff += n;
        return n;
    }

    @Override
    public int available() throws IOException {
        return this.maxBuf - this.bufOff;
    }

    private void ensureCapacity(int n, boolean bl) {
        int n2 = n;
        if (bl) {
            if (this.bufferedBlockCipher != null) {
                n2 = this.bufferedBlockCipher.getOutputSize(n);
            } else if (this.aeadBlockCipher != null) {
                n2 = this.aeadBlockCipher.getOutputSize(n);
            }
        } else if (this.bufferedBlockCipher != null) {
            n2 = this.bufferedBlockCipher.getUpdateOutputSize(n);
        } else if (this.aeadBlockCipher != null) {
            n2 = this.aeadBlockCipher.getUpdateOutputSize(n);
        }
        if (this.buf == null || this.buf.length < n2) {
            this.buf = new byte[n2];
        }
    }

    @Override
    public void close() throws IOException {
        Utils.approvedModeCheck(this.isApprovedMode, this.algorithmName);
        try {
            this.in.close();
        }
        finally {
            if (!this.finalized) {
                this.finaliseCipher();
            }
        }
        this.bufOff = 0;
        this.maxBuf = 0;
        this.markBufOff = 0;
        this.markPosition = 0L;
        if (this.markBuf != null) {
            Arrays.fill(this.markBuf, (byte)0);
            this.markBuf = null;
        }
        if (this.buf != null) {
            Arrays.fill(this.buf, (byte)0);
            this.buf = null;
        }
        Arrays.fill(this.inBuf, (byte)0);
    }

    @Override
    public void mark(int n) {
        Utils.approvedModeCheck(this.isApprovedMode, this.algorithmName);
        this.in.mark(n);
        if (this.streamCipher instanceof SkippingCipher) {
            SkippingCipher skippingCipher = (SkippingCipher)((Object)this.streamCipher);
            this.markPosition = skippingCipher.getPosition();
        }
        if (this.buf != null) {
            this.markBuf = new byte[this.buf.length];
            System.arraycopy(this.buf, 0, this.markBuf, 0, this.buf.length);
        }
        this.markBufOff = this.bufOff;
    }

    @Override
    public void reset() throws IOException {
        if (!(this.streamCipher instanceof SkippingCipher)) {
            throw new IOException("cipher must implement SkippingCipher to be used with reset()");
        }
        this.in.reset();
        SkippingCipher skippingCipher = (SkippingCipher)((Object)this.streamCipher);
        skippingCipher.seekTo(this.markPosition);
        if (this.markBuf != null) {
            this.buf = this.markBuf;
        }
        this.bufOff = this.markBufOff;
    }

    @Override
    public boolean markSupported() {
        if (this.streamCipher instanceof SkippingCipher) {
            return this.in.markSupported();
        }
        return false;
    }
}

