/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.configuration;

import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.Set;
import org.mockito.configuration.AnnotationEngine;
import org.mockito.internal.configuration.DefaultInjectionEngine;
import org.mockito.internal.configuration.IndependentAnnotationEngine;
import org.mockito.internal.configuration.SpyAnnotationEngine;
import org.mockito.internal.configuration.injection.scanner.InjectMocksScanner;
import org.mockito.internal.configuration.injection.scanner.MockScanner;
import org.mockito.internal.util.collections.Sets;

public class InjectingAnnotationEngine
implements org.mockito.plugins.AnnotationEngine,
AnnotationEngine {
    private final org.mockito.plugins.AnnotationEngine delegate = new IndependentAnnotationEngine();
    private final org.mockito.plugins.AnnotationEngine spyAnnotationEngine = new SpyAnnotationEngine();

    @Override
    public void process(Class<?> clazz, Object testInstance) {
        this.processIndependentAnnotations(testInstance.getClass(), testInstance);
        this.processInjectMocks(testInstance.getClass(), testInstance);
    }

    private void processInjectMocks(Class<?> clazz, Object testInstance) {
        for (Class<?> classContext = clazz; classContext != Object.class; classContext = classContext.getSuperclass()) {
            this.injectMocks(testInstance);
        }
    }

    private void processIndependentAnnotations(Class<?> clazz, Object testInstance) {
        for (Class<?> classContext = clazz; classContext != Object.class; classContext = classContext.getSuperclass()) {
            this.delegate.process(classContext, testInstance);
            this.spyAnnotationEngine.process(classContext, testInstance);
        }
    }

    public void injectMocks(Object testClassInstance) {
        HashSet<Field> mockDependentFields = new HashSet<Field>();
        Set<Object> mocks = Sets.newMockSafeHashSet(new Object[0]);
        for (Class<?> clazz = testClassInstance.getClass(); clazz != Object.class; clazz = clazz.getSuperclass()) {
            new InjectMocksScanner(clazz).addTo(mockDependentFields);
            new MockScanner(testClassInstance, clazz).addPreparedMocks(mocks);
            this.onInjection(testClassInstance, clazz, mockDependentFields, mocks);
        }
        new DefaultInjectionEngine().injectMocksOnFields(mockDependentFields, mocks, testClassInstance);
    }

    protected void onInjection(Object testClassInstance, Class<?> clazz, Set<Field> mockDependentFields, Set<Object> mocks) {
    }
}

