/*
 * Decompiled with CFR 0.152.
 */
package com.azure.identity.implementation;

import com.azure.core.http.HttpHeaders;
import com.azure.core.http.HttpMethod;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpRequest;
import com.azure.core.http.HttpResponse;
import com.azure.core.util.Context;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.Header;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.logging.LogLevel;
import com.azure.identity.implementation.IdentityClientOptions;
import com.azure.identity.implementation.util.IdentityUtil;
import com.microsoft.aad.msal4j.IHttpClient;
import com.microsoft.aad.msal4j.IHttpResponse;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.Base64;
import java.util.Map;
import java.util.stream.Collectors;

class HttpPipelineAdapter
implements IHttpClient {
    private static final ClientLogger CLIENT_LOGGER = new ClientLogger(HttpPipelineAdapter.class);
    private static final String ACCOUNT_IDENTIFIER_LOG_MESSAGE = "[Authenticated account] Client ID: {0}, Tenant ID: {1}, User Principal Name: {2}, Object ID (user): {3})";
    private static final String APPLICATION_IDENTIFIER = "Application Identifier";
    private static final String OBJECT_ID = "Object Id";
    private static final String TENANT_ID = "Tenant Id";
    private static final String USER_PRINCIPAL_NAME = "User Principal Name";
    private static final String APPLICATION_ID_JSON_KEY = "appid";
    private static final String OBJECT_ID_JSON_KEY = "oid";
    private static final String TENANT_ID_JSON_KEY = "tid";
    private static final String USER_PRINCIPAL_NAME_JSON_KEY = "upn";
    private final HttpPipeline httpPipeline;
    private IdentityClientOptions identityClientOptions;

    HttpPipelineAdapter(HttpPipeline httpPipeline, IdentityClientOptions identityClientOptions) {
        this.httpPipeline = httpPipeline;
        this.identityClientOptions = identityClientOptions;
    }

    public IHttpResponse send(com.microsoft.aad.msal4j.HttpRequest httpRequest) {
        HttpRequest request = new HttpRequest(HttpMethod.valueOf((String)httpRequest.httpMethod().name()), httpRequest.url());
        if (httpRequest.headers() != null) {
            request.setHeaders(new HttpHeaders(httpRequest.headers()));
        }
        if (httpRequest.body() != null) {
            request.setBody(httpRequest.body());
        }
        HttpResponse response = this.httpPipeline.sendSync(request, Context.NONE);
        String body = response.getBodyAsBinaryData().toString();
        this.logAccountIdentifiersIfConfigured(body);
        com.microsoft.aad.msal4j.HttpResponse httpResponse = new com.microsoft.aad.msal4j.HttpResponse().statusCode(response.getStatusCode());
        if (!CoreUtils.isNullOrEmpty((CharSequence)body)) {
            httpResponse.body(body);
        }
        httpResponse.addHeaders(response.getHeaders().stream().collect(Collectors.toMap(Header::getName, Header::getValuesList)));
        return httpResponse;
    }

    private void logAccountIdentifiersIfConfigured(String body) {
        if (this.identityClientOptions == null || !this.identityClientOptions.getIdentityLogOptionsImpl().isLoggingAccountIdentifiersAllowed()) {
            return;
        }
        try {
            String[] base64Metadata;
            String accessToken = IdentityUtil.getAccessToken(body);
            if (accessToken != null && (base64Metadata = accessToken.split("\\.")).length > 1) {
                byte[] decoded = Base64.getDecoder().decode(base64Metadata[1]);
                String data = new String(decoded, StandardCharsets.UTF_8);
                Map<String, String> jsonMap = IdentityUtil.parseJsonIntoMap(data);
                String appId = jsonMap.containsKey(APPLICATION_ID_JSON_KEY) ? jsonMap.get(APPLICATION_ID_JSON_KEY) : null;
                String objectId = jsonMap.containsKey(OBJECT_ID_JSON_KEY) ? jsonMap.get(OBJECT_ID_JSON_KEY) : null;
                String tenantId = jsonMap.containsKey(TENANT_ID_JSON_KEY) ? jsonMap.get(TENANT_ID_JSON_KEY) : null;
                String userPrincipalName = jsonMap.containsKey(USER_PRINCIPAL_NAME_JSON_KEY) ? jsonMap.get(USER_PRINCIPAL_NAME_JSON_KEY) : null;
                CLIENT_LOGGER.log(LogLevel.INFORMATIONAL, () -> MessageFormat.format(ACCOUNT_IDENTIFIER_LOG_MESSAGE, this.getAccountIdentifierMessage(APPLICATION_IDENTIFIER, appId), this.getAccountIdentifierMessage(TENANT_ID, tenantId), this.getAccountIdentifierMessage(USER_PRINCIPAL_NAME, userPrincipalName), this.getAccountIdentifierMessage(OBJECT_ID, objectId)));
            }
        }
        catch (IOException e) {
            CLIENT_LOGGER.log(LogLevel.WARNING, () -> "allowLoggingAccountIdentifiers Log option was set, but the account information could not be logged.", (Throwable)e);
        }
    }

    private String getAccountIdentifierMessage(String identifierName, String identifierValue) {
        if (identifierValue == null) {
            return "No " + identifierName + " available.";
        }
        return identifierValue;
    }
}

