/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob.implementation.models;

import com.azure.core.util.CoreUtils;
import com.azure.storage.blob.implementation.models.BlobFlatListSegment;
import com.azure.xml.XmlReader;
import com.azure.xml.XmlSerializable;
import com.azure.xml.XmlToken;
import com.azure.xml.XmlWriter;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;

public final class ListBlobsFlatSegmentResponse
implements XmlSerializable<ListBlobsFlatSegmentResponse> {
    private String serviceEndpoint;
    private String containerName;
    private String prefix;
    private String marker;
    private int maxResults;
    private BlobFlatListSegment segment;
    private String nextMarker;

    public String getServiceEndpoint() {
        return this.serviceEndpoint;
    }

    public ListBlobsFlatSegmentResponse setServiceEndpoint(String serviceEndpoint) {
        this.serviceEndpoint = serviceEndpoint;
        return this;
    }

    public String getContainerName() {
        return this.containerName;
    }

    public ListBlobsFlatSegmentResponse setContainerName(String containerName) {
        this.containerName = containerName;
        return this;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public ListBlobsFlatSegmentResponse setPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    public String getMarker() {
        return this.marker;
    }

    public ListBlobsFlatSegmentResponse setMarker(String marker) {
        this.marker = marker;
        return this;
    }

    public int getMaxResults() {
        return this.maxResults;
    }

    public ListBlobsFlatSegmentResponse setMaxResults(int maxResults) {
        this.maxResults = maxResults;
        return this;
    }

    public BlobFlatListSegment getSegment() {
        return this.segment;
    }

    public ListBlobsFlatSegmentResponse setSegment(BlobFlatListSegment segment) {
        this.segment = segment;
        return this;
    }

    public String getNextMarker() {
        return this.nextMarker;
    }

    public ListBlobsFlatSegmentResponse setNextMarker(String nextMarker) {
        this.nextMarker = nextMarker;
        return this;
    }

    public XmlWriter toXml(XmlWriter xmlWriter) throws XMLStreamException {
        return this.toXml(xmlWriter, null);
    }

    public XmlWriter toXml(XmlWriter xmlWriter, String rootElementName) throws XMLStreamException {
        rootElementName = CoreUtils.isNullOrEmpty((CharSequence)rootElementName) ? "EnumerationResults" : rootElementName;
        xmlWriter.writeStartElement(rootElementName);
        xmlWriter.writeStringAttribute("ServiceEndpoint", this.serviceEndpoint);
        xmlWriter.writeStringAttribute("ContainerName", this.containerName);
        xmlWriter.writeStringElement("Prefix", this.prefix);
        xmlWriter.writeStringElement("Marker", this.marker);
        xmlWriter.writeIntElement("MaxResults", this.maxResults);
        xmlWriter.writeXml((XmlSerializable)this.segment, "Blobs");
        xmlWriter.writeStringElement("NextMarker", this.nextMarker);
        return xmlWriter.writeEndElement();
    }

    public static ListBlobsFlatSegmentResponse fromXml(XmlReader xmlReader) throws XMLStreamException {
        return ListBlobsFlatSegmentResponse.fromXml(xmlReader, null);
    }

    public static ListBlobsFlatSegmentResponse fromXml(XmlReader xmlReader, String rootElementName) throws XMLStreamException {
        String finalRootElementName = CoreUtils.isNullOrEmpty((CharSequence)rootElementName) ? "EnumerationResults" : rootElementName;
        return (ListBlobsFlatSegmentResponse)xmlReader.readObject(finalRootElementName, reader -> {
            ListBlobsFlatSegmentResponse deserializedListBlobsFlatSegmentResponse = new ListBlobsFlatSegmentResponse();
            deserializedListBlobsFlatSegmentResponse.serviceEndpoint = reader.getStringAttribute(null, "ServiceEndpoint");
            deserializedListBlobsFlatSegmentResponse.containerName = reader.getStringAttribute(null, "ContainerName");
            while (reader.nextElement() != XmlToken.END_ELEMENT) {
                QName elementName = reader.getElementName();
                if ("Prefix".equals(elementName.getLocalPart())) {
                    deserializedListBlobsFlatSegmentResponse.prefix = reader.getStringElement();
                    continue;
                }
                if ("Marker".equals(elementName.getLocalPart())) {
                    deserializedListBlobsFlatSegmentResponse.marker = reader.getStringElement();
                    continue;
                }
                if ("MaxResults".equals(elementName.getLocalPart())) {
                    deserializedListBlobsFlatSegmentResponse.maxResults = reader.getIntElement();
                    continue;
                }
                if ("Blobs".equals(elementName.getLocalPart())) {
                    deserializedListBlobsFlatSegmentResponse.segment = BlobFlatListSegment.fromXml(reader, "Blobs");
                    continue;
                }
                if ("NextMarker".equals(elementName.getLocalPart())) {
                    deserializedListBlobsFlatSegmentResponse.nextMarker = reader.getStringElement();
                    continue;
                }
                reader.skipElement();
            }
            return deserializedListBlobsFlatSegmentResponse;
        });
    }
}

