/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.aad.msal4jextensions.persistence.linux;

import com.microsoft.aad.msal4jextensions.persistence.CacheFileAccessor;
import com.microsoft.aad.msal4jextensions.persistence.ICacheAccessor;
import com.microsoft.aad.msal4jextensions.persistence.linux.GError;
import com.microsoft.aad.msal4jextensions.persistence.linux.ISecurityLibrary;
import com.microsoft.aad.msal4jextensions.persistence.linux.KeyRingAccessException;
import com.microsoft.aad.msal4jextensions.persistence.linux.SecretSchemaAttributeType;
import com.microsoft.aad.msal4jextensions.persistence.linux.SecretSchemaFlags;
import com.nimbusds.jose.util.StandardCharset;
import com.sun.jna.Pointer;
import java.nio.charset.StandardCharsets;
import java.util.Base64;

public class KeyRingAccessor
implements ICacheAccessor {
    private String cacheFilePath;
    private String keyringCollection;
    private String keyringSchemaName;
    private String keyringSecretLabel;
    private String attributeKey1;
    private String attributeValue1;
    private String attributeKey2;
    private String attributeValue2;
    private Pointer libSecretSchema;

    public KeyRingAccessor(String cacheFilePath, String keyringCollection, String keyringSchemaName, String keyringSecretLabel, String attributeKey1, String attributeValue1, String attributeKey2, String attributeValue2) {
        this.cacheFilePath = cacheFilePath;
        this.keyringCollection = keyringCollection;
        this.keyringSchemaName = keyringSchemaName;
        this.keyringSecretLabel = keyringSecretLabel;
        this.attributeKey1 = attributeKey1;
        this.attributeValue1 = attributeValue1;
        this.attributeKey2 = attributeKey2;
        this.attributeValue2 = attributeValue2;
    }

    public void verify() {
        String testAttributeValue1 = "testAttr1";
        String testAttributeValue2 = "testAttr2";
        String testData = "Test Data";
        this.write(testData.getBytes(StandardCharsets.UTF_8), testAttributeValue1, testAttributeValue2);
        byte[] readData = this.read(testAttributeValue1, testAttributeValue2);
        if (readData == null || !testData.equals(new String(readData, StandardCharset.UTF_8))) {
            throw new KeyRingAccessException("An error while validating KeyRing availability");
        }
        this.delete(testAttributeValue1, testAttributeValue2);
    }

    private byte[] read(String attributeValue1, String attributeValue2) {
        byte[] data = null;
        Pointer[] error = new Pointer[1];
        String secret = ISecurityLibrary.library.secret_password_lookup_sync(this.getLibSecretSchema(), null, error, this.attributeKey1, attributeValue1, this.attributeKey2, attributeValue2, null);
        if (error[0] != Pointer.NULL) {
            GError err = new GError(error[0]);
            throw new KeyRingAccessException("An error while reading secret from keyring, domain:" + err.domain + " code:" + err.code + " message:" + err.message);
        }
        if (secret != null && !secret.isEmpty()) {
            data = Base64.getDecoder().decode(secret);
        }
        return data;
    }

    @Override
    public byte[] read() {
        return this.read(this.attributeValue1, this.attributeValue2);
    }

    private void write(byte[] data, String attributeValue1, String attributeValue2) {
        Pointer[] error = new Pointer[1];
        ISecurityLibrary.library.secret_password_store_sync(this.getLibSecretSchema(), this.keyringCollection, this.keyringSecretLabel, Base64.getEncoder().encodeToString(data), null, error, this.attributeKey1, attributeValue1, this.attributeKey2, attributeValue2, null);
        if (error[0] != Pointer.NULL) {
            GError err = new GError(error[0]);
            throw new KeyRingAccessException("An error while saving secret to keyring, domain:" + err.domain + " code:" + err.code + " message:" + err.message);
        }
        new CacheFileAccessor(this.cacheFilePath).updateCacheFileLastModifiedTime();
    }

    @Override
    public void write(byte[] data) {
        this.write(data, this.attributeValue1, this.attributeValue2);
    }

    private void delete(String attributeValue1, String attributeValue2) {
        Pointer[] error = new Pointer[1];
        ISecurityLibrary.library.secret_password_clear_sync(this.getLibSecretSchema(), null, error, this.attributeKey1, attributeValue1, this.attributeKey2, attributeValue2, null);
        if (error[0] != Pointer.NULL) {
            GError err = new GError(error[0]);
            throw new KeyRingAccessException("An error while deleting secret from keyring, domain:" + err.domain + " code:" + err.code + " message:" + err.message);
        }
        new CacheFileAccessor(this.cacheFilePath).updateCacheFileLastModifiedTime();
    }

    @Override
    public void delete() {
        this.delete(this.attributeValue1, this.attributeValue2);
    }

    private Pointer getLibSecretSchema() {
        if (this.libSecretSchema == Pointer.NULL) {
            this.libSecretSchema = ISecurityLibrary.library.secret_schema_new(this.keyringSchemaName, SecretSchemaFlags.SECRET_SCHEMA_NONE, this.attributeKey1, SecretSchemaAttributeType.SECRET_SCHEMA_ATTRIBUTE_STRING, this.attributeKey2, SecretSchemaAttributeType.SECRET_SCHEMA_ATTRIBUTE_STRING, null);
            if (this.libSecretSchema == Pointer.NULL) {
                throw new KeyRingAccessException("Failed to create libSecret schema " + this.keyringSchemaName);
            }
        }
        return this.libSecretSchema;
    }
}

