/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.common.implementation;

import com.azure.core.util.FluxUtil;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

public class MappedByteBufferInputStream
extends InputStream {
    private final ByteBuffer byteBuffer;

    public MappedByteBufferInputStream(ByteBuffer buffer) {
        this.byteBuffer = ByteBuffer.wrap(FluxUtil.byteBufferToArray((ByteBuffer)buffer));
        this.byteBuffer.flip();
    }

    @Override
    public int read() throws IOException {
        if (!this.byteBuffer.hasRemaining()) {
            return -1;
        }
        return this.byteBuffer.get() & 0xFF;
    }

    @Override
    public int read(byte[] bytes, int off, int len) throws IOException {
        if (!this.byteBuffer.hasRemaining()) {
            return -1;
        }
        len = Math.min(len, this.byteBuffer.remaining());
        this.byteBuffer.get(bytes, off, len);
        return len;
    }
}

