/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;
import java.util.Objects;

public final class GeoPosition
implements JsonSerializable<GeoPosition> {
    private static final ClientLogger LOGGER = new ClientLogger(GeoPosition.class);
    private final double longitude;
    private final double latitude;
    private final Double altitude;

    public GeoPosition(double longitude, double latitude) {
        this(longitude, latitude, null);
    }

    public GeoPosition(double longitude, double latitude, Double altitude) {
        this.longitude = longitude;
        this.latitude = latitude;
        this.altitude = altitude;
    }

    public double getLongitude() {
        return this.longitude;
    }

    public double getLatitude() {
        return this.latitude;
    }

    public Double getAltitude() {
        return this.altitude;
    }

    public int count() {
        return this.altitude == null ? 2 : 3;
    }

    double get(int index) {
        switch (index) {
            case 0: {
                return this.longitude;
            }
            case 1: {
                return this.latitude;
            }
            case 2: {
                if (this.altitude == null) {
                    throw LOGGER.logExceptionAsError(new IndexOutOfBoundsException("Index out of range: " + index));
                }
                return this.altitude;
            }
        }
        throw LOGGER.logExceptionAsError(new IndexOutOfBoundsException("Index out of range: " + index));
    }

    public int hashCode() {
        return Objects.hash(this.longitude, this.latitude, this.altitude);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof GeoPosition)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        GeoPosition other = (GeoPosition)obj;
        return Double.compare(this.longitude, other.longitude) == 0 && Double.compare(this.latitude, other.latitude) == 0 && Objects.equals(this.altitude, other.altitude);
    }

    public String toString() {
        return this.altitude != null ? String.format("[%s, %s, %s]", this.longitude, this.latitude, this.altitude) : String.format("[%s, %s]", this.longitude, this.latitude);
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartArray().writeDouble(this.longitude).writeDouble(this.latitude);
        if (this.altitude != null) {
            jsonWriter.writeDouble(this.altitude.doubleValue());
        }
        return jsonWriter.writeEndArray();
    }

    public static GeoPosition fromJson(JsonReader jsonReader) throws IOException {
        List coordinates = jsonReader.readArray(reader -> {
            if (reader.currentToken() == JsonToken.NUMBER) {
                return reader.getDouble();
            }
            return null;
        });
        if (coordinates == null) {
            return null;
        }
        int coordinateCount = coordinates.size();
        if (coordinateCount < 2 || coordinateCount > 3) {
            throw LOGGER.logExceptionAsError(new IllegalStateException("Only 2 or 3 element coordinates supported."));
        }
        double longitude = ((Number)coordinates.get(0)).doubleValue();
        double latitude = ((Number)coordinates.get(1)).doubleValue();
        Double altitude = coordinateCount == 3 ? Double.valueOf(((Number)coordinates.get(2)).doubleValue()) : null;
        return new GeoPosition(longitude, latitude, altitude);
    }
}

