/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.util.serializer;

import com.azure.core.http.HttpHeaders;
import com.azure.core.util.Header;
import com.azure.core.util.serializer.CollectionFormat;
import com.azure.core.util.serializer.SerializerEncoding;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public interface SerializerAdapter {
    public String serialize(Object var1, SerializerEncoding var2) throws IOException;

    default public byte[] serializeToBytes(Object object, SerializerEncoding encoding) throws IOException {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        this.serialize(object, encoding, stream);
        return stream.toByteArray();
    }

    default public void serialize(Object object, SerializerEncoding encoding, OutputStream outputStream) throws IOException {
        String serializedObject = this.serialize(object, encoding);
        if (serializedObject != null) {
            outputStream.write(serializedObject.getBytes(StandardCharsets.UTF_8));
        }
    }

    public String serializeRaw(Object var1);

    public String serializeList(List<?> var1, CollectionFormat var2);

    default public String serializeIterable(Iterable<?> iterable, CollectionFormat format) {
        if (iterable == null) {
            return null;
        }
        return StreamSupport.stream(iterable.spliterator(), false).map(this::serializeRaw).map(serializedString -> serializedString == null ? "" : serializedString).collect(Collectors.joining(format.getDelimiter()));
    }

    public <T> T deserialize(String var1, Type var2, SerializerEncoding var3) throws IOException;

    default public <T> T deserialize(byte[] bytes, Type type, SerializerEncoding encoding) throws IOException {
        return this.deserialize(new String(bytes, StandardCharsets.UTF_8), type, encoding);
    }

    default public <T> T deserialize(InputStream inputStream, Type type, SerializerEncoding encoding) throws IOException {
        int length;
        if (inputStream == null) {
            return this.deserialize((String)null, type, encoding);
        }
        ByteArrayOutputStream converterStream = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while ((length = inputStream.read(buffer)) != -1) {
            converterStream.write(buffer, 0, length);
        }
        return this.deserialize(converterStream.toString(StandardCharsets.UTF_8.name()), type, encoding);
    }

    public <T> T deserialize(HttpHeaders var1, Type var2) throws IOException;

    default public <T> T deserializeHeader(Header header, Type type) throws IOException {
        return this.deserialize(new HttpHeaders().add(header.getName(), header.getValue()), type);
    }
}

