/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.type.ad;

import java.io.IOException;
import org.apache.hadoop.shaded.org.apache.kerby.asn1.Asn1Dumper;
import org.apache.hadoop.shaded.org.apache.kerby.asn1.Asn1FieldInfo;
import org.apache.hadoop.shaded.org.apache.kerby.asn1.EnumType;
import org.apache.hadoop.shaded.org.apache.kerby.asn1.ExplicitField;
import org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.type.KrbSequenceType;
import org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.type.ad.AuthorizationData;
import org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.type.ad.AuthorizationDataEntry;
import org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.type.ad.AuthorizationType;
import org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.type.ad.PrincipalList;

public class ADIntendedForServer
extends AuthorizationDataEntry {
    private IntForSrvr myIntForSrvr = new IntForSrvr();

    public ADIntendedForServer() {
        super(AuthorizationType.AD_INTENDED_FOR_SERVER);
        this.myIntForSrvr.outerEncodeable = this;
    }

    public ADIntendedForServer(byte[] encoded) throws IOException {
        this();
        this.myIntForSrvr.decode(encoded);
    }

    public ADIntendedForServer(PrincipalList principals) throws IOException {
        this();
        this.myIntForSrvr.setIntendedServer(principals);
    }

    public PrincipalList getIntendedServer() {
        return this.myIntForSrvr.getIntendedServer();
    }

    public void setIntendedServer(PrincipalList principals) {
        this.myIntForSrvr.setIntendedServer(principals);
    }

    public AuthorizationData getAuthorizationData() {
        return this.myIntForSrvr.getAuthzData();
    }

    public void setAuthorizationData(AuthorizationData authzData) {
        this.myIntForSrvr.setAuthzData(authzData);
    }

    @Override
    protected int encodingBodyLength() throws IOException {
        if (this.bodyLength == -1) {
            this.setAuthzData(this.myIntForSrvr.encode());
            this.bodyLength = super.encodingBodyLength();
        }
        return this.bodyLength;
    }

    @Override
    public void dumpWith(Asn1Dumper dumper, int indents) {
        super.dumpWith(dumper, indents);
        dumper.newLine();
        this.myIntForSrvr.dumpWith(dumper, indents + 8);
    }

    private static class IntForSrvr
    extends KrbSequenceType {
        private AuthorizationData authzData;
        private static Asn1FieldInfo[] fieldInfos = new Asn1FieldInfo[]{new ExplicitField(IntForSrvrField.IFS_intendedServer, PrincipalList.class), new ExplicitField(IntForSrvrField.IFS_elements, AuthorizationData.class)};

        IntForSrvr() {
            super(fieldInfos);
        }

        IntForSrvr(PrincipalList principals) {
            super(fieldInfos);
            this.setFieldAs(IntForSrvrField.IFS_intendedServer, principals);
        }

        public PrincipalList getIntendedServer() {
            return this.getFieldAs(IntForSrvrField.IFS_intendedServer, PrincipalList.class);
        }

        public void setIntendedServer(PrincipalList principals) {
            this.setFieldAs(IntForSrvrField.IFS_intendedServer, principals);
            this.resetBodyLength();
        }

        public AuthorizationData getAuthzData() {
            if (this.authzData == null) {
                this.authzData = this.getFieldAs(IntForSrvrField.IFS_elements, AuthorizationData.class);
            }
            return this.authzData;
        }

        public void setAuthzData(AuthorizationData authzData) {
            this.authzData = authzData;
            this.setFieldAs(IntForSrvrField.IFS_elements, authzData);
            this.resetBodyLength();
        }

        protected static enum IntForSrvrField implements EnumType
        {
            IFS_intendedServer,
            IFS_elements;


            @Override
            public int getValue() {
                return this.ordinal();
            }

            @Override
            public String getName() {
                return this.name();
            }
        }
    }
}

