/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.protocol;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hdfs.server.protocol.DataNodeUsageReport;
import org.apache.hadoop.util.Time;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public final class DataNodeUsageReportUtil {
    private long bytesWritten;
    private long bytesRead;
    private long writeTime;
    private long readTime;
    private long blocksWritten;
    private long blocksRead;
    private DataNodeUsageReport lastReport;

    public DataNodeUsageReport getUsageReport(long bWritten, long bRead, long wTime, long rTime, long wBlockOp, long rBlockOp, long timeSinceLastReport) {
        if (timeSinceLastReport == 0L) {
            if (this.lastReport == null) {
                this.lastReport = DataNodeUsageReport.EMPTY_REPORT;
            }
            return this.lastReport;
        }
        DataNodeUsageReport.Builder builder = new DataNodeUsageReport.Builder();
        DataNodeUsageReport report = builder.setBytesWrittenPerSec(this.getBytesWrittenPerSec(bWritten, timeSinceLastReport)).setBytesReadPerSec(this.getBytesReadPerSec(bRead, timeSinceLastReport)).setWriteTime(this.getWriteTime(wTime)).setReadTime(this.getReadTime(rTime)).setBlocksWrittenPerSec(this.getWriteBlockOpPerSec(wBlockOp, timeSinceLastReport)).setBlocksReadPerSec(this.getReadBlockOpPerSec(rBlockOp, timeSinceLastReport)).setTimestamp(Time.monotonicNow()).build();
        this.bytesRead = bRead;
        this.bytesWritten = bWritten;
        this.blocksWritten = wBlockOp;
        this.blocksRead = rBlockOp;
        this.readTime = rTime;
        this.writeTime = wTime;
        this.lastReport = report;
        return report;
    }

    private long getBytesReadPerSec(long bRead, long timeInSec) {
        return (bRead - this.bytesRead) / timeInSec;
    }

    private long getBytesWrittenPerSec(long bWritten, long timeInSec) {
        return (bWritten - this.bytesWritten) / timeInSec;
    }

    private long getWriteBlockOpPerSec(long totalWriteBlocks, long timeInSec) {
        return (totalWriteBlocks - this.blocksWritten) / timeInSec;
    }

    private long getReadBlockOpPerSec(long totalReadBlockOp, long timeInSec) {
        return (totalReadBlockOp - this.blocksRead) / timeInSec;
    }

    private long getReadTime(long totalReadTime) {
        return totalReadTime - this.readTime;
    }

    private long getWriteTime(long totalWriteTime) {
        return totalWriteTime - this.writeTime;
    }
}

