/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.task.reduce;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.DataInputBuffer;
import org.apache.hadoop.mapred.IFile;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.task.reduce.MergeManagerImpl;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class InMemoryReader<K, V>
extends IFile.Reader<K, V> {
    private final TaskAttemptID taskAttemptId;
    private final MergeManagerImpl<K, V> merger;
    private final DataInputBuffer memDataIn = new DataInputBuffer();
    private final int start;
    private final int length;

    public InMemoryReader(MergeManagerImpl<K, V> merger, TaskAttemptID taskAttemptId, byte[] data, int start, int length, Configuration conf) throws IOException {
        super(conf, null, length - start, null, null);
        this.merger = merger;
        this.taskAttemptId = taskAttemptId;
        this.buffer = data;
        this.bufferSize = (int)this.fileLength;
        this.memDataIn.reset(this.buffer, start, length - start);
        this.start = start;
        this.length = length;
    }

    @Override
    public void reset(int offset) {
        this.memDataIn.reset(this.buffer, this.start + offset, this.length - this.start - offset);
        this.bytesRead = offset;
        this.eof = false;
    }

    @Override
    public long getPosition() throws IOException {
        return this.bytesRead;
    }

    @Override
    public long getLength() {
        return this.fileLength;
    }

    private void dumpOnError() {
        File dumpFile = new File("../output/" + this.taskAttemptId + ".dump");
        System.err.println("Dumping corrupt map-output of " + this.taskAttemptId + " to " + dumpFile.getAbsolutePath());
        try (FileOutputStream fos = new FileOutputStream(dumpFile);){
            fos.write(this.buffer, 0, this.bufferSize);
        }
        catch (IOException ioe) {
            System.err.println("Failed to dump map-output of " + this.taskAttemptId);
        }
    }

    @Override
    public boolean nextRawKey(DataInputBuffer key) throws IOException {
        try {
            if (!this.positionToNextRecord(this.memDataIn)) {
                return false;
            }
            int pos = this.memDataIn.getPosition();
            byte[] data = this.memDataIn.getData();
            key.reset(data, pos, this.currentKeyLength);
            long skipped = this.memDataIn.skip(this.currentKeyLength);
            if (skipped != (long)this.currentKeyLength) {
                throw new IOException("Rec# " + this.recNo + ": Failed to skip past key of length: " + this.currentKeyLength);
            }
            this.bytesRead += (long)this.currentKeyLength;
            return true;
        }
        catch (IOException ioe) {
            this.dumpOnError();
            throw ioe;
        }
    }

    @Override
    public void nextRawValue(DataInputBuffer value) throws IOException {
        try {
            int pos = this.memDataIn.getPosition();
            byte[] data = this.memDataIn.getData();
            value.reset(data, pos, this.currentValueLength);
            long skipped = this.memDataIn.skip(this.currentValueLength);
            if (skipped != (long)this.currentValueLength) {
                throw new IOException("Rec# " + this.recNo + ": Failed to skip past value of length: " + this.currentValueLength);
            }
            this.bytesRead += (long)this.currentValueLength;
            ++this.recNo;
        }
        catch (IOException ioe) {
            this.dumpOnError();
            throw ioe;
        }
    }

    @Override
    public void close() {
        this.dataIn = null;
        this.buffer = null;
        if (this.merger != null) {
            this.merger.unreserve(this.bufferSize);
        }
    }
}

