/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.security.client;

import java.util.Collection;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.security.token.TokenSelector;
import org.apache.hadoop.yarn.security.client.RMDelegationTokenIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class RMDelegationTokenSelector
implements TokenSelector<RMDelegationTokenIdentifier> {
    private static final Logger LOG = LoggerFactory.getLogger(RMDelegationTokenSelector.class);

    private boolean checkService(Text service, Token<? extends TokenIdentifier> token) {
        if (service == null || token.getService() == null) {
            return false;
        }
        return token.getService().toString().contains(service.toString());
    }

    @Override
    public Token<RMDelegationTokenIdentifier> selectToken(Text service, Collection<Token<? extends TokenIdentifier>> tokens) {
        if (service == null) {
            return null;
        }
        LOG.debug("Looking for a token with service {}", (Object)service);
        for (Token<? extends TokenIdentifier> token : tokens) {
            LOG.debug("Token kind is {} and the token's service name is {}", (Object)token.getKind(), (Object)token.getService());
            if (!RMDelegationTokenIdentifier.KIND_NAME.equals(token.getKind()) || !this.checkService(service, token)) continue;
            return token;
        }
        return null;
    }
}

