/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockPlacementPolicy;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockPlacementPolicyDefault;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockPlacementStatus;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockPlacementStatusWithNodeGroup;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeStorageInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.FSClusterStats;
import org.apache.hadoop.hdfs.server.blockmanagement.Host2NodesMap;
import org.apache.hadoop.net.NetworkTopology;
import org.apache.hadoop.net.NetworkTopologyWithNodeGroup;
import org.apache.hadoop.net.Node;

public class BlockPlacementPolicyWithNodeGroup
extends BlockPlacementPolicyDefault {
    protected BlockPlacementPolicyWithNodeGroup() {
    }

    @Override
    public void initialize(Configuration conf, FSClusterStats stats, NetworkTopology clusterMap, Host2NodesMap host2datanodeMap) {
        if (!(clusterMap instanceof NetworkTopologyWithNodeGroup)) {
            throw new IllegalArgumentException("Configured cluster topology should be " + NetworkTopologyWithNodeGroup.class.getName());
        }
        super.initialize(conf, stats, clusterMap, host2datanodeMap);
    }

    @Override
    protected void chooseFavouredNodes(String src, int numOfReplicas, List<DatanodeDescriptor> favoredNodes, Set<Node> favoriteAndExcludedNodes, long blocksize, int maxNodesPerRack, List<DatanodeStorageInfo> results, boolean avoidStaleNodes, EnumMap<StorageType, Integer> storageTypes) throws BlockPlacementPolicy.NotEnoughReplicasException {
        super.chooseFavouredNodes(src, numOfReplicas, favoredNodes, favoriteAndExcludedNodes, blocksize, maxNodesPerRack, results, avoidStaleNodes, storageTypes);
        if (results.size() < numOfReplicas) {
            for (int i = 0; i < favoredNodes.size() && results.size() < numOfReplicas; ++i) {
                DatanodeDescriptor favoredNode = favoredNodes.get(i);
                boolean chosenNode = this.isNodeChosen(results, favoredNode);
                if (chosenNode) continue;
                NetworkTopologyWithNodeGroup clusterMapNodeGroup = (NetworkTopologyWithNodeGroup)this.clusterMap;
                DatanodeStorageInfo target = null;
                String scope = clusterMapNodeGroup.getNodeGroup(favoredNode.getNetworkLocation());
                try {
                    target = this.chooseRandom(scope, favoriteAndExcludedNodes, blocksize, maxNodesPerRack, results, avoidStaleNodes, storageTypes);
                }
                catch (BlockPlacementPolicy.NotEnoughReplicasException e) {
                    continue;
                }
                if (target == null) {
                    LOG.warn("Could not find a target for file " + src + " within nodegroup of favored node " + (Object)((Object)favoredNode));
                    continue;
                }
                favoriteAndExcludedNodes.add((Node)target.getDatanodeDescriptor());
            }
        }
    }

    private boolean isNodeChosen(List<DatanodeStorageInfo> results, DatanodeDescriptor favoredNode) {
        boolean chosenNode = false;
        for (int j = 0; j < results.size(); ++j) {
            if (!results.get(j).getDatanodeDescriptor().equals((Object)favoredNode)) continue;
            chosenNode = true;
            break;
        }
        return chosenNode;
    }

    @Override
    protected DatanodeStorageInfo chooseLocalStorage(Node localMachine, Set<Node> excludedNodes, long blocksize, int maxNodesPerRack, List<DatanodeStorageInfo> results, boolean avoidStaleNodes, EnumMap<StorageType, Integer> storageTypes, boolean fallbackToNodeGroupAndLocalRack) throws BlockPlacementPolicy.NotEnoughReplicasException {
        DatanodeStorageInfo localStorage = this.chooseLocalStorage(localMachine, excludedNodes, blocksize, maxNodesPerRack, results, avoidStaleNodes, storageTypes);
        if (localStorage != null) {
            return localStorage;
        }
        if (!fallbackToNodeGroupAndLocalRack) {
            return null;
        }
        DatanodeStorageInfo chosenStorage = this.chooseLocalNodeGroup((NetworkTopologyWithNodeGroup)this.clusterMap, localMachine, excludedNodes, blocksize, maxNodesPerRack, results, avoidStaleNodes, storageTypes);
        if (chosenStorage != null) {
            return chosenStorage;
        }
        return this.chooseLocalRack(localMachine, excludedNodes, blocksize, maxNodesPerRack, results, avoidStaleNodes, storageTypes);
    }

    private static DatanodeDescriptor secondNode(Node localMachine, List<DatanodeStorageInfo> results) {
        for (DatanodeStorageInfo nextStorage : results) {
            DatanodeDescriptor nextNode = nextStorage.getDatanodeDescriptor();
            if (nextNode == localMachine) continue;
            return nextNode;
        }
        return null;
    }

    @Override
    protected DatanodeStorageInfo chooseLocalRack(Node localMachine, Set<Node> excludedNodes, long blocksize, int maxNodesPerRack, List<DatanodeStorageInfo> results, boolean avoidStaleNodes, EnumMap<StorageType, Integer> storageTypes) throws BlockPlacementPolicy.NotEnoughReplicasException {
        if (localMachine == null) {
            return this.chooseRandom("", excludedNodes, blocksize, maxNodesPerRack, results, avoidStaleNodes, storageTypes);
        }
        try {
            String scope = NetworkTopology.getFirstHalf((String)localMachine.getNetworkLocation());
            return this.chooseRandom(scope, excludedNodes, blocksize, maxNodesPerRack, results, avoidStaleNodes, storageTypes);
        }
        catch (BlockPlacementPolicy.NotEnoughReplicasException e1) {
            DatanodeDescriptor newLocal = BlockPlacementPolicyWithNodeGroup.secondNode(localMachine, results);
            if (newLocal != null) {
                try {
                    return this.chooseRandom(this.clusterMap.getRack(newLocal.getNetworkLocation()), excludedNodes, blocksize, maxNodesPerRack, results, avoidStaleNodes, storageTypes);
                }
                catch (BlockPlacementPolicy.NotEnoughReplicasException e2) {
                    return this.chooseRandom("", excludedNodes, blocksize, maxNodesPerRack, results, avoidStaleNodes, storageTypes);
                }
            }
            return this.chooseRandom("", excludedNodes, blocksize, maxNodesPerRack, results, avoidStaleNodes, storageTypes);
        }
    }

    @Override
    protected void chooseRemoteRack(int numOfReplicas, DatanodeDescriptor localMachine, Set<Node> excludedNodes, long blocksize, int maxReplicasPerRack, List<DatanodeStorageInfo> results, boolean avoidStaleNodes, EnumMap<StorageType, Integer> storageTypes) throws BlockPlacementPolicy.NotEnoughReplicasException {
        int oldNumOfReplicas = results.size();
        String rackLocation = NetworkTopology.getFirstHalf((String)localMachine.getNetworkLocation());
        try {
            this.chooseRandom(numOfReplicas, "~" + rackLocation, excludedNodes, blocksize, maxReplicasPerRack, results, avoidStaleNodes, storageTypes);
        }
        catch (BlockPlacementPolicy.NotEnoughReplicasException e) {
            this.chooseRandom(numOfReplicas - (results.size() - oldNumOfReplicas), rackLocation, excludedNodes, blocksize, maxReplicasPerRack, results, avoidStaleNodes, storageTypes);
        }
    }

    private DatanodeStorageInfo chooseLocalNodeGroup(NetworkTopologyWithNodeGroup clusterMap, Node localMachine, Set<Node> excludedNodes, long blocksize, int maxNodesPerRack, List<DatanodeStorageInfo> results, boolean avoidStaleNodes, EnumMap<StorageType, Integer> storageTypes) throws BlockPlacementPolicy.NotEnoughReplicasException {
        if (localMachine == null) {
            return this.chooseRandom("", excludedNodes, blocksize, maxNodesPerRack, results, avoidStaleNodes, storageTypes);
        }
        try {
            return this.chooseRandom(clusterMap.getNodeGroup(localMachine.getNetworkLocation()), excludedNodes, blocksize, maxNodesPerRack, results, avoidStaleNodes, storageTypes);
        }
        catch (BlockPlacementPolicy.NotEnoughReplicasException e1) {
            DatanodeDescriptor newLocal = BlockPlacementPolicyWithNodeGroup.secondNode(localMachine, results);
            if (newLocal != null) {
                try {
                    return this.chooseRandom(clusterMap.getNodeGroup(newLocal.getNetworkLocation()), excludedNodes, blocksize, maxNodesPerRack, results, avoidStaleNodes, storageTypes);
                }
                catch (BlockPlacementPolicy.NotEnoughReplicasException e2) {
                    return null;
                }
            }
            return null;
        }
    }

    @Override
    protected String getRack(DatanodeInfo cur) {
        String nodeGroupString = cur.getNetworkLocation();
        return NetworkTopology.getFirstHalf((String)nodeGroupString);
    }

    @Override
    protected int addToExcludedNodes(DatanodeDescriptor chosenNode, Set<Node> excludedNodes) {
        int countOfExcludedNodes = 0;
        String nodeGroupScope = chosenNode.getNetworkLocation();
        List leafNodes = this.clusterMap.getLeaves(nodeGroupScope);
        for (Node leafNode : leafNodes) {
            if (!excludedNodes.add(leafNode)) continue;
            ++countOfExcludedNodes;
        }
        return countOfExcludedNodes += this.addDependentNodesToExcludedNodes(chosenNode, excludedNodes);
    }

    private int addDependentNodesToExcludedNodes(DatanodeDescriptor chosenNode, Set<Node> excludedNodes) {
        if (this.host2datanodeMap == null) {
            return 0;
        }
        int countOfExcludedNodes = 0;
        for (String hostname : chosenNode.getDependentHostNames()) {
            DatanodeDescriptor node = this.host2datanodeMap.getDataNodeByHostName(hostname);
            if (node != null) {
                if (!excludedNodes.add((Node)node)) continue;
                ++countOfExcludedNodes;
                continue;
            }
            LOG.warn("Not able to find datanode " + hostname + " which has dependency with datanode " + chosenNode.getHostName());
        }
        return countOfExcludedNodes;
    }

    @Override
    public Collection<DatanodeStorageInfo> pickupReplicaSet(Collection<DatanodeStorageInfo> first, Collection<DatanodeStorageInfo> second, Map<String, List<DatanodeStorageInfo>> rackMap) {
        if (first.isEmpty()) {
            return second;
        }
        HashMap<String, ArrayList<DatanodeStorageInfo>> nodeGroupMap = new HashMap<String, ArrayList<DatanodeStorageInfo>>();
        for (DatanodeStorageInfo storage : first) {
            String nodeGroupName = NetworkTopology.getLastHalf((String)storage.getDatanodeDescriptor().getNetworkLocation());
            ArrayList<DatanodeStorageInfo> storageList = (ArrayList<DatanodeStorageInfo>)nodeGroupMap.get(nodeGroupName);
            if (storageList == null) {
                storageList = new ArrayList<DatanodeStorageInfo>();
                nodeGroupMap.put(nodeGroupName, storageList);
            }
            storageList.add(storage);
        }
        ArrayList moreThanOne = new ArrayList();
        ArrayList<DatanodeStorageInfo> exactlyOne = new ArrayList<DatanodeStorageInfo>();
        for (List datanodeList : nodeGroupMap.values()) {
            if (datanodeList.size() == 1) {
                exactlyOne.add((DatanodeStorageInfo)datanodeList.get(0));
                continue;
            }
            moreThanOne.addAll(datanodeList);
        }
        return moreThanOne.isEmpty() ? exactlyOne : moreThanOne;
    }

    @Override
    public boolean isMovable(Collection<DatanodeInfo> locs, DatanodeInfo source, DatanodeInfo target) {
        for (DatanodeInfo dn : locs) {
            if (dn == source || dn == target || !this.clusterMap.isOnSameNodeGroup((Node)dn, (Node)target)) continue;
            return false;
        }
        return true;
    }

    @Override
    public BlockPlacementStatus verifyBlockPlacement(DatanodeInfo[] locs, int numberOfReplicas) {
        if (locs == null) {
            locs = DatanodeDescriptor.EMPTY_ARRAY;
        }
        ArrayList<String> locList = new ArrayList<String>();
        for (int i = 0; i < locs.length; ++i) {
            locList.add(locs[i].getNetworkLocation());
            locs[i].setNetworkLocation(NetworkTopology.getFirstHalf((String)locs[i].getNetworkLocation()));
        }
        BlockPlacementStatus defaultStatus = super.verifyBlockPlacement(locs, numberOfReplicas);
        for (int i = 0; i < locs.length; ++i) {
            locs[i].setNetworkLocation((String)locList.get(i));
        }
        int minNodeGroups = numberOfReplicas;
        BlockPlacementStatusWithNodeGroup nodeGroupStatus = new BlockPlacementStatusWithNodeGroup(defaultStatus, this.getNodeGroupsFromNode(locs), minNodeGroups);
        return nodeGroupStatus;
    }

    private Set<String> getNodeGroupsFromNode(DatanodeInfo[] nodes) {
        HashSet<String> nodeGroups = new HashSet<String>();
        if (nodes == null) {
            return nodeGroups;
        }
        for (DatanodeInfo node : nodes) {
            nodeGroups.add(NetworkTopology.getLastHalf((String)node.getNetworkLocation()));
        }
        return nodeGroups;
    }
}

