/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.crt.iot;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import software.amazon.awssdk.crt.CrtResource;
import software.amazon.awssdk.crt.iot.MqttRequestResponseClient;
import software.amazon.awssdk.crt.iot.StreamingOperationOptions;

public class StreamingOperation
extends CrtResource {
    private final ReentrantReadWriteLock handleLock = new ReentrantReadWriteLock();
    private final Lock handleReadLock = this.handleLock.readLock();
    private final Lock handleWriteLock = this.handleLock.writeLock();

    StreamingOperation(MqttRequestResponseClient rrClient, StreamingOperationOptions options) {
        this.acquireNativeHandle(StreamingOperation.streamingOperationNew(rrClient.getNativeHandle(), options));
    }

    public void open() {
        this.handleReadLock.lock();
        try {
            StreamingOperation.streamingOperationOpen(this.getNativeHandle());
        }
        finally {
            this.handleReadLock.unlock();
        }
    }

    @Override
    protected void releaseNativeHandle() {
        if (!this.isNull()) {
            StreamingOperation.streamingOperationDestroy(this.getNativeHandle());
        }
    }

    @Override
    public void close() {
        this.handleWriteLock.lock();
        try {
            super.close();
        }
        finally {
            this.handleWriteLock.unlock();
        }
    }

    @Override
    protected boolean canReleaseReferencesImmediately() {
        return true;
    }

    private static native long streamingOperationNew(long var0, StreamingOperationOptions var2);

    private static native void streamingOperationOpen(long var0);

    private static native void streamingOperationDestroy(long var0);
}

