/*
 * Decompiled with CFR 0.152.
 */
package org.passay;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Collections;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.cryptacular.codec.Encoder;
import org.cryptacular.codec.HexEncoder;
import org.cryptacular.util.CodecUtil;
import org.cryptacular.util.HashUtil;
import org.passay.PasswordData;
import org.passay.Rule;
import org.passay.RuleResult;
import org.passay.RuleResultDetail;
import org.passay.RuleResultMetadata;

public class HaveIBeenPwnedRule
implements Rule {
    public static final String ERROR_CODE = "EXPOSED_HAVEIBEENPWNED";
    public static final String IO_ERROR_CODE = "IO_ERROR_HAVEIBEENPWNED";
    private static final String DEFAULT_URL = "https://api.pwnedpasswords.com/range/";
    private static final int PREFIX_LENGTH = 5;
    private static final Duration DEFAULT_CONNECT_TIMEOUT = Duration.ofSeconds(5L);
    private static final Duration DEFAULT_READ_TIMEOUT = Duration.ofSeconds(30L);
    private final String applicationName;
    private URL apiUrl;
    private boolean allowExposed;
    private Duration connectTimeout = DEFAULT_CONNECT_TIMEOUT;
    private Duration readTimeout = DEFAULT_READ_TIMEOUT;
    private boolean allowOnException;

    public HaveIBeenPwnedRule(String appName) {
        this(appName, DEFAULT_URL);
    }

    public HaveIBeenPwnedRule(String appName, String address) {
        if (appName == null) {
            throw new IllegalArgumentException("appName cannot be null");
        }
        this.applicationName = appName;
        if (!address.endsWith("/")) {
            throw new IllegalArgumentException("address must end with '/'");
        }
        try {
            this.apiUrl = new URL(address);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public void setAllowExposed(boolean allow) {
        this.allowExposed = allow;
    }

    public void setConnectTimeout(Duration timeout) {
        this.connectTimeout = timeout;
    }

    public void setReadTimeout(Duration timeout) {
        this.readTimeout = timeout;
    }

    public void setAllowOnException(boolean allow) {
        this.allowOnException = allow;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public RuleResult validate(PasswordData passwordData) {
        String hexDigest = HaveIBeenPwnedRule.getHexDigest(passwordData);
        try (LineNumberReader lnr = this.openApiConnectionForRange(hexDigest.substring(0, 5));){
            RuleResult ruleResult = this.searchResponse(hexDigest, lnr);
            return ruleResult;
        }
        catch (IOException e) {
            return new RuleResult(this.allowOnException, new RuleResultDetail(IO_ERROR_CODE, Collections.singletonMap("url", this.apiUrl)));
        }
    }

    private RuleResult searchResponse(String hexDigest, LineNumberReader reader) throws IOException {
        String line;
        Pattern p = Pattern.compile("^(" + hexDigest.substring(5) + "):(\\d+)\\s*$");
        while ((line = reader.readLine()) != null) {
            Matcher m = p.matcher(line);
            if (!m.matches()) continue;
            int matchCount = Integer.parseInt(m.group(2));
            return new RuleResult(this.allowExposed, new RuleResultDetail(ERROR_CODE, Collections.singletonMap("count", matchCount)), new RuleResultMetadata(RuleResultMetadata.CountCategory.Pwned, matchCount));
        }
        return new RuleResult(true);
    }

    private static String getHexDigest(PasswordData passwordData) {
        byte[] digest = HashUtil.sha1((Object[])new Object[]{passwordData.getPassword().getBytes(Charset.defaultCharset())});
        return CodecUtil.encode((Encoder)new HexEncoder(false, true), (byte[])digest);
    }

    private LineNumberReader openApiConnectionForRange(String range) throws IOException {
        URL url = new URL(this.apiUrl, range);
        URLConnection c = url.openConnection();
        c.setRequestProperty("User-Agent", this.applicationName);
        if (this.connectTimeout != null) {
            c.setConnectTimeout((int)this.connectTimeout.toMillis());
        }
        if (this.readTimeout != null) {
            c.setReadTimeout((int)this.readTimeout.toMillis());
        }
        c.connect();
        return new LineNumberReader(new InputStreamReader(c.getInputStream(), StandardCharsets.UTF_8));
    }
}

