/*
 * Decompiled with CFR 0.152.
 */
package org.passay.dictionary;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.LongBuffer;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import org.passay.dictionary.AbstractWordList;
import org.passay.dictionary.WordLists;

public abstract class AbstractFileWordList
extends AbstractWordList {
    public static final int DEFAULT_CACHE_PERCENT = 5;
    protected final RandomAccessFile file;
    protected int size;
    private Cache cache;
    private final CharsetDecoder charsetDecoder;
    private final ByteBuffer wordBuf = ByteBuffer.allocate(256);
    private final CharBuffer charBuf = CharBuffer.allocate(this.wordBuf.capacity() * 4);
    private long position;

    public AbstractFileWordList(RandomAccessFile raf, boolean caseSensitive, CharsetDecoder decoder) {
        this.file = raf;
        this.charsetDecoder = decoder;
        this.comparator = caseSensitive ? WordLists.CASE_SENSITIVE_COMPARATOR : WordLists.CASE_INSENSITIVE_COMPARATOR;
    }

    @Override
    public String get(int index) {
        this.checkRange(index);
        try {
            return this.readWord(index);
        }
        catch (IOException e) {
            throw new RuntimeException("Error reading from file backing word list", e);
        }
    }

    @Override
    public int size() {
        return this.size;
    }

    public RandomAccessFile getFile() {
        return this.file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        Cache cache = this.cache;
        synchronized (cache) {
            this.file.close();
        }
        this.cache = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initialize(int cachePercent, boolean allocateDirect) throws IOException {
        this.cache = new Cache(this.file.length(), cachePercent, allocateDirect);
        FileWord prev = null;
        Cache cache = this.cache;
        synchronized (cache) {
            FileWord word;
            this.seek(0L);
            while ((word = this.readNextWord()) != null) {
                if (prev != null && this.comparator.compare(word.word, prev.word) < 0) {
                    throw new IllegalArgumentException("File is not sorted correctly for this comparator");
                }
                prev = word;
                this.cache.put(this.size++, word.offset);
            }
            this.cache.initialized = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String readWord(int index) throws IOException {
        Cache cache = this.cache;
        synchronized (cache) {
            FileWord word;
            Cache.Entry entry = this.cache.get(index);
            int i = entry.index;
            this.seek(entry.position);
            do {
                word = this.readNextWord();
            } while (i++ < index && word != null);
            return word != null ? word.word : null;
        }
    }

    protected abstract void seek(long var1) throws IOException;

    protected abstract ByteBuffer buffer();

    protected abstract void fill() throws IOException;

    private FileWord readNextWord() throws IOException {
        ((Buffer)this.wordBuf).clear();
        long start = this.position;
        while (this.hasRemaining()) {
            byte b = this.buffer().get();
            ++this.position;
            if (b == 10 || b == 13) {
                if (this.wordBuf.position() != 0) break;
                ++start;
                continue;
            }
            this.wordBuf.put(b);
        }
        if (this.wordBuf.position() == 0) {
            return null;
        }
        ((Buffer)this.charBuf).clear();
        ((Buffer)this.wordBuf).flip();
        CoderResult result = this.charsetDecoder.decode(this.wordBuf, this.charBuf, true);
        if (result.isError()) {
            result.throwException();
        }
        ((Buffer)this.charBuf).flip();
        return new FileWord(this.charBuf.toString(), start);
    }

    private boolean hasRemaining() throws IOException {
        if (this.buffer().hasRemaining()) {
            return true;
        }
        this.fill();
        return this.buffer().hasRemaining();
    }

    public String toString() {
        return String.format("%s@%h::size=%s,cache=%s,charsetDecoder=%s", this.getClass().getName(), this.hashCode(), this.size, this.cache, this.charsetDecoder);
    }

    private static class Cache {
        private LongBuffer map;
        private int modulus;
        private boolean allocateDirect;
        private boolean initialized;

        Cache(long fileSize, int cachePercent, boolean direct) {
            if (cachePercent < 0 || cachePercent > 100) {
                throw new IllegalArgumentException("cachePercent must be between 0 and 100 inclusive");
            }
            this.allocateDirect = direct;
            long cacheSize = fileSize * (long)cachePercent / 100L;
            if (cacheSize > 0L) {
                if (cacheSize < 16L) {
                    cacheSize = 16L;
                }
                this.modulus = (int)(fileSize / cacheSize);
                this.resize(cacheSize);
            }
        }

        void put(int index, long position) {
            if (this.initialized) {
                throw new IllegalStateException("Cache initialized, put is not allowed");
            }
            if (this.modulus == 0 || index % this.modulus > 0) {
                return;
            }
            if (this.map.position() == this.map.capacity()) {
                long newSize = (long)this.map.capacity() * 12L;
                this.resize(newSize);
            }
            this.map.put(position);
        }

        Entry get(int index) {
            if (this.modulus == 0) {
                return new Entry(0, 0L);
            }
            int i = index / this.modulus;
            return new Entry(i * this.modulus, this.map.get(i));
        }

        private void resize(long size) {
            LongBuffer temp;
            if (size > Integer.MAX_VALUE) {
                throw new IllegalArgumentException("Cache limit exceeded. Try reducing cacheSize.");
            }
            LongBuffer longBuffer = temp = this.allocateDirect ? ByteBuffer.allocateDirect((int)size).asLongBuffer() : ByteBuffer.allocate((int)size).asLongBuffer();
            if (this.map != null) {
                ((Buffer)this.map).rewind();
                temp.put(this.map);
            }
            this.map = temp;
        }

        public String toString() {
            return String.format("%s@%h::size=%s,modulus=%s,allocateDirect=%s,initialized=%s", this.getClass().getSimpleName(), this.hashCode(), this.map != null ? this.map.capacity() : 0, this.modulus, this.allocateDirect, this.initialized);
        }

        static class Entry {
            int index;
            long position;

            Entry(int i, long pos) {
                this.index = i;
                this.position = pos;
            }
        }
    }

    protected static class FileWord {
        String word;
        long offset;

        FileWord(String s, long position) {
            this.word = s;
            this.offset = position;
        }
    }
}

