/*
 * Decompiled with CFR 0.152.
 */
package org.passay.dictionary;

import com.google.common.hash.BloomFilter;
import org.passay.dictionary.Dictionary;

public class BloomFilterDictionary
implements Dictionary {
    private final BloomFilter<String> bloomFilter;

    public BloomFilterDictionary(BloomFilter<String> bf) {
        this.bloomFilter = bf;
    }

    public BloomFilter<String> getBloomFilter() {
        return this.bloomFilter;
    }

    @Override
    public long size() {
        return this.bloomFilter == null ? 0L : this.bloomFilter.approximateElementCount();
    }

    @Override
    public boolean search(String word) {
        return this.bloomFilter.mightContain((Object)word);
    }

    public String toString() {
        return String.format("%s@%h::bloomFilter=%s", this.getClass().getName(), this.hashCode(), this.bloomFilter);
    }
}

