/*
 * Decompiled with CFR 0.152.
 */
package com.selectivem.collections;

import com.selectivem.collections.IndexedImmutableSetImpl;
import com.selectivem.collections.UnmodifiableMapImpl;
import com.selectivem.collections.UnmodifiableSetImpl;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.function.BiConsumer;

class IndexRefMapImpl<K, V>
extends UnmodifiableMapImpl<K, V> {
    private final V[] values;
    private final int size;
    private final IndexedImmutableSetImpl<K> keyToIndexMap;
    private final int valuesArrayOffset;
    private String cachedToString;

    IndexRefMapImpl(V[] values, int size, IndexedImmutableSetImpl<K> keyToIndexMap, int valuesArrayOffset) {
        this.values = values;
        this.size = size;
        this.keyToIndexMap = keyToIndexMap;
        this.valuesArrayOffset = valuesArrayOffset;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean containsValue(Object value) {
        for (int i = 0; i < this.values.length; ++i) {
            V present = this.values[i];
            if (present == null || !present.equals(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.get(key) != null;
    }

    @Override
    public V get(Object key) {
        int i = this.keyToIndexMap.elementToIndex(key);
        if (i == -1) {
            return null;
        }
        if ((i -= this.valuesArrayOffset) < 0 || i >= this.values.length) {
            return null;
        }
        return this.values[i];
    }

    @Override
    public Set<K> keySet() {
        return new UnmodifiableSetImpl<K>(){

            @Override
            public int size() {
                return IndexRefMapImpl.this.size;
            }

            @Override
            public boolean isEmpty() {
                return false;
            }

            @Override
            public boolean contains(Object o) {
                return IndexRefMapImpl.this.containsKey(o);
            }

            @Override
            public Iterator<K> iterator() {
                return new Iterator<K>(){
                    int current;
                    {
                        this.current = IndexRefMapImpl.this.findNext(0);
                    }

                    @Override
                    public boolean hasNext() {
                        return this.current != -1;
                    }

                    @Override
                    public K next() {
                        if (this.current == -1) {
                            throw new NoSuchElementException();
                        }
                        Object key = IndexRefMapImpl.this.keyToIndexMap.indexToElement(this.current + IndexRefMapImpl.this.valuesArrayOffset);
                        this.current = IndexRefMapImpl.this.findNext(this.current + 1);
                        return key;
                    }
                };
            }
        };
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new UnmodifiableSetImpl<Map.Entry<K, V>>(){

            @Override
            public int size() {
                return IndexRefMapImpl.this.size;
            }

            @Override
            public boolean isEmpty() {
                return false;
            }

            @Override
            public boolean contains(Object o) {
                if (o instanceof Map.Entry) {
                    Map.Entry entry = (Map.Entry)o;
                    Object presentValue = IndexRefMapImpl.this.get(entry.getKey());
                    return presentValue != null && presentValue.equals(entry.getValue());
                }
                return false;
            }

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                return new Iterator<Map.Entry<K, V>>(){
                    int current;
                    {
                        this.current = IndexRefMapImpl.this.findNext(0);
                    }

                    @Override
                    public boolean hasNext() {
                        return this.current != -1;
                    }

                    @Override
                    public Map.Entry<K, V> next() {
                        if (this.current == -1) {
                            throw new NoSuchElementException();
                        }
                        final Object value = IndexRefMapImpl.this.values[this.current];
                        final Object key = IndexRefMapImpl.this.keyToIndexMap.indexToElement(this.current + IndexRefMapImpl.this.valuesArrayOffset);
                        this.current = IndexRefMapImpl.this.findNext(this.current + 1);
                        return new Map.Entry<K, V>(){

                            @Override
                            public K getKey() {
                                return key;
                            }

                            @Override
                            public V getValue() {
                                return value;
                            }

                            @Override
                            public V setValue(V value2) {
                                throw new UnsupportedOperationException();
                            }
                        };
                    }
                };
            }
        };
    }

    @Override
    public void forEach(BiConsumer<? super K, ? super V> action) {
        for (int i = 0; i < this.values.length; ++i) {
            V value = this.values[i];
            if (value == null) continue;
            K key = this.keyToIndexMap.indexToElement(i + this.valuesArrayOffset);
            action.accept(key, value);
        }
    }

    @Override
    public String toString() {
        String result = this.cachedToString;
        if (result == null) {
            StringBuilder stringBuilder = new StringBuilder("[");
            for (int i = 0; i < this.values.length; ++i) {
                V value = this.values[i];
                if (value == null) continue;
                if (stringBuilder.length() > 1) {
                    stringBuilder.append(", ");
                }
                K key = this.keyToIndexMap.indexToElement(i + this.valuesArrayOffset);
                stringBuilder.append(key).append("=").append(value);
            }
            stringBuilder.append("]");
            this.cachedToString = result = stringBuilder.toString();
        }
        return result;
    }

    private int findNext(int start) {
        for (int i = start; i < this.values.length; ++i) {
            if (this.values[i] == null) continue;
            return i;
        }
        return -1;
    }
}

