/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.action.configupdate;

import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.FailedNodeException;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.nodes.TransportNodesAction;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.inject.Provider;
import org.opensearch.common.settings.Settings;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.security.action.configupdate.ConfigUpdateNodeResponse;
import org.opensearch.security.action.configupdate.ConfigUpdateRequest;
import org.opensearch.security.action.configupdate.ConfigUpdateResponse;
import org.opensearch.security.auth.BackendRegistry;
import org.opensearch.security.configuration.ConfigurationRepository;
import org.opensearch.security.securityconf.DynamicConfigFactory;
import org.opensearch.security.securityconf.impl.CType;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.TransportRequest;
import org.opensearch.transport.TransportService;

public class TransportConfigUpdateAction
extends TransportNodesAction<ConfigUpdateRequest, ConfigUpdateResponse, NodeConfigUpdateRequest, ConfigUpdateNodeResponse> {
    protected Logger logger = LogManager.getLogger(((Object)((Object)this)).getClass());
    private final Provider<BackendRegistry> backendRegistry;
    private final ConfigurationRepository configurationRepository;
    private DynamicConfigFactory dynamicConfigFactory;
    private static final Set<CType<?>> SELECTIVE_VALIDATION_TYPES = Set.of(CType.INTERNALUSERS);

    @Inject
    public TransportConfigUpdateAction(Settings settings, ThreadPool threadPool, ClusterService clusterService, TransportService transportService, ConfigurationRepository configurationRepository, ActionFilters actionFilters, Provider<BackendRegistry> backendRegistry, DynamicConfigFactory dynamicConfigFactory) {
        super("cluster:admin/opendistro_security/config/update", threadPool, clusterService, transportService, actionFilters, ConfigUpdateRequest::new, NodeConfigUpdateRequest::new, "management", ConfigUpdateNodeResponse.class);
        this.configurationRepository = configurationRepository;
        this.backendRegistry = backendRegistry;
        this.dynamicConfigFactory = dynamicConfigFactory;
    }

    protected ConfigUpdateNodeResponse newNodeResponse(StreamInput in) throws IOException {
        return new ConfigUpdateNodeResponse(in);
    }

    protected ConfigUpdateResponse newResponse(ConfigUpdateRequest request, List<ConfigUpdateNodeResponse> responses, List<FailedNodeException> failures) {
        return new ConfigUpdateResponse(this.clusterService.getClusterName(), responses, failures);
    }

    protected ConfigUpdateNodeResponse nodeOperation(NodeConfigUpdateRequest request) {
        ConfigUpdateRequest configupdateRequest = request.request;
        if (this.canHandleSelectively(configupdateRequest)) {
            ((BackendRegistry)this.backendRegistry.get()).invalidateUserCache(configupdateRequest.getEntityNames());
        } else {
            boolean didReload = this.configurationRepository.reloadConfiguration(CType.fromStringValues(configupdateRequest.getConfigTypes()));
            if (didReload) {
                ((BackendRegistry)this.backendRegistry.get()).invalidateCache();
            }
        }
        return new ConfigUpdateNodeResponse(this.clusterService.localNode(), configupdateRequest.getConfigTypes(), null);
    }

    private boolean canHandleSelectively(ConfigUpdateRequest request) {
        return request.getConfigTypes() != null && request.getEntityNames() != null && request.getConfigTypes().length == 1 && request.getEntityNames().length > 0 && SELECTIVE_VALIDATION_TYPES.contains(CType.fromString(request.getConfigTypes()[0]));
    }

    protected NodeConfigUpdateRequest newNodeRequest(ConfigUpdateRequest request) {
        return new NodeConfigUpdateRequest(request);
    }

    public static class NodeConfigUpdateRequest
    extends TransportRequest {
        ConfigUpdateRequest request;

        public NodeConfigUpdateRequest(StreamInput in) throws IOException {
            super(in);
            this.request = new ConfigUpdateRequest(in);
        }

        public NodeConfigUpdateRequest(ConfigUpdateRequest request) {
            this.request = request;
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.request.writeTo(out);
        }
    }
}

