/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.dlic.rest.api.ssl;

import java.io.IOException;
import java.util.Objects;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;

public class CertificateInfo
implements Writeable,
ToXContent {
    private final String subject;
    private final String san;
    private final String issuer;
    private final String notAfter;
    private final String notBefore;
    private final String format;
    private final String alias;
    private final boolean hasPrivateKey;
    private final String serialNumber;

    public CertificateInfo(String format, String alias, String serialNumber, boolean hasPrivateKey, String subject, String san, String issuer, String notAfter, String notBefore) {
        this.format = format;
        this.alias = alias;
        this.serialNumber = serialNumber;
        this.hasPrivateKey = hasPrivateKey;
        this.subject = subject;
        this.san = san;
        this.issuer = issuer;
        this.notAfter = notAfter;
        this.notBefore = notBefore;
    }

    public CertificateInfo(StreamInput in) throws IOException {
        this.subject = in.readOptionalString();
        this.san = in.readOptionalString();
        this.issuer = in.readOptionalString();
        this.notAfter = in.readOptionalString();
        this.notBefore = in.readOptionalString();
        this.format = in.readOptionalString();
        this.alias = in.readOptionalString();
        this.serialNumber = in.readOptionalString();
        this.hasPrivateKey = in.readBoolean();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalString(this.subject);
        out.writeOptionalString(this.san);
        out.writeOptionalString(this.issuer);
        out.writeOptionalString(this.notAfter);
        out.writeOptionalString(this.notBefore);
        out.writeOptionalString(this.format);
        out.writeOptionalString(this.alias);
        out.writeOptionalString(this.serialNumber);
        out.writeBoolean(this.hasPrivateKey);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return builder.startObject().field("format", this.format).field("alias", this.alias).field("subject_dn", this.subject).field("san", this.san).field("serial_number", this.serialNumber).field("issuer_dn", this.issuer).field("has_private_key", this.hasPrivateKey).field("not_after", this.notAfter).field("not_before", this.notAfter).endObject();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CertificateInfo that = (CertificateInfo)o;
        return Objects.equals(this.subject, that.subject) && Objects.equals(this.san, that.san) && Objects.equals(this.issuer, that.issuer) && Objects.equals(this.notAfter, that.notAfter) && Objects.equals(this.notBefore, that.notBefore);
    }

    public int hashCode() {
        return Objects.hash(this.subject, this.san, this.issuer, this.notAfter, this.notBefore);
    }
}

