/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.filter;

import com.google.common.collect.ImmutableSet;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import javax.net.ssl.SSLPeerUnverifiedException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.ThreadContext;
import org.greenrobot.eventbus.Subscribe;
import org.opensearch.OpenSearchException;
import org.opensearch.common.settings.Settings;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.rest.BytesRestResponse;
import org.opensearch.rest.NamedRoute;
import org.opensearch.rest.RestChannel;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.RestResponse;
import org.opensearch.security.auditlog.AuditLog;
import org.opensearch.security.auth.BackendRegistry;
import org.opensearch.security.configuration.AdminDNs;
import org.opensearch.security.configuration.CompatConfig;
import org.opensearch.security.filter.DelegatingRestHandler;
import org.opensearch.security.filter.NettyAttribute;
import org.opensearch.security.filter.SecurityRequestChannel;
import org.opensearch.security.filter.SecurityRequestFactory;
import org.opensearch.security.filter.SecurityResponse;
import org.opensearch.security.filter.SecurityRestUtils;
import org.opensearch.security.privileges.PrivilegesEvaluatorResponse;
import org.opensearch.security.privileges.RestLayerPrivilegesEvaluator;
import org.opensearch.security.securityconf.impl.AllowlistingSettings;
import org.opensearch.security.ssl.http.netty.Netty4HttpRequestHeaderVerifier;
import org.opensearch.security.ssl.transport.PrincipalExtractor;
import org.opensearch.security.ssl.util.ExceptionUtils;
import org.opensearch.security.ssl.util.SSLRequestHelper;
import org.opensearch.security.support.HTTPHelper;
import org.opensearch.security.user.User;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.client.node.NodeClient;

public class SecurityRestFilter {
    protected final Logger log = LogManager.getLogger(this.getClass());
    private final BackendRegistry registry;
    private final RestLayerPrivilegesEvaluator evaluator;
    private final AuditLog auditLog;
    private final org.opensearch.common.util.concurrent.ThreadContext threadContext;
    private final PrincipalExtractor principalExtractor;
    private final Settings settings;
    private final Path configPath;
    private final CompatConfig compatConfig;
    private AllowlistingSettings allowlistingSettings;
    public static final String HEALTH_SUFFIX = "health";
    public static final String WHO_AM_I_SUFFIX = "whoami";
    public static final String REGEX_PATH_PREFIX = "/(_opendistro/_security|_plugins/_security)/(.*)";
    public static final Pattern PATTERN_PATH_PREFIX = Pattern.compile("/(_opendistro/_security|_plugins/_security)/(.*)");

    public SecurityRestFilter(BackendRegistry registry, RestLayerPrivilegesEvaluator evaluator, AuditLog auditLog, ThreadPool threadPool, PrincipalExtractor principalExtractor, Settings settings, Path configPath, CompatConfig compatConfig) {
        this.registry = registry;
        this.evaluator = evaluator;
        this.auditLog = auditLog;
        this.threadContext = threadPool.getThreadContext();
        this.principalExtractor = principalExtractor;
        this.settings = settings;
        this.configPath = configPath;
        this.compatConfig = compatConfig;
        this.allowlistingSettings = new AllowlistingSettings();
    }

    public RestHandler wrap(RestHandler original, AdminDNs adminDNs) {
        return new AuthczRestHandler(original, adminDNs);
    }

    boolean userIsSuperAdmin(User user, AdminDNs adminDNs) {
        return user != null && adminDNs.isAdmin(user);
    }

    void authorizeRequest(RestHandler original, SecurityRequestChannel request, User user) {
        boolean routeSupportsRestAuthorization;
        List restRoutes = original.routes();
        Optional<RestHandler.Route> handler = restRoutes.stream().filter(rh -> rh.getMethod().equals((Object)request.method())).filter(rh -> this.restPathMatches(request.path(), rh.getPath())).findFirst();
        boolean bl = routeSupportsRestAuthorization = handler.isPresent() && handler.get() instanceof NamedRoute;
        if (routeSupportsRestAuthorization) {
            PrivilegesEvaluatorResponse pres = new PrivilegesEvaluatorResponse();
            NamedRoute route = (NamedRoute)handler.get();
            ImmutableSet actionNames = ImmutableSet.builder().addAll((Iterable)(route.actionNames() != null ? route.actionNames() : Collections.emptySet())).add((Object)route.name()).build();
            pres = this.evaluator.evaluate(user, route.name(), (Set<String>)actionNames);
            if (this.log.isDebugEnabled()) {
                this.log.debug(pres.toString());
            }
            if (pres.isAllowed()) {
                this.log.debug("Request has been granted");
                this.auditLog.logGrantedPrivileges(user.getName(), request);
            } else {
                this.auditLog.logMissingPrivileges(route.name(), user.getName(), request);
                String err = !pres.getMissingSecurityRoles().isEmpty() ? String.format("No mapping for %s on roles %s", user, pres.getMissingSecurityRoles()) : String.format("no permissions for %s and %s", pres.getMissingPrivileges(), user);
                this.log.debug(err);
                request.queueForSending(new SecurityResponse(401, err));
            }
        }
    }

    public void checkAndAuthenticateRequest(SecurityRequestChannel requestChannel) throws Exception {
        this.threadContext.putTransient("_opendistro_security_origin", (Object)AuditLog.Origin.REST.toString());
        if (HTTPHelper.containsBadHeader(requestChannel)) {
            OpenSearchException exception = ExceptionUtils.createBadHeaderException();
            this.log.error(exception.toString());
            this.auditLog.logBadHeaders(requestChannel);
            requestChannel.queueForSending(new SecurityResponse(403, (Exception)((Object)exception)));
            return;
        }
        if (SSLRequestHelper.containsBadHeader(this.threadContext, "_opendistro_security_")) {
            OpenSearchException exception = ExceptionUtils.createBadHeaderException();
            this.log.error(exception.toString());
            this.auditLog.logBadHeaders(requestChannel);
            requestChannel.queueForSending(new SecurityResponse(403, (Exception)((Object)exception)));
            return;
        }
        try {
            SSLRequestHelper.SSLInfo sslInfo = SSLRequestHelper.getSSLInfo(this.settings, this.configPath, requestChannel, this.principalExtractor);
            if (sslInfo != null) {
                if (sslInfo.getPrincipal() != null) {
                    this.threadContext.putTransient("_opendistro_security_ssl_principal", (Object)sslInfo.getPrincipal());
                }
                if (sslInfo.getX509Certs() != null) {
                    this.threadContext.putTransient("_opendistro_security_ssl_peer_certificates", (Object)sslInfo.getX509Certs());
                }
                this.threadContext.putTransient("_opendistro_security_ssl_protocol", (Object)sslInfo.getProtocol());
                this.threadContext.putTransient("_opendistro_security_ssl_cipher", (Object)sslInfo.getCipher());
            }
        }
        catch (SSLPeerUnverifiedException e) {
            this.log.error("No ssl info", (Throwable)e);
            this.auditLog.logSSLException(requestChannel, e);
            requestChannel.queueForSending(new SecurityResponse(403, e));
            return;
        }
        if (!this.compatConfig.restAuthEnabled()) {
            return;
        }
        if (!SecurityRestUtils.shouldSkipAuthentication(requestChannel)) {
            if (!this.registry.authenticate(requestChannel)) {
                ThreadContext.remove((String)"user");
            } else {
                ThreadContext.put((String)"user", (String)((User)this.threadContext.getTransient("_opendistro_security_user")).getName());
            }
        }
    }

    @Subscribe
    public void onAllowlistingSettingChanged(AllowlistingSettings allowlistingSettings) {
        this.allowlistingSettings = allowlistingSettings;
    }

    private boolean restPathMatches(String requestPath, String handlerPath) {
        String[] requestSplit;
        requestPath = requestPath.replaceAll("^/+", "").replaceAll("/+$", "");
        if ((handlerPath = handlerPath.replaceAll("^/+", "").replaceAll("/+$", "")).equals(requestPath)) {
            return true;
        }
        String[] handlerSplit = handlerPath.split("/");
        if (handlerSplit.length != (requestSplit = requestPath.split("/")).length) {
            return false;
        }
        for (int i = 0; i < handlerSplit.length; ++i) {
            if (handlerSplit[i].equals(requestSplit[i]) || handlerSplit[i].startsWith("{") && handlerSplit[i].endsWith("}")) continue;
            return false;
        }
        return true;
    }

    class AuthczRestHandler
    extends DelegatingRestHandler {
        private final AdminDNs adminDNs;

        public AuthczRestHandler(RestHandler original, AdminDNs adminDNs) {
            super(original);
            this.adminDNs = adminDNs;
        }

        @Override
        public void handleRequest(RestRequest request, RestChannel channel, NodeClient client) throws Exception {
            Optional<SecurityResponse> deniedResponse;
            Optional<SecurityResponse> maybeSavedResponse = NettyAttribute.popFrom(request, Netty4HttpRequestHeaderVerifier.EARLY_RESPONSE);
            if (maybeSavedResponse.isPresent()) {
                NettyAttribute.clearAttribute(request, Netty4HttpRequestHeaderVerifier.CONTEXT_TO_RESTORE);
                NettyAttribute.clearAttribute(request, Netty4HttpRequestHeaderVerifier.IS_AUTHENTICATED);
                channel.sendResponse(maybeSavedResponse.get().asRestResponse());
                return;
            }
            NettyAttribute.popFrom(request, Netty4HttpRequestHeaderVerifier.CONTEXT_TO_RESTORE).ifPresent(storedContext -> {
                String xOpaqueId = SecurityRestFilter.this.threadContext.getHeader("X-Opaque-Id");
                storedContext.restore();
                if (xOpaqueId != null) {
                    SecurityRestFilter.this.threadContext.putHeader("X-Opaque-Id", xOpaqueId);
                }
            });
            NettyAttribute.popFrom(request, Netty4HttpRequestHeaderVerifier.UNCONSUMED_PARAMS).ifPresent(unconsumedParams -> {
                for (String unconsumedParam : unconsumedParams) {
                    request.param(unconsumedParam);
                }
            });
            SecurityRequestChannel requestChannel = SecurityRequestFactory.from(request, channel);
            if (!NettyAttribute.popFrom(request, Netty4HttpRequestHeaderVerifier.IS_AUTHENTICATED).orElse(false).booleanValue()) {
                SecurityRestFilter.this.checkAndAuthenticateRequest(requestChannel);
            }
            if (requestChannel.getQueuedResponse().isPresent()) {
                channel.sendResponse(requestChannel.getQueuedResponse().get().asRestResponse());
                return;
            }
            boolean performPermissionCheck = request.paramAsBoolean("perform_permission_check", false);
            if (performPermissionCheck) {
                SecurityRestFilter.this.threadContext.putHeader("perform_permission_check", Boolean.TRUE.toString());
            }
            User user = (User)SecurityRestFilter.this.threadContext.getTransient("_opendistro_security_user");
            String intiatingUser = (String)SecurityRestFilter.this.threadContext.getTransient("_opendistro_security__initiating_user");
            if (SecurityRestFilter.this.userIsSuperAdmin(user, this.adminDNs)) {
                SecurityRestFilter.this.auditLog.logSucceededLogin(user.getName(), true, intiatingUser, requestChannel);
                if (performPermissionCheck) {
                    SecurityRestFilter.this.log.debug("Permission check skipped: Super admin has full access");
                    this.handleSuperAdminPermissionCheck(channel);
                    return;
                }
                this.delegate.handleRequest(request, channel, client);
                return;
            }
            if (user != null) {
                SecurityRestFilter.this.auditLog.logSucceededLogin(user.getName(), false, intiatingUser, requestChannel);
            }
            if ((deniedResponse = SecurityRestFilter.this.allowlistingSettings.checkRequestIsAllowed(requestChannel)).isPresent()) {
                channel.sendResponse(deniedResponse.get().asRestResponse());
                return;
            }
            SecurityRestFilter.this.authorizeRequest(this.delegate, requestChannel, user);
            if (requestChannel.getQueuedResponse().isPresent()) {
                channel.sendResponse(requestChannel.getQueuedResponse().get().asRestResponse());
                return;
            }
            this.delegate.handleRequest(request, channel, client);
        }

        private void handleSuperAdminPermissionCheck(RestChannel channel) throws Exception {
            XContentBuilder builder = channel.newBuilder();
            builder.startObject();
            builder.field("accessAllowed", true);
            builder.field("missingPrivileges", Collections.emptyList());
            builder.endObject();
            channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.OK, builder));
        }
    }
}

